/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.util;

import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.type.TypeReference;

public final class ObjectToBooleanConverter
implements IConverter {
    public Object convert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Boolean result = true;
        String stringVal = sourceObject.toString();
        if (stringVal.equalsIgnoreCase("true")) {
            result = true;
        } else if (stringVal.equalsIgnoreCase("false")) {
            result = false;
        } else if (stringVal.isEmpty()) {
            result = false;
        } else {
            double value = 0.0;
            try {
                value = Double.valueOf(sourceObject.toString());
                if (value == 0.0) {
                    result = false;
                }
            }
            catch (NumberFormatException e) {
                result = false;
            }
        }
        return result;
    }

    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        return !(!destinationType.isType(Boolean.class) && !destinationType.isType(Boolean.TYPE) || !Number.class.isAssignableFrom(sourceObject.getClass()) && !String.class.isAssignableFrom(sourceObject.getClass()));
    }
}

