/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.Group.AttributeGroup;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import fr.soleil.tango.clientapi.factory.ProxyFactory;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.tango.utils.DevFailedUtils;

public final class TangoGroupAttribute {
    private final AttributeGroup group;
    private final String[] attributeNamesGroup;
    private DeviceAttribute[] deviceAttributes;

    public TangoGroupAttribute(String ... attributeNames) throws DevFailed {
        this.attributeNamesGroup = attributeNames;
        this.group = ProxyFactory.getInstance().createAttributeGroup(true, attributeNames);
        this.deviceAttributes = this.group.read();
    }

    public TangoGroupAttribute(boolean throwExceptions, String ... attributeNames) throws DevFailed {
        this(throwExceptions, true, attributeNames);
    }

    public TangoGroupAttribute(boolean throwExceptions, boolean readValue, String ... attributeNames) throws DevFailed {
        this.attributeNamesGroup = attributeNames;
        this.group = ProxyFactory.getInstance().createAttributeGroup(throwExceptions, attributeNames);
        if (readValue) {
            this.initDeviceAttributes();
        }
    }

    private void initDeviceAttributes() throws DevFailed {
        if (this.deviceAttributes == null) {
            this.deviceAttributes = this.group.read();
            if (this.deviceAttributes.length != this.attributeNamesGroup.length) {
                this.deviceAttributes = null;
                throw DevFailedUtils.newDevFailed((String)"Some attributes are not available");
            }
        }
    }

    public void write(Object value) throws DevFailed {
        this.initDeviceAttributes();
        for (DeviceAttribute deviceAttribute : this.deviceAttributes) {
            if (deviceAttribute == null) continue;
            InsertExtractUtils.insert(deviceAttribute, value);
        }
        this.group.write(this.deviceAttributes);
    }

    public void writeAysn(Object value) throws DevFailed {
        this.initDeviceAttributes();
        for (DeviceAttribute deviceAttribute : this.deviceAttributes) {
            if (deviceAttribute == null) continue;
            InsertExtractUtils.insert(deviceAttribute, value);
        }
        this.group.writeAsync(this.deviceAttributes);
    }

    public void write(Object ... value) throws DevFailed {
        this.writeAysn(value);
        this.getWriteAsyncReplies();
    }

    public void writeAysn(Object ... value) throws DevFailed {
        if (this.deviceAttributes == null) {
            this.deviceAttributes = this.group.read();
        }
        if (value.length != this.deviceAttributes.length) {
            throw DevFailedUtils.newDevFailed((String)"WRITE_ERROR", (String)(this.deviceAttributes.length + " values must be provided"));
        }
        int i = 0;
        for (DeviceAttribute deviceAttribute : this.deviceAttributes) {
            InsertExtractUtils.insert(deviceAttribute, value[i++]);
        }
        this.group.writeAsync(this.deviceAttributes);
    }

    public void getWriteAsyncReplies() throws DevFailed {
        this.group.getWriteReplies();
    }

    public DeviceAttribute[] read() throws DevFailed {
        return this.group.read();
    }

    public Object[] readExtract() throws DevFailed {
        DeviceAttribute[] da = this.read();
        Object[] results = this.extract(da);
        return results;
    }

    public Object[] extract(DeviceAttribute[] da) throws DevFailed {
        Object[] results = new Object[da.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = InsertExtractUtils.extract(da[i]);
        }
        return results;
    }

    public void readAync() throws DevFailed {
        this.group.readAsync();
    }

    public DeviceAttribute[] getReadAsyncReplies() throws DevFailed {
        return this.group.getReadReplies();
    }

    public AttributeInfoEx[] getConfig() throws DevFailed {
        return this.group.getConfig();
    }

    public Map<String, DevError[]> getErrors() {
        return this.group.getErrors();
    }

    public boolean hasFailed() {
        return this.group.hasFailed();
    }

    public String toString() {
        ToStringBuilder str = new ToStringBuilder((Object)this);
        str.append("names", (Object)Arrays.toString(this.attributeNamesGroup));
        return str.toString();
    }

    public AttributeGroup getGroup() {
        return this.group;
    }

    public boolean isThrowExceptions() {
        return this.group.isThrowExceptions();
    }

    public void setTimeout(int timeout) {
        this.group.setTimeout(timeout);
    }
}

