/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceProxy;
import fr.soleil.tango.clientapi.TangoAttribute;
import fr.soleil.tango.clientapi.TangoCommand;
import fr.soleil.tango.clientapi.factory.ProxyFactory;
import java.util.HashMap;
import java.util.Map;

public final class TangoDevice {
    private final Map<String, TangoAttribute> attributes = new HashMap<String, TangoAttribute>();
    private final Map<String, TangoCommand> commands = new HashMap<String, TangoCommand>();
    private final DeviceProxy dev;
    private final String deviceName;

    public TangoDevice(String deviceName) throws DevFailed {
        this(ProxyFactory.getInstance().createDeviceProxy(deviceName));
    }

    public TangoDevice(DeviceProxy deviceProxy) {
        this.deviceName = deviceProxy.name();
        this.dev = deviceProxy;
    }

    public DeviceProxy getDeviceProxy() {
        return this.dev;
    }

    public TangoAttribute getTangoAttribute(String attributeName) throws DevFailed {
        TangoAttribute ta;
        if (this.attributes.containsKey(attributeName)) {
            ta = this.attributes.get(attributeName);
        } else {
            ta = new TangoAttribute(this.deviceName + "/" + attributeName);
            this.attributes.put(attributeName, ta);
        }
        return ta;
    }

    public TangoCommand getTangoCommand(String commandName) throws DevFailed {
        TangoCommand tc;
        if (this.commands.containsKey(commandName)) {
            tc = this.commands.get(commandName);
        } else {
            tc = new TangoCommand(this.deviceName, commandName);
            this.commands.put(commandName, tc);
        }
        return tc;
    }

    public DevState state() throws DevFailed {
        return this.dev.state();
    }
}

