/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.attributecomposer;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.soleil.tango.attributecomposer.IAttributeGroupTaskListener;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import fr.soleil.tango.clientapi.TangoGroupAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.utils.DevFailedUtils;

public class AttributeGroupReader
implements Runnable {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private final Logger logger = LoggerFactory.getLogger(AttributeGroupReader.class);
    private boolean readWriteValue = false;
    private boolean readQuality = false;
    private boolean readAttributeInfo = false;
    private final IAttributeGroupTaskListener attributeGroupListener;
    private final TangoGroupAttribute attributeGroup;

    public AttributeGroupReader(IAttributeGroupTaskListener listener, TangoGroupAttribute attributeGroup, boolean readWriteValue, boolean readQuality, boolean readAttributeInfo) {
        this.attributeGroupListener = listener;
        this.readWriteValue = readWriteValue;
        this.readQuality = readQuality;
        this.readAttributeInfo = readAttributeInfo;
        this.attributeGroup = attributeGroup;
    }

    public AttributeGroupReader(IAttributeGroupTaskListener listener, TangoGroupAttribute attributeGroup) {
        this(listener, attributeGroup, false, false, false);
    }

    @Override
    public void run() {
        this.valueReader();
    }

    public void valueReader() {
        try {
            DevFailed e;
            String attributeName;
            Map<String, DevError[]> errors;
            DeviceAttribute[] resultGroup = null;
            AttributeInfoEx[] attributeInfoExList = null;
            String[] attributeNames = this.attributeGroup.getGroup().getAttributeNames();
            try {
                resultGroup = this.attributeGroup.read();
                this.attributeGroupListener.updateDeviceAttribute(resultGroup);
            }
            catch (DevFailed devFailed) {
                DevFailedUtils.logDevFailed((DevFailed)devFailed, (Logger)this.logger);
                this.logger.error("error extract group", (Throwable)devFailed);
                this.logger.error(DevFailedUtils.toString((DevFailed)devFailed));
                this.attributeGroupListener.catchDevFailed(devFailed);
                return;
            }
            boolean hasFailed = false;
            if (!this.attributeGroup.isThrowExceptions() && this.attributeGroup.hasFailed()) {
                hasFailed = true;
                errors = this.attributeGroup.getErrors();
                for (Map.Entry<String, DevError[]> entry : errors.entrySet()) {
                    attributeName = entry.getKey();
                    e = new DevFailed(entry.getValue());
                    this.logger.error("error extract group", (Throwable)e);
                    this.logger.error(DevFailedUtils.toString((DevFailed)e));
                    this.attributeGroupListener.updateQuality(attributeName, AttrQuality.ATTR_INVALID);
                    this.attributeGroupListener.updateErrorMessage(attributeName, DATE_FORMAT.format(new Date()) + " : " + DevFailedUtils.toString((DevFailed)e));
                }
            }
            if (this.readAttributeInfo || this.readWriteValue) {
                try {
                    attributeInfoExList = this.attributeGroup.getConfig();
                }
                catch (DevFailed devFailed) {
                    DevFailedUtils.logDevFailed((DevFailed)devFailed, (Logger)this.logger);
                    this.logger.error("error read attribute info", (Throwable)devFailed);
                    this.logger.error(DevFailedUtils.toString((DevFailed)devFailed));
                    this.attributeGroupListener.catchDevFailed(devFailed);
                }
                if (!this.attributeGroup.isThrowExceptions() && this.attributeGroup.hasFailed()) {
                    errors = this.attributeGroup.getErrors();
                    for (Map.Entry<String, DevError[]> entry : errors.entrySet()) {
                        attributeName = entry.getKey();
                        e = new DevFailed(entry.getValue());
                        this.logger.error("error read attribute info", (Throwable)e);
                        this.logger.error(DevFailedUtils.toString((DevFailed)e));
                        this.attributeGroupListener.updateAttributeInfoErrorMessage(attributeName, DATE_FORMAT.format(new Date()) + " : " + DevFailedUtils.toString((DevFailed)e));
                    }
                }
            }
            int i = 0;
            String attrName = null;
            for (DeviceAttribute deviceAttribute : resultGroup) {
                block25: {
                    attrName = attributeNames[i];
                    AttributeInfoEx attributeInfo = null;
                    if (attributeInfoExList != null && i >= 0 && i < attributeInfoExList.length) {
                        attributeInfo = attributeInfoExList[i];
                    }
                    if (deviceAttribute != null) {
                        try {
                            AttrDataFormat format = deviceAttribute.getDataFormat();
                            Object tmpReadValue = InsertExtractUtils.extractRead(deviceAttribute, format);
                            this.attributeGroupListener.updateReadValue(attrName, tmpReadValue);
                            if (this.readAttributeInfo) {
                                if (attributeInfo != null) {
                                    this.attributeGroupListener.updateAttributeInfoEx(attrName, attributeInfo);
                                } else {
                                    this.attributeGroupListener.updateAttributeInfoErrorMessage(attrName, DATE_FORMAT.format(new Date()) + " : Can't read attribute info of" + attrName);
                                }
                            }
                            if (this.readQuality) {
                                this.attributeGroupListener.updateQuality(attrName, deviceAttribute.getQuality());
                            }
                            if (!this.readWriteValue) break block25;
                            try {
                                if (attributeInfo != null && attributeInfo.writable != AttrWriteType.READ) {
                                    Object tmpWriteValue = InsertExtractUtils.extractWrite(deviceAttribute, attributeInfo.writable, format);
                                    this.attributeGroupListener.updateWriteValue(attrName, tmpWriteValue);
                                }
                            }
                            catch (DevFailed e2) {
                                DevFailedUtils.logDevFailed((DevFailed)e2, (Logger)this.logger);
                                this.logger.error("error extract write value", (Throwable)e2);
                                this.logger.error(DevFailedUtils.toString((DevFailed)e2));
                                this.attributeGroupListener.updateWriteValueErrorMessage(attrName, DATE_FORMAT.format(new Date()) + " : " + DevFailedUtils.toString((DevFailed)e2));
                            }
                        }
                        catch (DevFailed devFailed) {
                            DevFailedUtils.logDevFailed((DevFailed)devFailed, (Logger)this.logger);
                            this.logger.error("error extract group", (Throwable)devFailed);
                            this.logger.error(DevFailedUtils.toString((DevFailed)devFailed));
                            hasFailed = true;
                            this.attributeGroupListener.updateQuality(attrName, AttrQuality.ATTR_INVALID);
                            this.attributeGroupListener.updateErrorMessage(attrName, DATE_FORMAT.format(new Date()) + " : " + DevFailedUtils.toString((DevFailed)devFailed));
                        }
                    }
                }
                ++i;
            }
            if (hasFailed) {
                this.attributeGroupListener.catchException(new Exception(DATE_FORMAT.format(new Date()) + " : at least, one attribute reading has failed"));
            } else {
                this.attributeGroupListener.readingLoopFinished();
            }
        }
        catch (Exception e) {
            this.logger.error("error ", (Throwable)e);
            this.attributeGroupListener.catchException(e);
        }
    }

    boolean isReadWriteValue() {
        return this.readWriteValue;
    }

    boolean isReadQuality() {
        return this.readQuality;
    }

    boolean isReadAttributeInfo() {
        return this.readAttributeInfo;
    }

    IAttributeGroupTaskListener getAttributeGroupListener() {
        return this.attributeGroupListener;
    }
}

