/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.Group;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.NamedDevFailed;
import fr.esrf.TangoDs.NamedDevFailedList;
import fr.soleil.tango.clientapi.factory.ProxyFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public final class AttributeGroup {
    private final Logger logger = LoggerFactory.getLogger(AttributeGroup.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributeGroup.class);
    private String[] userAttributesNames;
    private DeviceProxy[] devices;
    private final Map<String, List<String>> attributesMap = new HashMap<String, List<String>>();
    private final Map<String, DeviceProxy> devicesMap = new HashMap<String, DeviceProxy>();
    private final Map<String, Integer> readAnswersIDs = new HashMap<String, Integer>();
    private final Map<String, Integer> writeAnswersIDs = new HashMap<String, Integer>();
    private List<DeviceAttribute> readReply = new ArrayList<DeviceAttribute>();
    private int timeout;
    private final boolean throwExceptions;
    private final Map<String, DevError[]> errorsMap = new HashMap<String, DevError[]>();

    public AttributeGroup(String ... attributes) throws DevFailed {
        this.throwExceptions = true;
        this.add(attributes);
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public AttributeGroup(boolean throwExceptions, String ... attributes) throws DevFailed {
        this.throwExceptions = throwExceptions;
        this.add(attributes);
    }

    public DeviceProxy getDevice(String attributeName) throws DevFailed {
        return this.devicesMap.get(TangoUtil.getfullDeviceNameForAttribute((String)attributeName).toLowerCase(Locale.ENGLISH));
    }

    private synchronized void add(String ... attributes) throws DevFailed {
        this.userAttributesNames = new String[attributes.length];
        this.devices = new DeviceProxy[attributes.length];
        int i = 0;
        for (String attributeName : attributes) {
            String fullAttribute;
            String deviceName;
            block6: {
                deviceName = TangoUtil.getfullDeviceNameForAttribute((String)attributeName).toLowerCase(Locale.ENGLISH);
                this.userAttributesNames[i] = fullAttribute = TangoUtil.getfullAttributeNameForAttribute((String)attributeName).toLowerCase(Locale.ENGLISH);
                try {
                    DeviceProxy device = ProxyFactory.getInstance().createDeviceProxy(deviceName);
                    this.devices[i++] = device;
                    if (!this.devicesMap.containsKey(deviceName)) {
                        this.devicesMap.put(deviceName, device);
                    }
                }
                catch (DevFailed e) {
                    if (this.throwExceptions) {
                        throw e;
                    }
                    this.devices[i++] = null;
                    if (this.devicesMap.containsKey(deviceName)) break block6;
                    this.devicesMap.put(deviceName, null);
                }
            }
            String attribute = fullAttribute.split("/")[3];
            if (!this.attributesMap.containsKey(deviceName)) {
                ArrayList<String> attributesNames = new ArrayList<String>();
                attributesNames.add(attribute);
                this.attributesMap.put(deviceName, attributesNames);
                continue;
            }
            this.attributesMap.get(deviceName).add(attribute);
        }
    }

    public synchronized void readAsync() {
        this.xlogger.entry(new Object[]{this.devicesMap.keySet()});
        if (!this.readAnswersIDs.isEmpty()) {
            this.getReadReplies();
        }
        this.errorsMap.clear();
        for (String deviceName : this.devicesMap.keySet()) {
            List<String> attributeNames = this.attributesMap.get(deviceName);
            DeviceProxy devElement = this.devicesMap.get(deviceName);
            if (devElement == null) continue;
            try {
                int rid = devElement.read_attribute_asynch(attributeNames.toArray(new String[attributeNames.size()]));
                this.readAnswersIDs.put(deviceName, rid);
            }
            catch (DevFailed e) {
                this.logger.error("error", (Throwable)e);
                this.logger.error(DevFailedUtils.toString((DevFailed)e));
                for (String attribute : attributeNames) {
                    this.errorsMap.put(deviceName + "/" + attribute, e.errors);
                }
            }
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DeviceAttribute[] getReadReplies() {
        this.xlogger.entry(new Object[]{this.devicesMap.keySet()});
        if (!this.readAnswersIDs.isEmpty()) {
            HashMap<String, DeviceAttribute> replies = new HashMap<String, DeviceAttribute>();
            try {
                this.readReply = new ArrayList<DeviceAttribute>();
                for (String deviceName : this.devicesMap.keySet()) {
                    List<String> attributeNames = this.attributesMap.get(deviceName);
                    DeviceProxy devElement = this.devicesMap.get(deviceName);
                    if (devElement == null) continue;
                    try {
                        Integer id = this.readAnswersIDs.get(deviceName);
                        if (id == null) continue;
                        DeviceAttribute[] subReply = devElement.read_attribute_reply(id.intValue(), this.timeout);
                        int i = 0;
                        for (String attribute : attributeNames) {
                            replies.put(deviceName + "/" + attribute, subReply[i++]);
                        }
                    }
                    catch (DevFailed e) {
                        this.logger.error("error", (Throwable)e);
                        this.logger.error(DevFailedUtils.toString((DevFailed)e));
                        for (String attribute : attributeNames) {
                            this.errorsMap.put(deviceName + "/" + attribute, e.errors);
                        }
                    }
                }
            }
            finally {
                this.readAnswersIDs.clear();
            }
            for (String userAttributesName : this.userAttributesNames) {
                this.readReply.add((DeviceAttribute)replies.get(userAttributesName));
            }
        }
        this.xlogger.exit();
        return this.readReply.toArray(new DeviceAttribute[this.readReply.size()]);
    }

    public synchronized DeviceAttribute[] read() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.readAsync();
        DeviceAttribute[] replies = this.getReadReplies();
        if (this.throwExceptions && !this.errorsMap.isEmpty()) {
            DevError[] allErrors = null;
            for (DevError[] errors : this.errorsMap.values()) {
                for (DevError error : errors) {
                    allErrors = (DevError[])ArrayUtils.add(allErrors, (Object)error);
                }
            }
            throw new DevFailed(allErrors);
        }
        this.xlogger.exit();
        return replies;
    }

    private void writeAttributesAsync(DeviceAttribute ... values) throws DevFailed {
        this.errorsMap.clear();
        if (!this.writeAnswersIDs.isEmpty()) {
            this.writeAnswersIDs.clear();
        }
        HashMap<String, ArrayList<DeviceAttribute>> inputs = new HashMap<String, ArrayList<DeviceAttribute>>();
        int i = 0;
        for (DeviceAttribute value : values) {
            String deviceName;
            ArrayList<DeviceAttribute> list;
            if ((list = (ArrayList<DeviceAttribute>)inputs.get(deviceName = this.devices[i++].get_name())) == null) {
                list = new ArrayList<DeviceAttribute>();
            }
            if (value != null) {
                list.add(value);
            }
            inputs.put(deviceName, list);
        }
        for (String deviceName : this.devicesMap.keySet()) {
            DeviceProxy devElement = this.devicesMap.get(deviceName);
            List list = (List)inputs.get(deviceName);
            if (devElement == null) continue;
            try {
                int answersID = devElement.write_attribute_asynch(list.toArray(new DeviceAttribute[list.size()]), false);
                this.writeAnswersIDs.put(deviceName, answersID);
            }
            catch (DevFailed e) {
                this.logger.error("error", (Throwable)e);
                this.logger.error(DevFailedUtils.toString((DevFailed)e));
                DevError[] errors = e.errors;
                List<String> attributeNames = this.attributesMap.get(deviceName);
                for (String attribute : attributeNames) {
                    this.errorsMap.put(deviceName + "/" + attribute, errors);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getWriteReplies() throws DevFailed {
        if (!this.writeAnswersIDs.isEmpty()) {
            try {
                for (String deviceName : this.devicesMap.keySet()) {
                    DeviceProxy devElement = this.devicesMap.get(deviceName);
                    if (devElement == null || this.writeAnswersIDs.get(deviceName) == null) continue;
                    try {
                        devElement.write_attribute_reply(this.writeAnswersIDs.get(deviceName).intValue(), this.timeout);
                    }
                    catch (DevFailed e) {
                        this.logger.error("error", (Throwable)e);
                        this.logger.error(DevFailedUtils.toString((DevFailed)e));
                        if (e instanceof NamedDevFailedList) {
                            NamedDevFailedList list = (NamedDevFailedList)e;
                            for (int i = 0; i < list.get_faulty_attr_nb(); ++i) {
                                NamedDevFailed named = list.elementAt(i);
                                this.errorsMap.put(deviceName + "/" + named.name, named.err_stack);
                            }
                            continue;
                        }
                        DevError[] errors = e.errors;
                        List<String> attributeNames = this.attributesMap.get(deviceName);
                        for (String attribute : attributeNames) {
                            this.errorsMap.put(deviceName + "/" + attribute, errors);
                        }
                    }
                }
            }
            finally {
                this.writeAnswersIDs.clear();
            }
            if (!this.errorsMap.isEmpty()) {
                DevError[] allErrors = null;
                for (DevError[] errors : this.errorsMap.values()) {
                    for (DevError error : errors) {
                        allErrors = (DevError[])ArrayUtils.add(allErrors, (Object)error);
                    }
                }
                throw new DevFailed(allErrors);
            }
        }
    }

    public synchronized void writeAsync(DeviceAttribute ... value) throws DevFailed {
        this.writeAttributesAsync(value);
    }

    public synchronized void write(DeviceAttribute ... value) throws DevFailed {
        this.writeAsync(value);
        this.getWriteReplies();
    }

    public synchronized AttributeInfoEx[] getConfig() throws DevFailed {
        this.errorsMap.clear();
        AttributeInfoEx[] result = new AttributeInfoEx[this.userAttributesNames.length];
        Object[] allErrors = new DevError[]{};
        HashMap<String, AttributeInfoEx> replies = new HashMap<String, AttributeInfoEx>();
        for (String deviceName : this.devicesMap.keySet()) {
            List<String> attributeNames = this.attributesMap.get(deviceName);
            DeviceProxy devElement = this.devicesMap.get(deviceName);
            if (devElement == null) continue;
            try {
                AttributeInfoEx[] subReply = devElement.get_attribute_info_ex(attributeNames.toArray(new String[attributeNames.size()]));
                int i = 0;
                for (String attribute : attributeNames) {
                    replies.put(deviceName + "/" + attribute, subReply[i++]);
                }
            }
            catch (DevFailed e) {
                this.logger.error("error", (Throwable)e);
                this.logger.error(DevFailedUtils.toString((DevFailed)e));
                DevError[] errors = e.errors;
                for (DevError error : errors) {
                    allErrors = (DevError[])ArrayUtils.add((Object[])allErrors, (Object)error);
                }
                for (String attribute : attributeNames) {
                    this.errorsMap.put(deviceName + "/" + attribute, errors);
                }
            }
        }
        if (allErrors.length > 0 && this.throwExceptions) {
            throw new DevFailed((DevError[])allErrors);
        }
        int i = 0;
        for (String userAttributesName : this.userAttributesNames) {
            result[i++] = (AttributeInfoEx)replies.get(userAttributesName);
        }
        return result;
    }

    public DeviceProxy getDeviceProxy(String attributeName) {
        return this.devicesMap.get(attributeName.toLowerCase(Locale.ENGLISH));
    }

    public synchronized String[] getAttributeNames() {
        return Arrays.copyOf(this.userAttributesNames, this.userAttributesNames.length);
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized Map<String, DevError[]> getErrors() {
        return new HashMap<String, DevError[]>(this.errorsMap);
    }

    public synchronized boolean hasFailed() {
        return !this.errorsMap.isEmpty();
    }
}

