/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package tachyon.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerService {

  public interface Iface {

    public void accessBlock(long blockId) throws org.apache.thrift.TException;

    public void addCheckpoint(long userId, int fileId) throws FileDoesNotExistException, SuspectedFileSizeException, FailedToCheckpointException, BlockInfoException, org.apache.thrift.TException;

    public boolean asyncCheckpoint(int fileId) throws TachyonException, org.apache.thrift.TException;

    /**
     * Used to cache a block into Tachyon space, worker will move the temporary block file from user
     * folder to data folder, and update the space usage information related. then update the block
     * information to master.
     * 
     * @param userId
     * @param blockId
     */
    public void cacheBlock(long userId, long blockId) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException;

    /**
     * Used to cancel a block which is being written. worker will delete the temporary block file and
     * the location and space information related, then reclaim space allocated to the block.
     * 
     * @param userId
     * @param blockId
     */
    public void cancelBlock(long userId, long blockId) throws org.apache.thrift.TException;

    /**
     * Used to get user's temporary folder on under file system, and the path of the user's temporary
     * folder will be returned.
     * 
     * @param userId
     */
    public String getUserUfsTempFolder(long userId) throws org.apache.thrift.TException;

    /**
     * Lock the file in Tachyon's space while the user is reading it, and the path of the block file
     * locked will be returned, if the block file is not found, FileDoesNotExistException will be
     * thrown.
     * 
     * @param blockId
     * @param userId
     */
    public String lockBlock(long blockId, long userId) throws FileDoesNotExistException, org.apache.thrift.TException;

    /**
     * Used to promote block on under storage layer to top storage layer when there are more than one
     * storage layers in Tachyon's space. return true if the block is successfully promoted, false
     * otherwise.
     * 
     * @param blockId
     */
    public boolean promoteBlock(long blockId) throws org.apache.thrift.TException;

    /**
     * Used to allocate location and space for a new coming block, worker will choose the appropriate
     * storage directory which fits the initial block size by some allocation strategy, and the
     * temporary file path of the block file will be returned. if there is no enough space on Tachyon
     * storage OutOfSpaceException will be thrown, if the file is already being written by the user,
     * FileAlreadyExistException will be thrown.
     * 
     * @param userId
     * @param blockId
     * @param initialBytes
     */
    public String requestBlockLocation(long userId, long blockId, long initialBytes) throws OutOfSpaceException, FileAlreadyExistException, org.apache.thrift.TException;

    /**
     * Used to request space for some block file. return true if the worker successfully allocates
     * space for the block on block’s location, false if there is no enough space, if there is no
     * information of the block on worker, FileDoesNotExistException will be thrown.
     * 
     * @param userId
     * @param blockId
     * @param requestBytes
     */
    public boolean requestSpace(long userId, long blockId, long requestBytes) throws FileDoesNotExistException, org.apache.thrift.TException;

    /**
     * Used to unlock a block after the block is accessed, if the block is to be removed, delete the
     * block file. return true if successfully unlock the block, return false if the block is not
     * found or failed to delete the block.
     * 
     * @param blockId
     * @param userId
     */
    public boolean unlockBlock(long blockId, long userId) throws org.apache.thrift.TException;

    /**
     * Local user send heartbeat to local worker to keep its temporary folder.
     * 
     * @param userId
     */
    public void userHeartbeat(long userId) throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void accessBlock(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addCheckpoint(long userId, int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void asyncCheckpoint(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cacheBlock(long userId, long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cancelBlock(long userId, long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserUfsTempFolder(long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void lockBlock(long blockId, long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void promoteBlock(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void requestBlockLocation(long userId, long blockId, long initialBytes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void requestSpace(long userId, long blockId, long requestBytes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void unlockBlock(long blockId, long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void userHeartbeat(long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void accessBlock(long blockId) throws org.apache.thrift.TException
    {
      send_accessBlock(blockId);
      recv_accessBlock();
    }

    public void send_accessBlock(long blockId) throws org.apache.thrift.TException
    {
      accessBlock_args args = new accessBlock_args();
      args.setBlockId(blockId);
      sendBase("accessBlock", args);
    }

    public void recv_accessBlock() throws org.apache.thrift.TException
    {
      accessBlock_result result = new accessBlock_result();
      receiveBase(result, "accessBlock");
      return;
    }

    public void addCheckpoint(long userId, int fileId) throws FileDoesNotExistException, SuspectedFileSizeException, FailedToCheckpointException, BlockInfoException, org.apache.thrift.TException
    {
      send_addCheckpoint(userId, fileId);
      recv_addCheckpoint();
    }

    public void send_addCheckpoint(long userId, int fileId) throws org.apache.thrift.TException
    {
      addCheckpoint_args args = new addCheckpoint_args();
      args.setUserId(userId);
      args.setFileId(fileId);
      sendBase("addCheckpoint", args);
    }

    public void recv_addCheckpoint() throws FileDoesNotExistException, SuspectedFileSizeException, FailedToCheckpointException, BlockInfoException, org.apache.thrift.TException
    {
      addCheckpoint_result result = new addCheckpoint_result();
      receiveBase(result, "addCheckpoint");
      if (result.eP != null) {
        throw result.eP;
      }
      if (result.eS != null) {
        throw result.eS;
      }
      if (result.eF != null) {
        throw result.eF;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      return;
    }

    public boolean asyncCheckpoint(int fileId) throws TachyonException, org.apache.thrift.TException
    {
      send_asyncCheckpoint(fileId);
      return recv_asyncCheckpoint();
    }

    public void send_asyncCheckpoint(int fileId) throws org.apache.thrift.TException
    {
      asyncCheckpoint_args args = new asyncCheckpoint_args();
      args.setFileId(fileId);
      sendBase("asyncCheckpoint", args);
    }

    public boolean recv_asyncCheckpoint() throws TachyonException, org.apache.thrift.TException
    {
      asyncCheckpoint_result result = new asyncCheckpoint_result();
      receiveBase(result, "asyncCheckpoint");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "asyncCheckpoint failed: unknown result");
    }

    public void cacheBlock(long userId, long blockId) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException
    {
      send_cacheBlock(userId, blockId);
      recv_cacheBlock();
    }

    public void send_cacheBlock(long userId, long blockId) throws org.apache.thrift.TException
    {
      cacheBlock_args args = new cacheBlock_args();
      args.setUserId(userId);
      args.setBlockId(blockId);
      sendBase("cacheBlock", args);
    }

    public void recv_cacheBlock() throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException
    {
      cacheBlock_result result = new cacheBlock_result();
      receiveBase(result, "cacheBlock");
      if (result.eP != null) {
        throw result.eP;
      }
      if (result.eS != null) {
        throw result.eS;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      return;
    }

    public void cancelBlock(long userId, long blockId) throws org.apache.thrift.TException
    {
      send_cancelBlock(userId, blockId);
      recv_cancelBlock();
    }

    public void send_cancelBlock(long userId, long blockId) throws org.apache.thrift.TException
    {
      cancelBlock_args args = new cancelBlock_args();
      args.setUserId(userId);
      args.setBlockId(blockId);
      sendBase("cancelBlock", args);
    }

    public void recv_cancelBlock() throws org.apache.thrift.TException
    {
      cancelBlock_result result = new cancelBlock_result();
      receiveBase(result, "cancelBlock");
      return;
    }

    public String getUserUfsTempFolder(long userId) throws org.apache.thrift.TException
    {
      send_getUserUfsTempFolder(userId);
      return recv_getUserUfsTempFolder();
    }

    public void send_getUserUfsTempFolder(long userId) throws org.apache.thrift.TException
    {
      getUserUfsTempFolder_args args = new getUserUfsTempFolder_args();
      args.setUserId(userId);
      sendBase("getUserUfsTempFolder", args);
    }

    public String recv_getUserUfsTempFolder() throws org.apache.thrift.TException
    {
      getUserUfsTempFolder_result result = new getUserUfsTempFolder_result();
      receiveBase(result, "getUserUfsTempFolder");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserUfsTempFolder failed: unknown result");
    }

    public String lockBlock(long blockId, long userId) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_lockBlock(blockId, userId);
      return recv_lockBlock();
    }

    public void send_lockBlock(long blockId, long userId) throws org.apache.thrift.TException
    {
      lockBlock_args args = new lockBlock_args();
      args.setBlockId(blockId);
      args.setUserId(userId);
      sendBase("lockBlock", args);
    }

    public String recv_lockBlock() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      lockBlock_result result = new lockBlock_result();
      receiveBase(result, "lockBlock");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eP != null) {
        throw result.eP;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "lockBlock failed: unknown result");
    }

    public boolean promoteBlock(long blockId) throws org.apache.thrift.TException
    {
      send_promoteBlock(blockId);
      return recv_promoteBlock();
    }

    public void send_promoteBlock(long blockId) throws org.apache.thrift.TException
    {
      promoteBlock_args args = new promoteBlock_args();
      args.setBlockId(blockId);
      sendBase("promoteBlock", args);
    }

    public boolean recv_promoteBlock() throws org.apache.thrift.TException
    {
      promoteBlock_result result = new promoteBlock_result();
      receiveBase(result, "promoteBlock");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "promoteBlock failed: unknown result");
    }

    public String requestBlockLocation(long userId, long blockId, long initialBytes) throws OutOfSpaceException, FileAlreadyExistException, org.apache.thrift.TException
    {
      send_requestBlockLocation(userId, blockId, initialBytes);
      return recv_requestBlockLocation();
    }

    public void send_requestBlockLocation(long userId, long blockId, long initialBytes) throws org.apache.thrift.TException
    {
      requestBlockLocation_args args = new requestBlockLocation_args();
      args.setUserId(userId);
      args.setBlockId(blockId);
      args.setInitialBytes(initialBytes);
      sendBase("requestBlockLocation", args);
    }

    public String recv_requestBlockLocation() throws OutOfSpaceException, FileAlreadyExistException, org.apache.thrift.TException
    {
      requestBlockLocation_result result = new requestBlockLocation_result();
      receiveBase(result, "requestBlockLocation");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eP != null) {
        throw result.eP;
      }
      if (result.eS != null) {
        throw result.eS;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "requestBlockLocation failed: unknown result");
    }

    public boolean requestSpace(long userId, long blockId, long requestBytes) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_requestSpace(userId, blockId, requestBytes);
      return recv_requestSpace();
    }

    public void send_requestSpace(long userId, long blockId, long requestBytes) throws org.apache.thrift.TException
    {
      requestSpace_args args = new requestSpace_args();
      args.setUserId(userId);
      args.setBlockId(blockId);
      args.setRequestBytes(requestBytes);
      sendBase("requestSpace", args);
    }

    public boolean recv_requestSpace() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      requestSpace_result result = new requestSpace_result();
      receiveBase(result, "requestSpace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eP != null) {
        throw result.eP;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "requestSpace failed: unknown result");
    }

    public boolean unlockBlock(long blockId, long userId) throws org.apache.thrift.TException
    {
      send_unlockBlock(blockId, userId);
      return recv_unlockBlock();
    }

    public void send_unlockBlock(long blockId, long userId) throws org.apache.thrift.TException
    {
      unlockBlock_args args = new unlockBlock_args();
      args.setBlockId(blockId);
      args.setUserId(userId);
      sendBase("unlockBlock", args);
    }

    public boolean recv_unlockBlock() throws org.apache.thrift.TException
    {
      unlockBlock_result result = new unlockBlock_result();
      receiveBase(result, "unlockBlock");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "unlockBlock failed: unknown result");
    }

    public void userHeartbeat(long userId) throws org.apache.thrift.TException
    {
      send_userHeartbeat(userId);
      recv_userHeartbeat();
    }

    public void send_userHeartbeat(long userId) throws org.apache.thrift.TException
    {
      userHeartbeat_args args = new userHeartbeat_args();
      args.setUserId(userId);
      sendBase("userHeartbeat", args);
    }

    public void recv_userHeartbeat() throws org.apache.thrift.TException
    {
      userHeartbeat_result result = new userHeartbeat_result();
      receiveBase(result, "userHeartbeat");
      return;
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void accessBlock(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      accessBlock_call method_call = new accessBlock_call(blockId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class accessBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long blockId;
      public accessBlock_call(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.blockId = blockId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("accessBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        accessBlock_args args = new accessBlock_args();
        args.setBlockId(blockId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_accessBlock();
      }
    }

    public void addCheckpoint(long userId, int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addCheckpoint_call method_call = new addCheckpoint_call(userId, fileId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addCheckpoint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      private int fileId;
      public addCheckpoint_call(long userId, int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.fileId = fileId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addCheckpoint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addCheckpoint_args args = new addCheckpoint_args();
        args.setUserId(userId);
        args.setFileId(fileId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws FileDoesNotExistException, SuspectedFileSizeException, FailedToCheckpointException, BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_addCheckpoint();
      }
    }

    public void asyncCheckpoint(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      asyncCheckpoint_call method_call = new asyncCheckpoint_call(fileId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class asyncCheckpoint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      public asyncCheckpoint_call(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("asyncCheckpoint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        asyncCheckpoint_args args = new asyncCheckpoint_args();
        args.setFileId(fileId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_asyncCheckpoint();
      }
    }

    public void cacheBlock(long userId, long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cacheBlock_call method_call = new cacheBlock_call(userId, blockId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cacheBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      private long blockId;
      public cacheBlock_call(long userId, long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.blockId = blockId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cacheBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cacheBlock_args args = new cacheBlock_args();
        args.setUserId(userId);
        args.setBlockId(blockId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_cacheBlock();
      }
    }

    public void cancelBlock(long userId, long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cancelBlock_call method_call = new cancelBlock_call(userId, blockId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cancelBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      private long blockId;
      public cancelBlock_call(long userId, long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.blockId = blockId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cancelBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cancelBlock_args args = new cancelBlock_args();
        args.setUserId(userId);
        args.setBlockId(blockId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_cancelBlock();
      }
    }

    public void getUserUfsTempFolder(long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserUfsTempFolder_call method_call = new getUserUfsTempFolder_call(userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserUfsTempFolder_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      public getUserUfsTempFolder_call(long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserUfsTempFolder", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserUfsTempFolder_args args = new getUserUfsTempFolder_args();
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserUfsTempFolder();
      }
    }

    public void lockBlock(long blockId, long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      lockBlock_call method_call = new lockBlock_call(blockId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class lockBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long blockId;
      private long userId;
      public lockBlock_call(long blockId, long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.blockId = blockId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("lockBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        lockBlock_args args = new lockBlock_args();
        args.setBlockId(blockId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_lockBlock();
      }
    }

    public void promoteBlock(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      promoteBlock_call method_call = new promoteBlock_call(blockId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class promoteBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long blockId;
      public promoteBlock_call(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.blockId = blockId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("promoteBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        promoteBlock_args args = new promoteBlock_args();
        args.setBlockId(blockId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_promoteBlock();
      }
    }

    public void requestBlockLocation(long userId, long blockId, long initialBytes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      requestBlockLocation_call method_call = new requestBlockLocation_call(userId, blockId, initialBytes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class requestBlockLocation_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      private long blockId;
      private long initialBytes;
      public requestBlockLocation_call(long userId, long blockId, long initialBytes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.blockId = blockId;
        this.initialBytes = initialBytes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("requestBlockLocation", org.apache.thrift.protocol.TMessageType.CALL, 0));
        requestBlockLocation_args args = new requestBlockLocation_args();
        args.setUserId(userId);
        args.setBlockId(blockId);
        args.setInitialBytes(initialBytes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws OutOfSpaceException, FileAlreadyExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_requestBlockLocation();
      }
    }

    public void requestSpace(long userId, long blockId, long requestBytes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      requestSpace_call method_call = new requestSpace_call(userId, blockId, requestBytes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class requestSpace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      private long blockId;
      private long requestBytes;
      public requestSpace_call(long userId, long blockId, long requestBytes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.blockId = blockId;
        this.requestBytes = requestBytes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("requestSpace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        requestSpace_args args = new requestSpace_args();
        args.setUserId(userId);
        args.setBlockId(blockId);
        args.setRequestBytes(requestBytes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_requestSpace();
      }
    }

    public void unlockBlock(long blockId, long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      unlockBlock_call method_call = new unlockBlock_call(blockId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class unlockBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long blockId;
      private long userId;
      public unlockBlock_call(long blockId, long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.blockId = blockId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("unlockBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        unlockBlock_args args = new unlockBlock_args();
        args.setBlockId(blockId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_unlockBlock();
      }
    }

    public void userHeartbeat(long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      userHeartbeat_call method_call = new userHeartbeat_call(userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class userHeartbeat_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long userId;
      public userHeartbeat_call(long userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("userHeartbeat", org.apache.thrift.protocol.TMessageType.CALL, 0));
        userHeartbeat_args args = new userHeartbeat_args();
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_userHeartbeat();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("accessBlock", new accessBlock());
      processMap.put("addCheckpoint", new addCheckpoint());
      processMap.put("asyncCheckpoint", new asyncCheckpoint());
      processMap.put("cacheBlock", new cacheBlock());
      processMap.put("cancelBlock", new cancelBlock());
      processMap.put("getUserUfsTempFolder", new getUserUfsTempFolder());
      processMap.put("lockBlock", new lockBlock());
      processMap.put("promoteBlock", new promoteBlock());
      processMap.put("requestBlockLocation", new requestBlockLocation());
      processMap.put("requestSpace", new requestSpace());
      processMap.put("unlockBlock", new unlockBlock());
      processMap.put("userHeartbeat", new userHeartbeat());
      return processMap;
    }

    public static class accessBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, accessBlock_args> {
      public accessBlock() {
        super("accessBlock");
      }

      public accessBlock_args getEmptyArgsInstance() {
        return new accessBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public accessBlock_result getResult(I iface, accessBlock_args args) throws org.apache.thrift.TException {
        accessBlock_result result = new accessBlock_result();
        iface.accessBlock(args.blockId);
        return result;
      }
    }

    public static class addCheckpoint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addCheckpoint_args> {
      public addCheckpoint() {
        super("addCheckpoint");
      }

      public addCheckpoint_args getEmptyArgsInstance() {
        return new addCheckpoint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addCheckpoint_result getResult(I iface, addCheckpoint_args args) throws org.apache.thrift.TException {
        addCheckpoint_result result = new addCheckpoint_result();
        try {
          iface.addCheckpoint(args.userId, args.fileId);
        } catch (FileDoesNotExistException eP) {
          result.eP = eP;
        } catch (SuspectedFileSizeException eS) {
          result.eS = eS;
        } catch (FailedToCheckpointException eF) {
          result.eF = eF;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        }
        return result;
      }
    }

    public static class asyncCheckpoint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, asyncCheckpoint_args> {
      public asyncCheckpoint() {
        super("asyncCheckpoint");
      }

      public asyncCheckpoint_args getEmptyArgsInstance() {
        return new asyncCheckpoint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public asyncCheckpoint_result getResult(I iface, asyncCheckpoint_args args) throws org.apache.thrift.TException {
        asyncCheckpoint_result result = new asyncCheckpoint_result();
        try {
          result.success = iface.asyncCheckpoint(args.fileId);
          result.setSuccessIsSet(true);
        } catch (TachyonException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class cacheBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cacheBlock_args> {
      public cacheBlock() {
        super("cacheBlock");
      }

      public cacheBlock_args getEmptyArgsInstance() {
        return new cacheBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cacheBlock_result getResult(I iface, cacheBlock_args args) throws org.apache.thrift.TException {
        cacheBlock_result result = new cacheBlock_result();
        try {
          iface.cacheBlock(args.userId, args.blockId);
        } catch (FileDoesNotExistException eP) {
          result.eP = eP;
        } catch (SuspectedFileSizeException eS) {
          result.eS = eS;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        }
        return result;
      }
    }

    public static class cancelBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cancelBlock_args> {
      public cancelBlock() {
        super("cancelBlock");
      }

      public cancelBlock_args getEmptyArgsInstance() {
        return new cancelBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cancelBlock_result getResult(I iface, cancelBlock_args args) throws org.apache.thrift.TException {
        cancelBlock_result result = new cancelBlock_result();
        iface.cancelBlock(args.userId, args.blockId);
        return result;
      }
    }

    public static class getUserUfsTempFolder<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserUfsTempFolder_args> {
      public getUserUfsTempFolder() {
        super("getUserUfsTempFolder");
      }

      public getUserUfsTempFolder_args getEmptyArgsInstance() {
        return new getUserUfsTempFolder_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserUfsTempFolder_result getResult(I iface, getUserUfsTempFolder_args args) throws org.apache.thrift.TException {
        getUserUfsTempFolder_result result = new getUserUfsTempFolder_result();
        result.success = iface.getUserUfsTempFolder(args.userId);
        return result;
      }
    }

    public static class lockBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, lockBlock_args> {
      public lockBlock() {
        super("lockBlock");
      }

      public lockBlock_args getEmptyArgsInstance() {
        return new lockBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public lockBlock_result getResult(I iface, lockBlock_args args) throws org.apache.thrift.TException {
        lockBlock_result result = new lockBlock_result();
        try {
          result.success = iface.lockBlock(args.blockId, args.userId);
        } catch (FileDoesNotExistException eP) {
          result.eP = eP;
        }
        return result;
      }
    }

    public static class promoteBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, promoteBlock_args> {
      public promoteBlock() {
        super("promoteBlock");
      }

      public promoteBlock_args getEmptyArgsInstance() {
        return new promoteBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public promoteBlock_result getResult(I iface, promoteBlock_args args) throws org.apache.thrift.TException {
        promoteBlock_result result = new promoteBlock_result();
        result.success = iface.promoteBlock(args.blockId);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class requestBlockLocation<I extends Iface> extends org.apache.thrift.ProcessFunction<I, requestBlockLocation_args> {
      public requestBlockLocation() {
        super("requestBlockLocation");
      }

      public requestBlockLocation_args getEmptyArgsInstance() {
        return new requestBlockLocation_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public requestBlockLocation_result getResult(I iface, requestBlockLocation_args args) throws org.apache.thrift.TException {
        requestBlockLocation_result result = new requestBlockLocation_result();
        try {
          result.success = iface.requestBlockLocation(args.userId, args.blockId, args.initialBytes);
        } catch (OutOfSpaceException eP) {
          result.eP = eP;
        } catch (FileAlreadyExistException eS) {
          result.eS = eS;
        }
        return result;
      }
    }

    public static class requestSpace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, requestSpace_args> {
      public requestSpace() {
        super("requestSpace");
      }

      public requestSpace_args getEmptyArgsInstance() {
        return new requestSpace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public requestSpace_result getResult(I iface, requestSpace_args args) throws org.apache.thrift.TException {
        requestSpace_result result = new requestSpace_result();
        try {
          result.success = iface.requestSpace(args.userId, args.blockId, args.requestBytes);
          result.setSuccessIsSet(true);
        } catch (FileDoesNotExistException eP) {
          result.eP = eP;
        }
        return result;
      }
    }

    public static class unlockBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, unlockBlock_args> {
      public unlockBlock() {
        super("unlockBlock");
      }

      public unlockBlock_args getEmptyArgsInstance() {
        return new unlockBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public unlockBlock_result getResult(I iface, unlockBlock_args args) throws org.apache.thrift.TException {
        unlockBlock_result result = new unlockBlock_result();
        result.success = iface.unlockBlock(args.blockId, args.userId);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class userHeartbeat<I extends Iface> extends org.apache.thrift.ProcessFunction<I, userHeartbeat_args> {
      public userHeartbeat() {
        super("userHeartbeat");
      }

      public userHeartbeat_args getEmptyArgsInstance() {
        return new userHeartbeat_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public userHeartbeat_result getResult(I iface, userHeartbeat_args args) throws org.apache.thrift.TException {
        userHeartbeat_result result = new userHeartbeat_result();
        iface.userHeartbeat(args.userId);
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("accessBlock", new accessBlock());
      processMap.put("addCheckpoint", new addCheckpoint());
      processMap.put("asyncCheckpoint", new asyncCheckpoint());
      processMap.put("cacheBlock", new cacheBlock());
      processMap.put("cancelBlock", new cancelBlock());
      processMap.put("getUserUfsTempFolder", new getUserUfsTempFolder());
      processMap.put("lockBlock", new lockBlock());
      processMap.put("promoteBlock", new promoteBlock());
      processMap.put("requestBlockLocation", new requestBlockLocation());
      processMap.put("requestSpace", new requestSpace());
      processMap.put("unlockBlock", new unlockBlock());
      processMap.put("userHeartbeat", new userHeartbeat());
      return processMap;
    }

    public static class accessBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, accessBlock_args, Void> {
      public accessBlock() {
        super("accessBlock");
      }

      public accessBlock_args getEmptyArgsInstance() {
        return new accessBlock_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            accessBlock_result result = new accessBlock_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            accessBlock_result result = new accessBlock_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, accessBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.accessBlock(args.blockId,resultHandler);
      }
    }

    public static class addCheckpoint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addCheckpoint_args, Void> {
      public addCheckpoint() {
        super("addCheckpoint");
      }

      public addCheckpoint_args getEmptyArgsInstance() {
        return new addCheckpoint_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            addCheckpoint_result result = new addCheckpoint_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addCheckpoint_result result = new addCheckpoint_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eP = (FileDoesNotExistException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
            else             if (e instanceof SuspectedFileSizeException) {
                        result.eS = (SuspectedFileSizeException) e;
                        result.setESIsSet(true);
                        msg = result;
            }
            else             if (e instanceof FailedToCheckpointException) {
                        result.eF = (FailedToCheckpointException) e;
                        result.setEFIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addCheckpoint_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.addCheckpoint(args.userId, args.fileId,resultHandler);
      }
    }

    public static class asyncCheckpoint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, asyncCheckpoint_args, Boolean> {
      public asyncCheckpoint() {
        super("asyncCheckpoint");
      }

      public asyncCheckpoint_args getEmptyArgsInstance() {
        return new asyncCheckpoint_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            asyncCheckpoint_result result = new asyncCheckpoint_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            asyncCheckpoint_result result = new asyncCheckpoint_result();
            if (e instanceof TachyonException) {
                        result.e = (TachyonException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, asyncCheckpoint_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.asyncCheckpoint(args.fileId,resultHandler);
      }
    }

    public static class cacheBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cacheBlock_args, Void> {
      public cacheBlock() {
        super("cacheBlock");
      }

      public cacheBlock_args getEmptyArgsInstance() {
        return new cacheBlock_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            cacheBlock_result result = new cacheBlock_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cacheBlock_result result = new cacheBlock_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eP = (FileDoesNotExistException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
            else             if (e instanceof SuspectedFileSizeException) {
                        result.eS = (SuspectedFileSizeException) e;
                        result.setESIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cacheBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.cacheBlock(args.userId, args.blockId,resultHandler);
      }
    }

    public static class cancelBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cancelBlock_args, Void> {
      public cancelBlock() {
        super("cancelBlock");
      }

      public cancelBlock_args getEmptyArgsInstance() {
        return new cancelBlock_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            cancelBlock_result result = new cancelBlock_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cancelBlock_result result = new cancelBlock_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cancelBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.cancelBlock(args.userId, args.blockId,resultHandler);
      }
    }

    public static class getUserUfsTempFolder<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUserUfsTempFolder_args, String> {
      public getUserUfsTempFolder() {
        super("getUserUfsTempFolder");
      }

      public getUserUfsTempFolder_args getEmptyArgsInstance() {
        return new getUserUfsTempFolder_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getUserUfsTempFolder_result result = new getUserUfsTempFolder_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUserUfsTempFolder_result result = new getUserUfsTempFolder_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUserUfsTempFolder_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getUserUfsTempFolder(args.userId,resultHandler);
      }
    }

    public static class lockBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, lockBlock_args, String> {
      public lockBlock() {
        super("lockBlock");
      }

      public lockBlock_args getEmptyArgsInstance() {
        return new lockBlock_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            lockBlock_result result = new lockBlock_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            lockBlock_result result = new lockBlock_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eP = (FileDoesNotExistException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, lockBlock_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.lockBlock(args.blockId, args.userId,resultHandler);
      }
    }

    public static class promoteBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, promoteBlock_args, Boolean> {
      public promoteBlock() {
        super("promoteBlock");
      }

      public promoteBlock_args getEmptyArgsInstance() {
        return new promoteBlock_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            promoteBlock_result result = new promoteBlock_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            promoteBlock_result result = new promoteBlock_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, promoteBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.promoteBlock(args.blockId,resultHandler);
      }
    }

    public static class requestBlockLocation<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, requestBlockLocation_args, String> {
      public requestBlockLocation() {
        super("requestBlockLocation");
      }

      public requestBlockLocation_args getEmptyArgsInstance() {
        return new requestBlockLocation_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            requestBlockLocation_result result = new requestBlockLocation_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            requestBlockLocation_result result = new requestBlockLocation_result();
            if (e instanceof OutOfSpaceException) {
                        result.eP = (OutOfSpaceException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
            else             if (e instanceof FileAlreadyExistException) {
                        result.eS = (FileAlreadyExistException) e;
                        result.setESIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, requestBlockLocation_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.requestBlockLocation(args.userId, args.blockId, args.initialBytes,resultHandler);
      }
    }

    public static class requestSpace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, requestSpace_args, Boolean> {
      public requestSpace() {
        super("requestSpace");
      }

      public requestSpace_args getEmptyArgsInstance() {
        return new requestSpace_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            requestSpace_result result = new requestSpace_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            requestSpace_result result = new requestSpace_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eP = (FileDoesNotExistException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, requestSpace_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.requestSpace(args.userId, args.blockId, args.requestBytes,resultHandler);
      }
    }

    public static class unlockBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, unlockBlock_args, Boolean> {
      public unlockBlock() {
        super("unlockBlock");
      }

      public unlockBlock_args getEmptyArgsInstance() {
        return new unlockBlock_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            unlockBlock_result result = new unlockBlock_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            unlockBlock_result result = new unlockBlock_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, unlockBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.unlockBlock(args.blockId, args.userId,resultHandler);
      }
    }

    public static class userHeartbeat<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, userHeartbeat_args, Void> {
      public userHeartbeat() {
        super("userHeartbeat");
      }

      public userHeartbeat_args getEmptyArgsInstance() {
        return new userHeartbeat_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            userHeartbeat_result result = new userHeartbeat_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            userHeartbeat_result result = new userHeartbeat_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, userHeartbeat_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.userHeartbeat(args.userId,resultHandler);
      }
    }

  }

  public static class accessBlock_args implements org.apache.thrift.TBase<accessBlock_args, accessBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<accessBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("accessBlock_args");

    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new accessBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new accessBlock_argsTupleSchemeFactory());
    }

    public long blockId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      BLOCK_ID((short)1, "blockId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // BLOCK_ID
            return BLOCK_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BLOCKID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(accessBlock_args.class, metaDataMap);
    }

    public accessBlock_args() {
    }

    public accessBlock_args(
      long blockId)
    {
      this();
      this.blockId = blockId;
      setBlockIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public accessBlock_args(accessBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.blockId = other.blockId;
    }

    public accessBlock_args deepCopy() {
      return new accessBlock_args(this);
    }

    @Override
    public void clear() {
      setBlockIdIsSet(false);
      this.blockId = 0;
    }

    public long getBlockId() {
      return this.blockId;
    }

    public accessBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case BLOCK_ID:
        return isSetBlockId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof accessBlock_args)
        return this.equals((accessBlock_args)that);
      return false;
    }

    public boolean equals(accessBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(accessBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("accessBlock_args(");
      boolean first = true;

      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class accessBlock_argsStandardSchemeFactory implements SchemeFactory {
      public accessBlock_argsStandardScheme getScheme() {
        return new accessBlock_argsStandardScheme();
      }
    }

    private static class accessBlock_argsStandardScheme extends StandardScheme<accessBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, accessBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, accessBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class accessBlock_argsTupleSchemeFactory implements SchemeFactory {
      public accessBlock_argsTupleScheme getScheme() {
        return new accessBlock_argsTupleScheme();
      }
    }

    private static class accessBlock_argsTupleScheme extends TupleScheme<accessBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, accessBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetBlockId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, accessBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
      }
    }

  }

  public static class accessBlock_result implements org.apache.thrift.TBase<accessBlock_result, accessBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<accessBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("accessBlock_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new accessBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new accessBlock_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(accessBlock_result.class, metaDataMap);
    }

    public accessBlock_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public accessBlock_result(accessBlock_result other) {
    }

    public accessBlock_result deepCopy() {
      return new accessBlock_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof accessBlock_result)
        return this.equals((accessBlock_result)that);
      return false;
    }

    public boolean equals(accessBlock_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(accessBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("accessBlock_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class accessBlock_resultStandardSchemeFactory implements SchemeFactory {
      public accessBlock_resultStandardScheme getScheme() {
        return new accessBlock_resultStandardScheme();
      }
    }

    private static class accessBlock_resultStandardScheme extends StandardScheme<accessBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, accessBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, accessBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class accessBlock_resultTupleSchemeFactory implements SchemeFactory {
      public accessBlock_resultTupleScheme getScheme() {
        return new accessBlock_resultTupleScheme();
      }
    }

    private static class accessBlock_resultTupleScheme extends TupleScheme<accessBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, accessBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, accessBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class addCheckpoint_args implements org.apache.thrift.TBase<addCheckpoint_args, addCheckpoint_args._Fields>, java.io.Serializable, Cloneable, Comparable<addCheckpoint_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addCheckpoint_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addCheckpoint_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addCheckpoint_argsTupleSchemeFactory());
    }

    public long userId; // required
    public int fileId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId"),
      FILE_ID((short)2, "fileId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          case 2: // FILE_ID
            return FILE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private static final int __FILEID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addCheckpoint_args.class, metaDataMap);
    }

    public addCheckpoint_args() {
    }

    public addCheckpoint_args(
      long userId,
      int fileId)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
      this.fileId = fileId;
      setFileIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addCheckpoint_args(addCheckpoint_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
      this.fileId = other.fileId;
    }

    public addCheckpoint_args deepCopy() {
      return new addCheckpoint_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
      setFileIdIsSet(false);
      this.fileId = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public addCheckpoint_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public int getFileId() {
      return this.fileId;
    }

    public addCheckpoint_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      case FILE_ID:
        return Integer.valueOf(getFileId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      case FILE_ID:
        return isSetFileId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addCheckpoint_args)
        return this.equals((addCheckpoint_args)that);
      return false;
    }

    public boolean equals(addCheckpoint_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(addCheckpoint_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addCheckpoint_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addCheckpoint_argsStandardSchemeFactory implements SchemeFactory {
      public addCheckpoint_argsStandardScheme getScheme() {
        return new addCheckpoint_argsStandardScheme();
      }
    }

    private static class addCheckpoint_argsStandardScheme extends StandardScheme<addCheckpoint_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addCheckpoint_argsTupleSchemeFactory implements SchemeFactory {
      public addCheckpoint_argsTupleScheme getScheme() {
        return new addCheckpoint_argsTupleScheme();
      }
    }

    private static class addCheckpoint_argsTupleScheme extends TupleScheme<addCheckpoint_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        if (struct.isSetFileId()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
      }
    }

  }

  public static class addCheckpoint_result implements org.apache.thrift.TBase<addCheckpoint_result, addCheckpoint_result._Fields>, java.io.Serializable, Cloneable, Comparable<addCheckpoint_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addCheckpoint_result");

    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_S_FIELD_DESC = new org.apache.thrift.protocol.TField("eS", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_F_FIELD_DESC = new org.apache.thrift.protocol.TField("eF", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addCheckpoint_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addCheckpoint_resultTupleSchemeFactory());
    }

    public FileDoesNotExistException eP; // required
    public SuspectedFileSizeException eS; // required
    public FailedToCheckpointException eF; // required
    public BlockInfoException eB; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E_P((short)1, "eP"),
      E_S((short)2, "eS"),
      E_F((short)3, "eF"),
      E_B((short)4, "eB");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E_P
            return E_P;
          case 2: // E_S
            return E_S;
          case 3: // E_F
            return E_F;
          case 4: // E_B
            return E_B;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_S, new org.apache.thrift.meta_data.FieldMetaData("eS", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_F, new org.apache.thrift.meta_data.FieldMetaData("eF", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addCheckpoint_result.class, metaDataMap);
    }

    public addCheckpoint_result() {
    }

    public addCheckpoint_result(
      FileDoesNotExistException eP,
      SuspectedFileSizeException eS,
      FailedToCheckpointException eF,
      BlockInfoException eB)
    {
      this();
      this.eP = eP;
      this.eS = eS;
      this.eF = eF;
      this.eB = eB;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addCheckpoint_result(addCheckpoint_result other) {
      if (other.isSetEP()) {
        this.eP = new FileDoesNotExistException(other.eP);
      }
      if (other.isSetES()) {
        this.eS = new SuspectedFileSizeException(other.eS);
      }
      if (other.isSetEF()) {
        this.eF = new FailedToCheckpointException(other.eF);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
    }

    public addCheckpoint_result deepCopy() {
      return new addCheckpoint_result(this);
    }

    @Override
    public void clear() {
      this.eP = null;
      this.eS = null;
      this.eF = null;
      this.eB = null;
    }

    public FileDoesNotExistException getEP() {
      return this.eP;
    }

    public addCheckpoint_result setEP(FileDoesNotExistException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public SuspectedFileSizeException getES() {
      return this.eS;
    }

    public addCheckpoint_result setES(SuspectedFileSizeException eS) {
      this.eS = eS;
      return this;
    }

    public void unsetES() {
      this.eS = null;
    }

    /** Returns true if field eS is set (has been assigned a value) and false otherwise */
    public boolean isSetES() {
      return this.eS != null;
    }

    public void setESIsSet(boolean value) {
      if (!value) {
        this.eS = null;
      }
    }

    public FailedToCheckpointException getEF() {
      return this.eF;
    }

    public addCheckpoint_result setEF(FailedToCheckpointException eF) {
      this.eF = eF;
      return this;
    }

    public void unsetEF() {
      this.eF = null;
    }

    /** Returns true if field eF is set (has been assigned a value) and false otherwise */
    public boolean isSetEF() {
      return this.eF != null;
    }

    public void setEFIsSet(boolean value) {
      if (!value) {
        this.eF = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public addCheckpoint_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((FileDoesNotExistException)value);
        }
        break;

      case E_S:
        if (value == null) {
          unsetES();
        } else {
          setES((SuspectedFileSizeException)value);
        }
        break;

      case E_F:
        if (value == null) {
          unsetEF();
        } else {
          setEF((FailedToCheckpointException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E_P:
        return getEP();

      case E_S:
        return getES();

      case E_F:
        return getEF();

      case E_B:
        return getEB();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E_P:
        return isSetEP();
      case E_S:
        return isSetES();
      case E_F:
        return isSetEF();
      case E_B:
        return isSetEB();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addCheckpoint_result)
        return this.equals((addCheckpoint_result)that);
      return false;
    }

    public boolean equals(addCheckpoint_result that) {
      if (that == null)
        return false;

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      boolean this_present_eS = true && this.isSetES();
      boolean that_present_eS = true && that.isSetES();
      if (this_present_eS || that_present_eS) {
        if (!(this_present_eS && that_present_eS))
          return false;
        if (!this.eS.equals(that.eS))
          return false;
      }

      boolean this_present_eF = true && this.isSetEF();
      boolean that_present_eF = true && that.isSetEF();
      if (this_present_eF || that_present_eF) {
        if (!(this_present_eF && that_present_eF))
          return false;
        if (!this.eF.equals(that.eF))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(addCheckpoint_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetES()).compareTo(other.isSetES());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetES()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eS, other.eS);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEF()).compareTo(other.isSetEF());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEF()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eF, other.eF);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addCheckpoint_result(");
      boolean first = true;

      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eS:");
      if (this.eS == null) {
        sb.append("null");
      } else {
        sb.append(this.eS);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eF:");
      if (this.eF == null) {
        sb.append("null");
      } else {
        sb.append(this.eF);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addCheckpoint_resultStandardSchemeFactory implements SchemeFactory {
      public addCheckpoint_resultStandardScheme getScheme() {
        return new addCheckpoint_resultStandardScheme();
      }
    }

    private static class addCheckpoint_resultStandardScheme extends StandardScheme<addCheckpoint_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new FileDoesNotExistException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_S
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eS = new SuspectedFileSizeException();
                struct.eS.read(iprot);
                struct.setESIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_F
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eF = new FailedToCheckpointException();
                struct.eF.read(iprot);
                struct.setEFIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eS != null) {
          oprot.writeFieldBegin(E_S_FIELD_DESC);
          struct.eS.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eF != null) {
          oprot.writeFieldBegin(E_F_FIELD_DESC);
          struct.eF.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addCheckpoint_resultTupleSchemeFactory implements SchemeFactory {
      public addCheckpoint_resultTupleScheme getScheme() {
        return new addCheckpoint_resultTupleScheme();
      }
    }

    private static class addCheckpoint_resultTupleScheme extends TupleScheme<addCheckpoint_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetEP()) {
          optionals.set(0);
        }
        if (struct.isSetES()) {
          optionals.set(1);
        }
        if (struct.isSetEF()) {
          optionals.set(2);
        }
        if (struct.isSetEB()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
        if (struct.isSetES()) {
          struct.eS.write(oprot);
        }
        if (struct.isSetEF()) {
          struct.eF.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.eP = new FileDoesNotExistException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eS = new SuspectedFileSizeException();
          struct.eS.read(iprot);
          struct.setESIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eF = new FailedToCheckpointException();
          struct.eF.read(iprot);
          struct.setEFIsSet(true);
        }
        if (incoming.get(3)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
      }
    }

  }

  public static class asyncCheckpoint_args implements org.apache.thrift.TBase<asyncCheckpoint_args, asyncCheckpoint_args._Fields>, java.io.Serializable, Cloneable, Comparable<asyncCheckpoint_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("asyncCheckpoint_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new asyncCheckpoint_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new asyncCheckpoint_argsTupleSchemeFactory());
    }

    public int fileId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(asyncCheckpoint_args.class, metaDataMap);
    }

    public asyncCheckpoint_args() {
    }

    public asyncCheckpoint_args(
      int fileId)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public asyncCheckpoint_args(asyncCheckpoint_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
    }

    public asyncCheckpoint_args deepCopy() {
      return new asyncCheckpoint_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
    }

    public int getFileId() {
      return this.fileId;
    }

    public asyncCheckpoint_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof asyncCheckpoint_args)
        return this.equals((asyncCheckpoint_args)that);
      return false;
    }

    public boolean equals(asyncCheckpoint_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(asyncCheckpoint_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("asyncCheckpoint_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class asyncCheckpoint_argsStandardSchemeFactory implements SchemeFactory {
      public asyncCheckpoint_argsStandardScheme getScheme() {
        return new asyncCheckpoint_argsStandardScheme();
      }
    }

    private static class asyncCheckpoint_argsStandardScheme extends StandardScheme<asyncCheckpoint_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, asyncCheckpoint_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, asyncCheckpoint_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class asyncCheckpoint_argsTupleSchemeFactory implements SchemeFactory {
      public asyncCheckpoint_argsTupleScheme getScheme() {
        return new asyncCheckpoint_argsTupleScheme();
      }
    }

    private static class asyncCheckpoint_argsTupleScheme extends TupleScheme<asyncCheckpoint_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, asyncCheckpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, asyncCheckpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
      }
    }

  }

  public static class asyncCheckpoint_result implements org.apache.thrift.TBase<asyncCheckpoint_result, asyncCheckpoint_result._Fields>, java.io.Serializable, Cloneable, Comparable<asyncCheckpoint_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("asyncCheckpoint_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new asyncCheckpoint_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new asyncCheckpoint_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public TachyonException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(asyncCheckpoint_result.class, metaDataMap);
    }

    public asyncCheckpoint_result() {
    }

    public asyncCheckpoint_result(
      boolean success,
      TachyonException e)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public asyncCheckpoint_result(asyncCheckpoint_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetE()) {
        this.e = new TachyonException(other.e);
      }
    }

    public asyncCheckpoint_result deepCopy() {
      return new asyncCheckpoint_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.e = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public asyncCheckpoint_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public TachyonException getE() {
      return this.e;
    }

    public asyncCheckpoint_result setE(TachyonException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TachyonException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof asyncCheckpoint_result)
        return this.equals((asyncCheckpoint_result)that);
      return false;
    }

    public boolean equals(asyncCheckpoint_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(asyncCheckpoint_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("asyncCheckpoint_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class asyncCheckpoint_resultStandardSchemeFactory implements SchemeFactory {
      public asyncCheckpoint_resultStandardScheme getScheme() {
        return new asyncCheckpoint_resultStandardScheme();
      }
    }

    private static class asyncCheckpoint_resultStandardScheme extends StandardScheme<asyncCheckpoint_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, asyncCheckpoint_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TachyonException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, asyncCheckpoint_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class asyncCheckpoint_resultTupleSchemeFactory implements SchemeFactory {
      public asyncCheckpoint_resultTupleScheme getScheme() {
        return new asyncCheckpoint_resultTupleScheme();
      }
    }

    private static class asyncCheckpoint_resultTupleScheme extends TupleScheme<asyncCheckpoint_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, asyncCheckpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, asyncCheckpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TachyonException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class cacheBlock_args implements org.apache.thrift.TBase<cacheBlock_args, cacheBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<cacheBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cacheBlock_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cacheBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cacheBlock_argsTupleSchemeFactory());
    }

    public long userId; // required
    public long blockId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId"),
      BLOCK_ID((short)2, "blockId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          case 2: // BLOCK_ID
            return BLOCK_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private static final int __BLOCKID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cacheBlock_args.class, metaDataMap);
    }

    public cacheBlock_args() {
    }

    public cacheBlock_args(
      long userId,
      long blockId)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
      this.blockId = blockId;
      setBlockIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cacheBlock_args(cacheBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
      this.blockId = other.blockId;
    }

    public cacheBlock_args deepCopy() {
      return new cacheBlock_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
      setBlockIdIsSet(false);
      this.blockId = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public cacheBlock_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public long getBlockId() {
      return this.blockId;
    }

    public cacheBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      case BLOCK_ID:
        return isSetBlockId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cacheBlock_args)
        return this.equals((cacheBlock_args)that);
      return false;
    }

    public boolean equals(cacheBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(cacheBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cacheBlock_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cacheBlock_argsStandardSchemeFactory implements SchemeFactory {
      public cacheBlock_argsStandardScheme getScheme() {
        return new cacheBlock_argsStandardScheme();
      }
    }

    private static class cacheBlock_argsStandardScheme extends StandardScheme<cacheBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cacheBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cacheBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cacheBlock_argsTupleSchemeFactory implements SchemeFactory {
      public cacheBlock_argsTupleScheme getScheme() {
        return new cacheBlock_argsTupleScheme();
      }
    }

    private static class cacheBlock_argsTupleScheme extends TupleScheme<cacheBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cacheBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        if (struct.isSetBlockId()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cacheBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
      }
    }

  }

  public static class cacheBlock_result implements org.apache.thrift.TBase<cacheBlock_result, cacheBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<cacheBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cacheBlock_result");

    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_S_FIELD_DESC = new org.apache.thrift.protocol.TField("eS", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cacheBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cacheBlock_resultTupleSchemeFactory());
    }

    public FileDoesNotExistException eP; // required
    public SuspectedFileSizeException eS; // required
    public BlockInfoException eB; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E_P((short)1, "eP"),
      E_S((short)2, "eS"),
      E_B((short)3, "eB");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E_P
            return E_P;
          case 2: // E_S
            return E_S;
          case 3: // E_B
            return E_B;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_S, new org.apache.thrift.meta_data.FieldMetaData("eS", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cacheBlock_result.class, metaDataMap);
    }

    public cacheBlock_result() {
    }

    public cacheBlock_result(
      FileDoesNotExistException eP,
      SuspectedFileSizeException eS,
      BlockInfoException eB)
    {
      this();
      this.eP = eP;
      this.eS = eS;
      this.eB = eB;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cacheBlock_result(cacheBlock_result other) {
      if (other.isSetEP()) {
        this.eP = new FileDoesNotExistException(other.eP);
      }
      if (other.isSetES()) {
        this.eS = new SuspectedFileSizeException(other.eS);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
    }

    public cacheBlock_result deepCopy() {
      return new cacheBlock_result(this);
    }

    @Override
    public void clear() {
      this.eP = null;
      this.eS = null;
      this.eB = null;
    }

    public FileDoesNotExistException getEP() {
      return this.eP;
    }

    public cacheBlock_result setEP(FileDoesNotExistException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public SuspectedFileSizeException getES() {
      return this.eS;
    }

    public cacheBlock_result setES(SuspectedFileSizeException eS) {
      this.eS = eS;
      return this;
    }

    public void unsetES() {
      this.eS = null;
    }

    /** Returns true if field eS is set (has been assigned a value) and false otherwise */
    public boolean isSetES() {
      return this.eS != null;
    }

    public void setESIsSet(boolean value) {
      if (!value) {
        this.eS = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public cacheBlock_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((FileDoesNotExistException)value);
        }
        break;

      case E_S:
        if (value == null) {
          unsetES();
        } else {
          setES((SuspectedFileSizeException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E_P:
        return getEP();

      case E_S:
        return getES();

      case E_B:
        return getEB();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E_P:
        return isSetEP();
      case E_S:
        return isSetES();
      case E_B:
        return isSetEB();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cacheBlock_result)
        return this.equals((cacheBlock_result)that);
      return false;
    }

    public boolean equals(cacheBlock_result that) {
      if (that == null)
        return false;

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      boolean this_present_eS = true && this.isSetES();
      boolean that_present_eS = true && that.isSetES();
      if (this_present_eS || that_present_eS) {
        if (!(this_present_eS && that_present_eS))
          return false;
        if (!this.eS.equals(that.eS))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(cacheBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetES()).compareTo(other.isSetES());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetES()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eS, other.eS);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cacheBlock_result(");
      boolean first = true;

      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eS:");
      if (this.eS == null) {
        sb.append("null");
      } else {
        sb.append(this.eS);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cacheBlock_resultStandardSchemeFactory implements SchemeFactory {
      public cacheBlock_resultStandardScheme getScheme() {
        return new cacheBlock_resultStandardScheme();
      }
    }

    private static class cacheBlock_resultStandardScheme extends StandardScheme<cacheBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cacheBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new FileDoesNotExistException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_S
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eS = new SuspectedFileSizeException();
                struct.eS.read(iprot);
                struct.setESIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cacheBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eS != null) {
          oprot.writeFieldBegin(E_S_FIELD_DESC);
          struct.eS.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cacheBlock_resultTupleSchemeFactory implements SchemeFactory {
      public cacheBlock_resultTupleScheme getScheme() {
        return new cacheBlock_resultTupleScheme();
      }
    }

    private static class cacheBlock_resultTupleScheme extends TupleScheme<cacheBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cacheBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetEP()) {
          optionals.set(0);
        }
        if (struct.isSetES()) {
          optionals.set(1);
        }
        if (struct.isSetEB()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
        if (struct.isSetES()) {
          struct.eS.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cacheBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.eP = new FileDoesNotExistException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eS = new SuspectedFileSizeException();
          struct.eS.read(iprot);
          struct.setESIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
      }
    }

  }

  public static class cancelBlock_args implements org.apache.thrift.TBase<cancelBlock_args, cancelBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<cancelBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelBlock_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cancelBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cancelBlock_argsTupleSchemeFactory());
    }

    public long userId; // required
    public long blockId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId"),
      BLOCK_ID((short)2, "blockId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          case 2: // BLOCK_ID
            return BLOCK_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private static final int __BLOCKID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelBlock_args.class, metaDataMap);
    }

    public cancelBlock_args() {
    }

    public cancelBlock_args(
      long userId,
      long blockId)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
      this.blockId = blockId;
      setBlockIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancelBlock_args(cancelBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
      this.blockId = other.blockId;
    }

    public cancelBlock_args deepCopy() {
      return new cancelBlock_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
      setBlockIdIsSet(false);
      this.blockId = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public cancelBlock_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public long getBlockId() {
      return this.blockId;
    }

    public cancelBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      case BLOCK_ID:
        return isSetBlockId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cancelBlock_args)
        return this.equals((cancelBlock_args)that);
      return false;
    }

    public boolean equals(cancelBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(cancelBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cancelBlock_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancelBlock_argsStandardSchemeFactory implements SchemeFactory {
      public cancelBlock_argsStandardScheme getScheme() {
        return new cancelBlock_argsStandardScheme();
      }
    }

    private static class cancelBlock_argsStandardScheme extends StandardScheme<cancelBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cancelBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cancelBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancelBlock_argsTupleSchemeFactory implements SchemeFactory {
      public cancelBlock_argsTupleScheme getScheme() {
        return new cancelBlock_argsTupleScheme();
      }
    }

    private static class cancelBlock_argsTupleScheme extends TupleScheme<cancelBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancelBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        if (struct.isSetBlockId()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancelBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
      }
    }

  }

  public static class cancelBlock_result implements org.apache.thrift.TBase<cancelBlock_result, cancelBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<cancelBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelBlock_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cancelBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cancelBlock_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelBlock_result.class, metaDataMap);
    }

    public cancelBlock_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancelBlock_result(cancelBlock_result other) {
    }

    public cancelBlock_result deepCopy() {
      return new cancelBlock_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cancelBlock_result)
        return this.equals((cancelBlock_result)that);
      return false;
    }

    public boolean equals(cancelBlock_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(cancelBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cancelBlock_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancelBlock_resultStandardSchemeFactory implements SchemeFactory {
      public cancelBlock_resultStandardScheme getScheme() {
        return new cancelBlock_resultStandardScheme();
      }
    }

    private static class cancelBlock_resultStandardScheme extends StandardScheme<cancelBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cancelBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cancelBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancelBlock_resultTupleSchemeFactory implements SchemeFactory {
      public cancelBlock_resultTupleScheme getScheme() {
        return new cancelBlock_resultTupleScheme();
      }
    }

    private static class cancelBlock_resultTupleScheme extends TupleScheme<cancelBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancelBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancelBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getUserUfsTempFolder_args implements org.apache.thrift.TBase<getUserUfsTempFolder_args, getUserUfsTempFolder_args._Fields>, java.io.Serializable, Cloneable, Comparable<getUserUfsTempFolder_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUserUfsTempFolder_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUserUfsTempFolder_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUserUfsTempFolder_argsTupleSchemeFactory());
    }

    public long userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUserUfsTempFolder_args.class, metaDataMap);
    }

    public getUserUfsTempFolder_args() {
    }

    public getUserUfsTempFolder_args(
      long userId)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUserUfsTempFolder_args(getUserUfsTempFolder_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
    }

    public getUserUfsTempFolder_args deepCopy() {
      return new getUserUfsTempFolder_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public getUserUfsTempFolder_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUserUfsTempFolder_args)
        return this.equals((getUserUfsTempFolder_args)that);
      return false;
    }

    public boolean equals(getUserUfsTempFolder_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(getUserUfsTempFolder_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUserUfsTempFolder_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUserUfsTempFolder_argsStandardSchemeFactory implements SchemeFactory {
      public getUserUfsTempFolder_argsStandardScheme getScheme() {
        return new getUserUfsTempFolder_argsStandardScheme();
      }
    }

    private static class getUserUfsTempFolder_argsStandardScheme extends StandardScheme<getUserUfsTempFolder_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUserUfsTempFolder_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUserUfsTempFolder_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUserUfsTempFolder_argsTupleSchemeFactory implements SchemeFactory {
      public getUserUfsTempFolder_argsTupleScheme getScheme() {
        return new getUserUfsTempFolder_argsTupleScheme();
      }
    }

    private static class getUserUfsTempFolder_argsTupleScheme extends TupleScheme<getUserUfsTempFolder_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUserUfsTempFolder_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUserUfsTempFolder_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
      }
    }

  }

  public static class getUserUfsTempFolder_result implements org.apache.thrift.TBase<getUserUfsTempFolder_result, getUserUfsTempFolder_result._Fields>, java.io.Serializable, Cloneable, Comparable<getUserUfsTempFolder_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUserUfsTempFolder_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUserUfsTempFolder_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUserUfsTempFolder_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUserUfsTempFolder_result.class, metaDataMap);
    }

    public getUserUfsTempFolder_result() {
    }

    public getUserUfsTempFolder_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUserUfsTempFolder_result(getUserUfsTempFolder_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getUserUfsTempFolder_result deepCopy() {
      return new getUserUfsTempFolder_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getUserUfsTempFolder_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUserUfsTempFolder_result)
        return this.equals((getUserUfsTempFolder_result)that);
      return false;
    }

    public boolean equals(getUserUfsTempFolder_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(getUserUfsTempFolder_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUserUfsTempFolder_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUserUfsTempFolder_resultStandardSchemeFactory implements SchemeFactory {
      public getUserUfsTempFolder_resultStandardScheme getScheme() {
        return new getUserUfsTempFolder_resultStandardScheme();
      }
    }

    private static class getUserUfsTempFolder_resultStandardScheme extends StandardScheme<getUserUfsTempFolder_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUserUfsTempFolder_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUserUfsTempFolder_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUserUfsTempFolder_resultTupleSchemeFactory implements SchemeFactory {
      public getUserUfsTempFolder_resultTupleScheme getScheme() {
        return new getUserUfsTempFolder_resultTupleScheme();
      }
    }

    private static class getUserUfsTempFolder_resultTupleScheme extends TupleScheme<getUserUfsTempFolder_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUserUfsTempFolder_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUserUfsTempFolder_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class lockBlock_args implements org.apache.thrift.TBase<lockBlock_args, lockBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<lockBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("lockBlock_args");

    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new lockBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new lockBlock_argsTupleSchemeFactory());
    }

    public long blockId; // required
    public long userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      BLOCK_ID((short)1, "blockId"),
      USER_ID((short)2, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // BLOCK_ID
            return BLOCK_ID;
          case 2: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BLOCKID_ISSET_ID = 0;
    private static final int __USERID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(lockBlock_args.class, metaDataMap);
    }

    public lockBlock_args() {
    }

    public lockBlock_args(
      long blockId,
      long userId)
    {
      this();
      this.blockId = blockId;
      setBlockIdIsSet(true);
      this.userId = userId;
      setUserIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public lockBlock_args(lockBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.blockId = other.blockId;
      this.userId = other.userId;
    }

    public lockBlock_args deepCopy() {
      return new lockBlock_args(this);
    }

    @Override
    public void clear() {
      setBlockIdIsSet(false);
      this.blockId = 0;
      setUserIdIsSet(false);
      this.userId = 0;
    }

    public long getBlockId() {
      return this.blockId;
    }

    public lockBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public long getUserId() {
      return this.userId;
    }

    public lockBlock_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      case USER_ID:
        return Long.valueOf(getUserId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case BLOCK_ID:
        return isSetBlockId();
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof lockBlock_args)
        return this.equals((lockBlock_args)that);
      return false;
    }

    public boolean equals(lockBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(lockBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("lockBlock_args(");
      boolean first = true;

      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class lockBlock_argsStandardSchemeFactory implements SchemeFactory {
      public lockBlock_argsStandardScheme getScheme() {
        return new lockBlock_argsStandardScheme();
      }
    }

    private static class lockBlock_argsStandardScheme extends StandardScheme<lockBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, lockBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, lockBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class lockBlock_argsTupleSchemeFactory implements SchemeFactory {
      public lockBlock_argsTupleScheme getScheme() {
        return new lockBlock_argsTupleScheme();
      }
    }

    private static class lockBlock_argsTupleScheme extends TupleScheme<lockBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, lockBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetBlockId()) {
          optionals.set(0);
        }
        if (struct.isSetUserId()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, lockBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
      }
    }

  }

  public static class lockBlock_result implements org.apache.thrift.TBase<lockBlock_result, lockBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<lockBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("lockBlock_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new lockBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new lockBlock_resultTupleSchemeFactory());
    }

    public String success; // required
    public FileDoesNotExistException eP; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_P((short)1, "eP");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_P
            return E_P;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(lockBlock_result.class, metaDataMap);
    }

    public lockBlock_result() {
    }

    public lockBlock_result(
      String success,
      FileDoesNotExistException eP)
    {
      this();
      this.success = success;
      this.eP = eP;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public lockBlock_result(lockBlock_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetEP()) {
        this.eP = new FileDoesNotExistException(other.eP);
      }
    }

    public lockBlock_result deepCopy() {
      return new lockBlock_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.eP = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public lockBlock_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public FileDoesNotExistException getEP() {
      return this.eP;
    }

    public lockBlock_result setEP(FileDoesNotExistException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E_P:
        return getEP();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_P:
        return isSetEP();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof lockBlock_result)
        return this.equals((lockBlock_result)that);
      return false;
    }

    public boolean equals(lockBlock_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(lockBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("lockBlock_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class lockBlock_resultStandardSchemeFactory implements SchemeFactory {
      public lockBlock_resultStandardScheme getScheme() {
        return new lockBlock_resultStandardScheme();
      }
    }

    private static class lockBlock_resultStandardScheme extends StandardScheme<lockBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, lockBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new FileDoesNotExistException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, lockBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class lockBlock_resultTupleSchemeFactory implements SchemeFactory {
      public lockBlock_resultTupleScheme getScheme() {
        return new lockBlock_resultTupleScheme();
      }
    }

    private static class lockBlock_resultTupleScheme extends TupleScheme<lockBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, lockBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEP()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, lockBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eP = new FileDoesNotExistException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
      }
    }

  }

  public static class promoteBlock_args implements org.apache.thrift.TBase<promoteBlock_args, promoteBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<promoteBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("promoteBlock_args");

    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new promoteBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new promoteBlock_argsTupleSchemeFactory());
    }

    public long blockId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      BLOCK_ID((short)1, "blockId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // BLOCK_ID
            return BLOCK_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BLOCKID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(promoteBlock_args.class, metaDataMap);
    }

    public promoteBlock_args() {
    }

    public promoteBlock_args(
      long blockId)
    {
      this();
      this.blockId = blockId;
      setBlockIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public promoteBlock_args(promoteBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.blockId = other.blockId;
    }

    public promoteBlock_args deepCopy() {
      return new promoteBlock_args(this);
    }

    @Override
    public void clear() {
      setBlockIdIsSet(false);
      this.blockId = 0;
    }

    public long getBlockId() {
      return this.blockId;
    }

    public promoteBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case BLOCK_ID:
        return isSetBlockId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof promoteBlock_args)
        return this.equals((promoteBlock_args)that);
      return false;
    }

    public boolean equals(promoteBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(promoteBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("promoteBlock_args(");
      boolean first = true;

      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class promoteBlock_argsStandardSchemeFactory implements SchemeFactory {
      public promoteBlock_argsStandardScheme getScheme() {
        return new promoteBlock_argsStandardScheme();
      }
    }

    private static class promoteBlock_argsStandardScheme extends StandardScheme<promoteBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, promoteBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, promoteBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class promoteBlock_argsTupleSchemeFactory implements SchemeFactory {
      public promoteBlock_argsTupleScheme getScheme() {
        return new promoteBlock_argsTupleScheme();
      }
    }

    private static class promoteBlock_argsTupleScheme extends TupleScheme<promoteBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, promoteBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetBlockId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, promoteBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
      }
    }

  }

  public static class promoteBlock_result implements org.apache.thrift.TBase<promoteBlock_result, promoteBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<promoteBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("promoteBlock_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new promoteBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new promoteBlock_resultTupleSchemeFactory());
    }

    public boolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(promoteBlock_result.class, metaDataMap);
    }

    public promoteBlock_result() {
    }

    public promoteBlock_result(
      boolean success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public promoteBlock_result(promoteBlock_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public promoteBlock_result deepCopy() {
      return new promoteBlock_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public promoteBlock_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof promoteBlock_result)
        return this.equals((promoteBlock_result)that);
      return false;
    }

    public boolean equals(promoteBlock_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(promoteBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("promoteBlock_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class promoteBlock_resultStandardSchemeFactory implements SchemeFactory {
      public promoteBlock_resultStandardScheme getScheme() {
        return new promoteBlock_resultStandardScheme();
      }
    }

    private static class promoteBlock_resultStandardScheme extends StandardScheme<promoteBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, promoteBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, promoteBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class promoteBlock_resultTupleSchemeFactory implements SchemeFactory {
      public promoteBlock_resultTupleScheme getScheme() {
        return new promoteBlock_resultTupleScheme();
      }
    }

    private static class promoteBlock_resultTupleScheme extends TupleScheme<promoteBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, promoteBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, promoteBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class requestBlockLocation_args implements org.apache.thrift.TBase<requestBlockLocation_args, requestBlockLocation_args._Fields>, java.io.Serializable, Cloneable, Comparable<requestBlockLocation_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("requestBlockLocation_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField INITIAL_BYTES_FIELD_DESC = new org.apache.thrift.protocol.TField("initialBytes", org.apache.thrift.protocol.TType.I64, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new requestBlockLocation_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new requestBlockLocation_argsTupleSchemeFactory());
    }

    public long userId; // required
    public long blockId; // required
    public long initialBytes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId"),
      BLOCK_ID((short)2, "blockId"),
      INITIAL_BYTES((short)3, "initialBytes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          case 2: // BLOCK_ID
            return BLOCK_ID;
          case 3: // INITIAL_BYTES
            return INITIAL_BYTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private static final int __BLOCKID_ISSET_ID = 1;
    private static final int __INITIALBYTES_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.INITIAL_BYTES, new org.apache.thrift.meta_data.FieldMetaData("initialBytes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(requestBlockLocation_args.class, metaDataMap);
    }

    public requestBlockLocation_args() {
    }

    public requestBlockLocation_args(
      long userId,
      long blockId,
      long initialBytes)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
      this.blockId = blockId;
      setBlockIdIsSet(true);
      this.initialBytes = initialBytes;
      setInitialBytesIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public requestBlockLocation_args(requestBlockLocation_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
      this.blockId = other.blockId;
      this.initialBytes = other.initialBytes;
    }

    public requestBlockLocation_args deepCopy() {
      return new requestBlockLocation_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
      setBlockIdIsSet(false);
      this.blockId = 0;
      setInitialBytesIsSet(false);
      this.initialBytes = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public requestBlockLocation_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public long getBlockId() {
      return this.blockId;
    }

    public requestBlockLocation_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public long getInitialBytes() {
      return this.initialBytes;
    }

    public requestBlockLocation_args setInitialBytes(long initialBytes) {
      this.initialBytes = initialBytes;
      setInitialBytesIsSet(true);
      return this;
    }

    public void unsetInitialBytes() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __INITIALBYTES_ISSET_ID);
    }

    /** Returns true if field initialBytes is set (has been assigned a value) and false otherwise */
    public boolean isSetInitialBytes() {
      return EncodingUtils.testBit(__isset_bitfield, __INITIALBYTES_ISSET_ID);
    }

    public void setInitialBytesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __INITIALBYTES_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      case INITIAL_BYTES:
        if (value == null) {
          unsetInitialBytes();
        } else {
          setInitialBytes((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      case INITIAL_BYTES:
        return Long.valueOf(getInitialBytes());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      case BLOCK_ID:
        return isSetBlockId();
      case INITIAL_BYTES:
        return isSetInitialBytes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof requestBlockLocation_args)
        return this.equals((requestBlockLocation_args)that);
      return false;
    }

    public boolean equals(requestBlockLocation_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      boolean this_present_initialBytes = true;
      boolean that_present_initialBytes = true;
      if (this_present_initialBytes || that_present_initialBytes) {
        if (!(this_present_initialBytes && that_present_initialBytes))
          return false;
        if (this.initialBytes != that.initialBytes)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(requestBlockLocation_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetInitialBytes()).compareTo(other.isSetInitialBytes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetInitialBytes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.initialBytes, other.initialBytes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("requestBlockLocation_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("initialBytes:");
      sb.append(this.initialBytes);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class requestBlockLocation_argsStandardSchemeFactory implements SchemeFactory {
      public requestBlockLocation_argsStandardScheme getScheme() {
        return new requestBlockLocation_argsStandardScheme();
      }
    }

    private static class requestBlockLocation_argsStandardScheme extends StandardScheme<requestBlockLocation_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, requestBlockLocation_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // INITIAL_BYTES
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.initialBytes = iprot.readI64();
                struct.setInitialBytesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, requestBlockLocation_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(INITIAL_BYTES_FIELD_DESC);
        oprot.writeI64(struct.initialBytes);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class requestBlockLocation_argsTupleSchemeFactory implements SchemeFactory {
      public requestBlockLocation_argsTupleScheme getScheme() {
        return new requestBlockLocation_argsTupleScheme();
      }
    }

    private static class requestBlockLocation_argsTupleScheme extends TupleScheme<requestBlockLocation_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, requestBlockLocation_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        if (struct.isSetBlockId()) {
          optionals.set(1);
        }
        if (struct.isSetInitialBytes()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
        if (struct.isSetInitialBytes()) {
          oprot.writeI64(struct.initialBytes);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, requestBlockLocation_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.initialBytes = iprot.readI64();
          struct.setInitialBytesIsSet(true);
        }
      }
    }

  }

  public static class requestBlockLocation_result implements org.apache.thrift.TBase<requestBlockLocation_result, requestBlockLocation_result._Fields>, java.io.Serializable, Cloneable, Comparable<requestBlockLocation_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("requestBlockLocation_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_S_FIELD_DESC = new org.apache.thrift.protocol.TField("eS", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new requestBlockLocation_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new requestBlockLocation_resultTupleSchemeFactory());
    }

    public String success; // required
    public OutOfSpaceException eP; // required
    public FileAlreadyExistException eS; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_P((short)1, "eP"),
      E_S((short)2, "eS");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_P
            return E_P;
          case 2: // E_S
            return E_S;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_S, new org.apache.thrift.meta_data.FieldMetaData("eS", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(requestBlockLocation_result.class, metaDataMap);
    }

    public requestBlockLocation_result() {
    }

    public requestBlockLocation_result(
      String success,
      OutOfSpaceException eP,
      FileAlreadyExistException eS)
    {
      this();
      this.success = success;
      this.eP = eP;
      this.eS = eS;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public requestBlockLocation_result(requestBlockLocation_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetEP()) {
        this.eP = new OutOfSpaceException(other.eP);
      }
      if (other.isSetES()) {
        this.eS = new FileAlreadyExistException(other.eS);
      }
    }

    public requestBlockLocation_result deepCopy() {
      return new requestBlockLocation_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.eP = null;
      this.eS = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public requestBlockLocation_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public OutOfSpaceException getEP() {
      return this.eP;
    }

    public requestBlockLocation_result setEP(OutOfSpaceException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public FileAlreadyExistException getES() {
      return this.eS;
    }

    public requestBlockLocation_result setES(FileAlreadyExistException eS) {
      this.eS = eS;
      return this;
    }

    public void unsetES() {
      this.eS = null;
    }

    /** Returns true if field eS is set (has been assigned a value) and false otherwise */
    public boolean isSetES() {
      return this.eS != null;
    }

    public void setESIsSet(boolean value) {
      if (!value) {
        this.eS = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((OutOfSpaceException)value);
        }
        break;

      case E_S:
        if (value == null) {
          unsetES();
        } else {
          setES((FileAlreadyExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E_P:
        return getEP();

      case E_S:
        return getES();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_P:
        return isSetEP();
      case E_S:
        return isSetES();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof requestBlockLocation_result)
        return this.equals((requestBlockLocation_result)that);
      return false;
    }

    public boolean equals(requestBlockLocation_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      boolean this_present_eS = true && this.isSetES();
      boolean that_present_eS = true && that.isSetES();
      if (this_present_eS || that_present_eS) {
        if (!(this_present_eS && that_present_eS))
          return false;
        if (!this.eS.equals(that.eS))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(requestBlockLocation_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetES()).compareTo(other.isSetES());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetES()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eS, other.eS);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("requestBlockLocation_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eS:");
      if (this.eS == null) {
        sb.append("null");
      } else {
        sb.append(this.eS);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class requestBlockLocation_resultStandardSchemeFactory implements SchemeFactory {
      public requestBlockLocation_resultStandardScheme getScheme() {
        return new requestBlockLocation_resultStandardScheme();
      }
    }

    private static class requestBlockLocation_resultStandardScheme extends StandardScheme<requestBlockLocation_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, requestBlockLocation_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new OutOfSpaceException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_S
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eS = new FileAlreadyExistException();
                struct.eS.read(iprot);
                struct.setESIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, requestBlockLocation_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eS != null) {
          oprot.writeFieldBegin(E_S_FIELD_DESC);
          struct.eS.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class requestBlockLocation_resultTupleSchemeFactory implements SchemeFactory {
      public requestBlockLocation_resultTupleScheme getScheme() {
        return new requestBlockLocation_resultTupleScheme();
      }
    }

    private static class requestBlockLocation_resultTupleScheme extends TupleScheme<requestBlockLocation_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, requestBlockLocation_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEP()) {
          optionals.set(1);
        }
        if (struct.isSetES()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
        if (struct.isSetES()) {
          struct.eS.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, requestBlockLocation_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eP = new OutOfSpaceException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eS = new FileAlreadyExistException();
          struct.eS.read(iprot);
          struct.setESIsSet(true);
        }
      }
    }

  }

  public static class requestSpace_args implements org.apache.thrift.TBase<requestSpace_args, requestSpace_args._Fields>, java.io.Serializable, Cloneable, Comparable<requestSpace_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("requestSpace_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField REQUEST_BYTES_FIELD_DESC = new org.apache.thrift.protocol.TField("requestBytes", org.apache.thrift.protocol.TType.I64, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new requestSpace_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new requestSpace_argsTupleSchemeFactory());
    }

    public long userId; // required
    public long blockId; // required
    public long requestBytes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId"),
      BLOCK_ID((short)2, "blockId"),
      REQUEST_BYTES((short)3, "requestBytes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          case 2: // BLOCK_ID
            return BLOCK_ID;
          case 3: // REQUEST_BYTES
            return REQUEST_BYTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private static final int __BLOCKID_ISSET_ID = 1;
    private static final int __REQUESTBYTES_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.REQUEST_BYTES, new org.apache.thrift.meta_data.FieldMetaData("requestBytes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(requestSpace_args.class, metaDataMap);
    }

    public requestSpace_args() {
    }

    public requestSpace_args(
      long userId,
      long blockId,
      long requestBytes)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
      this.blockId = blockId;
      setBlockIdIsSet(true);
      this.requestBytes = requestBytes;
      setRequestBytesIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public requestSpace_args(requestSpace_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
      this.blockId = other.blockId;
      this.requestBytes = other.requestBytes;
    }

    public requestSpace_args deepCopy() {
      return new requestSpace_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
      setBlockIdIsSet(false);
      this.blockId = 0;
      setRequestBytesIsSet(false);
      this.requestBytes = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public requestSpace_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public long getBlockId() {
      return this.blockId;
    }

    public requestSpace_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public long getRequestBytes() {
      return this.requestBytes;
    }

    public requestSpace_args setRequestBytes(long requestBytes) {
      this.requestBytes = requestBytes;
      setRequestBytesIsSet(true);
      return this;
    }

    public void unsetRequestBytes() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __REQUESTBYTES_ISSET_ID);
    }

    /** Returns true if field requestBytes is set (has been assigned a value) and false otherwise */
    public boolean isSetRequestBytes() {
      return EncodingUtils.testBit(__isset_bitfield, __REQUESTBYTES_ISSET_ID);
    }

    public void setRequestBytesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __REQUESTBYTES_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      case REQUEST_BYTES:
        if (value == null) {
          unsetRequestBytes();
        } else {
          setRequestBytes((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      case REQUEST_BYTES:
        return Long.valueOf(getRequestBytes());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      case BLOCK_ID:
        return isSetBlockId();
      case REQUEST_BYTES:
        return isSetRequestBytes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof requestSpace_args)
        return this.equals((requestSpace_args)that);
      return false;
    }

    public boolean equals(requestSpace_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      boolean this_present_requestBytes = true;
      boolean that_present_requestBytes = true;
      if (this_present_requestBytes || that_present_requestBytes) {
        if (!(this_present_requestBytes && that_present_requestBytes))
          return false;
        if (this.requestBytes != that.requestBytes)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(requestSpace_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRequestBytes()).compareTo(other.isSetRequestBytes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRequestBytes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.requestBytes, other.requestBytes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("requestSpace_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("requestBytes:");
      sb.append(this.requestBytes);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class requestSpace_argsStandardSchemeFactory implements SchemeFactory {
      public requestSpace_argsStandardScheme getScheme() {
        return new requestSpace_argsStandardScheme();
      }
    }

    private static class requestSpace_argsStandardScheme extends StandardScheme<requestSpace_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, requestSpace_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // REQUEST_BYTES
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.requestBytes = iprot.readI64();
                struct.setRequestBytesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, requestSpace_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(REQUEST_BYTES_FIELD_DESC);
        oprot.writeI64(struct.requestBytes);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class requestSpace_argsTupleSchemeFactory implements SchemeFactory {
      public requestSpace_argsTupleScheme getScheme() {
        return new requestSpace_argsTupleScheme();
      }
    }

    private static class requestSpace_argsTupleScheme extends TupleScheme<requestSpace_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, requestSpace_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        if (struct.isSetBlockId()) {
          optionals.set(1);
        }
        if (struct.isSetRequestBytes()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
        if (struct.isSetRequestBytes()) {
          oprot.writeI64(struct.requestBytes);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, requestSpace_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.requestBytes = iprot.readI64();
          struct.setRequestBytesIsSet(true);
        }
      }
    }

  }

  public static class requestSpace_result implements org.apache.thrift.TBase<requestSpace_result, requestSpace_result._Fields>, java.io.Serializable, Cloneable, Comparable<requestSpace_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("requestSpace_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new requestSpace_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new requestSpace_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public FileDoesNotExistException eP; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_P((short)1, "eP");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_P
            return E_P;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(requestSpace_result.class, metaDataMap);
    }

    public requestSpace_result() {
    }

    public requestSpace_result(
      boolean success,
      FileDoesNotExistException eP)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.eP = eP;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public requestSpace_result(requestSpace_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetEP()) {
        this.eP = new FileDoesNotExistException(other.eP);
      }
    }

    public requestSpace_result deepCopy() {
      return new requestSpace_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.eP = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public requestSpace_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public FileDoesNotExistException getEP() {
      return this.eP;
    }

    public requestSpace_result setEP(FileDoesNotExistException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case E_P:
        return getEP();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_P:
        return isSetEP();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof requestSpace_result)
        return this.equals((requestSpace_result)that);
      return false;
    }

    public boolean equals(requestSpace_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(requestSpace_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("requestSpace_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class requestSpace_resultStandardSchemeFactory implements SchemeFactory {
      public requestSpace_resultStandardScheme getScheme() {
        return new requestSpace_resultStandardScheme();
      }
    }

    private static class requestSpace_resultStandardScheme extends StandardScheme<requestSpace_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, requestSpace_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new FileDoesNotExistException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, requestSpace_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class requestSpace_resultTupleSchemeFactory implements SchemeFactory {
      public requestSpace_resultTupleScheme getScheme() {
        return new requestSpace_resultTupleScheme();
      }
    }

    private static class requestSpace_resultTupleScheme extends TupleScheme<requestSpace_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, requestSpace_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEP()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, requestSpace_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eP = new FileDoesNotExistException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
      }
    }

  }

  public static class unlockBlock_args implements org.apache.thrift.TBase<unlockBlock_args, unlockBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<unlockBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("unlockBlock_args");

    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new unlockBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new unlockBlock_argsTupleSchemeFactory());
    }

    public long blockId; // required
    public long userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      BLOCK_ID((short)1, "blockId"),
      USER_ID((short)2, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // BLOCK_ID
            return BLOCK_ID;
          case 2: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BLOCKID_ISSET_ID = 0;
    private static final int __USERID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(unlockBlock_args.class, metaDataMap);
    }

    public unlockBlock_args() {
    }

    public unlockBlock_args(
      long blockId,
      long userId)
    {
      this();
      this.blockId = blockId;
      setBlockIdIsSet(true);
      this.userId = userId;
      setUserIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public unlockBlock_args(unlockBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.blockId = other.blockId;
      this.userId = other.userId;
    }

    public unlockBlock_args deepCopy() {
      return new unlockBlock_args(this);
    }

    @Override
    public void clear() {
      setBlockIdIsSet(false);
      this.blockId = 0;
      setUserIdIsSet(false);
      this.userId = 0;
    }

    public long getBlockId() {
      return this.blockId;
    }

    public unlockBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public long getUserId() {
      return this.userId;
    }

    public unlockBlock_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      case USER_ID:
        return Long.valueOf(getUserId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case BLOCK_ID:
        return isSetBlockId();
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof unlockBlock_args)
        return this.equals((unlockBlock_args)that);
      return false;
    }

    public boolean equals(unlockBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(unlockBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("unlockBlock_args(");
      boolean first = true;

      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class unlockBlock_argsStandardSchemeFactory implements SchemeFactory {
      public unlockBlock_argsStandardScheme getScheme() {
        return new unlockBlock_argsStandardScheme();
      }
    }

    private static class unlockBlock_argsStandardScheme extends StandardScheme<unlockBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, unlockBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, unlockBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class unlockBlock_argsTupleSchemeFactory implements SchemeFactory {
      public unlockBlock_argsTupleScheme getScheme() {
        return new unlockBlock_argsTupleScheme();
      }
    }

    private static class unlockBlock_argsTupleScheme extends TupleScheme<unlockBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, unlockBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetBlockId()) {
          optionals.set(0);
        }
        if (struct.isSetUserId()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, unlockBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
      }
    }

  }

  public static class unlockBlock_result implements org.apache.thrift.TBase<unlockBlock_result, unlockBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<unlockBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("unlockBlock_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new unlockBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new unlockBlock_resultTupleSchemeFactory());
    }

    public boolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(unlockBlock_result.class, metaDataMap);
    }

    public unlockBlock_result() {
    }

    public unlockBlock_result(
      boolean success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public unlockBlock_result(unlockBlock_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public unlockBlock_result deepCopy() {
      return new unlockBlock_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public unlockBlock_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof unlockBlock_result)
        return this.equals((unlockBlock_result)that);
      return false;
    }

    public boolean equals(unlockBlock_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(unlockBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("unlockBlock_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class unlockBlock_resultStandardSchemeFactory implements SchemeFactory {
      public unlockBlock_resultStandardScheme getScheme() {
        return new unlockBlock_resultStandardScheme();
      }
    }

    private static class unlockBlock_resultStandardScheme extends StandardScheme<unlockBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, unlockBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, unlockBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class unlockBlock_resultTupleSchemeFactory implements SchemeFactory {
      public unlockBlock_resultTupleScheme getScheme() {
        return new unlockBlock_resultTupleScheme();
      }
    }

    private static class unlockBlock_resultTupleScheme extends TupleScheme<unlockBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, unlockBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, unlockBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class userHeartbeat_args implements org.apache.thrift.TBase<userHeartbeat_args, userHeartbeat_args._Fields>, java.io.Serializable, Cloneable, Comparable<userHeartbeat_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("userHeartbeat_args");

    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new userHeartbeat_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new userHeartbeat_argsTupleSchemeFactory());
    }

    public long userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER_ID((short)1, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __USERID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(userHeartbeat_args.class, metaDataMap);
    }

    public userHeartbeat_args() {
    }

    public userHeartbeat_args(
      long userId)
    {
      this();
      this.userId = userId;
      setUserIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public userHeartbeat_args(userHeartbeat_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.userId = other.userId;
    }

    public userHeartbeat_args deepCopy() {
      return new userHeartbeat_args(this);
    }

    @Override
    public void clear() {
      setUserIdIsSet(false);
      this.userId = 0;
    }

    public long getUserId() {
      return this.userId;
    }

    public userHeartbeat_args setUserId(long userId) {
      this.userId = userId;
      setUserIdIsSet(true);
      return this;
    }

    public void unsetUserId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return EncodingUtils.testBit(__isset_bitfield, __USERID_ISSET_ID);
    }

    public void setUserIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USERID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER_ID:
        return Long.valueOf(getUserId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof userHeartbeat_args)
        return this.equals((userHeartbeat_args)that);
      return false;
    }

    public boolean equals(userHeartbeat_args that) {
      if (that == null)
        return false;

      boolean this_present_userId = true;
      boolean that_present_userId = true;
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (this.userId != that.userId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(userHeartbeat_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("userHeartbeat_args(");
      boolean first = true;

      sb.append("userId:");
      sb.append(this.userId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class userHeartbeat_argsStandardSchemeFactory implements SchemeFactory {
      public userHeartbeat_argsStandardScheme getScheme() {
        return new userHeartbeat_argsStandardScheme();
      }
    }

    private static class userHeartbeat_argsStandardScheme extends StandardScheme<userHeartbeat_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, userHeartbeat_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.userId = iprot.readI64();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, userHeartbeat_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeI64(struct.userId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class userHeartbeat_argsTupleSchemeFactory implements SchemeFactory {
      public userHeartbeat_argsTupleScheme getScheme() {
        return new userHeartbeat_argsTupleScheme();
      }
    }

    private static class userHeartbeat_argsTupleScheme extends TupleScheme<userHeartbeat_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, userHeartbeat_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUserId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetUserId()) {
          oprot.writeI64(struct.userId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, userHeartbeat_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.userId = iprot.readI64();
          struct.setUserIdIsSet(true);
        }
      }
    }

  }

  public static class userHeartbeat_result implements org.apache.thrift.TBase<userHeartbeat_result, userHeartbeat_result._Fields>, java.io.Serializable, Cloneable, Comparable<userHeartbeat_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("userHeartbeat_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new userHeartbeat_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new userHeartbeat_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(userHeartbeat_result.class, metaDataMap);
    }

    public userHeartbeat_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public userHeartbeat_result(userHeartbeat_result other) {
    }

    public userHeartbeat_result deepCopy() {
      return new userHeartbeat_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof userHeartbeat_result)
        return this.equals((userHeartbeat_result)that);
      return false;
    }

    public boolean equals(userHeartbeat_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(userHeartbeat_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("userHeartbeat_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class userHeartbeat_resultStandardSchemeFactory implements SchemeFactory {
      public userHeartbeat_resultStandardScheme getScheme() {
        return new userHeartbeat_resultStandardScheme();
      }
    }

    private static class userHeartbeat_resultStandardScheme extends StandardScheme<userHeartbeat_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, userHeartbeat_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, userHeartbeat_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class userHeartbeat_resultTupleSchemeFactory implements SchemeFactory {
      public userHeartbeat_resultTupleScheme getScheme() {
        return new userHeartbeat_resultTupleScheme();
      }
    }

    private static class userHeartbeat_resultTupleScheme extends TupleScheme<userHeartbeat_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, userHeartbeat_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, userHeartbeat_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

}
