/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package tachyon.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterService {

  public interface Iface {

    public boolean addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException;

    public List<ClientWorkerInfo> getWorkersInfo() throws org.apache.thrift.TException;

    public List<ClientFileInfo> liststatus(String path) throws InvalidPathException, FileDoesNotExistException, org.apache.thrift.TException;

    /**
     * Worker register and synch up capacity of Tachyon space, used space bytes and blocks in each
     * storage directory to master, the return value rv % 100,000 is really workerId, rv / 1000,000
     * is master started time. currentBlocks maps from id of storage directory to the blocks it
     * contains.
     * 
     * @param workerNetAddress
     * @param totalBytes
     * @param usedBytes
     * @param currentBlocks
     */
    public long worker_register(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long,List<Long>> currentBlocks) throws BlockInfoException, org.apache.thrift.TException;

    /**
     * Heart beat between worker and master, worker update used Tachyon space in bytes, removed
     * blocks and added blocks in each storage directory by eviction and promotion to master, and
     * return the command from master to worker. addedBlockIds maps from id of storage directory
     * to the blocks added in it.
     * 
     * @param workerId
     * @param usedBytes
     * @param removedBlockIds
     * @param addedBlockIds
     */
    public Command worker_heartbeat(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long,List<Long>> addedBlockIds) throws BlockInfoException, org.apache.thrift.TException;

    /**
     * Update information of the block newly cached to master, including used Tachyon space size in
     * bytes, the id of the storage directory in which the block is, the id of the block and the size
     * of the block in bytes.
     * 
     * @param workerId
     * @param workerUsedBytes
     * @param storageDirId
     * @param blockId
     * @param length
     */
    public void worker_cacheBlock(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException;

    public Set<Integer> worker_getPinIdList() throws org.apache.thrift.TException;

    public List<Integer> worker_getPriorityDependencyList() throws org.apache.thrift.TException;

    public int user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws InvalidPathException, FileDoesNotExistException, FileAlreadyExistException, BlockInfoException, TachyonException, org.apache.thrift.TException;

    public ClientDependencyInfo user_getClientDependencyInfo(int dependencyId) throws DependencyDoesNotExistException, org.apache.thrift.TException;

    public void user_reportLostFile(int fileId) throws FileDoesNotExistException, org.apache.thrift.TException;

    public void user_requestFilesInDependency(int depId) throws DependencyDoesNotExistException, org.apache.thrift.TException;

    public int user_createFile(String path, String ufsPath, long blockSizeByte, boolean recursive) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, SuspectedFileSizeException, TachyonException, org.apache.thrift.TException;

    public long user_createNewBlock(int fileId) throws FileDoesNotExistException, org.apache.thrift.TException;

    public void user_completeFile(int fileId) throws FileDoesNotExistException, org.apache.thrift.TException;

    public long user_getUserId() throws org.apache.thrift.TException;

    public long user_getBlockId(int fileId, int index) throws FileDoesNotExistException, org.apache.thrift.TException;

    /**
     * Get local worker NetAddress
     * 
     * @param random
     * @param host
     */
    public NetAddress user_getWorker(boolean random, String host) throws NoWorkerException, org.apache.thrift.TException;

    public ClientFileInfo getFileStatus(int fileId, String path) throws InvalidPathException, org.apache.thrift.TException;

    /**
     * Get block's ClientBlockInfo.
     * 
     * @param blockId
     */
    public ClientBlockInfo user_getClientBlockInfo(long blockId) throws FileDoesNotExistException, BlockInfoException, org.apache.thrift.TException;

    /**
     * Get file blocks info.
     * 
     * @param fileId
     * @param path
     */
    public List<ClientBlockInfo> user_getFileBlocks(int fileId, String path) throws FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException;

    /**
     * Delete file
     * 
     * @param fileId
     * @param path
     * @param recursive
     */
    public boolean user_delete(int fileId, String path, boolean recursive) throws TachyonException, org.apache.thrift.TException;

    public boolean user_rename(int fileId, String srcPath, String dstPath) throws FileAlreadyExistException, FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException;

    public void user_setPinned(int fileId, boolean pinned) throws FileDoesNotExistException, org.apache.thrift.TException;

    public boolean user_mkdirs(String path, boolean recursive) throws FileAlreadyExistException, InvalidPathException, TachyonException, org.apache.thrift.TException;

    public int user_createRawTable(String path, int columns, ByteBuffer metadata) throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException, org.apache.thrift.TException;

    /**
     * Return 0 if does not contain the Table, return fileId if it exists.
     * 
     * @param path
     */
    public int user_getRawTableId(String path) throws InvalidPathException, org.apache.thrift.TException;

    /**
     * Get RawTable's info; Return a ClientRawTable instance with id 0 if the system does not contain
     * the table. path if valid iff id is -1.
     * 
     * @param id
     * @param path
     */
    public ClientRawTableInfo user_getClientRawTableInfo(int id, String path) throws TableDoesNotExistException, InvalidPathException, org.apache.thrift.TException;

    public void user_updateRawTableMetadata(int tableId, ByteBuffer metadata) throws TableDoesNotExistException, TachyonException, org.apache.thrift.TException;

    public String user_getUfsAddress() throws org.apache.thrift.TException;

    /**
     * Returns if the message was received. Intended to check if the client can still connect to the
     * master.
     */
    public void user_heartbeat() throws org.apache.thrift.TException;

    public boolean user_freepath(int fileId, String path, boolean recursive) throws FileDoesNotExistException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void addCheckpoint(long workerId, int fileId, long length, String checkpointPath, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getWorkersInfo(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void liststatus(String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void worker_register(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long,List<Long>> currentBlocks, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void worker_heartbeat(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long,List<Long>> addedBlockIds, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void worker_cacheBlock(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void worker_getPinIdList(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void worker_getPriorityDependencyList(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getClientDependencyInfo(int dependencyId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_reportLostFile(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_requestFilesInDependency(int depId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_createFile(String path, String ufsPath, long blockSizeByte, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_createNewBlock(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_completeFile(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getUserId(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getBlockId(int fileId, int index, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getWorker(boolean random, String host, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getFileStatus(int fileId, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getClientBlockInfo(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getFileBlocks(int fileId, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_delete(int fileId, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_rename(int fileId, String srcPath, String dstPath, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_setPinned(int fileId, boolean pinned, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_mkdirs(String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_createRawTable(String path, int columns, ByteBuffer metadata, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getRawTableId(String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getClientRawTableInfo(int id, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_updateRawTableMetadata(int tableId, ByteBuffer metadata, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_getUfsAddress(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_heartbeat(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void user_freepath(int fileId, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public boolean addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException
    {
      send_addCheckpoint(workerId, fileId, length, checkpointPath);
      return recv_addCheckpoint();
    }

    public void send_addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws org.apache.thrift.TException
    {
      addCheckpoint_args args = new addCheckpoint_args();
      args.setWorkerId(workerId);
      args.setFileId(fileId);
      args.setLength(length);
      args.setCheckpointPath(checkpointPath);
      sendBase("addCheckpoint", args);
    }

    public boolean recv_addCheckpoint() throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException
    {
      addCheckpoint_result result = new addCheckpoint_result();
      receiveBase(result, "addCheckpoint");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eP != null) {
        throw result.eP;
      }
      if (result.eS != null) {
        throw result.eS;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addCheckpoint failed: unknown result");
    }

    public List<ClientWorkerInfo> getWorkersInfo() throws org.apache.thrift.TException
    {
      send_getWorkersInfo();
      return recv_getWorkersInfo();
    }

    public void send_getWorkersInfo() throws org.apache.thrift.TException
    {
      getWorkersInfo_args args = new getWorkersInfo_args();
      sendBase("getWorkersInfo", args);
    }

    public List<ClientWorkerInfo> recv_getWorkersInfo() throws org.apache.thrift.TException
    {
      getWorkersInfo_result result = new getWorkersInfo_result();
      receiveBase(result, "getWorkersInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getWorkersInfo failed: unknown result");
    }

    public List<ClientFileInfo> liststatus(String path) throws InvalidPathException, FileDoesNotExistException, org.apache.thrift.TException
    {
      send_liststatus(path);
      return recv_liststatus();
    }

    public void send_liststatus(String path) throws org.apache.thrift.TException
    {
      liststatus_args args = new liststatus_args();
      args.setPath(path);
      sendBase("liststatus", args);
    }

    public List<ClientFileInfo> recv_liststatus() throws InvalidPathException, FileDoesNotExistException, org.apache.thrift.TException
    {
      liststatus_result result = new liststatus_result();
      receiveBase(result, "liststatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      if (result.eF != null) {
        throw result.eF;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "liststatus failed: unknown result");
    }

    public long worker_register(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long,List<Long>> currentBlocks) throws BlockInfoException, org.apache.thrift.TException
    {
      send_worker_register(workerNetAddress, totalBytes, usedBytes, currentBlocks);
      return recv_worker_register();
    }

    public void send_worker_register(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long,List<Long>> currentBlocks) throws org.apache.thrift.TException
    {
      worker_register_args args = new worker_register_args();
      args.setWorkerNetAddress(workerNetAddress);
      args.setTotalBytes(totalBytes);
      args.setUsedBytes(usedBytes);
      args.setCurrentBlocks(currentBlocks);
      sendBase("worker_register", args);
    }

    public long recv_worker_register() throws BlockInfoException, org.apache.thrift.TException
    {
      worker_register_result result = new worker_register_result();
      receiveBase(result, "worker_register");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "worker_register failed: unknown result");
    }

    public Command worker_heartbeat(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long,List<Long>> addedBlockIds) throws BlockInfoException, org.apache.thrift.TException
    {
      send_worker_heartbeat(workerId, usedBytes, removedBlockIds, addedBlockIds);
      return recv_worker_heartbeat();
    }

    public void send_worker_heartbeat(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long,List<Long>> addedBlockIds) throws org.apache.thrift.TException
    {
      worker_heartbeat_args args = new worker_heartbeat_args();
      args.setWorkerId(workerId);
      args.setUsedBytes(usedBytes);
      args.setRemovedBlockIds(removedBlockIds);
      args.setAddedBlockIds(addedBlockIds);
      sendBase("worker_heartbeat", args);
    }

    public Command recv_worker_heartbeat() throws BlockInfoException, org.apache.thrift.TException
    {
      worker_heartbeat_result result = new worker_heartbeat_result();
      receiveBase(result, "worker_heartbeat");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "worker_heartbeat failed: unknown result");
    }

    public void worker_cacheBlock(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException
    {
      send_worker_cacheBlock(workerId, workerUsedBytes, storageDirId, blockId, length);
      recv_worker_cacheBlock();
    }

    public void send_worker_cacheBlock(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length) throws org.apache.thrift.TException
    {
      worker_cacheBlock_args args = new worker_cacheBlock_args();
      args.setWorkerId(workerId);
      args.setWorkerUsedBytes(workerUsedBytes);
      args.setStorageDirId(storageDirId);
      args.setBlockId(blockId);
      args.setLength(length);
      sendBase("worker_cacheBlock", args);
    }

    public void recv_worker_cacheBlock() throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException
    {
      worker_cacheBlock_result result = new worker_cacheBlock_result();
      receiveBase(result, "worker_cacheBlock");
      if (result.eP != null) {
        throw result.eP;
      }
      if (result.eS != null) {
        throw result.eS;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      return;
    }

    public Set<Integer> worker_getPinIdList() throws org.apache.thrift.TException
    {
      send_worker_getPinIdList();
      return recv_worker_getPinIdList();
    }

    public void send_worker_getPinIdList() throws org.apache.thrift.TException
    {
      worker_getPinIdList_args args = new worker_getPinIdList_args();
      sendBase("worker_getPinIdList", args);
    }

    public Set<Integer> recv_worker_getPinIdList() throws org.apache.thrift.TException
    {
      worker_getPinIdList_result result = new worker_getPinIdList_result();
      receiveBase(result, "worker_getPinIdList");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "worker_getPinIdList failed: unknown result");
    }

    public List<Integer> worker_getPriorityDependencyList() throws org.apache.thrift.TException
    {
      send_worker_getPriorityDependencyList();
      return recv_worker_getPriorityDependencyList();
    }

    public void send_worker_getPriorityDependencyList() throws org.apache.thrift.TException
    {
      worker_getPriorityDependencyList_args args = new worker_getPriorityDependencyList_args();
      sendBase("worker_getPriorityDependencyList", args);
    }

    public List<Integer> recv_worker_getPriorityDependencyList() throws org.apache.thrift.TException
    {
      worker_getPriorityDependencyList_result result = new worker_getPriorityDependencyList_result();
      receiveBase(result, "worker_getPriorityDependencyList");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "worker_getPriorityDependencyList failed: unknown result");
    }

    public int user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws InvalidPathException, FileDoesNotExistException, FileAlreadyExistException, BlockInfoException, TachyonException, org.apache.thrift.TException
    {
      send_user_createDependency(parents, children, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, childrenBlockSizeByte);
      return recv_user_createDependency();
    }

    public void send_user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws org.apache.thrift.TException
    {
      user_createDependency_args args = new user_createDependency_args();
      args.setParents(parents);
      args.setChildren(children);
      args.setCommandPrefix(commandPrefix);
      args.setData(data);
      args.setComment(comment);
      args.setFramework(framework);
      args.setFrameworkVersion(frameworkVersion);
      args.setDependencyType(dependencyType);
      args.setChildrenBlockSizeByte(childrenBlockSizeByte);
      sendBase("user_createDependency", args);
    }

    public int recv_user_createDependency() throws InvalidPathException, FileDoesNotExistException, FileAlreadyExistException, BlockInfoException, TachyonException, org.apache.thrift.TException
    {
      user_createDependency_result result = new user_createDependency_result();
      receiveBase(result, "user_createDependency");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      if (result.eF != null) {
        throw result.eF;
      }
      if (result.eA != null) {
        throw result.eA;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      if (result.eT != null) {
        throw result.eT;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_createDependency failed: unknown result");
    }

    public ClientDependencyInfo user_getClientDependencyInfo(int dependencyId) throws DependencyDoesNotExistException, org.apache.thrift.TException
    {
      send_user_getClientDependencyInfo(dependencyId);
      return recv_user_getClientDependencyInfo();
    }

    public void send_user_getClientDependencyInfo(int dependencyId) throws org.apache.thrift.TException
    {
      user_getClientDependencyInfo_args args = new user_getClientDependencyInfo_args();
      args.setDependencyId(dependencyId);
      sendBase("user_getClientDependencyInfo", args);
    }

    public ClientDependencyInfo recv_user_getClientDependencyInfo() throws DependencyDoesNotExistException, org.apache.thrift.TException
    {
      user_getClientDependencyInfo_result result = new user_getClientDependencyInfo_result();
      receiveBase(result, "user_getClientDependencyInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getClientDependencyInfo failed: unknown result");
    }

    public void user_reportLostFile(int fileId) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_user_reportLostFile(fileId);
      recv_user_reportLostFile();
    }

    public void send_user_reportLostFile(int fileId) throws org.apache.thrift.TException
    {
      user_reportLostFile_args args = new user_reportLostFile_args();
      args.setFileId(fileId);
      sendBase("user_reportLostFile", args);
    }

    public void recv_user_reportLostFile() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      user_reportLostFile_result result = new user_reportLostFile_result();
      receiveBase(result, "user_reportLostFile");
      if (result.e != null) {
        throw result.e;
      }
      return;
    }

    public void user_requestFilesInDependency(int depId) throws DependencyDoesNotExistException, org.apache.thrift.TException
    {
      send_user_requestFilesInDependency(depId);
      recv_user_requestFilesInDependency();
    }

    public void send_user_requestFilesInDependency(int depId) throws org.apache.thrift.TException
    {
      user_requestFilesInDependency_args args = new user_requestFilesInDependency_args();
      args.setDepId(depId);
      sendBase("user_requestFilesInDependency", args);
    }

    public void recv_user_requestFilesInDependency() throws DependencyDoesNotExistException, org.apache.thrift.TException
    {
      user_requestFilesInDependency_result result = new user_requestFilesInDependency_result();
      receiveBase(result, "user_requestFilesInDependency");
      if (result.e != null) {
        throw result.e;
      }
      return;
    }

    public int user_createFile(String path, String ufsPath, long blockSizeByte, boolean recursive) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, SuspectedFileSizeException, TachyonException, org.apache.thrift.TException
    {
      send_user_createFile(path, ufsPath, blockSizeByte, recursive);
      return recv_user_createFile();
    }

    public void send_user_createFile(String path, String ufsPath, long blockSizeByte, boolean recursive) throws org.apache.thrift.TException
    {
      user_createFile_args args = new user_createFile_args();
      args.setPath(path);
      args.setUfsPath(ufsPath);
      args.setBlockSizeByte(blockSizeByte);
      args.setRecursive(recursive);
      sendBase("user_createFile", args);
    }

    public int recv_user_createFile() throws FileAlreadyExistException, InvalidPathException, BlockInfoException, SuspectedFileSizeException, TachyonException, org.apache.thrift.TException
    {
      user_createFile_result result = new user_createFile_result();
      receiveBase(result, "user_createFile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eR != null) {
        throw result.eR;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      if (result.eS != null) {
        throw result.eS;
      }
      if (result.eT != null) {
        throw result.eT;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_createFile failed: unknown result");
    }

    public long user_createNewBlock(int fileId) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_user_createNewBlock(fileId);
      return recv_user_createNewBlock();
    }

    public void send_user_createNewBlock(int fileId) throws org.apache.thrift.TException
    {
      user_createNewBlock_args args = new user_createNewBlock_args();
      args.setFileId(fileId);
      sendBase("user_createNewBlock", args);
    }

    public long recv_user_createNewBlock() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      user_createNewBlock_result result = new user_createNewBlock_result();
      receiveBase(result, "user_createNewBlock");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_createNewBlock failed: unknown result");
    }

    public void user_completeFile(int fileId) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_user_completeFile(fileId);
      recv_user_completeFile();
    }

    public void send_user_completeFile(int fileId) throws org.apache.thrift.TException
    {
      user_completeFile_args args = new user_completeFile_args();
      args.setFileId(fileId);
      sendBase("user_completeFile", args);
    }

    public void recv_user_completeFile() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      user_completeFile_result result = new user_completeFile_result();
      receiveBase(result, "user_completeFile");
      if (result.e != null) {
        throw result.e;
      }
      return;
    }

    public long user_getUserId() throws org.apache.thrift.TException
    {
      send_user_getUserId();
      return recv_user_getUserId();
    }

    public void send_user_getUserId() throws org.apache.thrift.TException
    {
      user_getUserId_args args = new user_getUserId_args();
      sendBase("user_getUserId", args);
    }

    public long recv_user_getUserId() throws org.apache.thrift.TException
    {
      user_getUserId_result result = new user_getUserId_result();
      receiveBase(result, "user_getUserId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getUserId failed: unknown result");
    }

    public long user_getBlockId(int fileId, int index) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_user_getBlockId(fileId, index);
      return recv_user_getBlockId();
    }

    public void send_user_getBlockId(int fileId, int index) throws org.apache.thrift.TException
    {
      user_getBlockId_args args = new user_getBlockId_args();
      args.setFileId(fileId);
      args.setIndex(index);
      sendBase("user_getBlockId", args);
    }

    public long recv_user_getBlockId() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      user_getBlockId_result result = new user_getBlockId_result();
      receiveBase(result, "user_getBlockId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getBlockId failed: unknown result");
    }

    public NetAddress user_getWorker(boolean random, String host) throws NoWorkerException, org.apache.thrift.TException
    {
      send_user_getWorker(random, host);
      return recv_user_getWorker();
    }

    public void send_user_getWorker(boolean random, String host) throws org.apache.thrift.TException
    {
      user_getWorker_args args = new user_getWorker_args();
      args.setRandom(random);
      args.setHost(host);
      sendBase("user_getWorker", args);
    }

    public NetAddress recv_user_getWorker() throws NoWorkerException, org.apache.thrift.TException
    {
      user_getWorker_result result = new user_getWorker_result();
      receiveBase(result, "user_getWorker");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getWorker failed: unknown result");
    }

    public ClientFileInfo getFileStatus(int fileId, String path) throws InvalidPathException, org.apache.thrift.TException
    {
      send_getFileStatus(fileId, path);
      return recv_getFileStatus();
    }

    public void send_getFileStatus(int fileId, String path) throws org.apache.thrift.TException
    {
      getFileStatus_args args = new getFileStatus_args();
      args.setFileId(fileId);
      args.setPath(path);
      sendBase("getFileStatus", args);
    }

    public ClientFileInfo recv_getFileStatus() throws InvalidPathException, org.apache.thrift.TException
    {
      getFileStatus_result result = new getFileStatus_result();
      receiveBase(result, "getFileStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getFileStatus failed: unknown result");
    }

    public ClientBlockInfo user_getClientBlockInfo(long blockId) throws FileDoesNotExistException, BlockInfoException, org.apache.thrift.TException
    {
      send_user_getClientBlockInfo(blockId);
      return recv_user_getClientBlockInfo();
    }

    public void send_user_getClientBlockInfo(long blockId) throws org.apache.thrift.TException
    {
      user_getClientBlockInfo_args args = new user_getClientBlockInfo_args();
      args.setBlockId(blockId);
      sendBase("user_getClientBlockInfo", args);
    }

    public ClientBlockInfo recv_user_getClientBlockInfo() throws FileDoesNotExistException, BlockInfoException, org.apache.thrift.TException
    {
      user_getClientBlockInfo_result result = new user_getClientBlockInfo_result();
      receiveBase(result, "user_getClientBlockInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eF != null) {
        throw result.eF;
      }
      if (result.eB != null) {
        throw result.eB;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getClientBlockInfo failed: unknown result");
    }

    public List<ClientBlockInfo> user_getFileBlocks(int fileId, String path) throws FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException
    {
      send_user_getFileBlocks(fileId, path);
      return recv_user_getFileBlocks();
    }

    public void send_user_getFileBlocks(int fileId, String path) throws org.apache.thrift.TException
    {
      user_getFileBlocks_args args = new user_getFileBlocks_args();
      args.setFileId(fileId);
      args.setPath(path);
      sendBase("user_getFileBlocks", args);
    }

    public List<ClientBlockInfo> recv_user_getFileBlocks() throws FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException
    {
      user_getFileBlocks_result result = new user_getFileBlocks_result();
      receiveBase(result, "user_getFileBlocks");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eF != null) {
        throw result.eF;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getFileBlocks failed: unknown result");
    }

    public boolean user_delete(int fileId, String path, boolean recursive) throws TachyonException, org.apache.thrift.TException
    {
      send_user_delete(fileId, path, recursive);
      return recv_user_delete();
    }

    public void send_user_delete(int fileId, String path, boolean recursive) throws org.apache.thrift.TException
    {
      user_delete_args args = new user_delete_args();
      args.setFileId(fileId);
      args.setPath(path);
      args.setRecursive(recursive);
      sendBase("user_delete", args);
    }

    public boolean recv_user_delete() throws TachyonException, org.apache.thrift.TException
    {
      user_delete_result result = new user_delete_result();
      receiveBase(result, "user_delete");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_delete failed: unknown result");
    }

    public boolean user_rename(int fileId, String srcPath, String dstPath) throws FileAlreadyExistException, FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException
    {
      send_user_rename(fileId, srcPath, dstPath);
      return recv_user_rename();
    }

    public void send_user_rename(int fileId, String srcPath, String dstPath) throws org.apache.thrift.TException
    {
      user_rename_args args = new user_rename_args();
      args.setFileId(fileId);
      args.setSrcPath(srcPath);
      args.setDstPath(dstPath);
      sendBase("user_rename", args);
    }

    public boolean recv_user_rename() throws FileAlreadyExistException, FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException
    {
      user_rename_result result = new user_rename_result();
      receiveBase(result, "user_rename");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eA != null) {
        throw result.eA;
      }
      if (result.eF != null) {
        throw result.eF;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_rename failed: unknown result");
    }

    public void user_setPinned(int fileId, boolean pinned) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_user_setPinned(fileId, pinned);
      recv_user_setPinned();
    }

    public void send_user_setPinned(int fileId, boolean pinned) throws org.apache.thrift.TException
    {
      user_setPinned_args args = new user_setPinned_args();
      args.setFileId(fileId);
      args.setPinned(pinned);
      sendBase("user_setPinned", args);
    }

    public void recv_user_setPinned() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      user_setPinned_result result = new user_setPinned_result();
      receiveBase(result, "user_setPinned");
      if (result.e != null) {
        throw result.e;
      }
      return;
    }

    public boolean user_mkdirs(String path, boolean recursive) throws FileAlreadyExistException, InvalidPathException, TachyonException, org.apache.thrift.TException
    {
      send_user_mkdirs(path, recursive);
      return recv_user_mkdirs();
    }

    public void send_user_mkdirs(String path, boolean recursive) throws org.apache.thrift.TException
    {
      user_mkdirs_args args = new user_mkdirs_args();
      args.setPath(path);
      args.setRecursive(recursive);
      sendBase("user_mkdirs", args);
    }

    public boolean recv_user_mkdirs() throws FileAlreadyExistException, InvalidPathException, TachyonException, org.apache.thrift.TException
    {
      user_mkdirs_result result = new user_mkdirs_result();
      receiveBase(result, "user_mkdirs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eR != null) {
        throw result.eR;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      if (result.eT != null) {
        throw result.eT;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_mkdirs failed: unknown result");
    }

    public int user_createRawTable(String path, int columns, ByteBuffer metadata) throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException, org.apache.thrift.TException
    {
      send_user_createRawTable(path, columns, metadata);
      return recv_user_createRawTable();
    }

    public void send_user_createRawTable(String path, int columns, ByteBuffer metadata) throws org.apache.thrift.TException
    {
      user_createRawTable_args args = new user_createRawTable_args();
      args.setPath(path);
      args.setColumns(columns);
      args.setMetadata(metadata);
      sendBase("user_createRawTable", args);
    }

    public int recv_user_createRawTable() throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException, org.apache.thrift.TException
    {
      user_createRawTable_result result = new user_createRawTable_result();
      receiveBase(result, "user_createRawTable");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eR != null) {
        throw result.eR;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      if (result.eT != null) {
        throw result.eT;
      }
      if (result.eTa != null) {
        throw result.eTa;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_createRawTable failed: unknown result");
    }

    public int user_getRawTableId(String path) throws InvalidPathException, org.apache.thrift.TException
    {
      send_user_getRawTableId(path);
      return recv_user_getRawTableId();
    }

    public void send_user_getRawTableId(String path) throws org.apache.thrift.TException
    {
      user_getRawTableId_args args = new user_getRawTableId_args();
      args.setPath(path);
      sendBase("user_getRawTableId", args);
    }

    public int recv_user_getRawTableId() throws InvalidPathException, org.apache.thrift.TException
    {
      user_getRawTableId_result result = new user_getRawTableId_result();
      receiveBase(result, "user_getRawTableId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getRawTableId failed: unknown result");
    }

    public ClientRawTableInfo user_getClientRawTableInfo(int id, String path) throws TableDoesNotExistException, InvalidPathException, org.apache.thrift.TException
    {
      send_user_getClientRawTableInfo(id, path);
      return recv_user_getClientRawTableInfo();
    }

    public void send_user_getClientRawTableInfo(int id, String path) throws org.apache.thrift.TException
    {
      user_getClientRawTableInfo_args args = new user_getClientRawTableInfo_args();
      args.setId(id);
      args.setPath(path);
      sendBase("user_getClientRawTableInfo", args);
    }

    public ClientRawTableInfo recv_user_getClientRawTableInfo() throws TableDoesNotExistException, InvalidPathException, org.apache.thrift.TException
    {
      user_getClientRawTableInfo_result result = new user_getClientRawTableInfo_result();
      receiveBase(result, "user_getClientRawTableInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.eT != null) {
        throw result.eT;
      }
      if (result.eI != null) {
        throw result.eI;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getClientRawTableInfo failed: unknown result");
    }

    public void user_updateRawTableMetadata(int tableId, ByteBuffer metadata) throws TableDoesNotExistException, TachyonException, org.apache.thrift.TException
    {
      send_user_updateRawTableMetadata(tableId, metadata);
      recv_user_updateRawTableMetadata();
    }

    public void send_user_updateRawTableMetadata(int tableId, ByteBuffer metadata) throws org.apache.thrift.TException
    {
      user_updateRawTableMetadata_args args = new user_updateRawTableMetadata_args();
      args.setTableId(tableId);
      args.setMetadata(metadata);
      sendBase("user_updateRawTableMetadata", args);
    }

    public void recv_user_updateRawTableMetadata() throws TableDoesNotExistException, TachyonException, org.apache.thrift.TException
    {
      user_updateRawTableMetadata_result result = new user_updateRawTableMetadata_result();
      receiveBase(result, "user_updateRawTableMetadata");
      if (result.eT != null) {
        throw result.eT;
      }
      if (result.eTa != null) {
        throw result.eTa;
      }
      return;
    }

    public String user_getUfsAddress() throws org.apache.thrift.TException
    {
      send_user_getUfsAddress();
      return recv_user_getUfsAddress();
    }

    public void send_user_getUfsAddress() throws org.apache.thrift.TException
    {
      user_getUfsAddress_args args = new user_getUfsAddress_args();
      sendBase("user_getUfsAddress", args);
    }

    public String recv_user_getUfsAddress() throws org.apache.thrift.TException
    {
      user_getUfsAddress_result result = new user_getUfsAddress_result();
      receiveBase(result, "user_getUfsAddress");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_getUfsAddress failed: unknown result");
    }

    public void user_heartbeat() throws org.apache.thrift.TException
    {
      send_user_heartbeat();
      recv_user_heartbeat();
    }

    public void send_user_heartbeat() throws org.apache.thrift.TException
    {
      user_heartbeat_args args = new user_heartbeat_args();
      sendBase("user_heartbeat", args);
    }

    public void recv_user_heartbeat() throws org.apache.thrift.TException
    {
      user_heartbeat_result result = new user_heartbeat_result();
      receiveBase(result, "user_heartbeat");
      return;
    }

    public boolean user_freepath(int fileId, String path, boolean recursive) throws FileDoesNotExistException, org.apache.thrift.TException
    {
      send_user_freepath(fileId, path, recursive);
      return recv_user_freepath();
    }

    public void send_user_freepath(int fileId, String path, boolean recursive) throws org.apache.thrift.TException
    {
      user_freepath_args args = new user_freepath_args();
      args.setFileId(fileId);
      args.setPath(path);
      args.setRecursive(recursive);
      sendBase("user_freepath", args);
    }

    public boolean recv_user_freepath() throws FileDoesNotExistException, org.apache.thrift.TException
    {
      user_freepath_result result = new user_freepath_result();
      receiveBase(result, "user_freepath");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "user_freepath failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void addCheckpoint(long workerId, int fileId, long length, String checkpointPath, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addCheckpoint_call method_call = new addCheckpoint_call(workerId, fileId, length, checkpointPath, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addCheckpoint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long workerId;
      private int fileId;
      private long length;
      private String checkpointPath;
      public addCheckpoint_call(long workerId, int fileId, long length, String checkpointPath, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workerId = workerId;
        this.fileId = fileId;
        this.length = length;
        this.checkpointPath = checkpointPath;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addCheckpoint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addCheckpoint_args args = new addCheckpoint_args();
        args.setWorkerId(workerId);
        args.setFileId(fileId);
        args.setLength(length);
        args.setCheckpointPath(checkpointPath);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addCheckpoint();
      }
    }

    public void getWorkersInfo(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getWorkersInfo_call method_call = new getWorkersInfo_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getWorkersInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getWorkersInfo_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getWorkersInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getWorkersInfo_args args = new getWorkersInfo_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ClientWorkerInfo> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getWorkersInfo();
      }
    }

    public void liststatus(String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      liststatus_call method_call = new liststatus_call(path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class liststatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String path;
      public liststatus_call(String path, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("liststatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        liststatus_args args = new liststatus_args();
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ClientFileInfo> getResult() throws InvalidPathException, FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_liststatus();
      }
    }

    public void worker_register(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long,List<Long>> currentBlocks, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      worker_register_call method_call = new worker_register_call(workerNetAddress, totalBytes, usedBytes, currentBlocks, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class worker_register_call extends org.apache.thrift.async.TAsyncMethodCall {
      private NetAddress workerNetAddress;
      private long totalBytes;
      private long usedBytes;
      private Map<Long,List<Long>> currentBlocks;
      public worker_register_call(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long,List<Long>> currentBlocks, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workerNetAddress = workerNetAddress;
        this.totalBytes = totalBytes;
        this.usedBytes = usedBytes;
        this.currentBlocks = currentBlocks;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("worker_register", org.apache.thrift.protocol.TMessageType.CALL, 0));
        worker_register_args args = new worker_register_args();
        args.setWorkerNetAddress(workerNetAddress);
        args.setTotalBytes(totalBytes);
        args.setUsedBytes(usedBytes);
        args.setCurrentBlocks(currentBlocks);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_worker_register();
      }
    }

    public void worker_heartbeat(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long,List<Long>> addedBlockIds, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      worker_heartbeat_call method_call = new worker_heartbeat_call(workerId, usedBytes, removedBlockIds, addedBlockIds, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class worker_heartbeat_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long workerId;
      private long usedBytes;
      private List<Long> removedBlockIds;
      private Map<Long,List<Long>> addedBlockIds;
      public worker_heartbeat_call(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long,List<Long>> addedBlockIds, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workerId = workerId;
        this.usedBytes = usedBytes;
        this.removedBlockIds = removedBlockIds;
        this.addedBlockIds = addedBlockIds;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("worker_heartbeat", org.apache.thrift.protocol.TMessageType.CALL, 0));
        worker_heartbeat_args args = new worker_heartbeat_args();
        args.setWorkerId(workerId);
        args.setUsedBytes(usedBytes);
        args.setRemovedBlockIds(removedBlockIds);
        args.setAddedBlockIds(addedBlockIds);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Command getResult() throws BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_worker_heartbeat();
      }
    }

    public void worker_cacheBlock(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      worker_cacheBlock_call method_call = new worker_cacheBlock_call(workerId, workerUsedBytes, storageDirId, blockId, length, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class worker_cacheBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long workerId;
      private long workerUsedBytes;
      private long storageDirId;
      private long blockId;
      private long length;
      public worker_cacheBlock_call(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workerId = workerId;
        this.workerUsedBytes = workerUsedBytes;
        this.storageDirId = storageDirId;
        this.blockId = blockId;
        this.length = length;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("worker_cacheBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        worker_cacheBlock_args args = new worker_cacheBlock_args();
        args.setWorkerId(workerId);
        args.setWorkerUsedBytes(workerUsedBytes);
        args.setStorageDirId(storageDirId);
        args.setBlockId(blockId);
        args.setLength(length);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_worker_cacheBlock();
      }
    }

    public void worker_getPinIdList(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      worker_getPinIdList_call method_call = new worker_getPinIdList_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class worker_getPinIdList_call extends org.apache.thrift.async.TAsyncMethodCall {
      public worker_getPinIdList_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("worker_getPinIdList", org.apache.thrift.protocol.TMessageType.CALL, 0));
        worker_getPinIdList_args args = new worker_getPinIdList_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Set<Integer> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_worker_getPinIdList();
      }
    }

    public void worker_getPriorityDependencyList(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      worker_getPriorityDependencyList_call method_call = new worker_getPriorityDependencyList_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class worker_getPriorityDependencyList_call extends org.apache.thrift.async.TAsyncMethodCall {
      public worker_getPriorityDependencyList_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("worker_getPriorityDependencyList", org.apache.thrift.protocol.TMessageType.CALL, 0));
        worker_getPriorityDependencyList_args args = new worker_getPriorityDependencyList_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<Integer> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_worker_getPriorityDependencyList();
      }
    }

    public void user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_createDependency_call method_call = new user_createDependency_call(parents, children, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, childrenBlockSizeByte, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_createDependency_call extends org.apache.thrift.async.TAsyncMethodCall {
      private List<String> parents;
      private List<String> children;
      private String commandPrefix;
      private List<ByteBuffer> data;
      private String comment;
      private String framework;
      private String frameworkVersion;
      private int dependencyType;
      private long childrenBlockSizeByte;
      public user_createDependency_call(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.parents = parents;
        this.children = children;
        this.commandPrefix = commandPrefix;
        this.data = data;
        this.comment = comment;
        this.framework = framework;
        this.frameworkVersion = frameworkVersion;
        this.dependencyType = dependencyType;
        this.childrenBlockSizeByte = childrenBlockSizeByte;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_createDependency", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_createDependency_args args = new user_createDependency_args();
        args.setParents(parents);
        args.setChildren(children);
        args.setCommandPrefix(commandPrefix);
        args.setData(data);
        args.setComment(comment);
        args.setFramework(framework);
        args.setFrameworkVersion(frameworkVersion);
        args.setDependencyType(dependencyType);
        args.setChildrenBlockSizeByte(childrenBlockSizeByte);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws InvalidPathException, FileDoesNotExistException, FileAlreadyExistException, BlockInfoException, TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_createDependency();
      }
    }

    public void user_getClientDependencyInfo(int dependencyId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getClientDependencyInfo_call method_call = new user_getClientDependencyInfo_call(dependencyId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getClientDependencyInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int dependencyId;
      public user_getClientDependencyInfo_call(int dependencyId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dependencyId = dependencyId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getClientDependencyInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getClientDependencyInfo_args args = new user_getClientDependencyInfo_args();
        args.setDependencyId(dependencyId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ClientDependencyInfo getResult() throws DependencyDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getClientDependencyInfo();
      }
    }

    public void user_reportLostFile(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_reportLostFile_call method_call = new user_reportLostFile_call(fileId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_reportLostFile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      public user_reportLostFile_call(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_reportLostFile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_reportLostFile_args args = new user_reportLostFile_args();
        args.setFileId(fileId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_user_reportLostFile();
      }
    }

    public void user_requestFilesInDependency(int depId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_requestFilesInDependency_call method_call = new user_requestFilesInDependency_call(depId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_requestFilesInDependency_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int depId;
      public user_requestFilesInDependency_call(int depId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.depId = depId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_requestFilesInDependency", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_requestFilesInDependency_args args = new user_requestFilesInDependency_args();
        args.setDepId(depId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws DependencyDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_user_requestFilesInDependency();
      }
    }

    public void user_createFile(String path, String ufsPath, long blockSizeByte, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_createFile_call method_call = new user_createFile_call(path, ufsPath, blockSizeByte, recursive, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_createFile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String path;
      private String ufsPath;
      private long blockSizeByte;
      private boolean recursive;
      public user_createFile_call(String path, String ufsPath, long blockSizeByte, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.path = path;
        this.ufsPath = ufsPath;
        this.blockSizeByte = blockSizeByte;
        this.recursive = recursive;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_createFile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_createFile_args args = new user_createFile_args();
        args.setPath(path);
        args.setUfsPath(ufsPath);
        args.setBlockSizeByte(blockSizeByte);
        args.setRecursive(recursive);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws FileAlreadyExistException, InvalidPathException, BlockInfoException, SuspectedFileSizeException, TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_createFile();
      }
    }

    public void user_createNewBlock(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_createNewBlock_call method_call = new user_createNewBlock_call(fileId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_createNewBlock_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      public user_createNewBlock_call(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_createNewBlock", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_createNewBlock_args args = new user_createNewBlock_args();
        args.setFileId(fileId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_createNewBlock();
      }
    }

    public void user_completeFile(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_completeFile_call method_call = new user_completeFile_call(fileId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_completeFile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      public user_completeFile_call(int fileId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_completeFile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_completeFile_args args = new user_completeFile_args();
        args.setFileId(fileId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_user_completeFile();
      }
    }

    public void user_getUserId(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getUserId_call method_call = new user_getUserId_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getUserId_call extends org.apache.thrift.async.TAsyncMethodCall {
      public user_getUserId_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getUserId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getUserId_args args = new user_getUserId_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getUserId();
      }
    }

    public void user_getBlockId(int fileId, int index, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getBlockId_call method_call = new user_getBlockId_call(fileId, index, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getBlockId_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private int index;
      public user_getBlockId_call(int fileId, int index, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.index = index;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getBlockId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getBlockId_args args = new user_getBlockId_args();
        args.setFileId(fileId);
        args.setIndex(index);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getBlockId();
      }
    }

    public void user_getWorker(boolean random, String host, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getWorker_call method_call = new user_getWorker_call(random, host, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getWorker_call extends org.apache.thrift.async.TAsyncMethodCall {
      private boolean random;
      private String host;
      public user_getWorker_call(boolean random, String host, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.random = random;
        this.host = host;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getWorker", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getWorker_args args = new user_getWorker_args();
        args.setRandom(random);
        args.setHost(host);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public NetAddress getResult() throws NoWorkerException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getWorker();
      }
    }

    public void getFileStatus(int fileId, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getFileStatus_call method_call = new getFileStatus_call(fileId, path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getFileStatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private String path;
      public getFileStatus_call(int fileId, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getFileStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getFileStatus_args args = new getFileStatus_args();
        args.setFileId(fileId);
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ClientFileInfo getResult() throws InvalidPathException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getFileStatus();
      }
    }

    public void user_getClientBlockInfo(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getClientBlockInfo_call method_call = new user_getClientBlockInfo_call(blockId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getClientBlockInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long blockId;
      public user_getClientBlockInfo_call(long blockId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.blockId = blockId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getClientBlockInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getClientBlockInfo_args args = new user_getClientBlockInfo_args();
        args.setBlockId(blockId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ClientBlockInfo getResult() throws FileDoesNotExistException, BlockInfoException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getClientBlockInfo();
      }
    }

    public void user_getFileBlocks(int fileId, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getFileBlocks_call method_call = new user_getFileBlocks_call(fileId, path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getFileBlocks_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private String path;
      public user_getFileBlocks_call(int fileId, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getFileBlocks", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getFileBlocks_args args = new user_getFileBlocks_args();
        args.setFileId(fileId);
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ClientBlockInfo> getResult() throws FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getFileBlocks();
      }
    }

    public void user_delete(int fileId, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_delete_call method_call = new user_delete_call(fileId, path, recursive, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_delete_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private String path;
      private boolean recursive;
      public user_delete_call(int fileId, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.path = path;
        this.recursive = recursive;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_delete", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_delete_args args = new user_delete_args();
        args.setFileId(fileId);
        args.setPath(path);
        args.setRecursive(recursive);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_delete();
      }
    }

    public void user_rename(int fileId, String srcPath, String dstPath, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_rename_call method_call = new user_rename_call(fileId, srcPath, dstPath, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_rename_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private String srcPath;
      private String dstPath;
      public user_rename_call(int fileId, String srcPath, String dstPath, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.srcPath = srcPath;
        this.dstPath = dstPath;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_rename", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_rename_args args = new user_rename_args();
        args.setFileId(fileId);
        args.setSrcPath(srcPath);
        args.setDstPath(dstPath);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws FileAlreadyExistException, FileDoesNotExistException, InvalidPathException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_rename();
      }
    }

    public void user_setPinned(int fileId, boolean pinned, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_setPinned_call method_call = new user_setPinned_call(fileId, pinned, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_setPinned_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private boolean pinned;
      public user_setPinned_call(int fileId, boolean pinned, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.pinned = pinned;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_setPinned", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_setPinned_args args = new user_setPinned_args();
        args.setFileId(fileId);
        args.setPinned(pinned);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_user_setPinned();
      }
    }

    public void user_mkdirs(String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_mkdirs_call method_call = new user_mkdirs_call(path, recursive, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_mkdirs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String path;
      private boolean recursive;
      public user_mkdirs_call(String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.path = path;
        this.recursive = recursive;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_mkdirs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_mkdirs_args args = new user_mkdirs_args();
        args.setPath(path);
        args.setRecursive(recursive);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws FileAlreadyExistException, InvalidPathException, TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_mkdirs();
      }
    }

    public void user_createRawTable(String path, int columns, ByteBuffer metadata, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_createRawTable_call method_call = new user_createRawTable_call(path, columns, metadata, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_createRawTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String path;
      private int columns;
      private ByteBuffer metadata;
      public user_createRawTable_call(String path, int columns, ByteBuffer metadata, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.path = path;
        this.columns = columns;
        this.metadata = metadata;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_createRawTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_createRawTable_args args = new user_createRawTable_args();
        args.setPath(path);
        args.setColumns(columns);
        args.setMetadata(metadata);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_createRawTable();
      }
    }

    public void user_getRawTableId(String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getRawTableId_call method_call = new user_getRawTableId_call(path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getRawTableId_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String path;
      public user_getRawTableId_call(String path, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getRawTableId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getRawTableId_args args = new user_getRawTableId_args();
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws InvalidPathException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getRawTableId();
      }
    }

    public void user_getClientRawTableInfo(int id, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getClientRawTableInfo_call method_call = new user_getClientRawTableInfo_call(id, path, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getClientRawTableInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int id;
      private String path;
      public user_getClientRawTableInfo_call(int id, String path, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.path = path;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getClientRawTableInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getClientRawTableInfo_args args = new user_getClientRawTableInfo_args();
        args.setId(id);
        args.setPath(path);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ClientRawTableInfo getResult() throws TableDoesNotExistException, InvalidPathException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getClientRawTableInfo();
      }
    }

    public void user_updateRawTableMetadata(int tableId, ByteBuffer metadata, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_updateRawTableMetadata_call method_call = new user_updateRawTableMetadata_call(tableId, metadata, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_updateRawTableMetadata_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int tableId;
      private ByteBuffer metadata;
      public user_updateRawTableMetadata_call(int tableId, ByteBuffer metadata, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableId = tableId;
        this.metadata = metadata;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_updateRawTableMetadata", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_updateRawTableMetadata_args args = new user_updateRawTableMetadata_args();
        args.setTableId(tableId);
        args.setMetadata(metadata);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TableDoesNotExistException, TachyonException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_user_updateRawTableMetadata();
      }
    }

    public void user_getUfsAddress(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_getUfsAddress_call method_call = new user_getUfsAddress_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_getUfsAddress_call extends org.apache.thrift.async.TAsyncMethodCall {
      public user_getUfsAddress_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_getUfsAddress", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_getUfsAddress_args args = new user_getUfsAddress_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_getUfsAddress();
      }
    }

    public void user_heartbeat(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_heartbeat_call method_call = new user_heartbeat_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_heartbeat_call extends org.apache.thrift.async.TAsyncMethodCall {
      public user_heartbeat_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_heartbeat", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_heartbeat_args args = new user_heartbeat_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_user_heartbeat();
      }
    }

    public void user_freepath(int fileId, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      user_freepath_call method_call = new user_freepath_call(fileId, path, recursive, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class user_freepath_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int fileId;
      private String path;
      private boolean recursive;
      public user_freepath_call(int fileId, String path, boolean recursive, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.fileId = fileId;
        this.path = path;
        this.recursive = recursive;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("user_freepath", org.apache.thrift.protocol.TMessageType.CALL, 0));
        user_freepath_args args = new user_freepath_args();
        args.setFileId(fileId);
        args.setPath(path);
        args.setRecursive(recursive);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws FileDoesNotExistException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_user_freepath();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("addCheckpoint", new addCheckpoint());
      processMap.put("getWorkersInfo", new getWorkersInfo());
      processMap.put("liststatus", new liststatus());
      processMap.put("worker_register", new worker_register());
      processMap.put("worker_heartbeat", new worker_heartbeat());
      processMap.put("worker_cacheBlock", new worker_cacheBlock());
      processMap.put("worker_getPinIdList", new worker_getPinIdList());
      processMap.put("worker_getPriorityDependencyList", new worker_getPriorityDependencyList());
      processMap.put("user_createDependency", new user_createDependency());
      processMap.put("user_getClientDependencyInfo", new user_getClientDependencyInfo());
      processMap.put("user_reportLostFile", new user_reportLostFile());
      processMap.put("user_requestFilesInDependency", new user_requestFilesInDependency());
      processMap.put("user_createFile", new user_createFile());
      processMap.put("user_createNewBlock", new user_createNewBlock());
      processMap.put("user_completeFile", new user_completeFile());
      processMap.put("user_getUserId", new user_getUserId());
      processMap.put("user_getBlockId", new user_getBlockId());
      processMap.put("user_getWorker", new user_getWorker());
      processMap.put("getFileStatus", new getFileStatus());
      processMap.put("user_getClientBlockInfo", new user_getClientBlockInfo());
      processMap.put("user_getFileBlocks", new user_getFileBlocks());
      processMap.put("user_delete", new user_delete());
      processMap.put("user_rename", new user_rename());
      processMap.put("user_setPinned", new user_setPinned());
      processMap.put("user_mkdirs", new user_mkdirs());
      processMap.put("user_createRawTable", new user_createRawTable());
      processMap.put("user_getRawTableId", new user_getRawTableId());
      processMap.put("user_getClientRawTableInfo", new user_getClientRawTableInfo());
      processMap.put("user_updateRawTableMetadata", new user_updateRawTableMetadata());
      processMap.put("user_getUfsAddress", new user_getUfsAddress());
      processMap.put("user_heartbeat", new user_heartbeat());
      processMap.put("user_freepath", new user_freepath());
      return processMap;
    }

    public static class addCheckpoint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addCheckpoint_args> {
      public addCheckpoint() {
        super("addCheckpoint");
      }

      public addCheckpoint_args getEmptyArgsInstance() {
        return new addCheckpoint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addCheckpoint_result getResult(I iface, addCheckpoint_args args) throws org.apache.thrift.TException {
        addCheckpoint_result result = new addCheckpoint_result();
        try {
          result.success = iface.addCheckpoint(args.workerId, args.fileId, args.length, args.checkpointPath);
          result.setSuccessIsSet(true);
        } catch (FileDoesNotExistException eP) {
          result.eP = eP;
        } catch (SuspectedFileSizeException eS) {
          result.eS = eS;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        }
        return result;
      }
    }

    public static class getWorkersInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getWorkersInfo_args> {
      public getWorkersInfo() {
        super("getWorkersInfo");
      }

      public getWorkersInfo_args getEmptyArgsInstance() {
        return new getWorkersInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getWorkersInfo_result getResult(I iface, getWorkersInfo_args args) throws org.apache.thrift.TException {
        getWorkersInfo_result result = new getWorkersInfo_result();
        result.success = iface.getWorkersInfo();
        return result;
      }
    }

    public static class liststatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, liststatus_args> {
      public liststatus() {
        super("liststatus");
      }

      public liststatus_args getEmptyArgsInstance() {
        return new liststatus_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public liststatus_result getResult(I iface, liststatus_args args) throws org.apache.thrift.TException {
        liststatus_result result = new liststatus_result();
        try {
          result.success = iface.liststatus(args.path);
        } catch (InvalidPathException eI) {
          result.eI = eI;
        } catch (FileDoesNotExistException eF) {
          result.eF = eF;
        }
        return result;
      }
    }

    public static class worker_register<I extends Iface> extends org.apache.thrift.ProcessFunction<I, worker_register_args> {
      public worker_register() {
        super("worker_register");
      }

      public worker_register_args getEmptyArgsInstance() {
        return new worker_register_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public worker_register_result getResult(I iface, worker_register_args args) throws org.apache.thrift.TException {
        worker_register_result result = new worker_register_result();
        try {
          result.success = iface.worker_register(args.workerNetAddress, args.totalBytes, args.usedBytes, args.currentBlocks);
          result.setSuccessIsSet(true);
        } catch (BlockInfoException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class worker_heartbeat<I extends Iface> extends org.apache.thrift.ProcessFunction<I, worker_heartbeat_args> {
      public worker_heartbeat() {
        super("worker_heartbeat");
      }

      public worker_heartbeat_args getEmptyArgsInstance() {
        return new worker_heartbeat_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public worker_heartbeat_result getResult(I iface, worker_heartbeat_args args) throws org.apache.thrift.TException {
        worker_heartbeat_result result = new worker_heartbeat_result();
        try {
          result.success = iface.worker_heartbeat(args.workerId, args.usedBytes, args.removedBlockIds, args.addedBlockIds);
        } catch (BlockInfoException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class worker_cacheBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, worker_cacheBlock_args> {
      public worker_cacheBlock() {
        super("worker_cacheBlock");
      }

      public worker_cacheBlock_args getEmptyArgsInstance() {
        return new worker_cacheBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public worker_cacheBlock_result getResult(I iface, worker_cacheBlock_args args) throws org.apache.thrift.TException {
        worker_cacheBlock_result result = new worker_cacheBlock_result();
        try {
          iface.worker_cacheBlock(args.workerId, args.workerUsedBytes, args.storageDirId, args.blockId, args.length);
        } catch (FileDoesNotExistException eP) {
          result.eP = eP;
        } catch (SuspectedFileSizeException eS) {
          result.eS = eS;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        }
        return result;
      }
    }

    public static class worker_getPinIdList<I extends Iface> extends org.apache.thrift.ProcessFunction<I, worker_getPinIdList_args> {
      public worker_getPinIdList() {
        super("worker_getPinIdList");
      }

      public worker_getPinIdList_args getEmptyArgsInstance() {
        return new worker_getPinIdList_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public worker_getPinIdList_result getResult(I iface, worker_getPinIdList_args args) throws org.apache.thrift.TException {
        worker_getPinIdList_result result = new worker_getPinIdList_result();
        result.success = iface.worker_getPinIdList();
        return result;
      }
    }

    public static class worker_getPriorityDependencyList<I extends Iface> extends org.apache.thrift.ProcessFunction<I, worker_getPriorityDependencyList_args> {
      public worker_getPriorityDependencyList() {
        super("worker_getPriorityDependencyList");
      }

      public worker_getPriorityDependencyList_args getEmptyArgsInstance() {
        return new worker_getPriorityDependencyList_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public worker_getPriorityDependencyList_result getResult(I iface, worker_getPriorityDependencyList_args args) throws org.apache.thrift.TException {
        worker_getPriorityDependencyList_result result = new worker_getPriorityDependencyList_result();
        result.success = iface.worker_getPriorityDependencyList();
        return result;
      }
    }

    public static class user_createDependency<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_createDependency_args> {
      public user_createDependency() {
        super("user_createDependency");
      }

      public user_createDependency_args getEmptyArgsInstance() {
        return new user_createDependency_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_createDependency_result getResult(I iface, user_createDependency_args args) throws org.apache.thrift.TException {
        user_createDependency_result result = new user_createDependency_result();
        try {
          result.success = iface.user_createDependency(args.parents, args.children, args.commandPrefix, args.data, args.comment, args.framework, args.frameworkVersion, args.dependencyType, args.childrenBlockSizeByte);
          result.setSuccessIsSet(true);
        } catch (InvalidPathException eI) {
          result.eI = eI;
        } catch (FileDoesNotExistException eF) {
          result.eF = eF;
        } catch (FileAlreadyExistException eA) {
          result.eA = eA;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        } catch (TachyonException eT) {
          result.eT = eT;
        }
        return result;
      }
    }

    public static class user_getClientDependencyInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getClientDependencyInfo_args> {
      public user_getClientDependencyInfo() {
        super("user_getClientDependencyInfo");
      }

      public user_getClientDependencyInfo_args getEmptyArgsInstance() {
        return new user_getClientDependencyInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getClientDependencyInfo_result getResult(I iface, user_getClientDependencyInfo_args args) throws org.apache.thrift.TException {
        user_getClientDependencyInfo_result result = new user_getClientDependencyInfo_result();
        try {
          result.success = iface.user_getClientDependencyInfo(args.dependencyId);
        } catch (DependencyDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_reportLostFile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_reportLostFile_args> {
      public user_reportLostFile() {
        super("user_reportLostFile");
      }

      public user_reportLostFile_args getEmptyArgsInstance() {
        return new user_reportLostFile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_reportLostFile_result getResult(I iface, user_reportLostFile_args args) throws org.apache.thrift.TException {
        user_reportLostFile_result result = new user_reportLostFile_result();
        try {
          iface.user_reportLostFile(args.fileId);
        } catch (FileDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_requestFilesInDependency<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_requestFilesInDependency_args> {
      public user_requestFilesInDependency() {
        super("user_requestFilesInDependency");
      }

      public user_requestFilesInDependency_args getEmptyArgsInstance() {
        return new user_requestFilesInDependency_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_requestFilesInDependency_result getResult(I iface, user_requestFilesInDependency_args args) throws org.apache.thrift.TException {
        user_requestFilesInDependency_result result = new user_requestFilesInDependency_result();
        try {
          iface.user_requestFilesInDependency(args.depId);
        } catch (DependencyDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_createFile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_createFile_args> {
      public user_createFile() {
        super("user_createFile");
      }

      public user_createFile_args getEmptyArgsInstance() {
        return new user_createFile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_createFile_result getResult(I iface, user_createFile_args args) throws org.apache.thrift.TException {
        user_createFile_result result = new user_createFile_result();
        try {
          result.success = iface.user_createFile(args.path, args.ufsPath, args.blockSizeByte, args.recursive);
          result.setSuccessIsSet(true);
        } catch (FileAlreadyExistException eR) {
          result.eR = eR;
        } catch (InvalidPathException eI) {
          result.eI = eI;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        } catch (SuspectedFileSizeException eS) {
          result.eS = eS;
        } catch (TachyonException eT) {
          result.eT = eT;
        }
        return result;
      }
    }

    public static class user_createNewBlock<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_createNewBlock_args> {
      public user_createNewBlock() {
        super("user_createNewBlock");
      }

      public user_createNewBlock_args getEmptyArgsInstance() {
        return new user_createNewBlock_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_createNewBlock_result getResult(I iface, user_createNewBlock_args args) throws org.apache.thrift.TException {
        user_createNewBlock_result result = new user_createNewBlock_result();
        try {
          result.success = iface.user_createNewBlock(args.fileId);
          result.setSuccessIsSet(true);
        } catch (FileDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_completeFile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_completeFile_args> {
      public user_completeFile() {
        super("user_completeFile");
      }

      public user_completeFile_args getEmptyArgsInstance() {
        return new user_completeFile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_completeFile_result getResult(I iface, user_completeFile_args args) throws org.apache.thrift.TException {
        user_completeFile_result result = new user_completeFile_result();
        try {
          iface.user_completeFile(args.fileId);
        } catch (FileDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_getUserId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getUserId_args> {
      public user_getUserId() {
        super("user_getUserId");
      }

      public user_getUserId_args getEmptyArgsInstance() {
        return new user_getUserId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getUserId_result getResult(I iface, user_getUserId_args args) throws org.apache.thrift.TException {
        user_getUserId_result result = new user_getUserId_result();
        result.success = iface.user_getUserId();
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class user_getBlockId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getBlockId_args> {
      public user_getBlockId() {
        super("user_getBlockId");
      }

      public user_getBlockId_args getEmptyArgsInstance() {
        return new user_getBlockId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getBlockId_result getResult(I iface, user_getBlockId_args args) throws org.apache.thrift.TException {
        user_getBlockId_result result = new user_getBlockId_result();
        try {
          result.success = iface.user_getBlockId(args.fileId, args.index);
          result.setSuccessIsSet(true);
        } catch (FileDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_getWorker<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getWorker_args> {
      public user_getWorker() {
        super("user_getWorker");
      }

      public user_getWorker_args getEmptyArgsInstance() {
        return new user_getWorker_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getWorker_result getResult(I iface, user_getWorker_args args) throws org.apache.thrift.TException {
        user_getWorker_result result = new user_getWorker_result();
        try {
          result.success = iface.user_getWorker(args.random, args.host);
        } catch (NoWorkerException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class getFileStatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getFileStatus_args> {
      public getFileStatus() {
        super("getFileStatus");
      }

      public getFileStatus_args getEmptyArgsInstance() {
        return new getFileStatus_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getFileStatus_result getResult(I iface, getFileStatus_args args) throws org.apache.thrift.TException {
        getFileStatus_result result = new getFileStatus_result();
        try {
          result.success = iface.getFileStatus(args.fileId, args.path);
        } catch (InvalidPathException eI) {
          result.eI = eI;
        }
        return result;
      }
    }

    public static class user_getClientBlockInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getClientBlockInfo_args> {
      public user_getClientBlockInfo() {
        super("user_getClientBlockInfo");
      }

      public user_getClientBlockInfo_args getEmptyArgsInstance() {
        return new user_getClientBlockInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getClientBlockInfo_result getResult(I iface, user_getClientBlockInfo_args args) throws org.apache.thrift.TException {
        user_getClientBlockInfo_result result = new user_getClientBlockInfo_result();
        try {
          result.success = iface.user_getClientBlockInfo(args.blockId);
        } catch (FileDoesNotExistException eF) {
          result.eF = eF;
        } catch (BlockInfoException eB) {
          result.eB = eB;
        }
        return result;
      }
    }

    public static class user_getFileBlocks<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getFileBlocks_args> {
      public user_getFileBlocks() {
        super("user_getFileBlocks");
      }

      public user_getFileBlocks_args getEmptyArgsInstance() {
        return new user_getFileBlocks_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getFileBlocks_result getResult(I iface, user_getFileBlocks_args args) throws org.apache.thrift.TException {
        user_getFileBlocks_result result = new user_getFileBlocks_result();
        try {
          result.success = iface.user_getFileBlocks(args.fileId, args.path);
        } catch (FileDoesNotExistException eF) {
          result.eF = eF;
        } catch (InvalidPathException eI) {
          result.eI = eI;
        }
        return result;
      }
    }

    public static class user_delete<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_delete_args> {
      public user_delete() {
        super("user_delete");
      }

      public user_delete_args getEmptyArgsInstance() {
        return new user_delete_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_delete_result getResult(I iface, user_delete_args args) throws org.apache.thrift.TException {
        user_delete_result result = new user_delete_result();
        try {
          result.success = iface.user_delete(args.fileId, args.path, args.recursive);
          result.setSuccessIsSet(true);
        } catch (TachyonException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_rename<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_rename_args> {
      public user_rename() {
        super("user_rename");
      }

      public user_rename_args getEmptyArgsInstance() {
        return new user_rename_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_rename_result getResult(I iface, user_rename_args args) throws org.apache.thrift.TException {
        user_rename_result result = new user_rename_result();
        try {
          result.success = iface.user_rename(args.fileId, args.srcPath, args.dstPath);
          result.setSuccessIsSet(true);
        } catch (FileAlreadyExistException eA) {
          result.eA = eA;
        } catch (FileDoesNotExistException eF) {
          result.eF = eF;
        } catch (InvalidPathException eI) {
          result.eI = eI;
        }
        return result;
      }
    }

    public static class user_setPinned<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_setPinned_args> {
      public user_setPinned() {
        super("user_setPinned");
      }

      public user_setPinned_args getEmptyArgsInstance() {
        return new user_setPinned_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_setPinned_result getResult(I iface, user_setPinned_args args) throws org.apache.thrift.TException {
        user_setPinned_result result = new user_setPinned_result();
        try {
          iface.user_setPinned(args.fileId, args.pinned);
        } catch (FileDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_mkdirs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_mkdirs_args> {
      public user_mkdirs() {
        super("user_mkdirs");
      }

      public user_mkdirs_args getEmptyArgsInstance() {
        return new user_mkdirs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_mkdirs_result getResult(I iface, user_mkdirs_args args) throws org.apache.thrift.TException {
        user_mkdirs_result result = new user_mkdirs_result();
        try {
          result.success = iface.user_mkdirs(args.path, args.recursive);
          result.setSuccessIsSet(true);
        } catch (FileAlreadyExistException eR) {
          result.eR = eR;
        } catch (InvalidPathException eI) {
          result.eI = eI;
        } catch (TachyonException eT) {
          result.eT = eT;
        }
        return result;
      }
    }

    public static class user_createRawTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_createRawTable_args> {
      public user_createRawTable() {
        super("user_createRawTable");
      }

      public user_createRawTable_args getEmptyArgsInstance() {
        return new user_createRawTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_createRawTable_result getResult(I iface, user_createRawTable_args args) throws org.apache.thrift.TException {
        user_createRawTable_result result = new user_createRawTable_result();
        try {
          result.success = iface.user_createRawTable(args.path, args.columns, args.metadata);
          result.setSuccessIsSet(true);
        } catch (FileAlreadyExistException eR) {
          result.eR = eR;
        } catch (InvalidPathException eI) {
          result.eI = eI;
        } catch (TableColumnException eT) {
          result.eT = eT;
        } catch (TachyonException eTa) {
          result.eTa = eTa;
        }
        return result;
      }
    }

    public static class user_getRawTableId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getRawTableId_args> {
      public user_getRawTableId() {
        super("user_getRawTableId");
      }

      public user_getRawTableId_args getEmptyArgsInstance() {
        return new user_getRawTableId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getRawTableId_result getResult(I iface, user_getRawTableId_args args) throws org.apache.thrift.TException {
        user_getRawTableId_result result = new user_getRawTableId_result();
        try {
          result.success = iface.user_getRawTableId(args.path);
          result.setSuccessIsSet(true);
        } catch (InvalidPathException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class user_getClientRawTableInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getClientRawTableInfo_args> {
      public user_getClientRawTableInfo() {
        super("user_getClientRawTableInfo");
      }

      public user_getClientRawTableInfo_args getEmptyArgsInstance() {
        return new user_getClientRawTableInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getClientRawTableInfo_result getResult(I iface, user_getClientRawTableInfo_args args) throws org.apache.thrift.TException {
        user_getClientRawTableInfo_result result = new user_getClientRawTableInfo_result();
        try {
          result.success = iface.user_getClientRawTableInfo(args.id, args.path);
        } catch (TableDoesNotExistException eT) {
          result.eT = eT;
        } catch (InvalidPathException eI) {
          result.eI = eI;
        }
        return result;
      }
    }

    public static class user_updateRawTableMetadata<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_updateRawTableMetadata_args> {
      public user_updateRawTableMetadata() {
        super("user_updateRawTableMetadata");
      }

      public user_updateRawTableMetadata_args getEmptyArgsInstance() {
        return new user_updateRawTableMetadata_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_updateRawTableMetadata_result getResult(I iface, user_updateRawTableMetadata_args args) throws org.apache.thrift.TException {
        user_updateRawTableMetadata_result result = new user_updateRawTableMetadata_result();
        try {
          iface.user_updateRawTableMetadata(args.tableId, args.metadata);
        } catch (TableDoesNotExistException eT) {
          result.eT = eT;
        } catch (TachyonException eTa) {
          result.eTa = eTa;
        }
        return result;
      }
    }

    public static class user_getUfsAddress<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_getUfsAddress_args> {
      public user_getUfsAddress() {
        super("user_getUfsAddress");
      }

      public user_getUfsAddress_args getEmptyArgsInstance() {
        return new user_getUfsAddress_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_getUfsAddress_result getResult(I iface, user_getUfsAddress_args args) throws org.apache.thrift.TException {
        user_getUfsAddress_result result = new user_getUfsAddress_result();
        result.success = iface.user_getUfsAddress();
        return result;
      }
    }

    public static class user_heartbeat<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_heartbeat_args> {
      public user_heartbeat() {
        super("user_heartbeat");
      }

      public user_heartbeat_args getEmptyArgsInstance() {
        return new user_heartbeat_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_heartbeat_result getResult(I iface, user_heartbeat_args args) throws org.apache.thrift.TException {
        user_heartbeat_result result = new user_heartbeat_result();
        iface.user_heartbeat();
        return result;
      }
    }

    public static class user_freepath<I extends Iface> extends org.apache.thrift.ProcessFunction<I, user_freepath_args> {
      public user_freepath() {
        super("user_freepath");
      }

      public user_freepath_args getEmptyArgsInstance() {
        return new user_freepath_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public user_freepath_result getResult(I iface, user_freepath_args args) throws org.apache.thrift.TException {
        user_freepath_result result = new user_freepath_result();
        try {
          result.success = iface.user_freepath(args.fileId, args.path, args.recursive);
          result.setSuccessIsSet(true);
        } catch (FileDoesNotExistException e) {
          result.e = e;
        }
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("addCheckpoint", new addCheckpoint());
      processMap.put("getWorkersInfo", new getWorkersInfo());
      processMap.put("liststatus", new liststatus());
      processMap.put("worker_register", new worker_register());
      processMap.put("worker_heartbeat", new worker_heartbeat());
      processMap.put("worker_cacheBlock", new worker_cacheBlock());
      processMap.put("worker_getPinIdList", new worker_getPinIdList());
      processMap.put("worker_getPriorityDependencyList", new worker_getPriorityDependencyList());
      processMap.put("user_createDependency", new user_createDependency());
      processMap.put("user_getClientDependencyInfo", new user_getClientDependencyInfo());
      processMap.put("user_reportLostFile", new user_reportLostFile());
      processMap.put("user_requestFilesInDependency", new user_requestFilesInDependency());
      processMap.put("user_createFile", new user_createFile());
      processMap.put("user_createNewBlock", new user_createNewBlock());
      processMap.put("user_completeFile", new user_completeFile());
      processMap.put("user_getUserId", new user_getUserId());
      processMap.put("user_getBlockId", new user_getBlockId());
      processMap.put("user_getWorker", new user_getWorker());
      processMap.put("getFileStatus", new getFileStatus());
      processMap.put("user_getClientBlockInfo", new user_getClientBlockInfo());
      processMap.put("user_getFileBlocks", new user_getFileBlocks());
      processMap.put("user_delete", new user_delete());
      processMap.put("user_rename", new user_rename());
      processMap.put("user_setPinned", new user_setPinned());
      processMap.put("user_mkdirs", new user_mkdirs());
      processMap.put("user_createRawTable", new user_createRawTable());
      processMap.put("user_getRawTableId", new user_getRawTableId());
      processMap.put("user_getClientRawTableInfo", new user_getClientRawTableInfo());
      processMap.put("user_updateRawTableMetadata", new user_updateRawTableMetadata());
      processMap.put("user_getUfsAddress", new user_getUfsAddress());
      processMap.put("user_heartbeat", new user_heartbeat());
      processMap.put("user_freepath", new user_freepath());
      return processMap;
    }

    public static class addCheckpoint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addCheckpoint_args, Boolean> {
      public addCheckpoint() {
        super("addCheckpoint");
      }

      public addCheckpoint_args getEmptyArgsInstance() {
        return new addCheckpoint_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            addCheckpoint_result result = new addCheckpoint_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addCheckpoint_result result = new addCheckpoint_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eP = (FileDoesNotExistException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
            else             if (e instanceof SuspectedFileSizeException) {
                        result.eS = (SuspectedFileSizeException) e;
                        result.setESIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addCheckpoint_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.addCheckpoint(args.workerId, args.fileId, args.length, args.checkpointPath,resultHandler);
      }
    }

    public static class getWorkersInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getWorkersInfo_args, List<ClientWorkerInfo>> {
      public getWorkersInfo() {
        super("getWorkersInfo");
      }

      public getWorkersInfo_args getEmptyArgsInstance() {
        return new getWorkersInfo_args();
      }

      public AsyncMethodCallback<List<ClientWorkerInfo>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ClientWorkerInfo>>() { 
          public void onComplete(List<ClientWorkerInfo> o) {
            getWorkersInfo_result result = new getWorkersInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getWorkersInfo_result result = new getWorkersInfo_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getWorkersInfo_args args, org.apache.thrift.async.AsyncMethodCallback<List<ClientWorkerInfo>> resultHandler) throws TException {
        iface.getWorkersInfo(resultHandler);
      }
    }

    public static class liststatus<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, liststatus_args, List<ClientFileInfo>> {
      public liststatus() {
        super("liststatus");
      }

      public liststatus_args getEmptyArgsInstance() {
        return new liststatus_args();
      }

      public AsyncMethodCallback<List<ClientFileInfo>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ClientFileInfo>>() { 
          public void onComplete(List<ClientFileInfo> o) {
            liststatus_result result = new liststatus_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            liststatus_result result = new liststatus_result();
            if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
            else             if (e instanceof FileDoesNotExistException) {
                        result.eF = (FileDoesNotExistException) e;
                        result.setEFIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, liststatus_args args, org.apache.thrift.async.AsyncMethodCallback<List<ClientFileInfo>> resultHandler) throws TException {
        iface.liststatus(args.path,resultHandler);
      }
    }

    public static class worker_register<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, worker_register_args, Long> {
      public worker_register() {
        super("worker_register");
      }

      public worker_register_args getEmptyArgsInstance() {
        return new worker_register_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            worker_register_result result = new worker_register_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            worker_register_result result = new worker_register_result();
            if (e instanceof BlockInfoException) {
                        result.e = (BlockInfoException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, worker_register_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.worker_register(args.workerNetAddress, args.totalBytes, args.usedBytes, args.currentBlocks,resultHandler);
      }
    }

    public static class worker_heartbeat<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, worker_heartbeat_args, Command> {
      public worker_heartbeat() {
        super("worker_heartbeat");
      }

      public worker_heartbeat_args getEmptyArgsInstance() {
        return new worker_heartbeat_args();
      }

      public AsyncMethodCallback<Command> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Command>() { 
          public void onComplete(Command o) {
            worker_heartbeat_result result = new worker_heartbeat_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            worker_heartbeat_result result = new worker_heartbeat_result();
            if (e instanceof BlockInfoException) {
                        result.e = (BlockInfoException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, worker_heartbeat_args args, org.apache.thrift.async.AsyncMethodCallback<Command> resultHandler) throws TException {
        iface.worker_heartbeat(args.workerId, args.usedBytes, args.removedBlockIds, args.addedBlockIds,resultHandler);
      }
    }

    public static class worker_cacheBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, worker_cacheBlock_args, Void> {
      public worker_cacheBlock() {
        super("worker_cacheBlock");
      }

      public worker_cacheBlock_args getEmptyArgsInstance() {
        return new worker_cacheBlock_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            worker_cacheBlock_result result = new worker_cacheBlock_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            worker_cacheBlock_result result = new worker_cacheBlock_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eP = (FileDoesNotExistException) e;
                        result.setEPIsSet(true);
                        msg = result;
            }
            else             if (e instanceof SuspectedFileSizeException) {
                        result.eS = (SuspectedFileSizeException) e;
                        result.setESIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, worker_cacheBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.worker_cacheBlock(args.workerId, args.workerUsedBytes, args.storageDirId, args.blockId, args.length,resultHandler);
      }
    }

    public static class worker_getPinIdList<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, worker_getPinIdList_args, Set<Integer>> {
      public worker_getPinIdList() {
        super("worker_getPinIdList");
      }

      public worker_getPinIdList_args getEmptyArgsInstance() {
        return new worker_getPinIdList_args();
      }

      public AsyncMethodCallback<Set<Integer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Set<Integer>>() { 
          public void onComplete(Set<Integer> o) {
            worker_getPinIdList_result result = new worker_getPinIdList_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            worker_getPinIdList_result result = new worker_getPinIdList_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, worker_getPinIdList_args args, org.apache.thrift.async.AsyncMethodCallback<Set<Integer>> resultHandler) throws TException {
        iface.worker_getPinIdList(resultHandler);
      }
    }

    public static class worker_getPriorityDependencyList<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, worker_getPriorityDependencyList_args, List<Integer>> {
      public worker_getPriorityDependencyList() {
        super("worker_getPriorityDependencyList");
      }

      public worker_getPriorityDependencyList_args getEmptyArgsInstance() {
        return new worker_getPriorityDependencyList_args();
      }

      public AsyncMethodCallback<List<Integer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<Integer>>() { 
          public void onComplete(List<Integer> o) {
            worker_getPriorityDependencyList_result result = new worker_getPriorityDependencyList_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            worker_getPriorityDependencyList_result result = new worker_getPriorityDependencyList_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, worker_getPriorityDependencyList_args args, org.apache.thrift.async.AsyncMethodCallback<List<Integer>> resultHandler) throws TException {
        iface.worker_getPriorityDependencyList(resultHandler);
      }
    }

    public static class user_createDependency<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_createDependency_args, Integer> {
      public user_createDependency() {
        super("user_createDependency");
      }

      public user_createDependency_args getEmptyArgsInstance() {
        return new user_createDependency_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            user_createDependency_result result = new user_createDependency_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_createDependency_result result = new user_createDependency_result();
            if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
            else             if (e instanceof FileDoesNotExistException) {
                        result.eF = (FileDoesNotExistException) e;
                        result.setEFIsSet(true);
                        msg = result;
            }
            else             if (e instanceof FileAlreadyExistException) {
                        result.eA = (FileAlreadyExistException) e;
                        result.setEAIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TachyonException) {
                        result.eT = (TachyonException) e;
                        result.setETIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_createDependency_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.user_createDependency(args.parents, args.children, args.commandPrefix, args.data, args.comment, args.framework, args.frameworkVersion, args.dependencyType, args.childrenBlockSizeByte,resultHandler);
      }
    }

    public static class user_getClientDependencyInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getClientDependencyInfo_args, ClientDependencyInfo> {
      public user_getClientDependencyInfo() {
        super("user_getClientDependencyInfo");
      }

      public user_getClientDependencyInfo_args getEmptyArgsInstance() {
        return new user_getClientDependencyInfo_args();
      }

      public AsyncMethodCallback<ClientDependencyInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ClientDependencyInfo>() { 
          public void onComplete(ClientDependencyInfo o) {
            user_getClientDependencyInfo_result result = new user_getClientDependencyInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getClientDependencyInfo_result result = new user_getClientDependencyInfo_result();
            if (e instanceof DependencyDoesNotExistException) {
                        result.e = (DependencyDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getClientDependencyInfo_args args, org.apache.thrift.async.AsyncMethodCallback<ClientDependencyInfo> resultHandler) throws TException {
        iface.user_getClientDependencyInfo(args.dependencyId,resultHandler);
      }
    }

    public static class user_reportLostFile<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_reportLostFile_args, Void> {
      public user_reportLostFile() {
        super("user_reportLostFile");
      }

      public user_reportLostFile_args getEmptyArgsInstance() {
        return new user_reportLostFile_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            user_reportLostFile_result result = new user_reportLostFile_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_reportLostFile_result result = new user_reportLostFile_result();
            if (e instanceof FileDoesNotExistException) {
                        result.e = (FileDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_reportLostFile_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.user_reportLostFile(args.fileId,resultHandler);
      }
    }

    public static class user_requestFilesInDependency<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_requestFilesInDependency_args, Void> {
      public user_requestFilesInDependency() {
        super("user_requestFilesInDependency");
      }

      public user_requestFilesInDependency_args getEmptyArgsInstance() {
        return new user_requestFilesInDependency_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            user_requestFilesInDependency_result result = new user_requestFilesInDependency_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_requestFilesInDependency_result result = new user_requestFilesInDependency_result();
            if (e instanceof DependencyDoesNotExistException) {
                        result.e = (DependencyDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_requestFilesInDependency_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.user_requestFilesInDependency(args.depId,resultHandler);
      }
    }

    public static class user_createFile<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_createFile_args, Integer> {
      public user_createFile() {
        super("user_createFile");
      }

      public user_createFile_args getEmptyArgsInstance() {
        return new user_createFile_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            user_createFile_result result = new user_createFile_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_createFile_result result = new user_createFile_result();
            if (e instanceof FileAlreadyExistException) {
                        result.eR = (FileAlreadyExistException) e;
                        result.setERIsSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
            else             if (e instanceof SuspectedFileSizeException) {
                        result.eS = (SuspectedFileSizeException) e;
                        result.setESIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TachyonException) {
                        result.eT = (TachyonException) e;
                        result.setETIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_createFile_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.user_createFile(args.path, args.ufsPath, args.blockSizeByte, args.recursive,resultHandler);
      }
    }

    public static class user_createNewBlock<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_createNewBlock_args, Long> {
      public user_createNewBlock() {
        super("user_createNewBlock");
      }

      public user_createNewBlock_args getEmptyArgsInstance() {
        return new user_createNewBlock_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            user_createNewBlock_result result = new user_createNewBlock_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_createNewBlock_result result = new user_createNewBlock_result();
            if (e instanceof FileDoesNotExistException) {
                        result.e = (FileDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_createNewBlock_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.user_createNewBlock(args.fileId,resultHandler);
      }
    }

    public static class user_completeFile<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_completeFile_args, Void> {
      public user_completeFile() {
        super("user_completeFile");
      }

      public user_completeFile_args getEmptyArgsInstance() {
        return new user_completeFile_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            user_completeFile_result result = new user_completeFile_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_completeFile_result result = new user_completeFile_result();
            if (e instanceof FileDoesNotExistException) {
                        result.e = (FileDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_completeFile_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.user_completeFile(args.fileId,resultHandler);
      }
    }

    public static class user_getUserId<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getUserId_args, Long> {
      public user_getUserId() {
        super("user_getUserId");
      }

      public user_getUserId_args getEmptyArgsInstance() {
        return new user_getUserId_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            user_getUserId_result result = new user_getUserId_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getUserId_result result = new user_getUserId_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getUserId_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.user_getUserId(resultHandler);
      }
    }

    public static class user_getBlockId<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getBlockId_args, Long> {
      public user_getBlockId() {
        super("user_getBlockId");
      }

      public user_getBlockId_args getEmptyArgsInstance() {
        return new user_getBlockId_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            user_getBlockId_result result = new user_getBlockId_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getBlockId_result result = new user_getBlockId_result();
            if (e instanceof FileDoesNotExistException) {
                        result.e = (FileDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getBlockId_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.user_getBlockId(args.fileId, args.index,resultHandler);
      }
    }

    public static class user_getWorker<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getWorker_args, NetAddress> {
      public user_getWorker() {
        super("user_getWorker");
      }

      public user_getWorker_args getEmptyArgsInstance() {
        return new user_getWorker_args();
      }

      public AsyncMethodCallback<NetAddress> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<NetAddress>() { 
          public void onComplete(NetAddress o) {
            user_getWorker_result result = new user_getWorker_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getWorker_result result = new user_getWorker_result();
            if (e instanceof NoWorkerException) {
                        result.e = (NoWorkerException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getWorker_args args, org.apache.thrift.async.AsyncMethodCallback<NetAddress> resultHandler) throws TException {
        iface.user_getWorker(args.random, args.host,resultHandler);
      }
    }

    public static class getFileStatus<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getFileStatus_args, ClientFileInfo> {
      public getFileStatus() {
        super("getFileStatus");
      }

      public getFileStatus_args getEmptyArgsInstance() {
        return new getFileStatus_args();
      }

      public AsyncMethodCallback<ClientFileInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ClientFileInfo>() { 
          public void onComplete(ClientFileInfo o) {
            getFileStatus_result result = new getFileStatus_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getFileStatus_result result = new getFileStatus_result();
            if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getFileStatus_args args, org.apache.thrift.async.AsyncMethodCallback<ClientFileInfo> resultHandler) throws TException {
        iface.getFileStatus(args.fileId, args.path,resultHandler);
      }
    }

    public static class user_getClientBlockInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getClientBlockInfo_args, ClientBlockInfo> {
      public user_getClientBlockInfo() {
        super("user_getClientBlockInfo");
      }

      public user_getClientBlockInfo_args getEmptyArgsInstance() {
        return new user_getClientBlockInfo_args();
      }

      public AsyncMethodCallback<ClientBlockInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ClientBlockInfo>() { 
          public void onComplete(ClientBlockInfo o) {
            user_getClientBlockInfo_result result = new user_getClientBlockInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getClientBlockInfo_result result = new user_getClientBlockInfo_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eF = (FileDoesNotExistException) e;
                        result.setEFIsSet(true);
                        msg = result;
            }
            else             if (e instanceof BlockInfoException) {
                        result.eB = (BlockInfoException) e;
                        result.setEBIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getClientBlockInfo_args args, org.apache.thrift.async.AsyncMethodCallback<ClientBlockInfo> resultHandler) throws TException {
        iface.user_getClientBlockInfo(args.blockId,resultHandler);
      }
    }

    public static class user_getFileBlocks<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getFileBlocks_args, List<ClientBlockInfo>> {
      public user_getFileBlocks() {
        super("user_getFileBlocks");
      }

      public user_getFileBlocks_args getEmptyArgsInstance() {
        return new user_getFileBlocks_args();
      }

      public AsyncMethodCallback<List<ClientBlockInfo>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ClientBlockInfo>>() { 
          public void onComplete(List<ClientBlockInfo> o) {
            user_getFileBlocks_result result = new user_getFileBlocks_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getFileBlocks_result result = new user_getFileBlocks_result();
            if (e instanceof FileDoesNotExistException) {
                        result.eF = (FileDoesNotExistException) e;
                        result.setEFIsSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getFileBlocks_args args, org.apache.thrift.async.AsyncMethodCallback<List<ClientBlockInfo>> resultHandler) throws TException {
        iface.user_getFileBlocks(args.fileId, args.path,resultHandler);
      }
    }

    public static class user_delete<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_delete_args, Boolean> {
      public user_delete() {
        super("user_delete");
      }

      public user_delete_args getEmptyArgsInstance() {
        return new user_delete_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            user_delete_result result = new user_delete_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_delete_result result = new user_delete_result();
            if (e instanceof TachyonException) {
                        result.e = (TachyonException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_delete_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.user_delete(args.fileId, args.path, args.recursive,resultHandler);
      }
    }

    public static class user_rename<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_rename_args, Boolean> {
      public user_rename() {
        super("user_rename");
      }

      public user_rename_args getEmptyArgsInstance() {
        return new user_rename_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            user_rename_result result = new user_rename_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_rename_result result = new user_rename_result();
            if (e instanceof FileAlreadyExistException) {
                        result.eA = (FileAlreadyExistException) e;
                        result.setEAIsSet(true);
                        msg = result;
            }
            else             if (e instanceof FileDoesNotExistException) {
                        result.eF = (FileDoesNotExistException) e;
                        result.setEFIsSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_rename_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.user_rename(args.fileId, args.srcPath, args.dstPath,resultHandler);
      }
    }

    public static class user_setPinned<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_setPinned_args, Void> {
      public user_setPinned() {
        super("user_setPinned");
      }

      public user_setPinned_args getEmptyArgsInstance() {
        return new user_setPinned_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            user_setPinned_result result = new user_setPinned_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_setPinned_result result = new user_setPinned_result();
            if (e instanceof FileDoesNotExistException) {
                        result.e = (FileDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_setPinned_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.user_setPinned(args.fileId, args.pinned,resultHandler);
      }
    }

    public static class user_mkdirs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_mkdirs_args, Boolean> {
      public user_mkdirs() {
        super("user_mkdirs");
      }

      public user_mkdirs_args getEmptyArgsInstance() {
        return new user_mkdirs_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            user_mkdirs_result result = new user_mkdirs_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_mkdirs_result result = new user_mkdirs_result();
            if (e instanceof FileAlreadyExistException) {
                        result.eR = (FileAlreadyExistException) e;
                        result.setERIsSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TachyonException) {
                        result.eT = (TachyonException) e;
                        result.setETIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_mkdirs_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.user_mkdirs(args.path, args.recursive,resultHandler);
      }
    }

    public static class user_createRawTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_createRawTable_args, Integer> {
      public user_createRawTable() {
        super("user_createRawTable");
      }

      public user_createRawTable_args getEmptyArgsInstance() {
        return new user_createRawTable_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            user_createRawTable_result result = new user_createRawTable_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_createRawTable_result result = new user_createRawTable_result();
            if (e instanceof FileAlreadyExistException) {
                        result.eR = (FileAlreadyExistException) e;
                        result.setERIsSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableColumnException) {
                        result.eT = (TableColumnException) e;
                        result.setETIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TachyonException) {
                        result.eTa = (TachyonException) e;
                        result.setETaIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_createRawTable_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.user_createRawTable(args.path, args.columns, args.metadata,resultHandler);
      }
    }

    public static class user_getRawTableId<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getRawTableId_args, Integer> {
      public user_getRawTableId() {
        super("user_getRawTableId");
      }

      public user_getRawTableId_args getEmptyArgsInstance() {
        return new user_getRawTableId_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            user_getRawTableId_result result = new user_getRawTableId_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getRawTableId_result result = new user_getRawTableId_result();
            if (e instanceof InvalidPathException) {
                        result.e = (InvalidPathException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getRawTableId_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.user_getRawTableId(args.path,resultHandler);
      }
    }

    public static class user_getClientRawTableInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getClientRawTableInfo_args, ClientRawTableInfo> {
      public user_getClientRawTableInfo() {
        super("user_getClientRawTableInfo");
      }

      public user_getClientRawTableInfo_args getEmptyArgsInstance() {
        return new user_getClientRawTableInfo_args();
      }

      public AsyncMethodCallback<ClientRawTableInfo> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ClientRawTableInfo>() { 
          public void onComplete(ClientRawTableInfo o) {
            user_getClientRawTableInfo_result result = new user_getClientRawTableInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getClientRawTableInfo_result result = new user_getClientRawTableInfo_result();
            if (e instanceof TableDoesNotExistException) {
                        result.eT = (TableDoesNotExistException) e;
                        result.setETIsSet(true);
                        msg = result;
            }
            else             if (e instanceof InvalidPathException) {
                        result.eI = (InvalidPathException) e;
                        result.setEIIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getClientRawTableInfo_args args, org.apache.thrift.async.AsyncMethodCallback<ClientRawTableInfo> resultHandler) throws TException {
        iface.user_getClientRawTableInfo(args.id, args.path,resultHandler);
      }
    }

    public static class user_updateRawTableMetadata<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_updateRawTableMetadata_args, Void> {
      public user_updateRawTableMetadata() {
        super("user_updateRawTableMetadata");
      }

      public user_updateRawTableMetadata_args getEmptyArgsInstance() {
        return new user_updateRawTableMetadata_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            user_updateRawTableMetadata_result result = new user_updateRawTableMetadata_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_updateRawTableMetadata_result result = new user_updateRawTableMetadata_result();
            if (e instanceof TableDoesNotExistException) {
                        result.eT = (TableDoesNotExistException) e;
                        result.setETIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TachyonException) {
                        result.eTa = (TachyonException) e;
                        result.setETaIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_updateRawTableMetadata_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.user_updateRawTableMetadata(args.tableId, args.metadata,resultHandler);
      }
    }

    public static class user_getUfsAddress<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_getUfsAddress_args, String> {
      public user_getUfsAddress() {
        super("user_getUfsAddress");
      }

      public user_getUfsAddress_args getEmptyArgsInstance() {
        return new user_getUfsAddress_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            user_getUfsAddress_result result = new user_getUfsAddress_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_getUfsAddress_result result = new user_getUfsAddress_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_getUfsAddress_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.user_getUfsAddress(resultHandler);
      }
    }

    public static class user_heartbeat<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_heartbeat_args, Void> {
      public user_heartbeat() {
        super("user_heartbeat");
      }

      public user_heartbeat_args getEmptyArgsInstance() {
        return new user_heartbeat_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            user_heartbeat_result result = new user_heartbeat_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_heartbeat_result result = new user_heartbeat_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_heartbeat_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.user_heartbeat(resultHandler);
      }
    }

    public static class user_freepath<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, user_freepath_args, Boolean> {
      public user_freepath() {
        super("user_freepath");
      }

      public user_freepath_args getEmptyArgsInstance() {
        return new user_freepath_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            user_freepath_result result = new user_freepath_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            user_freepath_result result = new user_freepath_result();
            if (e instanceof FileDoesNotExistException) {
                        result.e = (FileDoesNotExistException) e;
                        result.setEIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, user_freepath_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.user_freepath(args.fileId, args.path, args.recursive,resultHandler);
      }
    }

  }

  public static class addCheckpoint_args implements org.apache.thrift.TBase<addCheckpoint_args, addCheckpoint_args._Fields>, java.io.Serializable, Cloneable, Comparable<addCheckpoint_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addCheckpoint_args");

    private static final org.apache.thrift.protocol.TField WORKER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("workerId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)2);
    private static final org.apache.thrift.protocol.TField LENGTH_FIELD_DESC = new org.apache.thrift.protocol.TField("length", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField CHECKPOINT_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("checkpointPath", org.apache.thrift.protocol.TType.STRING, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addCheckpoint_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addCheckpoint_argsTupleSchemeFactory());
    }

    public long workerId; // required
    public int fileId; // required
    public long length; // required
    public String checkpointPath; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      WORKER_ID((short)1, "workerId"),
      FILE_ID((short)2, "fileId"),
      LENGTH((short)3, "length"),
      CHECKPOINT_PATH((short)4, "checkpointPath");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // WORKER_ID
            return WORKER_ID;
          case 2: // FILE_ID
            return FILE_ID;
          case 3: // LENGTH
            return LENGTH;
          case 4: // CHECKPOINT_PATH
            return CHECKPOINT_PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __WORKERID_ISSET_ID = 0;
    private static final int __FILEID_ISSET_ID = 1;
    private static final int __LENGTH_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.WORKER_ID, new org.apache.thrift.meta_data.FieldMetaData("workerId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.LENGTH, new org.apache.thrift.meta_data.FieldMetaData("length", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CHECKPOINT_PATH, new org.apache.thrift.meta_data.FieldMetaData("checkpointPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addCheckpoint_args.class, metaDataMap);
    }

    public addCheckpoint_args() {
    }

    public addCheckpoint_args(
      long workerId,
      int fileId,
      long length,
      String checkpointPath)
    {
      this();
      this.workerId = workerId;
      setWorkerIdIsSet(true);
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.length = length;
      setLengthIsSet(true);
      this.checkpointPath = checkpointPath;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addCheckpoint_args(addCheckpoint_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.workerId = other.workerId;
      this.fileId = other.fileId;
      this.length = other.length;
      if (other.isSetCheckpointPath()) {
        this.checkpointPath = other.checkpointPath;
      }
    }

    public addCheckpoint_args deepCopy() {
      return new addCheckpoint_args(this);
    }

    @Override
    public void clear() {
      setWorkerIdIsSet(false);
      this.workerId = 0;
      setFileIdIsSet(false);
      this.fileId = 0;
      setLengthIsSet(false);
      this.length = 0;
      this.checkpointPath = null;
    }

    public long getWorkerId() {
      return this.workerId;
    }

    public addCheckpoint_args setWorkerId(long workerId) {
      this.workerId = workerId;
      setWorkerIdIsSet(true);
      return this;
    }

    public void unsetWorkerId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WORKERID_ISSET_ID);
    }

    /** Returns true if field workerId is set (has been assigned a value) and false otherwise */
    public boolean isSetWorkerId() {
      return EncodingUtils.testBit(__isset_bitfield, __WORKERID_ISSET_ID);
    }

    public void setWorkerIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WORKERID_ISSET_ID, value);
    }

    public int getFileId() {
      return this.fileId;
    }

    public addCheckpoint_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public long getLength() {
      return this.length;
    }

    public addCheckpoint_args setLength(long length) {
      this.length = length;
      setLengthIsSet(true);
      return this;
    }

    public void unsetLength() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LENGTH_ISSET_ID);
    }

    /** Returns true if field length is set (has been assigned a value) and false otherwise */
    public boolean isSetLength() {
      return EncodingUtils.testBit(__isset_bitfield, __LENGTH_ISSET_ID);
    }

    public void setLengthIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LENGTH_ISSET_ID, value);
    }

    public String getCheckpointPath() {
      return this.checkpointPath;
    }

    public addCheckpoint_args setCheckpointPath(String checkpointPath) {
      this.checkpointPath = checkpointPath;
      return this;
    }

    public void unsetCheckpointPath() {
      this.checkpointPath = null;
    }

    /** Returns true if field checkpointPath is set (has been assigned a value) and false otherwise */
    public boolean isSetCheckpointPath() {
      return this.checkpointPath != null;
    }

    public void setCheckpointPathIsSet(boolean value) {
      if (!value) {
        this.checkpointPath = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case WORKER_ID:
        if (value == null) {
          unsetWorkerId();
        } else {
          setWorkerId((Long)value);
        }
        break;

      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case LENGTH:
        if (value == null) {
          unsetLength();
        } else {
          setLength((Long)value);
        }
        break;

      case CHECKPOINT_PATH:
        if (value == null) {
          unsetCheckpointPath();
        } else {
          setCheckpointPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case WORKER_ID:
        return Long.valueOf(getWorkerId());

      case FILE_ID:
        return Integer.valueOf(getFileId());

      case LENGTH:
        return Long.valueOf(getLength());

      case CHECKPOINT_PATH:
        return getCheckpointPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case WORKER_ID:
        return isSetWorkerId();
      case FILE_ID:
        return isSetFileId();
      case LENGTH:
        return isSetLength();
      case CHECKPOINT_PATH:
        return isSetCheckpointPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addCheckpoint_args)
        return this.equals((addCheckpoint_args)that);
      return false;
    }

    public boolean equals(addCheckpoint_args that) {
      if (that == null)
        return false;

      boolean this_present_workerId = true;
      boolean that_present_workerId = true;
      if (this_present_workerId || that_present_workerId) {
        if (!(this_present_workerId && that_present_workerId))
          return false;
        if (this.workerId != that.workerId)
          return false;
      }

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      boolean this_present_length = true;
      boolean that_present_length = true;
      if (this_present_length || that_present_length) {
        if (!(this_present_length && that_present_length))
          return false;
        if (this.length != that.length)
          return false;
      }

      boolean this_present_checkpointPath = true && this.isSetCheckpointPath();
      boolean that_present_checkpointPath = true && that.isSetCheckpointPath();
      if (this_present_checkpointPath || that_present_checkpointPath) {
        if (!(this_present_checkpointPath && that_present_checkpointPath))
          return false;
        if (!this.checkpointPath.equals(that.checkpointPath))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(addCheckpoint_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetWorkerId()).compareTo(other.isSetWorkerId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWorkerId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workerId, other.workerId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLength()).compareTo(other.isSetLength());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLength()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.length, other.length);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCheckpointPath()).compareTo(other.isSetCheckpointPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCheckpointPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.checkpointPath, other.checkpointPath);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addCheckpoint_args(");
      boolean first = true;

      sb.append("workerId:");
      sb.append(this.workerId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("length:");
      sb.append(this.length);
      first = false;
      if (!first) sb.append(", ");
      sb.append("checkpointPath:");
      if (this.checkpointPath == null) {
        sb.append("null");
      } else {
        sb.append(this.checkpointPath);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addCheckpoint_argsStandardSchemeFactory implements SchemeFactory {
      public addCheckpoint_argsStandardScheme getScheme() {
        return new addCheckpoint_argsStandardScheme();
      }
    }

    private static class addCheckpoint_argsStandardScheme extends StandardScheme<addCheckpoint_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // WORKER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.workerId = iprot.readI64();
                struct.setWorkerIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LENGTH
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.length = iprot.readI64();
                struct.setLengthIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // CHECKPOINT_PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.checkpointPath = iprot.readString();
                struct.setCheckpointPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(WORKER_ID_FIELD_DESC);
        oprot.writeI64(struct.workerId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LENGTH_FIELD_DESC);
        oprot.writeI64(struct.length);
        oprot.writeFieldEnd();
        if (struct.checkpointPath != null) {
          oprot.writeFieldBegin(CHECKPOINT_PATH_FIELD_DESC);
          oprot.writeString(struct.checkpointPath);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addCheckpoint_argsTupleSchemeFactory implements SchemeFactory {
      public addCheckpoint_argsTupleScheme getScheme() {
        return new addCheckpoint_argsTupleScheme();
      }
    }

    private static class addCheckpoint_argsTupleScheme extends TupleScheme<addCheckpoint_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetWorkerId()) {
          optionals.set(0);
        }
        if (struct.isSetFileId()) {
          optionals.set(1);
        }
        if (struct.isSetLength()) {
          optionals.set(2);
        }
        if (struct.isSetCheckpointPath()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetWorkerId()) {
          oprot.writeI64(struct.workerId);
        }
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
        if (struct.isSetLength()) {
          oprot.writeI64(struct.length);
        }
        if (struct.isSetCheckpointPath()) {
          oprot.writeString(struct.checkpointPath);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.workerId = iprot.readI64();
          struct.setWorkerIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
        if (incoming.get(2)) {
          struct.length = iprot.readI64();
          struct.setLengthIsSet(true);
        }
        if (incoming.get(3)) {
          struct.checkpointPath = iprot.readString();
          struct.setCheckpointPathIsSet(true);
        }
      }
    }

  }

  public static class addCheckpoint_result implements org.apache.thrift.TBase<addCheckpoint_result, addCheckpoint_result._Fields>, java.io.Serializable, Cloneable, Comparable<addCheckpoint_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addCheckpoint_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_S_FIELD_DESC = new org.apache.thrift.protocol.TField("eS", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addCheckpoint_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addCheckpoint_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public FileDoesNotExistException eP; // required
    public SuspectedFileSizeException eS; // required
    public BlockInfoException eB; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_P((short)1, "eP"),
      E_S((short)2, "eS"),
      E_B((short)3, "eB");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_P
            return E_P;
          case 2: // E_S
            return E_S;
          case 3: // E_B
            return E_B;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_S, new org.apache.thrift.meta_data.FieldMetaData("eS", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addCheckpoint_result.class, metaDataMap);
    }

    public addCheckpoint_result() {
    }

    public addCheckpoint_result(
      boolean success,
      FileDoesNotExistException eP,
      SuspectedFileSizeException eS,
      BlockInfoException eB)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.eP = eP;
      this.eS = eS;
      this.eB = eB;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addCheckpoint_result(addCheckpoint_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetEP()) {
        this.eP = new FileDoesNotExistException(other.eP);
      }
      if (other.isSetES()) {
        this.eS = new SuspectedFileSizeException(other.eS);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
    }

    public addCheckpoint_result deepCopy() {
      return new addCheckpoint_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.eP = null;
      this.eS = null;
      this.eB = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public addCheckpoint_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public FileDoesNotExistException getEP() {
      return this.eP;
    }

    public addCheckpoint_result setEP(FileDoesNotExistException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public SuspectedFileSizeException getES() {
      return this.eS;
    }

    public addCheckpoint_result setES(SuspectedFileSizeException eS) {
      this.eS = eS;
      return this;
    }

    public void unsetES() {
      this.eS = null;
    }

    /** Returns true if field eS is set (has been assigned a value) and false otherwise */
    public boolean isSetES() {
      return this.eS != null;
    }

    public void setESIsSet(boolean value) {
      if (!value) {
        this.eS = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public addCheckpoint_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((FileDoesNotExistException)value);
        }
        break;

      case E_S:
        if (value == null) {
          unsetES();
        } else {
          setES((SuspectedFileSizeException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case E_P:
        return getEP();

      case E_S:
        return getES();

      case E_B:
        return getEB();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_P:
        return isSetEP();
      case E_S:
        return isSetES();
      case E_B:
        return isSetEB();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addCheckpoint_result)
        return this.equals((addCheckpoint_result)that);
      return false;
    }

    public boolean equals(addCheckpoint_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      boolean this_present_eS = true && this.isSetES();
      boolean that_present_eS = true && that.isSetES();
      if (this_present_eS || that_present_eS) {
        if (!(this_present_eS && that_present_eS))
          return false;
        if (!this.eS.equals(that.eS))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(addCheckpoint_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetES()).compareTo(other.isSetES());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetES()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eS, other.eS);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addCheckpoint_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eS:");
      if (this.eS == null) {
        sb.append("null");
      } else {
        sb.append(this.eS);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addCheckpoint_resultStandardSchemeFactory implements SchemeFactory {
      public addCheckpoint_resultStandardScheme getScheme() {
        return new addCheckpoint_resultStandardScheme();
      }
    }

    private static class addCheckpoint_resultStandardScheme extends StandardScheme<addCheckpoint_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new FileDoesNotExistException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_S
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eS = new SuspectedFileSizeException();
                struct.eS.read(iprot);
                struct.setESIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eS != null) {
          oprot.writeFieldBegin(E_S_FIELD_DESC);
          struct.eS.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addCheckpoint_resultTupleSchemeFactory implements SchemeFactory {
      public addCheckpoint_resultTupleScheme getScheme() {
        return new addCheckpoint_resultTupleScheme();
      }
    }

    private static class addCheckpoint_resultTupleScheme extends TupleScheme<addCheckpoint_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEP()) {
          optionals.set(1);
        }
        if (struct.isSetES()) {
          optionals.set(2);
        }
        if (struct.isSetEB()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
        if (struct.isSetES()) {
          struct.eS.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addCheckpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eP = new FileDoesNotExistException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eS = new SuspectedFileSizeException();
          struct.eS.read(iprot);
          struct.setESIsSet(true);
        }
        if (incoming.get(3)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
      }
    }

  }

  public static class getWorkersInfo_args implements org.apache.thrift.TBase<getWorkersInfo_args, getWorkersInfo_args._Fields>, java.io.Serializable, Cloneable, Comparable<getWorkersInfo_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getWorkersInfo_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getWorkersInfo_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getWorkersInfo_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getWorkersInfo_args.class, metaDataMap);
    }

    public getWorkersInfo_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getWorkersInfo_args(getWorkersInfo_args other) {
    }

    public getWorkersInfo_args deepCopy() {
      return new getWorkersInfo_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getWorkersInfo_args)
        return this.equals((getWorkersInfo_args)that);
      return false;
    }

    public boolean equals(getWorkersInfo_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(getWorkersInfo_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getWorkersInfo_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getWorkersInfo_argsStandardSchemeFactory implements SchemeFactory {
      public getWorkersInfo_argsStandardScheme getScheme() {
        return new getWorkersInfo_argsStandardScheme();
      }
    }

    private static class getWorkersInfo_argsStandardScheme extends StandardScheme<getWorkersInfo_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getWorkersInfo_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getWorkersInfo_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getWorkersInfo_argsTupleSchemeFactory implements SchemeFactory {
      public getWorkersInfo_argsTupleScheme getScheme() {
        return new getWorkersInfo_argsTupleScheme();
      }
    }

    private static class getWorkersInfo_argsTupleScheme extends TupleScheme<getWorkersInfo_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getWorkersInfo_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getWorkersInfo_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getWorkersInfo_result implements org.apache.thrift.TBase<getWorkersInfo_result, getWorkersInfo_result._Fields>, java.io.Serializable, Cloneable, Comparable<getWorkersInfo_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getWorkersInfo_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getWorkersInfo_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getWorkersInfo_resultTupleSchemeFactory());
    }

    public List<ClientWorkerInfo> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ClientWorkerInfo.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getWorkersInfo_result.class, metaDataMap);
    }

    public getWorkersInfo_result() {
    }

    public getWorkersInfo_result(
      List<ClientWorkerInfo> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getWorkersInfo_result(getWorkersInfo_result other) {
      if (other.isSetSuccess()) {
        List<ClientWorkerInfo> __this__success = new ArrayList<ClientWorkerInfo>(other.success.size());
        for (ClientWorkerInfo other_element : other.success) {
          __this__success.add(new ClientWorkerInfo(other_element));
        }
        this.success = __this__success;
      }
    }

    public getWorkersInfo_result deepCopy() {
      return new getWorkersInfo_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ClientWorkerInfo> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ClientWorkerInfo elem) {
      if (this.success == null) {
        this.success = new ArrayList<ClientWorkerInfo>();
      }
      this.success.add(elem);
    }

    public List<ClientWorkerInfo> getSuccess() {
      return this.success;
    }

    public getWorkersInfo_result setSuccess(List<ClientWorkerInfo> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ClientWorkerInfo>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getWorkersInfo_result)
        return this.equals((getWorkersInfo_result)that);
      return false;
    }

    public boolean equals(getWorkersInfo_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(getWorkersInfo_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getWorkersInfo_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getWorkersInfo_resultStandardSchemeFactory implements SchemeFactory {
      public getWorkersInfo_resultStandardScheme getScheme() {
        return new getWorkersInfo_resultStandardScheme();
      }
    }

    private static class getWorkersInfo_resultStandardScheme extends StandardScheme<getWorkersInfo_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getWorkersInfo_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list48 = iprot.readListBegin();
                  struct.success = new ArrayList<ClientWorkerInfo>(_list48.size);
                  for (int _i49 = 0; _i49 < _list48.size; ++_i49)
                  {
                    ClientWorkerInfo _elem50;
                    _elem50 = new ClientWorkerInfo();
                    _elem50.read(iprot);
                    struct.success.add(_elem50);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getWorkersInfo_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (ClientWorkerInfo _iter51 : struct.success)
            {
              _iter51.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getWorkersInfo_resultTupleSchemeFactory implements SchemeFactory {
      public getWorkersInfo_resultTupleScheme getScheme() {
        return new getWorkersInfo_resultTupleScheme();
      }
    }

    private static class getWorkersInfo_resultTupleScheme extends TupleScheme<getWorkersInfo_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getWorkersInfo_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (ClientWorkerInfo _iter52 : struct.success)
            {
              _iter52.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getWorkersInfo_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list53 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<ClientWorkerInfo>(_list53.size);
            for (int _i54 = 0; _i54 < _list53.size; ++_i54)
            {
              ClientWorkerInfo _elem55;
              _elem55 = new ClientWorkerInfo();
              _elem55.read(iprot);
              struct.success.add(_elem55);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class liststatus_args implements org.apache.thrift.TBase<liststatus_args, liststatus_args._Fields>, java.io.Serializable, Cloneable, Comparable<liststatus_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("liststatus_args");

    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new liststatus_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new liststatus_argsTupleSchemeFactory());
    }

    public String path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      PATH((short)1, "path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(liststatus_args.class, metaDataMap);
    }

    public liststatus_args() {
    }

    public liststatus_args(
      String path)
    {
      this();
      this.path = path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public liststatus_args(liststatus_args other) {
      if (other.isSetPath()) {
        this.path = other.path;
      }
    }

    public liststatus_args deepCopy() {
      return new liststatus_args(this);
    }

    @Override
    public void clear() {
      this.path = null;
    }

    public String getPath() {
      return this.path;
    }

    public liststatus_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof liststatus_args)
        return this.equals((liststatus_args)that);
      return false;
    }

    public boolean equals(liststatus_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(liststatus_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetPath()).compareTo(other.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, other.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("liststatus_args(");
      boolean first = true;

      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class liststatus_argsStandardSchemeFactory implements SchemeFactory {
      public liststatus_argsStandardScheme getScheme() {
        return new liststatus_argsStandardScheme();
      }
    }

    private static class liststatus_argsStandardScheme extends StandardScheme<liststatus_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, liststatus_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, liststatus_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class liststatus_argsTupleSchemeFactory implements SchemeFactory {
      public liststatus_argsTupleScheme getScheme() {
        return new liststatus_argsTupleScheme();
      }
    }

    private static class liststatus_argsTupleScheme extends TupleScheme<liststatus_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, liststatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetPath()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, liststatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class liststatus_result implements org.apache.thrift.TBase<liststatus_result, liststatus_result._Fields>, java.io.Serializable, Cloneable, Comparable<liststatus_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("liststatus_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField E_I_FIELD_DESC = new org.apache.thrift.protocol.TField("eI", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_F_FIELD_DESC = new org.apache.thrift.protocol.TField("eF", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new liststatus_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new liststatus_resultTupleSchemeFactory());
    }

    public List<ClientFileInfo> success; // required
    public InvalidPathException eI; // required
    public FileDoesNotExistException eF; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_I((short)1, "eI"),
      E_F((short)2, "eF");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_I
            return E_I;
          case 2: // E_F
            return E_F;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ClientFileInfo.class))));
      tmpMap.put(_Fields.E_I, new org.apache.thrift.meta_data.FieldMetaData("eI", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_F, new org.apache.thrift.meta_data.FieldMetaData("eF", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(liststatus_result.class, metaDataMap);
    }

    public liststatus_result() {
    }

    public liststatus_result(
      List<ClientFileInfo> success,
      InvalidPathException eI,
      FileDoesNotExistException eF)
    {
      this();
      this.success = success;
      this.eI = eI;
      this.eF = eF;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public liststatus_result(liststatus_result other) {
      if (other.isSetSuccess()) {
        List<ClientFileInfo> __this__success = new ArrayList<ClientFileInfo>(other.success.size());
        for (ClientFileInfo other_element : other.success) {
          __this__success.add(new ClientFileInfo(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetEI()) {
        this.eI = new InvalidPathException(other.eI);
      }
      if (other.isSetEF()) {
        this.eF = new FileDoesNotExistException(other.eF);
      }
    }

    public liststatus_result deepCopy() {
      return new liststatus_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.eI = null;
      this.eF = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ClientFileInfo> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ClientFileInfo elem) {
      if (this.success == null) {
        this.success = new ArrayList<ClientFileInfo>();
      }
      this.success.add(elem);
    }

    public List<ClientFileInfo> getSuccess() {
      return this.success;
    }

    public liststatus_result setSuccess(List<ClientFileInfo> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidPathException getEI() {
      return this.eI;
    }

    public liststatus_result setEI(InvalidPathException eI) {
      this.eI = eI;
      return this;
    }

    public void unsetEI() {
      this.eI = null;
    }

    /** Returns true if field eI is set (has been assigned a value) and false otherwise */
    public boolean isSetEI() {
      return this.eI != null;
    }

    public void setEIIsSet(boolean value) {
      if (!value) {
        this.eI = null;
      }
    }

    public FileDoesNotExistException getEF() {
      return this.eF;
    }

    public liststatus_result setEF(FileDoesNotExistException eF) {
      this.eF = eF;
      return this;
    }

    public void unsetEF() {
      this.eF = null;
    }

    /** Returns true if field eF is set (has been assigned a value) and false otherwise */
    public boolean isSetEF() {
      return this.eF != null;
    }

    public void setEFIsSet(boolean value) {
      if (!value) {
        this.eF = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ClientFileInfo>)value);
        }
        break;

      case E_I:
        if (value == null) {
          unsetEI();
        } else {
          setEI((InvalidPathException)value);
        }
        break;

      case E_F:
        if (value == null) {
          unsetEF();
        } else {
          setEF((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E_I:
        return getEI();

      case E_F:
        return getEF();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_I:
        return isSetEI();
      case E_F:
        return isSetEF();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof liststatus_result)
        return this.equals((liststatus_result)that);
      return false;
    }

    public boolean equals(liststatus_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_eI = true && this.isSetEI();
      boolean that_present_eI = true && that.isSetEI();
      if (this_present_eI || that_present_eI) {
        if (!(this_present_eI && that_present_eI))
          return false;
        if (!this.eI.equals(that.eI))
          return false;
      }

      boolean this_present_eF = true && this.isSetEF();
      boolean that_present_eF = true && that.isSetEF();
      if (this_present_eF || that_present_eF) {
        if (!(this_present_eF && that_present_eF))
          return false;
        if (!this.eF.equals(that.eF))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(liststatus_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEI()).compareTo(other.isSetEI());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEI()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eI, other.eI);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEF()).compareTo(other.isSetEF());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEF()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eF, other.eF);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("liststatus_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eI:");
      if (this.eI == null) {
        sb.append("null");
      } else {
        sb.append(this.eI);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eF:");
      if (this.eF == null) {
        sb.append("null");
      } else {
        sb.append(this.eF);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class liststatus_resultStandardSchemeFactory implements SchemeFactory {
      public liststatus_resultStandardScheme getScheme() {
        return new liststatus_resultStandardScheme();
      }
    }

    private static class liststatus_resultStandardScheme extends StandardScheme<liststatus_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, liststatus_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list56 = iprot.readListBegin();
                  struct.success = new ArrayList<ClientFileInfo>(_list56.size);
                  for (int _i57 = 0; _i57 < _list56.size; ++_i57)
                  {
                    ClientFileInfo _elem58;
                    _elem58 = new ClientFileInfo();
                    _elem58.read(iprot);
                    struct.success.add(_elem58);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_I
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eI = new InvalidPathException();
                struct.eI.read(iprot);
                struct.setEIIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_F
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eF = new FileDoesNotExistException();
                struct.eF.read(iprot);
                struct.setEFIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, liststatus_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (ClientFileInfo _iter59 : struct.success)
            {
              _iter59.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.eI != null) {
          oprot.writeFieldBegin(E_I_FIELD_DESC);
          struct.eI.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eF != null) {
          oprot.writeFieldBegin(E_F_FIELD_DESC);
          struct.eF.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class liststatus_resultTupleSchemeFactory implements SchemeFactory {
      public liststatus_resultTupleScheme getScheme() {
        return new liststatus_resultTupleScheme();
      }
    }

    private static class liststatus_resultTupleScheme extends TupleScheme<liststatus_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, liststatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEI()) {
          optionals.set(1);
        }
        if (struct.isSetEF()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (ClientFileInfo _iter60 : struct.success)
            {
              _iter60.write(oprot);
            }
          }
        }
        if (struct.isSetEI()) {
          struct.eI.write(oprot);
        }
        if (struct.isSetEF()) {
          struct.eF.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, liststatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list61 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<ClientFileInfo>(_list61.size);
            for (int _i62 = 0; _i62 < _list61.size; ++_i62)
            {
              ClientFileInfo _elem63;
              _elem63 = new ClientFileInfo();
              _elem63.read(iprot);
              struct.success.add(_elem63);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eI = new InvalidPathException();
          struct.eI.read(iprot);
          struct.setEIIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eF = new FileDoesNotExistException();
          struct.eF.read(iprot);
          struct.setEFIsSet(true);
        }
      }
    }

  }

  public static class worker_register_args implements org.apache.thrift.TBase<worker_register_args, worker_register_args._Fields>, java.io.Serializable, Cloneable, Comparable<worker_register_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_register_args");

    private static final org.apache.thrift.protocol.TField WORKER_NET_ADDRESS_FIELD_DESC = new org.apache.thrift.protocol.TField("workerNetAddress", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOTAL_BYTES_FIELD_DESC = new org.apache.thrift.protocol.TField("totalBytes", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField USED_BYTES_FIELD_DESC = new org.apache.thrift.protocol.TField("usedBytes", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField CURRENT_BLOCKS_FIELD_DESC = new org.apache.thrift.protocol.TField("currentBlocks", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_register_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_register_argsTupleSchemeFactory());
    }

    public NetAddress workerNetAddress; // required
    public long totalBytes; // required
    public long usedBytes; // required
    public Map<Long,List<Long>> currentBlocks; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      WORKER_NET_ADDRESS((short)1, "workerNetAddress"),
      TOTAL_BYTES((short)2, "totalBytes"),
      USED_BYTES((short)3, "usedBytes"),
      CURRENT_BLOCKS((short)4, "currentBlocks");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // WORKER_NET_ADDRESS
            return WORKER_NET_ADDRESS;
          case 2: // TOTAL_BYTES
            return TOTAL_BYTES;
          case 3: // USED_BYTES
            return USED_BYTES;
          case 4: // CURRENT_BLOCKS
            return CURRENT_BLOCKS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TOTALBYTES_ISSET_ID = 0;
    private static final int __USEDBYTES_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.WORKER_NET_ADDRESS, new org.apache.thrift.meta_data.FieldMetaData("workerNetAddress", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NetAddress.class)));
      tmpMap.put(_Fields.TOTAL_BYTES, new org.apache.thrift.meta_data.FieldMetaData("totalBytes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.USED_BYTES, new org.apache.thrift.meta_data.FieldMetaData("usedBytes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CURRENT_BLOCKS, new org.apache.thrift.meta_data.FieldMetaData("currentBlocks", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64), 
              new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_register_args.class, metaDataMap);
    }

    public worker_register_args() {
    }

    public worker_register_args(
      NetAddress workerNetAddress,
      long totalBytes,
      long usedBytes,
      Map<Long,List<Long>> currentBlocks)
    {
      this();
      this.workerNetAddress = workerNetAddress;
      this.totalBytes = totalBytes;
      setTotalBytesIsSet(true);
      this.usedBytes = usedBytes;
      setUsedBytesIsSet(true);
      this.currentBlocks = currentBlocks;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_register_args(worker_register_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetWorkerNetAddress()) {
        this.workerNetAddress = new NetAddress(other.workerNetAddress);
      }
      this.totalBytes = other.totalBytes;
      this.usedBytes = other.usedBytes;
      if (other.isSetCurrentBlocks()) {
        Map<Long,List<Long>> __this__currentBlocks = new HashMap<Long,List<Long>>(other.currentBlocks.size());
        for (Map.Entry<Long, List<Long>> other_element : other.currentBlocks.entrySet()) {

          Long other_element_key = other_element.getKey();
          List<Long> other_element_value = other_element.getValue();

          Long __this__currentBlocks_copy_key = other_element_key;

          List<Long> __this__currentBlocks_copy_value = new ArrayList<Long>(other_element_value);

          __this__currentBlocks.put(__this__currentBlocks_copy_key, __this__currentBlocks_copy_value);
        }
        this.currentBlocks = __this__currentBlocks;
      }
    }

    public worker_register_args deepCopy() {
      return new worker_register_args(this);
    }

    @Override
    public void clear() {
      this.workerNetAddress = null;
      setTotalBytesIsSet(false);
      this.totalBytes = 0;
      setUsedBytesIsSet(false);
      this.usedBytes = 0;
      this.currentBlocks = null;
    }

    public NetAddress getWorkerNetAddress() {
      return this.workerNetAddress;
    }

    public worker_register_args setWorkerNetAddress(NetAddress workerNetAddress) {
      this.workerNetAddress = workerNetAddress;
      return this;
    }

    public void unsetWorkerNetAddress() {
      this.workerNetAddress = null;
    }

    /** Returns true if field workerNetAddress is set (has been assigned a value) and false otherwise */
    public boolean isSetWorkerNetAddress() {
      return this.workerNetAddress != null;
    }

    public void setWorkerNetAddressIsSet(boolean value) {
      if (!value) {
        this.workerNetAddress = null;
      }
    }

    public long getTotalBytes() {
      return this.totalBytes;
    }

    public worker_register_args setTotalBytes(long totalBytes) {
      this.totalBytes = totalBytes;
      setTotalBytesIsSet(true);
      return this;
    }

    public void unsetTotalBytes() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TOTALBYTES_ISSET_ID);
    }

    /** Returns true if field totalBytes is set (has been assigned a value) and false otherwise */
    public boolean isSetTotalBytes() {
      return EncodingUtils.testBit(__isset_bitfield, __TOTALBYTES_ISSET_ID);
    }

    public void setTotalBytesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TOTALBYTES_ISSET_ID, value);
    }

    public long getUsedBytes() {
      return this.usedBytes;
    }

    public worker_register_args setUsedBytes(long usedBytes) {
      this.usedBytes = usedBytes;
      setUsedBytesIsSet(true);
      return this;
    }

    public void unsetUsedBytes() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USEDBYTES_ISSET_ID);
    }

    /** Returns true if field usedBytes is set (has been assigned a value) and false otherwise */
    public boolean isSetUsedBytes() {
      return EncodingUtils.testBit(__isset_bitfield, __USEDBYTES_ISSET_ID);
    }

    public void setUsedBytesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USEDBYTES_ISSET_ID, value);
    }

    public int getCurrentBlocksSize() {
      return (this.currentBlocks == null) ? 0 : this.currentBlocks.size();
    }

    public void putToCurrentBlocks(long key, List<Long> val) {
      if (this.currentBlocks == null) {
        this.currentBlocks = new HashMap<Long,List<Long>>();
      }
      this.currentBlocks.put(key, val);
    }

    public Map<Long,List<Long>> getCurrentBlocks() {
      return this.currentBlocks;
    }

    public worker_register_args setCurrentBlocks(Map<Long,List<Long>> currentBlocks) {
      this.currentBlocks = currentBlocks;
      return this;
    }

    public void unsetCurrentBlocks() {
      this.currentBlocks = null;
    }

    /** Returns true if field currentBlocks is set (has been assigned a value) and false otherwise */
    public boolean isSetCurrentBlocks() {
      return this.currentBlocks != null;
    }

    public void setCurrentBlocksIsSet(boolean value) {
      if (!value) {
        this.currentBlocks = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case WORKER_NET_ADDRESS:
        if (value == null) {
          unsetWorkerNetAddress();
        } else {
          setWorkerNetAddress((NetAddress)value);
        }
        break;

      case TOTAL_BYTES:
        if (value == null) {
          unsetTotalBytes();
        } else {
          setTotalBytes((Long)value);
        }
        break;

      case USED_BYTES:
        if (value == null) {
          unsetUsedBytes();
        } else {
          setUsedBytes((Long)value);
        }
        break;

      case CURRENT_BLOCKS:
        if (value == null) {
          unsetCurrentBlocks();
        } else {
          setCurrentBlocks((Map<Long,List<Long>>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case WORKER_NET_ADDRESS:
        return getWorkerNetAddress();

      case TOTAL_BYTES:
        return Long.valueOf(getTotalBytes());

      case USED_BYTES:
        return Long.valueOf(getUsedBytes());

      case CURRENT_BLOCKS:
        return getCurrentBlocks();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case WORKER_NET_ADDRESS:
        return isSetWorkerNetAddress();
      case TOTAL_BYTES:
        return isSetTotalBytes();
      case USED_BYTES:
        return isSetUsedBytes();
      case CURRENT_BLOCKS:
        return isSetCurrentBlocks();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_register_args)
        return this.equals((worker_register_args)that);
      return false;
    }

    public boolean equals(worker_register_args that) {
      if (that == null)
        return false;

      boolean this_present_workerNetAddress = true && this.isSetWorkerNetAddress();
      boolean that_present_workerNetAddress = true && that.isSetWorkerNetAddress();
      if (this_present_workerNetAddress || that_present_workerNetAddress) {
        if (!(this_present_workerNetAddress && that_present_workerNetAddress))
          return false;
        if (!this.workerNetAddress.equals(that.workerNetAddress))
          return false;
      }

      boolean this_present_totalBytes = true;
      boolean that_present_totalBytes = true;
      if (this_present_totalBytes || that_present_totalBytes) {
        if (!(this_present_totalBytes && that_present_totalBytes))
          return false;
        if (this.totalBytes != that.totalBytes)
          return false;
      }

      boolean this_present_usedBytes = true;
      boolean that_present_usedBytes = true;
      if (this_present_usedBytes || that_present_usedBytes) {
        if (!(this_present_usedBytes && that_present_usedBytes))
          return false;
        if (this.usedBytes != that.usedBytes)
          return false;
      }

      boolean this_present_currentBlocks = true && this.isSetCurrentBlocks();
      boolean that_present_currentBlocks = true && that.isSetCurrentBlocks();
      if (this_present_currentBlocks || that_present_currentBlocks) {
        if (!(this_present_currentBlocks && that_present_currentBlocks))
          return false;
        if (!this.currentBlocks.equals(that.currentBlocks))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_register_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetWorkerNetAddress()).compareTo(other.isSetWorkerNetAddress());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWorkerNetAddress()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workerNetAddress, other.workerNetAddress);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTotalBytes()).compareTo(other.isSetTotalBytes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTotalBytes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.totalBytes, other.totalBytes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUsedBytes()).compareTo(other.isSetUsedBytes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUsedBytes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.usedBytes, other.usedBytes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCurrentBlocks()).compareTo(other.isSetCurrentBlocks());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCurrentBlocks()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.currentBlocks, other.currentBlocks);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_register_args(");
      boolean first = true;

      sb.append("workerNetAddress:");
      if (this.workerNetAddress == null) {
        sb.append("null");
      } else {
        sb.append(this.workerNetAddress);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("totalBytes:");
      sb.append(this.totalBytes);
      first = false;
      if (!first) sb.append(", ");
      sb.append("usedBytes:");
      sb.append(this.usedBytes);
      first = false;
      if (!first) sb.append(", ");
      sb.append("currentBlocks:");
      if (this.currentBlocks == null) {
        sb.append("null");
      } else {
        sb.append(this.currentBlocks);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (workerNetAddress != null) {
        workerNetAddress.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_register_argsStandardSchemeFactory implements SchemeFactory {
      public worker_register_argsStandardScheme getScheme() {
        return new worker_register_argsStandardScheme();
      }
    }

    private static class worker_register_argsStandardScheme extends StandardScheme<worker_register_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_register_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // WORKER_NET_ADDRESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.workerNetAddress = new NetAddress();
                struct.workerNetAddress.read(iprot);
                struct.setWorkerNetAddressIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TOTAL_BYTES
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.totalBytes = iprot.readI64();
                struct.setTotalBytesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // USED_BYTES
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.usedBytes = iprot.readI64();
                struct.setUsedBytesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // CURRENT_BLOCKS
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map64 = iprot.readMapBegin();
                  struct.currentBlocks = new HashMap<Long,List<Long>>(2*_map64.size);
                  for (int _i65 = 0; _i65 < _map64.size; ++_i65)
                  {
                    long _key66;
                    List<Long> _val67;
                    _key66 = iprot.readI64();
                    {
                      org.apache.thrift.protocol.TList _list68 = iprot.readListBegin();
                      _val67 = new ArrayList<Long>(_list68.size);
                      for (int _i69 = 0; _i69 < _list68.size; ++_i69)
                      {
                        long _elem70;
                        _elem70 = iprot.readI64();
                        _val67.add(_elem70);
                      }
                      iprot.readListEnd();
                    }
                    struct.currentBlocks.put(_key66, _val67);
                  }
                  iprot.readMapEnd();
                }
                struct.setCurrentBlocksIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_register_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.workerNetAddress != null) {
          oprot.writeFieldBegin(WORKER_NET_ADDRESS_FIELD_DESC);
          struct.workerNetAddress.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TOTAL_BYTES_FIELD_DESC);
        oprot.writeI64(struct.totalBytes);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(USED_BYTES_FIELD_DESC);
        oprot.writeI64(struct.usedBytes);
        oprot.writeFieldEnd();
        if (struct.currentBlocks != null) {
          oprot.writeFieldBegin(CURRENT_BLOCKS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.I64, org.apache.thrift.protocol.TType.LIST, struct.currentBlocks.size()));
            for (Map.Entry<Long, List<Long>> _iter71 : struct.currentBlocks.entrySet())
            {
              oprot.writeI64(_iter71.getKey());
              {
                oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, _iter71.getValue().size()));
                for (long _iter72 : _iter71.getValue())
                {
                  oprot.writeI64(_iter72);
                }
                oprot.writeListEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_register_argsTupleSchemeFactory implements SchemeFactory {
      public worker_register_argsTupleScheme getScheme() {
        return new worker_register_argsTupleScheme();
      }
    }

    private static class worker_register_argsTupleScheme extends TupleScheme<worker_register_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_register_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetWorkerNetAddress()) {
          optionals.set(0);
        }
        if (struct.isSetTotalBytes()) {
          optionals.set(1);
        }
        if (struct.isSetUsedBytes()) {
          optionals.set(2);
        }
        if (struct.isSetCurrentBlocks()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetWorkerNetAddress()) {
          struct.workerNetAddress.write(oprot);
        }
        if (struct.isSetTotalBytes()) {
          oprot.writeI64(struct.totalBytes);
        }
        if (struct.isSetUsedBytes()) {
          oprot.writeI64(struct.usedBytes);
        }
        if (struct.isSetCurrentBlocks()) {
          {
            oprot.writeI32(struct.currentBlocks.size());
            for (Map.Entry<Long, List<Long>> _iter73 : struct.currentBlocks.entrySet())
            {
              oprot.writeI64(_iter73.getKey());
              {
                oprot.writeI32(_iter73.getValue().size());
                for (long _iter74 : _iter73.getValue())
                {
                  oprot.writeI64(_iter74);
                }
              }
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_register_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.workerNetAddress = new NetAddress();
          struct.workerNetAddress.read(iprot);
          struct.setWorkerNetAddressIsSet(true);
        }
        if (incoming.get(1)) {
          struct.totalBytes = iprot.readI64();
          struct.setTotalBytesIsSet(true);
        }
        if (incoming.get(2)) {
          struct.usedBytes = iprot.readI64();
          struct.setUsedBytesIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map75 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.I64, org.apache.thrift.protocol.TType.LIST, iprot.readI32());
            struct.currentBlocks = new HashMap<Long,List<Long>>(2*_map75.size);
            for (int _i76 = 0; _i76 < _map75.size; ++_i76)
            {
              long _key77;
              List<Long> _val78;
              _key77 = iprot.readI64();
              {
                org.apache.thrift.protocol.TList _list79 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, iprot.readI32());
                _val78 = new ArrayList<Long>(_list79.size);
                for (int _i80 = 0; _i80 < _list79.size; ++_i80)
                {
                  long _elem81;
                  _elem81 = iprot.readI64();
                  _val78.add(_elem81);
                }
              }
              struct.currentBlocks.put(_key77, _val78);
            }
          }
          struct.setCurrentBlocksIsSet(true);
        }
      }
    }

  }

  public static class worker_register_result implements org.apache.thrift.TBase<worker_register_result, worker_register_result._Fields>, java.io.Serializable, Cloneable, Comparable<worker_register_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_register_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_register_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_register_resultTupleSchemeFactory());
    }

    public long success; // required
    public BlockInfoException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_register_result.class, metaDataMap);
    }

    public worker_register_result() {
    }

    public worker_register_result(
      long success,
      BlockInfoException e)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_register_result(worker_register_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetE()) {
        this.e = new BlockInfoException(other.e);
      }
    }

    public worker_register_result deepCopy() {
      return new worker_register_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.e = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public worker_register_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public BlockInfoException getE() {
      return this.e;
    }

    public worker_register_result setE(BlockInfoException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Long.valueOf(getSuccess());

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_register_result)
        return this.equals((worker_register_result)that);
      return false;
    }

    public boolean equals(worker_register_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_register_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_register_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_register_resultStandardSchemeFactory implements SchemeFactory {
      public worker_register_resultStandardScheme getScheme() {
        return new worker_register_resultStandardScheme();
      }
    }

    private static class worker_register_resultStandardScheme extends StandardScheme<worker_register_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_register_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new BlockInfoException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_register_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_register_resultTupleSchemeFactory implements SchemeFactory {
      public worker_register_resultTupleScheme getScheme() {
        return new worker_register_resultTupleScheme();
      }
    }

    private static class worker_register_resultTupleScheme extends TupleScheme<worker_register_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_register_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_register_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new BlockInfoException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class worker_heartbeat_args implements org.apache.thrift.TBase<worker_heartbeat_args, worker_heartbeat_args._Fields>, java.io.Serializable, Cloneable, Comparable<worker_heartbeat_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_heartbeat_args");

    private static final org.apache.thrift.protocol.TField WORKER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("workerId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField USED_BYTES_FIELD_DESC = new org.apache.thrift.protocol.TField("usedBytes", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField REMOVED_BLOCK_IDS_FIELD_DESC = new org.apache.thrift.protocol.TField("removedBlockIds", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField ADDED_BLOCK_IDS_FIELD_DESC = new org.apache.thrift.protocol.TField("addedBlockIds", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_heartbeat_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_heartbeat_argsTupleSchemeFactory());
    }

    public long workerId; // required
    public long usedBytes; // required
    public List<Long> removedBlockIds; // required
    public Map<Long,List<Long>> addedBlockIds; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      WORKER_ID((short)1, "workerId"),
      USED_BYTES((short)2, "usedBytes"),
      REMOVED_BLOCK_IDS((short)3, "removedBlockIds"),
      ADDED_BLOCK_IDS((short)4, "addedBlockIds");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // WORKER_ID
            return WORKER_ID;
          case 2: // USED_BYTES
            return USED_BYTES;
          case 3: // REMOVED_BLOCK_IDS
            return REMOVED_BLOCK_IDS;
          case 4: // ADDED_BLOCK_IDS
            return ADDED_BLOCK_IDS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __WORKERID_ISSET_ID = 0;
    private static final int __USEDBYTES_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.WORKER_ID, new org.apache.thrift.meta_data.FieldMetaData("workerId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.USED_BYTES, new org.apache.thrift.meta_data.FieldMetaData("usedBytes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.REMOVED_BLOCK_IDS, new org.apache.thrift.meta_data.FieldMetaData("removedBlockIds", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64))));
      tmpMap.put(_Fields.ADDED_BLOCK_IDS, new org.apache.thrift.meta_data.FieldMetaData("addedBlockIds", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64), 
              new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_heartbeat_args.class, metaDataMap);
    }

    public worker_heartbeat_args() {
    }

    public worker_heartbeat_args(
      long workerId,
      long usedBytes,
      List<Long> removedBlockIds,
      Map<Long,List<Long>> addedBlockIds)
    {
      this();
      this.workerId = workerId;
      setWorkerIdIsSet(true);
      this.usedBytes = usedBytes;
      setUsedBytesIsSet(true);
      this.removedBlockIds = removedBlockIds;
      this.addedBlockIds = addedBlockIds;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_heartbeat_args(worker_heartbeat_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.workerId = other.workerId;
      this.usedBytes = other.usedBytes;
      if (other.isSetRemovedBlockIds()) {
        List<Long> __this__removedBlockIds = new ArrayList<Long>(other.removedBlockIds);
        this.removedBlockIds = __this__removedBlockIds;
      }
      if (other.isSetAddedBlockIds()) {
        Map<Long,List<Long>> __this__addedBlockIds = new HashMap<Long,List<Long>>(other.addedBlockIds.size());
        for (Map.Entry<Long, List<Long>> other_element : other.addedBlockIds.entrySet()) {

          Long other_element_key = other_element.getKey();
          List<Long> other_element_value = other_element.getValue();

          Long __this__addedBlockIds_copy_key = other_element_key;

          List<Long> __this__addedBlockIds_copy_value = new ArrayList<Long>(other_element_value);

          __this__addedBlockIds.put(__this__addedBlockIds_copy_key, __this__addedBlockIds_copy_value);
        }
        this.addedBlockIds = __this__addedBlockIds;
      }
    }

    public worker_heartbeat_args deepCopy() {
      return new worker_heartbeat_args(this);
    }

    @Override
    public void clear() {
      setWorkerIdIsSet(false);
      this.workerId = 0;
      setUsedBytesIsSet(false);
      this.usedBytes = 0;
      this.removedBlockIds = null;
      this.addedBlockIds = null;
    }

    public long getWorkerId() {
      return this.workerId;
    }

    public worker_heartbeat_args setWorkerId(long workerId) {
      this.workerId = workerId;
      setWorkerIdIsSet(true);
      return this;
    }

    public void unsetWorkerId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WORKERID_ISSET_ID);
    }

    /** Returns true if field workerId is set (has been assigned a value) and false otherwise */
    public boolean isSetWorkerId() {
      return EncodingUtils.testBit(__isset_bitfield, __WORKERID_ISSET_ID);
    }

    public void setWorkerIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WORKERID_ISSET_ID, value);
    }

    public long getUsedBytes() {
      return this.usedBytes;
    }

    public worker_heartbeat_args setUsedBytes(long usedBytes) {
      this.usedBytes = usedBytes;
      setUsedBytesIsSet(true);
      return this;
    }

    public void unsetUsedBytes() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USEDBYTES_ISSET_ID);
    }

    /** Returns true if field usedBytes is set (has been assigned a value) and false otherwise */
    public boolean isSetUsedBytes() {
      return EncodingUtils.testBit(__isset_bitfield, __USEDBYTES_ISSET_ID);
    }

    public void setUsedBytesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USEDBYTES_ISSET_ID, value);
    }

    public int getRemovedBlockIdsSize() {
      return (this.removedBlockIds == null) ? 0 : this.removedBlockIds.size();
    }

    public java.util.Iterator<Long> getRemovedBlockIdsIterator() {
      return (this.removedBlockIds == null) ? null : this.removedBlockIds.iterator();
    }

    public void addToRemovedBlockIds(long elem) {
      if (this.removedBlockIds == null) {
        this.removedBlockIds = new ArrayList<Long>();
      }
      this.removedBlockIds.add(elem);
    }

    public List<Long> getRemovedBlockIds() {
      return this.removedBlockIds;
    }

    public worker_heartbeat_args setRemovedBlockIds(List<Long> removedBlockIds) {
      this.removedBlockIds = removedBlockIds;
      return this;
    }

    public void unsetRemovedBlockIds() {
      this.removedBlockIds = null;
    }

    /** Returns true if field removedBlockIds is set (has been assigned a value) and false otherwise */
    public boolean isSetRemovedBlockIds() {
      return this.removedBlockIds != null;
    }

    public void setRemovedBlockIdsIsSet(boolean value) {
      if (!value) {
        this.removedBlockIds = null;
      }
    }

    public int getAddedBlockIdsSize() {
      return (this.addedBlockIds == null) ? 0 : this.addedBlockIds.size();
    }

    public void putToAddedBlockIds(long key, List<Long> val) {
      if (this.addedBlockIds == null) {
        this.addedBlockIds = new HashMap<Long,List<Long>>();
      }
      this.addedBlockIds.put(key, val);
    }

    public Map<Long,List<Long>> getAddedBlockIds() {
      return this.addedBlockIds;
    }

    public worker_heartbeat_args setAddedBlockIds(Map<Long,List<Long>> addedBlockIds) {
      this.addedBlockIds = addedBlockIds;
      return this;
    }

    public void unsetAddedBlockIds() {
      this.addedBlockIds = null;
    }

    /** Returns true if field addedBlockIds is set (has been assigned a value) and false otherwise */
    public boolean isSetAddedBlockIds() {
      return this.addedBlockIds != null;
    }

    public void setAddedBlockIdsIsSet(boolean value) {
      if (!value) {
        this.addedBlockIds = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case WORKER_ID:
        if (value == null) {
          unsetWorkerId();
        } else {
          setWorkerId((Long)value);
        }
        break;

      case USED_BYTES:
        if (value == null) {
          unsetUsedBytes();
        } else {
          setUsedBytes((Long)value);
        }
        break;

      case REMOVED_BLOCK_IDS:
        if (value == null) {
          unsetRemovedBlockIds();
        } else {
          setRemovedBlockIds((List<Long>)value);
        }
        break;

      case ADDED_BLOCK_IDS:
        if (value == null) {
          unsetAddedBlockIds();
        } else {
          setAddedBlockIds((Map<Long,List<Long>>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case WORKER_ID:
        return Long.valueOf(getWorkerId());

      case USED_BYTES:
        return Long.valueOf(getUsedBytes());

      case REMOVED_BLOCK_IDS:
        return getRemovedBlockIds();

      case ADDED_BLOCK_IDS:
        return getAddedBlockIds();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case WORKER_ID:
        return isSetWorkerId();
      case USED_BYTES:
        return isSetUsedBytes();
      case REMOVED_BLOCK_IDS:
        return isSetRemovedBlockIds();
      case ADDED_BLOCK_IDS:
        return isSetAddedBlockIds();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_heartbeat_args)
        return this.equals((worker_heartbeat_args)that);
      return false;
    }

    public boolean equals(worker_heartbeat_args that) {
      if (that == null)
        return false;

      boolean this_present_workerId = true;
      boolean that_present_workerId = true;
      if (this_present_workerId || that_present_workerId) {
        if (!(this_present_workerId && that_present_workerId))
          return false;
        if (this.workerId != that.workerId)
          return false;
      }

      boolean this_present_usedBytes = true;
      boolean that_present_usedBytes = true;
      if (this_present_usedBytes || that_present_usedBytes) {
        if (!(this_present_usedBytes && that_present_usedBytes))
          return false;
        if (this.usedBytes != that.usedBytes)
          return false;
      }

      boolean this_present_removedBlockIds = true && this.isSetRemovedBlockIds();
      boolean that_present_removedBlockIds = true && that.isSetRemovedBlockIds();
      if (this_present_removedBlockIds || that_present_removedBlockIds) {
        if (!(this_present_removedBlockIds && that_present_removedBlockIds))
          return false;
        if (!this.removedBlockIds.equals(that.removedBlockIds))
          return false;
      }

      boolean this_present_addedBlockIds = true && this.isSetAddedBlockIds();
      boolean that_present_addedBlockIds = true && that.isSetAddedBlockIds();
      if (this_present_addedBlockIds || that_present_addedBlockIds) {
        if (!(this_present_addedBlockIds && that_present_addedBlockIds))
          return false;
        if (!this.addedBlockIds.equals(that.addedBlockIds))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_heartbeat_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetWorkerId()).compareTo(other.isSetWorkerId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWorkerId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workerId, other.workerId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUsedBytes()).compareTo(other.isSetUsedBytes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUsedBytes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.usedBytes, other.usedBytes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRemovedBlockIds()).compareTo(other.isSetRemovedBlockIds());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRemovedBlockIds()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.removedBlockIds, other.removedBlockIds);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAddedBlockIds()).compareTo(other.isSetAddedBlockIds());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAddedBlockIds()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.addedBlockIds, other.addedBlockIds);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_heartbeat_args(");
      boolean first = true;

      sb.append("workerId:");
      sb.append(this.workerId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("usedBytes:");
      sb.append(this.usedBytes);
      first = false;
      if (!first) sb.append(", ");
      sb.append("removedBlockIds:");
      if (this.removedBlockIds == null) {
        sb.append("null");
      } else {
        sb.append(this.removedBlockIds);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("addedBlockIds:");
      if (this.addedBlockIds == null) {
        sb.append("null");
      } else {
        sb.append(this.addedBlockIds);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_heartbeat_argsStandardSchemeFactory implements SchemeFactory {
      public worker_heartbeat_argsStandardScheme getScheme() {
        return new worker_heartbeat_argsStandardScheme();
      }
    }

    private static class worker_heartbeat_argsStandardScheme extends StandardScheme<worker_heartbeat_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_heartbeat_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // WORKER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.workerId = iprot.readI64();
                struct.setWorkerIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USED_BYTES
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.usedBytes = iprot.readI64();
                struct.setUsedBytesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // REMOVED_BLOCK_IDS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list82 = iprot.readListBegin();
                  struct.removedBlockIds = new ArrayList<Long>(_list82.size);
                  for (int _i83 = 0; _i83 < _list82.size; ++_i83)
                  {
                    long _elem84;
                    _elem84 = iprot.readI64();
                    struct.removedBlockIds.add(_elem84);
                  }
                  iprot.readListEnd();
                }
                struct.setRemovedBlockIdsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ADDED_BLOCK_IDS
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map85 = iprot.readMapBegin();
                  struct.addedBlockIds = new HashMap<Long,List<Long>>(2*_map85.size);
                  for (int _i86 = 0; _i86 < _map85.size; ++_i86)
                  {
                    long _key87;
                    List<Long> _val88;
                    _key87 = iprot.readI64();
                    {
                      org.apache.thrift.protocol.TList _list89 = iprot.readListBegin();
                      _val88 = new ArrayList<Long>(_list89.size);
                      for (int _i90 = 0; _i90 < _list89.size; ++_i90)
                      {
                        long _elem91;
                        _elem91 = iprot.readI64();
                        _val88.add(_elem91);
                      }
                      iprot.readListEnd();
                    }
                    struct.addedBlockIds.put(_key87, _val88);
                  }
                  iprot.readMapEnd();
                }
                struct.setAddedBlockIdsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_heartbeat_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(WORKER_ID_FIELD_DESC);
        oprot.writeI64(struct.workerId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(USED_BYTES_FIELD_DESC);
        oprot.writeI64(struct.usedBytes);
        oprot.writeFieldEnd();
        if (struct.removedBlockIds != null) {
          oprot.writeFieldBegin(REMOVED_BLOCK_IDS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, struct.removedBlockIds.size()));
            for (long _iter92 : struct.removedBlockIds)
            {
              oprot.writeI64(_iter92);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.addedBlockIds != null) {
          oprot.writeFieldBegin(ADDED_BLOCK_IDS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.I64, org.apache.thrift.protocol.TType.LIST, struct.addedBlockIds.size()));
            for (Map.Entry<Long, List<Long>> _iter93 : struct.addedBlockIds.entrySet())
            {
              oprot.writeI64(_iter93.getKey());
              {
                oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, _iter93.getValue().size()));
                for (long _iter94 : _iter93.getValue())
                {
                  oprot.writeI64(_iter94);
                }
                oprot.writeListEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_heartbeat_argsTupleSchemeFactory implements SchemeFactory {
      public worker_heartbeat_argsTupleScheme getScheme() {
        return new worker_heartbeat_argsTupleScheme();
      }
    }

    private static class worker_heartbeat_argsTupleScheme extends TupleScheme<worker_heartbeat_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_heartbeat_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetWorkerId()) {
          optionals.set(0);
        }
        if (struct.isSetUsedBytes()) {
          optionals.set(1);
        }
        if (struct.isSetRemovedBlockIds()) {
          optionals.set(2);
        }
        if (struct.isSetAddedBlockIds()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetWorkerId()) {
          oprot.writeI64(struct.workerId);
        }
        if (struct.isSetUsedBytes()) {
          oprot.writeI64(struct.usedBytes);
        }
        if (struct.isSetRemovedBlockIds()) {
          {
            oprot.writeI32(struct.removedBlockIds.size());
            for (long _iter95 : struct.removedBlockIds)
            {
              oprot.writeI64(_iter95);
            }
          }
        }
        if (struct.isSetAddedBlockIds()) {
          {
            oprot.writeI32(struct.addedBlockIds.size());
            for (Map.Entry<Long, List<Long>> _iter96 : struct.addedBlockIds.entrySet())
            {
              oprot.writeI64(_iter96.getKey());
              {
                oprot.writeI32(_iter96.getValue().size());
                for (long _iter97 : _iter96.getValue())
                {
                  oprot.writeI64(_iter97);
                }
              }
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_heartbeat_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.workerId = iprot.readI64();
          struct.setWorkerIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.usedBytes = iprot.readI64();
          struct.setUsedBytesIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list98 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, iprot.readI32());
            struct.removedBlockIds = new ArrayList<Long>(_list98.size);
            for (int _i99 = 0; _i99 < _list98.size; ++_i99)
            {
              long _elem100;
              _elem100 = iprot.readI64();
              struct.removedBlockIds.add(_elem100);
            }
          }
          struct.setRemovedBlockIdsIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map101 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.I64, org.apache.thrift.protocol.TType.LIST, iprot.readI32());
            struct.addedBlockIds = new HashMap<Long,List<Long>>(2*_map101.size);
            for (int _i102 = 0; _i102 < _map101.size; ++_i102)
            {
              long _key103;
              List<Long> _val104;
              _key103 = iprot.readI64();
              {
                org.apache.thrift.protocol.TList _list105 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I64, iprot.readI32());
                _val104 = new ArrayList<Long>(_list105.size);
                for (int _i106 = 0; _i106 < _list105.size; ++_i106)
                {
                  long _elem107;
                  _elem107 = iprot.readI64();
                  _val104.add(_elem107);
                }
              }
              struct.addedBlockIds.put(_key103, _val104);
            }
          }
          struct.setAddedBlockIdsIsSet(true);
        }
      }
    }

  }

  public static class worker_heartbeat_result implements org.apache.thrift.TBase<worker_heartbeat_result, worker_heartbeat_result._Fields>, java.io.Serializable, Cloneable, Comparable<worker_heartbeat_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_heartbeat_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_heartbeat_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_heartbeat_resultTupleSchemeFactory());
    }

    public Command success; // required
    public BlockInfoException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Command.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_heartbeat_result.class, metaDataMap);
    }

    public worker_heartbeat_result() {
    }

    public worker_heartbeat_result(
      Command success,
      BlockInfoException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_heartbeat_result(worker_heartbeat_result other) {
      if (other.isSetSuccess()) {
        this.success = new Command(other.success);
      }
      if (other.isSetE()) {
        this.e = new BlockInfoException(other.e);
      }
    }

    public worker_heartbeat_result deepCopy() {
      return new worker_heartbeat_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public Command getSuccess() {
      return this.success;
    }

    public worker_heartbeat_result setSuccess(Command success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public BlockInfoException getE() {
      return this.e;
    }

    public worker_heartbeat_result setE(BlockInfoException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Command)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_heartbeat_result)
        return this.equals((worker_heartbeat_result)that);
      return false;
    }

    public boolean equals(worker_heartbeat_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_heartbeat_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_heartbeat_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_heartbeat_resultStandardSchemeFactory implements SchemeFactory {
      public worker_heartbeat_resultStandardScheme getScheme() {
        return new worker_heartbeat_resultStandardScheme();
      }
    }

    private static class worker_heartbeat_resultStandardScheme extends StandardScheme<worker_heartbeat_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_heartbeat_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new Command();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new BlockInfoException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_heartbeat_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_heartbeat_resultTupleSchemeFactory implements SchemeFactory {
      public worker_heartbeat_resultTupleScheme getScheme() {
        return new worker_heartbeat_resultTupleScheme();
      }
    }

    private static class worker_heartbeat_resultTupleScheme extends TupleScheme<worker_heartbeat_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_heartbeat_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_heartbeat_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new Command();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new BlockInfoException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class worker_cacheBlock_args implements org.apache.thrift.TBase<worker_cacheBlock_args, worker_cacheBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<worker_cacheBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_cacheBlock_args");

    private static final org.apache.thrift.protocol.TField WORKER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("workerId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField WORKER_USED_BYTES_FIELD_DESC = new org.apache.thrift.protocol.TField("workerUsedBytes", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField STORAGE_DIR_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("storageDirId", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField LENGTH_FIELD_DESC = new org.apache.thrift.protocol.TField("length", org.apache.thrift.protocol.TType.I64, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_cacheBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_cacheBlock_argsTupleSchemeFactory());
    }

    public long workerId; // required
    public long workerUsedBytes; // required
    public long storageDirId; // required
    public long blockId; // required
    public long length; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      WORKER_ID((short)1, "workerId"),
      WORKER_USED_BYTES((short)2, "workerUsedBytes"),
      STORAGE_DIR_ID((short)3, "storageDirId"),
      BLOCK_ID((short)4, "blockId"),
      LENGTH((short)5, "length");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // WORKER_ID
            return WORKER_ID;
          case 2: // WORKER_USED_BYTES
            return WORKER_USED_BYTES;
          case 3: // STORAGE_DIR_ID
            return STORAGE_DIR_ID;
          case 4: // BLOCK_ID
            return BLOCK_ID;
          case 5: // LENGTH
            return LENGTH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __WORKERID_ISSET_ID = 0;
    private static final int __WORKERUSEDBYTES_ISSET_ID = 1;
    private static final int __STORAGEDIRID_ISSET_ID = 2;
    private static final int __BLOCKID_ISSET_ID = 3;
    private static final int __LENGTH_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.WORKER_ID, new org.apache.thrift.meta_data.FieldMetaData("workerId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.WORKER_USED_BYTES, new org.apache.thrift.meta_data.FieldMetaData("workerUsedBytes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.STORAGE_DIR_ID, new org.apache.thrift.meta_data.FieldMetaData("storageDirId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.LENGTH, new org.apache.thrift.meta_data.FieldMetaData("length", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_cacheBlock_args.class, metaDataMap);
    }

    public worker_cacheBlock_args() {
    }

    public worker_cacheBlock_args(
      long workerId,
      long workerUsedBytes,
      long storageDirId,
      long blockId,
      long length)
    {
      this();
      this.workerId = workerId;
      setWorkerIdIsSet(true);
      this.workerUsedBytes = workerUsedBytes;
      setWorkerUsedBytesIsSet(true);
      this.storageDirId = storageDirId;
      setStorageDirIdIsSet(true);
      this.blockId = blockId;
      setBlockIdIsSet(true);
      this.length = length;
      setLengthIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_cacheBlock_args(worker_cacheBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.workerId = other.workerId;
      this.workerUsedBytes = other.workerUsedBytes;
      this.storageDirId = other.storageDirId;
      this.blockId = other.blockId;
      this.length = other.length;
    }

    public worker_cacheBlock_args deepCopy() {
      return new worker_cacheBlock_args(this);
    }

    @Override
    public void clear() {
      setWorkerIdIsSet(false);
      this.workerId = 0;
      setWorkerUsedBytesIsSet(false);
      this.workerUsedBytes = 0;
      setStorageDirIdIsSet(false);
      this.storageDirId = 0;
      setBlockIdIsSet(false);
      this.blockId = 0;
      setLengthIsSet(false);
      this.length = 0;
    }

    public long getWorkerId() {
      return this.workerId;
    }

    public worker_cacheBlock_args setWorkerId(long workerId) {
      this.workerId = workerId;
      setWorkerIdIsSet(true);
      return this;
    }

    public void unsetWorkerId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WORKERID_ISSET_ID);
    }

    /** Returns true if field workerId is set (has been assigned a value) and false otherwise */
    public boolean isSetWorkerId() {
      return EncodingUtils.testBit(__isset_bitfield, __WORKERID_ISSET_ID);
    }

    public void setWorkerIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WORKERID_ISSET_ID, value);
    }

    public long getWorkerUsedBytes() {
      return this.workerUsedBytes;
    }

    public worker_cacheBlock_args setWorkerUsedBytes(long workerUsedBytes) {
      this.workerUsedBytes = workerUsedBytes;
      setWorkerUsedBytesIsSet(true);
      return this;
    }

    public void unsetWorkerUsedBytes() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WORKERUSEDBYTES_ISSET_ID);
    }

    /** Returns true if field workerUsedBytes is set (has been assigned a value) and false otherwise */
    public boolean isSetWorkerUsedBytes() {
      return EncodingUtils.testBit(__isset_bitfield, __WORKERUSEDBYTES_ISSET_ID);
    }

    public void setWorkerUsedBytesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WORKERUSEDBYTES_ISSET_ID, value);
    }

    public long getStorageDirId() {
      return this.storageDirId;
    }

    public worker_cacheBlock_args setStorageDirId(long storageDirId) {
      this.storageDirId = storageDirId;
      setStorageDirIdIsSet(true);
      return this;
    }

    public void unsetStorageDirId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __STORAGEDIRID_ISSET_ID);
    }

    /** Returns true if field storageDirId is set (has been assigned a value) and false otherwise */
    public boolean isSetStorageDirId() {
      return EncodingUtils.testBit(__isset_bitfield, __STORAGEDIRID_ISSET_ID);
    }

    public void setStorageDirIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __STORAGEDIRID_ISSET_ID, value);
    }

    public long getBlockId() {
      return this.blockId;
    }

    public worker_cacheBlock_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public long getLength() {
      return this.length;
    }

    public worker_cacheBlock_args setLength(long length) {
      this.length = length;
      setLengthIsSet(true);
      return this;
    }

    public void unsetLength() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LENGTH_ISSET_ID);
    }

    /** Returns true if field length is set (has been assigned a value) and false otherwise */
    public boolean isSetLength() {
      return EncodingUtils.testBit(__isset_bitfield, __LENGTH_ISSET_ID);
    }

    public void setLengthIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LENGTH_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case WORKER_ID:
        if (value == null) {
          unsetWorkerId();
        } else {
          setWorkerId((Long)value);
        }
        break;

      case WORKER_USED_BYTES:
        if (value == null) {
          unsetWorkerUsedBytes();
        } else {
          setWorkerUsedBytes((Long)value);
        }
        break;

      case STORAGE_DIR_ID:
        if (value == null) {
          unsetStorageDirId();
        } else {
          setStorageDirId((Long)value);
        }
        break;

      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      case LENGTH:
        if (value == null) {
          unsetLength();
        } else {
          setLength((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case WORKER_ID:
        return Long.valueOf(getWorkerId());

      case WORKER_USED_BYTES:
        return Long.valueOf(getWorkerUsedBytes());

      case STORAGE_DIR_ID:
        return Long.valueOf(getStorageDirId());

      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      case LENGTH:
        return Long.valueOf(getLength());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case WORKER_ID:
        return isSetWorkerId();
      case WORKER_USED_BYTES:
        return isSetWorkerUsedBytes();
      case STORAGE_DIR_ID:
        return isSetStorageDirId();
      case BLOCK_ID:
        return isSetBlockId();
      case LENGTH:
        return isSetLength();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_cacheBlock_args)
        return this.equals((worker_cacheBlock_args)that);
      return false;
    }

    public boolean equals(worker_cacheBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_workerId = true;
      boolean that_present_workerId = true;
      if (this_present_workerId || that_present_workerId) {
        if (!(this_present_workerId && that_present_workerId))
          return false;
        if (this.workerId != that.workerId)
          return false;
      }

      boolean this_present_workerUsedBytes = true;
      boolean that_present_workerUsedBytes = true;
      if (this_present_workerUsedBytes || that_present_workerUsedBytes) {
        if (!(this_present_workerUsedBytes && that_present_workerUsedBytes))
          return false;
        if (this.workerUsedBytes != that.workerUsedBytes)
          return false;
      }

      boolean this_present_storageDirId = true;
      boolean that_present_storageDirId = true;
      if (this_present_storageDirId || that_present_storageDirId) {
        if (!(this_present_storageDirId && that_present_storageDirId))
          return false;
        if (this.storageDirId != that.storageDirId)
          return false;
      }

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      boolean this_present_length = true;
      boolean that_present_length = true;
      if (this_present_length || that_present_length) {
        if (!(this_present_length && that_present_length))
          return false;
        if (this.length != that.length)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_cacheBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetWorkerId()).compareTo(other.isSetWorkerId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWorkerId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workerId, other.workerId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetWorkerUsedBytes()).compareTo(other.isSetWorkerUsedBytes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWorkerUsedBytes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workerUsedBytes, other.workerUsedBytes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStorageDirId()).compareTo(other.isSetStorageDirId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStorageDirId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.storageDirId, other.storageDirId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLength()).compareTo(other.isSetLength());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLength()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.length, other.length);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_cacheBlock_args(");
      boolean first = true;

      sb.append("workerId:");
      sb.append(this.workerId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("workerUsedBytes:");
      sb.append(this.workerUsedBytes);
      first = false;
      if (!first) sb.append(", ");
      sb.append("storageDirId:");
      sb.append(this.storageDirId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("length:");
      sb.append(this.length);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_cacheBlock_argsStandardSchemeFactory implements SchemeFactory {
      public worker_cacheBlock_argsStandardScheme getScheme() {
        return new worker_cacheBlock_argsStandardScheme();
      }
    }

    private static class worker_cacheBlock_argsStandardScheme extends StandardScheme<worker_cacheBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_cacheBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // WORKER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.workerId = iprot.readI64();
                struct.setWorkerIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // WORKER_USED_BYTES
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.workerUsedBytes = iprot.readI64();
                struct.setWorkerUsedBytesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // STORAGE_DIR_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.storageDirId = iprot.readI64();
                struct.setStorageDirIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // LENGTH
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.length = iprot.readI64();
                struct.setLengthIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_cacheBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(WORKER_ID_FIELD_DESC);
        oprot.writeI64(struct.workerId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(WORKER_USED_BYTES_FIELD_DESC);
        oprot.writeI64(struct.workerUsedBytes);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(STORAGE_DIR_ID_FIELD_DESC);
        oprot.writeI64(struct.storageDirId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LENGTH_FIELD_DESC);
        oprot.writeI64(struct.length);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_cacheBlock_argsTupleSchemeFactory implements SchemeFactory {
      public worker_cacheBlock_argsTupleScheme getScheme() {
        return new worker_cacheBlock_argsTupleScheme();
      }
    }

    private static class worker_cacheBlock_argsTupleScheme extends TupleScheme<worker_cacheBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_cacheBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetWorkerId()) {
          optionals.set(0);
        }
        if (struct.isSetWorkerUsedBytes()) {
          optionals.set(1);
        }
        if (struct.isSetStorageDirId()) {
          optionals.set(2);
        }
        if (struct.isSetBlockId()) {
          optionals.set(3);
        }
        if (struct.isSetLength()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetWorkerId()) {
          oprot.writeI64(struct.workerId);
        }
        if (struct.isSetWorkerUsedBytes()) {
          oprot.writeI64(struct.workerUsedBytes);
        }
        if (struct.isSetStorageDirId()) {
          oprot.writeI64(struct.storageDirId);
        }
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
        if (struct.isSetLength()) {
          oprot.writeI64(struct.length);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_cacheBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.workerId = iprot.readI64();
          struct.setWorkerIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.workerUsedBytes = iprot.readI64();
          struct.setWorkerUsedBytesIsSet(true);
        }
        if (incoming.get(2)) {
          struct.storageDirId = iprot.readI64();
          struct.setStorageDirIdIsSet(true);
        }
        if (incoming.get(3)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
        if (incoming.get(4)) {
          struct.length = iprot.readI64();
          struct.setLengthIsSet(true);
        }
      }
    }

  }

  public static class worker_cacheBlock_result implements org.apache.thrift.TBase<worker_cacheBlock_result, worker_cacheBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<worker_cacheBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_cacheBlock_result");

    private static final org.apache.thrift.protocol.TField E_P_FIELD_DESC = new org.apache.thrift.protocol.TField("eP", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_S_FIELD_DESC = new org.apache.thrift.protocol.TField("eS", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_cacheBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_cacheBlock_resultTupleSchemeFactory());
    }

    public FileDoesNotExistException eP; // required
    public SuspectedFileSizeException eS; // required
    public BlockInfoException eB; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E_P((short)1, "eP"),
      E_S((short)2, "eS"),
      E_B((short)3, "eB");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E_P
            return E_P;
          case 2: // E_S
            return E_S;
          case 3: // E_B
            return E_B;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E_P, new org.apache.thrift.meta_data.FieldMetaData("eP", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_S, new org.apache.thrift.meta_data.FieldMetaData("eS", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_cacheBlock_result.class, metaDataMap);
    }

    public worker_cacheBlock_result() {
    }

    public worker_cacheBlock_result(
      FileDoesNotExistException eP,
      SuspectedFileSizeException eS,
      BlockInfoException eB)
    {
      this();
      this.eP = eP;
      this.eS = eS;
      this.eB = eB;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_cacheBlock_result(worker_cacheBlock_result other) {
      if (other.isSetEP()) {
        this.eP = new FileDoesNotExistException(other.eP);
      }
      if (other.isSetES()) {
        this.eS = new SuspectedFileSizeException(other.eS);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
    }

    public worker_cacheBlock_result deepCopy() {
      return new worker_cacheBlock_result(this);
    }

    @Override
    public void clear() {
      this.eP = null;
      this.eS = null;
      this.eB = null;
    }

    public FileDoesNotExistException getEP() {
      return this.eP;
    }

    public worker_cacheBlock_result setEP(FileDoesNotExistException eP) {
      this.eP = eP;
      return this;
    }

    public void unsetEP() {
      this.eP = null;
    }

    /** Returns true if field eP is set (has been assigned a value) and false otherwise */
    public boolean isSetEP() {
      return this.eP != null;
    }

    public void setEPIsSet(boolean value) {
      if (!value) {
        this.eP = null;
      }
    }

    public SuspectedFileSizeException getES() {
      return this.eS;
    }

    public worker_cacheBlock_result setES(SuspectedFileSizeException eS) {
      this.eS = eS;
      return this;
    }

    public void unsetES() {
      this.eS = null;
    }

    /** Returns true if field eS is set (has been assigned a value) and false otherwise */
    public boolean isSetES() {
      return this.eS != null;
    }

    public void setESIsSet(boolean value) {
      if (!value) {
        this.eS = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public worker_cacheBlock_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E_P:
        if (value == null) {
          unsetEP();
        } else {
          setEP((FileDoesNotExistException)value);
        }
        break;

      case E_S:
        if (value == null) {
          unsetES();
        } else {
          setES((SuspectedFileSizeException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E_P:
        return getEP();

      case E_S:
        return getES();

      case E_B:
        return getEB();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E_P:
        return isSetEP();
      case E_S:
        return isSetES();
      case E_B:
        return isSetEB();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_cacheBlock_result)
        return this.equals((worker_cacheBlock_result)that);
      return false;
    }

    public boolean equals(worker_cacheBlock_result that) {
      if (that == null)
        return false;

      boolean this_present_eP = true && this.isSetEP();
      boolean that_present_eP = true && that.isSetEP();
      if (this_present_eP || that_present_eP) {
        if (!(this_present_eP && that_present_eP))
          return false;
        if (!this.eP.equals(that.eP))
          return false;
      }

      boolean this_present_eS = true && this.isSetES();
      boolean that_present_eS = true && that.isSetES();
      if (this_present_eS || that_present_eS) {
        if (!(this_present_eS && that_present_eS))
          return false;
        if (!this.eS.equals(that.eS))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_cacheBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetEP()).compareTo(other.isSetEP());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEP()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eP, other.eP);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetES()).compareTo(other.isSetES());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetES()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eS, other.eS);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_cacheBlock_result(");
      boolean first = true;

      sb.append("eP:");
      if (this.eP == null) {
        sb.append("null");
      } else {
        sb.append(this.eP);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eS:");
      if (this.eS == null) {
        sb.append("null");
      } else {
        sb.append(this.eS);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_cacheBlock_resultStandardSchemeFactory implements SchemeFactory {
      public worker_cacheBlock_resultStandardScheme getScheme() {
        return new worker_cacheBlock_resultStandardScheme();
      }
    }

    private static class worker_cacheBlock_resultStandardScheme extends StandardScheme<worker_cacheBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_cacheBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E_P
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eP = new FileDoesNotExistException();
                struct.eP.read(iprot);
                struct.setEPIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_S
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eS = new SuspectedFileSizeException();
                struct.eS.read(iprot);
                struct.setESIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_cacheBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.eP != null) {
          oprot.writeFieldBegin(E_P_FIELD_DESC);
          struct.eP.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eS != null) {
          oprot.writeFieldBegin(E_S_FIELD_DESC);
          struct.eS.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_cacheBlock_resultTupleSchemeFactory implements SchemeFactory {
      public worker_cacheBlock_resultTupleScheme getScheme() {
        return new worker_cacheBlock_resultTupleScheme();
      }
    }

    private static class worker_cacheBlock_resultTupleScheme extends TupleScheme<worker_cacheBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_cacheBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetEP()) {
          optionals.set(0);
        }
        if (struct.isSetES()) {
          optionals.set(1);
        }
        if (struct.isSetEB()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetEP()) {
          struct.eP.write(oprot);
        }
        if (struct.isSetES()) {
          struct.eS.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_cacheBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.eP = new FileDoesNotExistException();
          struct.eP.read(iprot);
          struct.setEPIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eS = new SuspectedFileSizeException();
          struct.eS.read(iprot);
          struct.setESIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
      }
    }

  }

  public static class worker_getPinIdList_args implements org.apache.thrift.TBase<worker_getPinIdList_args, worker_getPinIdList_args._Fields>, java.io.Serializable, Cloneable, Comparable<worker_getPinIdList_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_getPinIdList_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_getPinIdList_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_getPinIdList_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_getPinIdList_args.class, metaDataMap);
    }

    public worker_getPinIdList_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_getPinIdList_args(worker_getPinIdList_args other) {
    }

    public worker_getPinIdList_args deepCopy() {
      return new worker_getPinIdList_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_getPinIdList_args)
        return this.equals((worker_getPinIdList_args)that);
      return false;
    }

    public boolean equals(worker_getPinIdList_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_getPinIdList_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_getPinIdList_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_getPinIdList_argsStandardSchemeFactory implements SchemeFactory {
      public worker_getPinIdList_argsStandardScheme getScheme() {
        return new worker_getPinIdList_argsStandardScheme();
      }
    }

    private static class worker_getPinIdList_argsStandardScheme extends StandardScheme<worker_getPinIdList_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_getPinIdList_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_getPinIdList_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_getPinIdList_argsTupleSchemeFactory implements SchemeFactory {
      public worker_getPinIdList_argsTupleScheme getScheme() {
        return new worker_getPinIdList_argsTupleScheme();
      }
    }

    private static class worker_getPinIdList_argsTupleScheme extends TupleScheme<worker_getPinIdList_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_getPinIdList_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_getPinIdList_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class worker_getPinIdList_result implements org.apache.thrift.TBase<worker_getPinIdList_result, worker_getPinIdList_result._Fields>, java.io.Serializable, Cloneable, Comparable<worker_getPinIdList_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_getPinIdList_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.SET, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_getPinIdList_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_getPinIdList_resultTupleSchemeFactory());
    }

    public Set<Integer> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_getPinIdList_result.class, metaDataMap);
    }

    public worker_getPinIdList_result() {
    }

    public worker_getPinIdList_result(
      Set<Integer> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_getPinIdList_result(worker_getPinIdList_result other) {
      if (other.isSetSuccess()) {
        Set<Integer> __this__success = new HashSet<Integer>(other.success);
        this.success = __this__success;
      }
    }

    public worker_getPinIdList_result deepCopy() {
      return new worker_getPinIdList_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<Integer> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(int elem) {
      if (this.success == null) {
        this.success = new HashSet<Integer>();
      }
      this.success.add(elem);
    }

    public Set<Integer> getSuccess() {
      return this.success;
    }

    public worker_getPinIdList_result setSuccess(Set<Integer> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Set<Integer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_getPinIdList_result)
        return this.equals((worker_getPinIdList_result)that);
      return false;
    }

    public boolean equals(worker_getPinIdList_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_getPinIdList_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_getPinIdList_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_getPinIdList_resultStandardSchemeFactory implements SchemeFactory {
      public worker_getPinIdList_resultStandardScheme getScheme() {
        return new worker_getPinIdList_resultStandardScheme();
      }
    }

    private static class worker_getPinIdList_resultStandardScheme extends StandardScheme<worker_getPinIdList_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_getPinIdList_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set108 = iprot.readSetBegin();
                  struct.success = new HashSet<Integer>(2*_set108.size);
                  for (int _i109 = 0; _i109 < _set108.size; ++_i109)
                  {
                    int _elem110;
                    _elem110 = iprot.readI32();
                    struct.success.add(_elem110);
                  }
                  iprot.readSetEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_getPinIdList_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.success.size()));
            for (int _iter111 : struct.success)
            {
              oprot.writeI32(_iter111);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_getPinIdList_resultTupleSchemeFactory implements SchemeFactory {
      public worker_getPinIdList_resultTupleScheme getScheme() {
        return new worker_getPinIdList_resultTupleScheme();
      }
    }

    private static class worker_getPinIdList_resultTupleScheme extends TupleScheme<worker_getPinIdList_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_getPinIdList_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (int _iter112 : struct.success)
            {
              oprot.writeI32(_iter112);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_getPinIdList_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TSet _set113 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.success = new HashSet<Integer>(2*_set113.size);
            for (int _i114 = 0; _i114 < _set113.size; ++_i114)
            {
              int _elem115;
              _elem115 = iprot.readI32();
              struct.success.add(_elem115);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class worker_getPriorityDependencyList_args implements org.apache.thrift.TBase<worker_getPriorityDependencyList_args, worker_getPriorityDependencyList_args._Fields>, java.io.Serializable, Cloneable, Comparable<worker_getPriorityDependencyList_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_getPriorityDependencyList_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_getPriorityDependencyList_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_getPriorityDependencyList_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_getPriorityDependencyList_args.class, metaDataMap);
    }

    public worker_getPriorityDependencyList_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_getPriorityDependencyList_args(worker_getPriorityDependencyList_args other) {
    }

    public worker_getPriorityDependencyList_args deepCopy() {
      return new worker_getPriorityDependencyList_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_getPriorityDependencyList_args)
        return this.equals((worker_getPriorityDependencyList_args)that);
      return false;
    }

    public boolean equals(worker_getPriorityDependencyList_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_getPriorityDependencyList_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_getPriorityDependencyList_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_getPriorityDependencyList_argsStandardSchemeFactory implements SchemeFactory {
      public worker_getPriorityDependencyList_argsStandardScheme getScheme() {
        return new worker_getPriorityDependencyList_argsStandardScheme();
      }
    }

    private static class worker_getPriorityDependencyList_argsStandardScheme extends StandardScheme<worker_getPriorityDependencyList_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_getPriorityDependencyList_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_getPriorityDependencyList_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_getPriorityDependencyList_argsTupleSchemeFactory implements SchemeFactory {
      public worker_getPriorityDependencyList_argsTupleScheme getScheme() {
        return new worker_getPriorityDependencyList_argsTupleScheme();
      }
    }

    private static class worker_getPriorityDependencyList_argsTupleScheme extends TupleScheme<worker_getPriorityDependencyList_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_getPriorityDependencyList_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_getPriorityDependencyList_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class worker_getPriorityDependencyList_result implements org.apache.thrift.TBase<worker_getPriorityDependencyList_result, worker_getPriorityDependencyList_result._Fields>, java.io.Serializable, Cloneable, Comparable<worker_getPriorityDependencyList_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("worker_getPriorityDependencyList_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new worker_getPriorityDependencyList_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new worker_getPriorityDependencyList_resultTupleSchemeFactory());
    }

    public List<Integer> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(worker_getPriorityDependencyList_result.class, metaDataMap);
    }

    public worker_getPriorityDependencyList_result() {
    }

    public worker_getPriorityDependencyList_result(
      List<Integer> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public worker_getPriorityDependencyList_result(worker_getPriorityDependencyList_result other) {
      if (other.isSetSuccess()) {
        List<Integer> __this__success = new ArrayList<Integer>(other.success);
        this.success = __this__success;
      }
    }

    public worker_getPriorityDependencyList_result deepCopy() {
      return new worker_getPriorityDependencyList_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<Integer> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(int elem) {
      if (this.success == null) {
        this.success = new ArrayList<Integer>();
      }
      this.success.add(elem);
    }

    public List<Integer> getSuccess() {
      return this.success;
    }

    public worker_getPriorityDependencyList_result setSuccess(List<Integer> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<Integer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof worker_getPriorityDependencyList_result)
        return this.equals((worker_getPriorityDependencyList_result)that);
      return false;
    }

    public boolean equals(worker_getPriorityDependencyList_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(worker_getPriorityDependencyList_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("worker_getPriorityDependencyList_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class worker_getPriorityDependencyList_resultStandardSchemeFactory implements SchemeFactory {
      public worker_getPriorityDependencyList_resultStandardScheme getScheme() {
        return new worker_getPriorityDependencyList_resultStandardScheme();
      }
    }

    private static class worker_getPriorityDependencyList_resultStandardScheme extends StandardScheme<worker_getPriorityDependencyList_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, worker_getPriorityDependencyList_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list116 = iprot.readListBegin();
                  struct.success = new ArrayList<Integer>(_list116.size);
                  for (int _i117 = 0; _i117 < _list116.size; ++_i117)
                  {
                    int _elem118;
                    _elem118 = iprot.readI32();
                    struct.success.add(_elem118);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, worker_getPriorityDependencyList_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I32, struct.success.size()));
            for (int _iter119 : struct.success)
            {
              oprot.writeI32(_iter119);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class worker_getPriorityDependencyList_resultTupleSchemeFactory implements SchemeFactory {
      public worker_getPriorityDependencyList_resultTupleScheme getScheme() {
        return new worker_getPriorityDependencyList_resultTupleScheme();
      }
    }

    private static class worker_getPriorityDependencyList_resultTupleScheme extends TupleScheme<worker_getPriorityDependencyList_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, worker_getPriorityDependencyList_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (int _iter120 : struct.success)
            {
              oprot.writeI32(_iter120);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, worker_getPriorityDependencyList_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list121 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.success = new ArrayList<Integer>(_list121.size);
            for (int _i122 = 0; _i122 < _list121.size; ++_i122)
            {
              int _elem123;
              _elem123 = iprot.readI32();
              struct.success.add(_elem123);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class user_createDependency_args implements org.apache.thrift.TBase<user_createDependency_args, user_createDependency_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_createDependency_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_createDependency_args");

    private static final org.apache.thrift.protocol.TField PARENTS_FIELD_DESC = new org.apache.thrift.protocol.TField("parents", org.apache.thrift.protocol.TType.LIST, (short)1);
    private static final org.apache.thrift.protocol.TField CHILDREN_FIELD_DESC = new org.apache.thrift.protocol.TField("children", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField COMMAND_PREFIX_FIELD_DESC = new org.apache.thrift.protocol.TField("commandPrefix", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField DATA_FIELD_DESC = new org.apache.thrift.protocol.TField("data", org.apache.thrift.protocol.TType.LIST, (short)4);
    private static final org.apache.thrift.protocol.TField COMMENT_FIELD_DESC = new org.apache.thrift.protocol.TField("comment", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField FRAMEWORK_FIELD_DESC = new org.apache.thrift.protocol.TField("framework", org.apache.thrift.protocol.TType.STRING, (short)6);
    private static final org.apache.thrift.protocol.TField FRAMEWORK_VERSION_FIELD_DESC = new org.apache.thrift.protocol.TField("frameworkVersion", org.apache.thrift.protocol.TType.STRING, (short)7);
    private static final org.apache.thrift.protocol.TField DEPENDENCY_TYPE_FIELD_DESC = new org.apache.thrift.protocol.TField("dependencyType", org.apache.thrift.protocol.TType.I32, (short)8);
    private static final org.apache.thrift.protocol.TField CHILDREN_BLOCK_SIZE_BYTE_FIELD_DESC = new org.apache.thrift.protocol.TField("childrenBlockSizeByte", org.apache.thrift.protocol.TType.I64, (short)9);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_createDependency_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_createDependency_argsTupleSchemeFactory());
    }

    public List<String> parents; // required
    public List<String> children; // required
    public String commandPrefix; // required
    public List<ByteBuffer> data; // required
    public String comment; // required
    public String framework; // required
    public String frameworkVersion; // required
    public int dependencyType; // required
    public long childrenBlockSizeByte; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      PARENTS((short)1, "parents"),
      CHILDREN((short)2, "children"),
      COMMAND_PREFIX((short)3, "commandPrefix"),
      DATA((short)4, "data"),
      COMMENT((short)5, "comment"),
      FRAMEWORK((short)6, "framework"),
      FRAMEWORK_VERSION((short)7, "frameworkVersion"),
      DEPENDENCY_TYPE((short)8, "dependencyType"),
      CHILDREN_BLOCK_SIZE_BYTE((short)9, "childrenBlockSizeByte");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // PARENTS
            return PARENTS;
          case 2: // CHILDREN
            return CHILDREN;
          case 3: // COMMAND_PREFIX
            return COMMAND_PREFIX;
          case 4: // DATA
            return DATA;
          case 5: // COMMENT
            return COMMENT;
          case 6: // FRAMEWORK
            return FRAMEWORK;
          case 7: // FRAMEWORK_VERSION
            return FRAMEWORK_VERSION;
          case 8: // DEPENDENCY_TYPE
            return DEPENDENCY_TYPE;
          case 9: // CHILDREN_BLOCK_SIZE_BYTE
            return CHILDREN_BLOCK_SIZE_BYTE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __DEPENDENCYTYPE_ISSET_ID = 0;
    private static final int __CHILDRENBLOCKSIZEBYTE_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.PARENTS, new org.apache.thrift.meta_data.FieldMetaData("parents", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.CHILDREN, new org.apache.thrift.meta_data.FieldMetaData("children", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.COMMAND_PREFIX, new org.apache.thrift.meta_data.FieldMetaData("commandPrefix", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.DATA, new org.apache.thrift.meta_data.FieldMetaData("data", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.COMMENT, new org.apache.thrift.meta_data.FieldMetaData("comment", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.FRAMEWORK, new org.apache.thrift.meta_data.FieldMetaData("framework", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.FRAMEWORK_VERSION, new org.apache.thrift.meta_data.FieldMetaData("frameworkVersion", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.DEPENDENCY_TYPE, new org.apache.thrift.meta_data.FieldMetaData("dependencyType", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.CHILDREN_BLOCK_SIZE_BYTE, new org.apache.thrift.meta_data.FieldMetaData("childrenBlockSizeByte", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_createDependency_args.class, metaDataMap);
    }

    public user_createDependency_args() {
    }

    public user_createDependency_args(
      List<String> parents,
      List<String> children,
      String commandPrefix,
      List<ByteBuffer> data,
      String comment,
      String framework,
      String frameworkVersion,
      int dependencyType,
      long childrenBlockSizeByte)
    {
      this();
      this.parents = parents;
      this.children = children;
      this.commandPrefix = commandPrefix;
      this.data = data;
      this.comment = comment;
      this.framework = framework;
      this.frameworkVersion = frameworkVersion;
      this.dependencyType = dependencyType;
      setDependencyTypeIsSet(true);
      this.childrenBlockSizeByte = childrenBlockSizeByte;
      setChildrenBlockSizeByteIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_createDependency_args(user_createDependency_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetParents()) {
        List<String> __this__parents = new ArrayList<String>(other.parents);
        this.parents = __this__parents;
      }
      if (other.isSetChildren()) {
        List<String> __this__children = new ArrayList<String>(other.children);
        this.children = __this__children;
      }
      if (other.isSetCommandPrefix()) {
        this.commandPrefix = other.commandPrefix;
      }
      if (other.isSetData()) {
        List<ByteBuffer> __this__data = new ArrayList<ByteBuffer>(other.data);
        this.data = __this__data;
      }
      if (other.isSetComment()) {
        this.comment = other.comment;
      }
      if (other.isSetFramework()) {
        this.framework = other.framework;
      }
      if (other.isSetFrameworkVersion()) {
        this.frameworkVersion = other.frameworkVersion;
      }
      this.dependencyType = other.dependencyType;
      this.childrenBlockSizeByte = other.childrenBlockSizeByte;
    }

    public user_createDependency_args deepCopy() {
      return new user_createDependency_args(this);
    }

    @Override
    public void clear() {
      this.parents = null;
      this.children = null;
      this.commandPrefix = null;
      this.data = null;
      this.comment = null;
      this.framework = null;
      this.frameworkVersion = null;
      setDependencyTypeIsSet(false);
      this.dependencyType = 0;
      setChildrenBlockSizeByteIsSet(false);
      this.childrenBlockSizeByte = 0;
    }

    public int getParentsSize() {
      return (this.parents == null) ? 0 : this.parents.size();
    }

    public java.util.Iterator<String> getParentsIterator() {
      return (this.parents == null) ? null : this.parents.iterator();
    }

    public void addToParents(String elem) {
      if (this.parents == null) {
        this.parents = new ArrayList<String>();
      }
      this.parents.add(elem);
    }

    public List<String> getParents() {
      return this.parents;
    }

    public user_createDependency_args setParents(List<String> parents) {
      this.parents = parents;
      return this;
    }

    public void unsetParents() {
      this.parents = null;
    }

    /** Returns true if field parents is set (has been assigned a value) and false otherwise */
    public boolean isSetParents() {
      return this.parents != null;
    }

    public void setParentsIsSet(boolean value) {
      if (!value) {
        this.parents = null;
      }
    }

    public int getChildrenSize() {
      return (this.children == null) ? 0 : this.children.size();
    }

    public java.util.Iterator<String> getChildrenIterator() {
      return (this.children == null) ? null : this.children.iterator();
    }

    public void addToChildren(String elem) {
      if (this.children == null) {
        this.children = new ArrayList<String>();
      }
      this.children.add(elem);
    }

    public List<String> getChildren() {
      return this.children;
    }

    public user_createDependency_args setChildren(List<String> children) {
      this.children = children;
      return this;
    }

    public void unsetChildren() {
      this.children = null;
    }

    /** Returns true if field children is set (has been assigned a value) and false otherwise */
    public boolean isSetChildren() {
      return this.children != null;
    }

    public void setChildrenIsSet(boolean value) {
      if (!value) {
        this.children = null;
      }
    }

    public String getCommandPrefix() {
      return this.commandPrefix;
    }

    public user_createDependency_args setCommandPrefix(String commandPrefix) {
      this.commandPrefix = commandPrefix;
      return this;
    }

    public void unsetCommandPrefix() {
      this.commandPrefix = null;
    }

    /** Returns true if field commandPrefix is set (has been assigned a value) and false otherwise */
    public boolean isSetCommandPrefix() {
      return this.commandPrefix != null;
    }

    public void setCommandPrefixIsSet(boolean value) {
      if (!value) {
        this.commandPrefix = null;
      }
    }

    public int getDataSize() {
      return (this.data == null) ? 0 : this.data.size();
    }

    public java.util.Iterator<ByteBuffer> getDataIterator() {
      return (this.data == null) ? null : this.data.iterator();
    }

    public void addToData(ByteBuffer elem) {
      if (this.data == null) {
        this.data = new ArrayList<ByteBuffer>();
      }
      this.data.add(elem);
    }

    public List<ByteBuffer> getData() {
      return this.data;
    }

    public user_createDependency_args setData(List<ByteBuffer> data) {
      this.data = data;
      return this;
    }

    public void unsetData() {
      this.data = null;
    }

    /** Returns true if field data is set (has been assigned a value) and false otherwise */
    public boolean isSetData() {
      return this.data != null;
    }

    public void setDataIsSet(boolean value) {
      if (!value) {
        this.data = null;
      }
    }

    public String getComment() {
      return this.comment;
    }

    public user_createDependency_args setComment(String comment) {
      this.comment = comment;
      return this;
    }

    public void unsetComment() {
      this.comment = null;
    }

    /** Returns true if field comment is set (has been assigned a value) and false otherwise */
    public boolean isSetComment() {
      return this.comment != null;
    }

    public void setCommentIsSet(boolean value) {
      if (!value) {
        this.comment = null;
      }
    }

    public String getFramework() {
      return this.framework;
    }

    public user_createDependency_args setFramework(String framework) {
      this.framework = framework;
      return this;
    }

    public void unsetFramework() {
      this.framework = null;
    }

    /** Returns true if field framework is set (has been assigned a value) and false otherwise */
    public boolean isSetFramework() {
      return this.framework != null;
    }

    public void setFrameworkIsSet(boolean value) {
      if (!value) {
        this.framework = null;
      }
    }

    public String getFrameworkVersion() {
      return this.frameworkVersion;
    }

    public user_createDependency_args setFrameworkVersion(String frameworkVersion) {
      this.frameworkVersion = frameworkVersion;
      return this;
    }

    public void unsetFrameworkVersion() {
      this.frameworkVersion = null;
    }

    /** Returns true if field frameworkVersion is set (has been assigned a value) and false otherwise */
    public boolean isSetFrameworkVersion() {
      return this.frameworkVersion != null;
    }

    public void setFrameworkVersionIsSet(boolean value) {
      if (!value) {
        this.frameworkVersion = null;
      }
    }

    public int getDependencyType() {
      return this.dependencyType;
    }

    public user_createDependency_args setDependencyType(int dependencyType) {
      this.dependencyType = dependencyType;
      setDependencyTypeIsSet(true);
      return this;
    }

    public void unsetDependencyType() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __DEPENDENCYTYPE_ISSET_ID);
    }

    /** Returns true if field dependencyType is set (has been assigned a value) and false otherwise */
    public boolean isSetDependencyType() {
      return EncodingUtils.testBit(__isset_bitfield, __DEPENDENCYTYPE_ISSET_ID);
    }

    public void setDependencyTypeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __DEPENDENCYTYPE_ISSET_ID, value);
    }

    public long getChildrenBlockSizeByte() {
      return this.childrenBlockSizeByte;
    }

    public user_createDependency_args setChildrenBlockSizeByte(long childrenBlockSizeByte) {
      this.childrenBlockSizeByte = childrenBlockSizeByte;
      setChildrenBlockSizeByteIsSet(true);
      return this;
    }

    public void unsetChildrenBlockSizeByte() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CHILDRENBLOCKSIZEBYTE_ISSET_ID);
    }

    /** Returns true if field childrenBlockSizeByte is set (has been assigned a value) and false otherwise */
    public boolean isSetChildrenBlockSizeByte() {
      return EncodingUtils.testBit(__isset_bitfield, __CHILDRENBLOCKSIZEBYTE_ISSET_ID);
    }

    public void setChildrenBlockSizeByteIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CHILDRENBLOCKSIZEBYTE_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case PARENTS:
        if (value == null) {
          unsetParents();
        } else {
          setParents((List<String>)value);
        }
        break;

      case CHILDREN:
        if (value == null) {
          unsetChildren();
        } else {
          setChildren((List<String>)value);
        }
        break;

      case COMMAND_PREFIX:
        if (value == null) {
          unsetCommandPrefix();
        } else {
          setCommandPrefix((String)value);
        }
        break;

      case DATA:
        if (value == null) {
          unsetData();
        } else {
          setData((List<ByteBuffer>)value);
        }
        break;

      case COMMENT:
        if (value == null) {
          unsetComment();
        } else {
          setComment((String)value);
        }
        break;

      case FRAMEWORK:
        if (value == null) {
          unsetFramework();
        } else {
          setFramework((String)value);
        }
        break;

      case FRAMEWORK_VERSION:
        if (value == null) {
          unsetFrameworkVersion();
        } else {
          setFrameworkVersion((String)value);
        }
        break;

      case DEPENDENCY_TYPE:
        if (value == null) {
          unsetDependencyType();
        } else {
          setDependencyType((Integer)value);
        }
        break;

      case CHILDREN_BLOCK_SIZE_BYTE:
        if (value == null) {
          unsetChildrenBlockSizeByte();
        } else {
          setChildrenBlockSizeByte((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case PARENTS:
        return getParents();

      case CHILDREN:
        return getChildren();

      case COMMAND_PREFIX:
        return getCommandPrefix();

      case DATA:
        return getData();

      case COMMENT:
        return getComment();

      case FRAMEWORK:
        return getFramework();

      case FRAMEWORK_VERSION:
        return getFrameworkVersion();

      case DEPENDENCY_TYPE:
        return Integer.valueOf(getDependencyType());

      case CHILDREN_BLOCK_SIZE_BYTE:
        return Long.valueOf(getChildrenBlockSizeByte());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case PARENTS:
        return isSetParents();
      case CHILDREN:
        return isSetChildren();
      case COMMAND_PREFIX:
        return isSetCommandPrefix();
      case DATA:
        return isSetData();
      case COMMENT:
        return isSetComment();
      case FRAMEWORK:
        return isSetFramework();
      case FRAMEWORK_VERSION:
        return isSetFrameworkVersion();
      case DEPENDENCY_TYPE:
        return isSetDependencyType();
      case CHILDREN_BLOCK_SIZE_BYTE:
        return isSetChildrenBlockSizeByte();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_createDependency_args)
        return this.equals((user_createDependency_args)that);
      return false;
    }

    public boolean equals(user_createDependency_args that) {
      if (that == null)
        return false;

      boolean this_present_parents = true && this.isSetParents();
      boolean that_present_parents = true && that.isSetParents();
      if (this_present_parents || that_present_parents) {
        if (!(this_present_parents && that_present_parents))
          return false;
        if (!this.parents.equals(that.parents))
          return false;
      }

      boolean this_present_children = true && this.isSetChildren();
      boolean that_present_children = true && that.isSetChildren();
      if (this_present_children || that_present_children) {
        if (!(this_present_children && that_present_children))
          return false;
        if (!this.children.equals(that.children))
          return false;
      }

      boolean this_present_commandPrefix = true && this.isSetCommandPrefix();
      boolean that_present_commandPrefix = true && that.isSetCommandPrefix();
      if (this_present_commandPrefix || that_present_commandPrefix) {
        if (!(this_present_commandPrefix && that_present_commandPrefix))
          return false;
        if (!this.commandPrefix.equals(that.commandPrefix))
          return false;
      }

      boolean this_present_data = true && this.isSetData();
      boolean that_present_data = true && that.isSetData();
      if (this_present_data || that_present_data) {
        if (!(this_present_data && that_present_data))
          return false;
        if (!this.data.equals(that.data))
          return false;
      }

      boolean this_present_comment = true && this.isSetComment();
      boolean that_present_comment = true && that.isSetComment();
      if (this_present_comment || that_present_comment) {
        if (!(this_present_comment && that_present_comment))
          return false;
        if (!this.comment.equals(that.comment))
          return false;
      }

      boolean this_present_framework = true && this.isSetFramework();
      boolean that_present_framework = true && that.isSetFramework();
      if (this_present_framework || that_present_framework) {
        if (!(this_present_framework && that_present_framework))
          return false;
        if (!this.framework.equals(that.framework))
          return false;
      }

      boolean this_present_frameworkVersion = true && this.isSetFrameworkVersion();
      boolean that_present_frameworkVersion = true && that.isSetFrameworkVersion();
      if (this_present_frameworkVersion || that_present_frameworkVersion) {
        if (!(this_present_frameworkVersion && that_present_frameworkVersion))
          return false;
        if (!this.frameworkVersion.equals(that.frameworkVersion))
          return false;
      }

      boolean this_present_dependencyType = true;
      boolean that_present_dependencyType = true;
      if (this_present_dependencyType || that_present_dependencyType) {
        if (!(this_present_dependencyType && that_present_dependencyType))
          return false;
        if (this.dependencyType != that.dependencyType)
          return false;
      }

      boolean this_present_childrenBlockSizeByte = true;
      boolean that_present_childrenBlockSizeByte = true;
      if (this_present_childrenBlockSizeByte || that_present_childrenBlockSizeByte) {
        if (!(this_present_childrenBlockSizeByte && that_present_childrenBlockSizeByte))
          return false;
        if (this.childrenBlockSizeByte != that.childrenBlockSizeByte)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_createDependency_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetParents()).compareTo(other.isSetParents());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetParents()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.parents, other.parents);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetChildren()).compareTo(other.isSetChildren());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetChildren()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.children, other.children);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCommandPrefix()).compareTo(other.isSetCommandPrefix());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCommandPrefix()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.commandPrefix, other.commandPrefix);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetData()).compareTo(other.isSetData());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetData()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.data, other.data);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetComment()).compareTo(other.isSetComment());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetComment()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.comment, other.comment);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFramework()).compareTo(other.isSetFramework());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFramework()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.framework, other.framework);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFrameworkVersion()).compareTo(other.isSetFrameworkVersion());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFrameworkVersion()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.frameworkVersion, other.frameworkVersion);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDependencyType()).compareTo(other.isSetDependencyType());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDependencyType()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dependencyType, other.dependencyType);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetChildrenBlockSizeByte()).compareTo(other.isSetChildrenBlockSizeByte());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetChildrenBlockSizeByte()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.childrenBlockSizeByte, other.childrenBlockSizeByte);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_createDependency_args(");
      boolean first = true;

      sb.append("parents:");
      if (this.parents == null) {
        sb.append("null");
      } else {
        sb.append(this.parents);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("children:");
      if (this.children == null) {
        sb.append("null");
      } else {
        sb.append(this.children);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("commandPrefix:");
      if (this.commandPrefix == null) {
        sb.append("null");
      } else {
        sb.append(this.commandPrefix);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("data:");
      if (this.data == null) {
        sb.append("null");
      } else {
        sb.append(this.data);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("comment:");
      if (this.comment == null) {
        sb.append("null");
      } else {
        sb.append(this.comment);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("framework:");
      if (this.framework == null) {
        sb.append("null");
      } else {
        sb.append(this.framework);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("frameworkVersion:");
      if (this.frameworkVersion == null) {
        sb.append("null");
      } else {
        sb.append(this.frameworkVersion);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("dependencyType:");
      sb.append(this.dependencyType);
      first = false;
      if (!first) sb.append(", ");
      sb.append("childrenBlockSizeByte:");
      sb.append(this.childrenBlockSizeByte);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_createDependency_argsStandardSchemeFactory implements SchemeFactory {
      public user_createDependency_argsStandardScheme getScheme() {
        return new user_createDependency_argsStandardScheme();
      }
    }

    private static class user_createDependency_argsStandardScheme extends StandardScheme<user_createDependency_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_createDependency_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // PARENTS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list124 = iprot.readListBegin();
                  struct.parents = new ArrayList<String>(_list124.size);
                  for (int _i125 = 0; _i125 < _list124.size; ++_i125)
                  {
                    String _elem126;
                    _elem126 = iprot.readString();
                    struct.parents.add(_elem126);
                  }
                  iprot.readListEnd();
                }
                struct.setParentsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CHILDREN
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list127 = iprot.readListBegin();
                  struct.children = new ArrayList<String>(_list127.size);
                  for (int _i128 = 0; _i128 < _list127.size; ++_i128)
                  {
                    String _elem129;
                    _elem129 = iprot.readString();
                    struct.children.add(_elem129);
                  }
                  iprot.readListEnd();
                }
                struct.setChildrenIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COMMAND_PREFIX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.commandPrefix = iprot.readString();
                struct.setCommandPrefixIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // DATA
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list130 = iprot.readListBegin();
                  struct.data = new ArrayList<ByteBuffer>(_list130.size);
                  for (int _i131 = 0; _i131 < _list130.size; ++_i131)
                  {
                    ByteBuffer _elem132;
                    _elem132 = iprot.readBinary();
                    struct.data.add(_elem132);
                  }
                  iprot.readListEnd();
                }
                struct.setDataIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // COMMENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.comment = iprot.readString();
                struct.setCommentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // FRAMEWORK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.framework = iprot.readString();
                struct.setFrameworkIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // FRAMEWORK_VERSION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.frameworkVersion = iprot.readString();
                struct.setFrameworkVersionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 8: // DEPENDENCY_TYPE
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.dependencyType = iprot.readI32();
                struct.setDependencyTypeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 9: // CHILDREN_BLOCK_SIZE_BYTE
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.childrenBlockSizeByte = iprot.readI64();
                struct.setChildrenBlockSizeByteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_createDependency_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.parents != null) {
          oprot.writeFieldBegin(PARENTS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.parents.size()));
            for (String _iter133 : struct.parents)
            {
              oprot.writeString(_iter133);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.children != null) {
          oprot.writeFieldBegin(CHILDREN_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.children.size()));
            for (String _iter134 : struct.children)
            {
              oprot.writeString(_iter134);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.commandPrefix != null) {
          oprot.writeFieldBegin(COMMAND_PREFIX_FIELD_DESC);
          oprot.writeString(struct.commandPrefix);
          oprot.writeFieldEnd();
        }
        if (struct.data != null) {
          oprot.writeFieldBegin(DATA_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.data.size()));
            for (ByteBuffer _iter135 : struct.data)
            {
              oprot.writeBinary(_iter135);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.comment != null) {
          oprot.writeFieldBegin(COMMENT_FIELD_DESC);
          oprot.writeString(struct.comment);
          oprot.writeFieldEnd();
        }
        if (struct.framework != null) {
          oprot.writeFieldBegin(FRAMEWORK_FIELD_DESC);
          oprot.writeString(struct.framework);
          oprot.writeFieldEnd();
        }
        if (struct.frameworkVersion != null) {
          oprot.writeFieldBegin(FRAMEWORK_VERSION_FIELD_DESC);
          oprot.writeString(struct.frameworkVersion);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(DEPENDENCY_TYPE_FIELD_DESC);
        oprot.writeI32(struct.dependencyType);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(CHILDREN_BLOCK_SIZE_BYTE_FIELD_DESC);
        oprot.writeI64(struct.childrenBlockSizeByte);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_createDependency_argsTupleSchemeFactory implements SchemeFactory {
      public user_createDependency_argsTupleScheme getScheme() {
        return new user_createDependency_argsTupleScheme();
      }
    }

    private static class user_createDependency_argsTupleScheme extends TupleScheme<user_createDependency_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_createDependency_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetParents()) {
          optionals.set(0);
        }
        if (struct.isSetChildren()) {
          optionals.set(1);
        }
        if (struct.isSetCommandPrefix()) {
          optionals.set(2);
        }
        if (struct.isSetData()) {
          optionals.set(3);
        }
        if (struct.isSetComment()) {
          optionals.set(4);
        }
        if (struct.isSetFramework()) {
          optionals.set(5);
        }
        if (struct.isSetFrameworkVersion()) {
          optionals.set(6);
        }
        if (struct.isSetDependencyType()) {
          optionals.set(7);
        }
        if (struct.isSetChildrenBlockSizeByte()) {
          optionals.set(8);
        }
        oprot.writeBitSet(optionals, 9);
        if (struct.isSetParents()) {
          {
            oprot.writeI32(struct.parents.size());
            for (String _iter136 : struct.parents)
            {
              oprot.writeString(_iter136);
            }
          }
        }
        if (struct.isSetChildren()) {
          {
            oprot.writeI32(struct.children.size());
            for (String _iter137 : struct.children)
            {
              oprot.writeString(_iter137);
            }
          }
        }
        if (struct.isSetCommandPrefix()) {
          oprot.writeString(struct.commandPrefix);
        }
        if (struct.isSetData()) {
          {
            oprot.writeI32(struct.data.size());
            for (ByteBuffer _iter138 : struct.data)
            {
              oprot.writeBinary(_iter138);
            }
          }
        }
        if (struct.isSetComment()) {
          oprot.writeString(struct.comment);
        }
        if (struct.isSetFramework()) {
          oprot.writeString(struct.framework);
        }
        if (struct.isSetFrameworkVersion()) {
          oprot.writeString(struct.frameworkVersion);
        }
        if (struct.isSetDependencyType()) {
          oprot.writeI32(struct.dependencyType);
        }
        if (struct.isSetChildrenBlockSizeByte()) {
          oprot.writeI64(struct.childrenBlockSizeByte);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_createDependency_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(9);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list139 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.parents = new ArrayList<String>(_list139.size);
            for (int _i140 = 0; _i140 < _list139.size; ++_i140)
            {
              String _elem141;
              _elem141 = iprot.readString();
              struct.parents.add(_elem141);
            }
          }
          struct.setParentsIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list142 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.children = new ArrayList<String>(_list142.size);
            for (int _i143 = 0; _i143 < _list142.size; ++_i143)
            {
              String _elem144;
              _elem144 = iprot.readString();
              struct.children.add(_elem144);
            }
          }
          struct.setChildrenIsSet(true);
        }
        if (incoming.get(2)) {
          struct.commandPrefix = iprot.readString();
          struct.setCommandPrefixIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list145 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.data = new ArrayList<ByteBuffer>(_list145.size);
            for (int _i146 = 0; _i146 < _list145.size; ++_i146)
            {
              ByteBuffer _elem147;
              _elem147 = iprot.readBinary();
              struct.data.add(_elem147);
            }
          }
          struct.setDataIsSet(true);
        }
        if (incoming.get(4)) {
          struct.comment = iprot.readString();
          struct.setCommentIsSet(true);
        }
        if (incoming.get(5)) {
          struct.framework = iprot.readString();
          struct.setFrameworkIsSet(true);
        }
        if (incoming.get(6)) {
          struct.frameworkVersion = iprot.readString();
          struct.setFrameworkVersionIsSet(true);
        }
        if (incoming.get(7)) {
          struct.dependencyType = iprot.readI32();
          struct.setDependencyTypeIsSet(true);
        }
        if (incoming.get(8)) {
          struct.childrenBlockSizeByte = iprot.readI64();
          struct.setChildrenBlockSizeByteIsSet(true);
        }
      }
    }

  }

  public static class user_createDependency_result implements org.apache.thrift.TBase<user_createDependency_result, user_createDependency_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_createDependency_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_createDependency_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField E_I_FIELD_DESC = new org.apache.thrift.protocol.TField("eI", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_F_FIELD_DESC = new org.apache.thrift.protocol.TField("eF", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_A_FIELD_DESC = new org.apache.thrift.protocol.TField("eA", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField E_T_FIELD_DESC = new org.apache.thrift.protocol.TField("eT", org.apache.thrift.protocol.TType.STRUCT, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_createDependency_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_createDependency_resultTupleSchemeFactory());
    }

    public int success; // required
    public InvalidPathException eI; // required
    public FileDoesNotExistException eF; // required
    public FileAlreadyExistException eA; // required
    public BlockInfoException eB; // required
    public TachyonException eT; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_I((short)1, "eI"),
      E_F((short)2, "eF"),
      E_A((short)3, "eA"),
      E_B((short)4, "eB"),
      E_T((short)5, "eT");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_I
            return E_I;
          case 2: // E_F
            return E_F;
          case 3: // E_A
            return E_A;
          case 4: // E_B
            return E_B;
          case 5: // E_T
            return E_T;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.E_I, new org.apache.thrift.meta_data.FieldMetaData("eI", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_F, new org.apache.thrift.meta_data.FieldMetaData("eF", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_A, new org.apache.thrift.meta_data.FieldMetaData("eA", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_T, new org.apache.thrift.meta_data.FieldMetaData("eT", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_createDependency_result.class, metaDataMap);
    }

    public user_createDependency_result() {
    }

    public user_createDependency_result(
      int success,
      InvalidPathException eI,
      FileDoesNotExistException eF,
      FileAlreadyExistException eA,
      BlockInfoException eB,
      TachyonException eT)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.eI = eI;
      this.eF = eF;
      this.eA = eA;
      this.eB = eB;
      this.eT = eT;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_createDependency_result(user_createDependency_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetEI()) {
        this.eI = new InvalidPathException(other.eI);
      }
      if (other.isSetEF()) {
        this.eF = new FileDoesNotExistException(other.eF);
      }
      if (other.isSetEA()) {
        this.eA = new FileAlreadyExistException(other.eA);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
      if (other.isSetET()) {
        this.eT = new TachyonException(other.eT);
      }
    }

    public user_createDependency_result deepCopy() {
      return new user_createDependency_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.eI = null;
      this.eF = null;
      this.eA = null;
      this.eB = null;
      this.eT = null;
    }

    public int getSuccess() {
      return this.success;
    }

    public user_createDependency_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public InvalidPathException getEI() {
      return this.eI;
    }

    public user_createDependency_result setEI(InvalidPathException eI) {
      this.eI = eI;
      return this;
    }

    public void unsetEI() {
      this.eI = null;
    }

    /** Returns true if field eI is set (has been assigned a value) and false otherwise */
    public boolean isSetEI() {
      return this.eI != null;
    }

    public void setEIIsSet(boolean value) {
      if (!value) {
        this.eI = null;
      }
    }

    public FileDoesNotExistException getEF() {
      return this.eF;
    }

    public user_createDependency_result setEF(FileDoesNotExistException eF) {
      this.eF = eF;
      return this;
    }

    public void unsetEF() {
      this.eF = null;
    }

    /** Returns true if field eF is set (has been assigned a value) and false otherwise */
    public boolean isSetEF() {
      return this.eF != null;
    }

    public void setEFIsSet(boolean value) {
      if (!value) {
        this.eF = null;
      }
    }

    public FileAlreadyExistException getEA() {
      return this.eA;
    }

    public user_createDependency_result setEA(FileAlreadyExistException eA) {
      this.eA = eA;
      return this;
    }

    public void unsetEA() {
      this.eA = null;
    }

    /** Returns true if field eA is set (has been assigned a value) and false otherwise */
    public boolean isSetEA() {
      return this.eA != null;
    }

    public void setEAIsSet(boolean value) {
      if (!value) {
        this.eA = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public user_createDependency_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public TachyonException getET() {
      return this.eT;
    }

    public user_createDependency_result setET(TachyonException eT) {
      this.eT = eT;
      return this;
    }

    public void unsetET() {
      this.eT = null;
    }

    /** Returns true if field eT is set (has been assigned a value) and false otherwise */
    public boolean isSetET() {
      return this.eT != null;
    }

    public void setETIsSet(boolean value) {
      if (!value) {
        this.eT = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Integer)value);
        }
        break;

      case E_I:
        if (value == null) {
          unsetEI();
        } else {
          setEI((InvalidPathException)value);
        }
        break;

      case E_F:
        if (value == null) {
          unsetEF();
        } else {
          setEF((FileDoesNotExistException)value);
        }
        break;

      case E_A:
        if (value == null) {
          unsetEA();
        } else {
          setEA((FileAlreadyExistException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      case E_T:
        if (value == null) {
          unsetET();
        } else {
          setET((TachyonException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Integer.valueOf(getSuccess());

      case E_I:
        return getEI();

      case E_F:
        return getEF();

      case E_A:
        return getEA();

      case E_B:
        return getEB();

      case E_T:
        return getET();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_I:
        return isSetEI();
      case E_F:
        return isSetEF();
      case E_A:
        return isSetEA();
      case E_B:
        return isSetEB();
      case E_T:
        return isSetET();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_createDependency_result)
        return this.equals((user_createDependency_result)that);
      return false;
    }

    public boolean equals(user_createDependency_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_eI = true && this.isSetEI();
      boolean that_present_eI = true && that.isSetEI();
      if (this_present_eI || that_present_eI) {
        if (!(this_present_eI && that_present_eI))
          return false;
        if (!this.eI.equals(that.eI))
          return false;
      }

      boolean this_present_eF = true && this.isSetEF();
      boolean that_present_eF = true && that.isSetEF();
      if (this_present_eF || that_present_eF) {
        if (!(this_present_eF && that_present_eF))
          return false;
        if (!this.eF.equals(that.eF))
          return false;
      }

      boolean this_present_eA = true && this.isSetEA();
      boolean that_present_eA = true && that.isSetEA();
      if (this_present_eA || that_present_eA) {
        if (!(this_present_eA && that_present_eA))
          return false;
        if (!this.eA.equals(that.eA))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      boolean this_present_eT = true && this.isSetET();
      boolean that_present_eT = true && that.isSetET();
      if (this_present_eT || that_present_eT) {
        if (!(this_present_eT && that_present_eT))
          return false;
        if (!this.eT.equals(that.eT))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_createDependency_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEI()).compareTo(other.isSetEI());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEI()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eI, other.eI);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEF()).compareTo(other.isSetEF());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEF()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eF, other.eF);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEA()).compareTo(other.isSetEA());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEA()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eA, other.eA);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetET()).compareTo(other.isSetET());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetET()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eT, other.eT);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_createDependency_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("eI:");
      if (this.eI == null) {
        sb.append("null");
      } else {
        sb.append(this.eI);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eF:");
      if (this.eF == null) {
        sb.append("null");
      } else {
        sb.append(this.eF);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eA:");
      if (this.eA == null) {
        sb.append("null");
      } else {
        sb.append(this.eA);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eT:");
      if (this.eT == null) {
        sb.append("null");
      } else {
        sb.append(this.eT);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_createDependency_resultStandardSchemeFactory implements SchemeFactory {
      public user_createDependency_resultStandardScheme getScheme() {
        return new user_createDependency_resultStandardScheme();
      }
    }

    private static class user_createDependency_resultStandardScheme extends StandardScheme<user_createDependency_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_createDependency_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.success = iprot.readI32();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_I
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eI = new InvalidPathException();
                struct.eI.read(iprot);
                struct.setEIIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_F
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eF = new FileDoesNotExistException();
                struct.eF.read(iprot);
                struct.setEFIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_A
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eA = new FileAlreadyExistException();
                struct.eA.read(iprot);
                struct.setEAIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // E_T
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eT = new TachyonException();
                struct.eT.read(iprot);
                struct.setETIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_createDependency_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI32(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eI != null) {
          oprot.writeFieldBegin(E_I_FIELD_DESC);
          struct.eI.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eF != null) {
          oprot.writeFieldBegin(E_F_FIELD_DESC);
          struct.eF.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eA != null) {
          oprot.writeFieldBegin(E_A_FIELD_DESC);
          struct.eA.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eT != null) {
          oprot.writeFieldBegin(E_T_FIELD_DESC);
          struct.eT.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_createDependency_resultTupleSchemeFactory implements SchemeFactory {
      public user_createDependency_resultTupleScheme getScheme() {
        return new user_createDependency_resultTupleScheme();
      }
    }

    private static class user_createDependency_resultTupleScheme extends TupleScheme<user_createDependency_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_createDependency_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEI()) {
          optionals.set(1);
        }
        if (struct.isSetEF()) {
          optionals.set(2);
        }
        if (struct.isSetEA()) {
          optionals.set(3);
        }
        if (struct.isSetEB()) {
          optionals.set(4);
        }
        if (struct.isSetET()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetSuccess()) {
          oprot.writeI32(struct.success);
        }
        if (struct.isSetEI()) {
          struct.eI.write(oprot);
        }
        if (struct.isSetEF()) {
          struct.eF.write(oprot);
        }
        if (struct.isSetEA()) {
          struct.eA.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
        if (struct.isSetET()) {
          struct.eT.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_createDependency_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.success = iprot.readI32();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eI = new InvalidPathException();
          struct.eI.read(iprot);
          struct.setEIIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eF = new FileDoesNotExistException();
          struct.eF.read(iprot);
          struct.setEFIsSet(true);
        }
        if (incoming.get(3)) {
          struct.eA = new FileAlreadyExistException();
          struct.eA.read(iprot);
          struct.setEAIsSet(true);
        }
        if (incoming.get(4)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
        if (incoming.get(5)) {
          struct.eT = new TachyonException();
          struct.eT.read(iprot);
          struct.setETIsSet(true);
        }
      }
    }

  }

  public static class user_getClientDependencyInfo_args implements org.apache.thrift.TBase<user_getClientDependencyInfo_args, user_getClientDependencyInfo_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_getClientDependencyInfo_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getClientDependencyInfo_args");

    private static final org.apache.thrift.protocol.TField DEPENDENCY_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("dependencyId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getClientDependencyInfo_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getClientDependencyInfo_argsTupleSchemeFactory());
    }

    public int dependencyId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DEPENDENCY_ID((short)1, "dependencyId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DEPENDENCY_ID
            return DEPENDENCY_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __DEPENDENCYID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DEPENDENCY_ID, new org.apache.thrift.meta_data.FieldMetaData("dependencyId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getClientDependencyInfo_args.class, metaDataMap);
    }

    public user_getClientDependencyInfo_args() {
    }

    public user_getClientDependencyInfo_args(
      int dependencyId)
    {
      this();
      this.dependencyId = dependencyId;
      setDependencyIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getClientDependencyInfo_args(user_getClientDependencyInfo_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.dependencyId = other.dependencyId;
    }

    public user_getClientDependencyInfo_args deepCopy() {
      return new user_getClientDependencyInfo_args(this);
    }

    @Override
    public void clear() {
      setDependencyIdIsSet(false);
      this.dependencyId = 0;
    }

    public int getDependencyId() {
      return this.dependencyId;
    }

    public user_getClientDependencyInfo_args setDependencyId(int dependencyId) {
      this.dependencyId = dependencyId;
      setDependencyIdIsSet(true);
      return this;
    }

    public void unsetDependencyId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __DEPENDENCYID_ISSET_ID);
    }

    /** Returns true if field dependencyId is set (has been assigned a value) and false otherwise */
    public boolean isSetDependencyId() {
      return EncodingUtils.testBit(__isset_bitfield, __DEPENDENCYID_ISSET_ID);
    }

    public void setDependencyIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __DEPENDENCYID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DEPENDENCY_ID:
        if (value == null) {
          unsetDependencyId();
        } else {
          setDependencyId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DEPENDENCY_ID:
        return Integer.valueOf(getDependencyId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DEPENDENCY_ID:
        return isSetDependencyId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getClientDependencyInfo_args)
        return this.equals((user_getClientDependencyInfo_args)that);
      return false;
    }

    public boolean equals(user_getClientDependencyInfo_args that) {
      if (that == null)
        return false;

      boolean this_present_dependencyId = true;
      boolean that_present_dependencyId = true;
      if (this_present_dependencyId || that_present_dependencyId) {
        if (!(this_present_dependencyId && that_present_dependencyId))
          return false;
        if (this.dependencyId != that.dependencyId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getClientDependencyInfo_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDependencyId()).compareTo(other.isSetDependencyId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDependencyId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dependencyId, other.dependencyId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getClientDependencyInfo_args(");
      boolean first = true;

      sb.append("dependencyId:");
      sb.append(this.dependencyId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getClientDependencyInfo_argsStandardSchemeFactory implements SchemeFactory {
      public user_getClientDependencyInfo_argsStandardScheme getScheme() {
        return new user_getClientDependencyInfo_argsStandardScheme();
      }
    }

    private static class user_getClientDependencyInfo_argsStandardScheme extends StandardScheme<user_getClientDependencyInfo_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getClientDependencyInfo_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DEPENDENCY_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.dependencyId = iprot.readI32();
                struct.setDependencyIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getClientDependencyInfo_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(DEPENDENCY_ID_FIELD_DESC);
        oprot.writeI32(struct.dependencyId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getClientDependencyInfo_argsTupleSchemeFactory implements SchemeFactory {
      public user_getClientDependencyInfo_argsTupleScheme getScheme() {
        return new user_getClientDependencyInfo_argsTupleScheme();
      }
    }

    private static class user_getClientDependencyInfo_argsTupleScheme extends TupleScheme<user_getClientDependencyInfo_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getClientDependencyInfo_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetDependencyId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetDependencyId()) {
          oprot.writeI32(struct.dependencyId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getClientDependencyInfo_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.dependencyId = iprot.readI32();
          struct.setDependencyIdIsSet(true);
        }
      }
    }

  }

  public static class user_getClientDependencyInfo_result implements org.apache.thrift.TBase<user_getClientDependencyInfo_result, user_getClientDependencyInfo_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_getClientDependencyInfo_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getClientDependencyInfo_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getClientDependencyInfo_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getClientDependencyInfo_resultTupleSchemeFactory());
    }

    public ClientDependencyInfo success; // required
    public DependencyDoesNotExistException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ClientDependencyInfo.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getClientDependencyInfo_result.class, metaDataMap);
    }

    public user_getClientDependencyInfo_result() {
    }

    public user_getClientDependencyInfo_result(
      ClientDependencyInfo success,
      DependencyDoesNotExistException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getClientDependencyInfo_result(user_getClientDependencyInfo_result other) {
      if (other.isSetSuccess()) {
        this.success = new ClientDependencyInfo(other.success);
      }
      if (other.isSetE()) {
        this.e = new DependencyDoesNotExistException(other.e);
      }
    }

    public user_getClientDependencyInfo_result deepCopy() {
      return new user_getClientDependencyInfo_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public ClientDependencyInfo getSuccess() {
      return this.success;
    }

    public user_getClientDependencyInfo_result setSuccess(ClientDependencyInfo success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public DependencyDoesNotExistException getE() {
      return this.e;
    }

    public user_getClientDependencyInfo_result setE(DependencyDoesNotExistException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ClientDependencyInfo)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((DependencyDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getClientDependencyInfo_result)
        return this.equals((user_getClientDependencyInfo_result)that);
      return false;
    }

    public boolean equals(user_getClientDependencyInfo_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getClientDependencyInfo_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getClientDependencyInfo_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getClientDependencyInfo_resultStandardSchemeFactory implements SchemeFactory {
      public user_getClientDependencyInfo_resultStandardScheme getScheme() {
        return new user_getClientDependencyInfo_resultStandardScheme();
      }
    }

    private static class user_getClientDependencyInfo_resultStandardScheme extends StandardScheme<user_getClientDependencyInfo_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getClientDependencyInfo_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ClientDependencyInfo();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new DependencyDoesNotExistException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getClientDependencyInfo_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getClientDependencyInfo_resultTupleSchemeFactory implements SchemeFactory {
      public user_getClientDependencyInfo_resultTupleScheme getScheme() {
        return new user_getClientDependencyInfo_resultTupleScheme();
      }
    }

    private static class user_getClientDependencyInfo_resultTupleScheme extends TupleScheme<user_getClientDependencyInfo_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getClientDependencyInfo_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getClientDependencyInfo_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ClientDependencyInfo();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new DependencyDoesNotExistException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_reportLostFile_args implements org.apache.thrift.TBase<user_reportLostFile_args, user_reportLostFile_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_reportLostFile_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_reportLostFile_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_reportLostFile_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_reportLostFile_argsTupleSchemeFactory());
    }

    public int fileId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_reportLostFile_args.class, metaDataMap);
    }

    public user_reportLostFile_args() {
    }

    public user_reportLostFile_args(
      int fileId)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_reportLostFile_args(user_reportLostFile_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
    }

    public user_reportLostFile_args deepCopy() {
      return new user_reportLostFile_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_reportLostFile_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_reportLostFile_args)
        return this.equals((user_reportLostFile_args)that);
      return false;
    }

    public boolean equals(user_reportLostFile_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_reportLostFile_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_reportLostFile_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_reportLostFile_argsStandardSchemeFactory implements SchemeFactory {
      public user_reportLostFile_argsStandardScheme getScheme() {
        return new user_reportLostFile_argsStandardScheme();
      }
    }

    private static class user_reportLostFile_argsStandardScheme extends StandardScheme<user_reportLostFile_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_reportLostFile_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_reportLostFile_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_reportLostFile_argsTupleSchemeFactory implements SchemeFactory {
      public user_reportLostFile_argsTupleScheme getScheme() {
        return new user_reportLostFile_argsTupleScheme();
      }
    }

    private static class user_reportLostFile_argsTupleScheme extends TupleScheme<user_reportLostFile_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_reportLostFile_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_reportLostFile_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
      }
    }

  }

  public static class user_reportLostFile_result implements org.apache.thrift.TBase<user_reportLostFile_result, user_reportLostFile_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_reportLostFile_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_reportLostFile_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_reportLostFile_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_reportLostFile_resultTupleSchemeFactory());
    }

    public FileDoesNotExistException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_reportLostFile_result.class, metaDataMap);
    }

    public user_reportLostFile_result() {
    }

    public user_reportLostFile_result(
      FileDoesNotExistException e)
    {
      this();
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_reportLostFile_result(user_reportLostFile_result other) {
      if (other.isSetE()) {
        this.e = new FileDoesNotExistException(other.e);
      }
    }

    public user_reportLostFile_result deepCopy() {
      return new user_reportLostFile_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
    }

    public FileDoesNotExistException getE() {
      return this.e;
    }

    public user_reportLostFile_result setE(FileDoesNotExistException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_reportLostFile_result)
        return this.equals((user_reportLostFile_result)that);
      return false;
    }

    public boolean equals(user_reportLostFile_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_reportLostFile_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_reportLostFile_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_reportLostFile_resultStandardSchemeFactory implements SchemeFactory {
      public user_reportLostFile_resultStandardScheme getScheme() {
        return new user_reportLostFile_resultStandardScheme();
      }
    }

    private static class user_reportLostFile_resultStandardScheme extends StandardScheme<user_reportLostFile_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_reportLostFile_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new FileDoesNotExistException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_reportLostFile_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_reportLostFile_resultTupleSchemeFactory implements SchemeFactory {
      public user_reportLostFile_resultTupleScheme getScheme() {
        return new user_reportLostFile_resultTupleScheme();
      }
    }

    private static class user_reportLostFile_resultTupleScheme extends TupleScheme<user_reportLostFile_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_reportLostFile_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetE()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_reportLostFile_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.e = new FileDoesNotExistException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_requestFilesInDependency_args implements org.apache.thrift.TBase<user_requestFilesInDependency_args, user_requestFilesInDependency_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_requestFilesInDependency_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_requestFilesInDependency_args");

    private static final org.apache.thrift.protocol.TField DEP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("depId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_requestFilesInDependency_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_requestFilesInDependency_argsTupleSchemeFactory());
    }

    public int depId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DEP_ID((short)1, "depId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DEP_ID
            return DEP_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __DEPID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DEP_ID, new org.apache.thrift.meta_data.FieldMetaData("depId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_requestFilesInDependency_args.class, metaDataMap);
    }

    public user_requestFilesInDependency_args() {
    }

    public user_requestFilesInDependency_args(
      int depId)
    {
      this();
      this.depId = depId;
      setDepIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_requestFilesInDependency_args(user_requestFilesInDependency_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.depId = other.depId;
    }

    public user_requestFilesInDependency_args deepCopy() {
      return new user_requestFilesInDependency_args(this);
    }

    @Override
    public void clear() {
      setDepIdIsSet(false);
      this.depId = 0;
    }

    public int getDepId() {
      return this.depId;
    }

    public user_requestFilesInDependency_args setDepId(int depId) {
      this.depId = depId;
      setDepIdIsSet(true);
      return this;
    }

    public void unsetDepId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __DEPID_ISSET_ID);
    }

    /** Returns true if field depId is set (has been assigned a value) and false otherwise */
    public boolean isSetDepId() {
      return EncodingUtils.testBit(__isset_bitfield, __DEPID_ISSET_ID);
    }

    public void setDepIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __DEPID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DEP_ID:
        if (value == null) {
          unsetDepId();
        } else {
          setDepId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DEP_ID:
        return Integer.valueOf(getDepId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DEP_ID:
        return isSetDepId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_requestFilesInDependency_args)
        return this.equals((user_requestFilesInDependency_args)that);
      return false;
    }

    public boolean equals(user_requestFilesInDependency_args that) {
      if (that == null)
        return false;

      boolean this_present_depId = true;
      boolean that_present_depId = true;
      if (this_present_depId || that_present_depId) {
        if (!(this_present_depId && that_present_depId))
          return false;
        if (this.depId != that.depId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_requestFilesInDependency_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDepId()).compareTo(other.isSetDepId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDepId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.depId, other.depId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_requestFilesInDependency_args(");
      boolean first = true;

      sb.append("depId:");
      sb.append(this.depId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_requestFilesInDependency_argsStandardSchemeFactory implements SchemeFactory {
      public user_requestFilesInDependency_argsStandardScheme getScheme() {
        return new user_requestFilesInDependency_argsStandardScheme();
      }
    }

    private static class user_requestFilesInDependency_argsStandardScheme extends StandardScheme<user_requestFilesInDependency_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_requestFilesInDependency_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DEP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.depId = iprot.readI32();
                struct.setDepIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_requestFilesInDependency_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(DEP_ID_FIELD_DESC);
        oprot.writeI32(struct.depId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_requestFilesInDependency_argsTupleSchemeFactory implements SchemeFactory {
      public user_requestFilesInDependency_argsTupleScheme getScheme() {
        return new user_requestFilesInDependency_argsTupleScheme();
      }
    }

    private static class user_requestFilesInDependency_argsTupleScheme extends TupleScheme<user_requestFilesInDependency_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_requestFilesInDependency_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetDepId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetDepId()) {
          oprot.writeI32(struct.depId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_requestFilesInDependency_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.depId = iprot.readI32();
          struct.setDepIdIsSet(true);
        }
      }
    }

  }

  public static class user_requestFilesInDependency_result implements org.apache.thrift.TBase<user_requestFilesInDependency_result, user_requestFilesInDependency_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_requestFilesInDependency_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_requestFilesInDependency_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_requestFilesInDependency_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_requestFilesInDependency_resultTupleSchemeFactory());
    }

    public DependencyDoesNotExistException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_requestFilesInDependency_result.class, metaDataMap);
    }

    public user_requestFilesInDependency_result() {
    }

    public user_requestFilesInDependency_result(
      DependencyDoesNotExistException e)
    {
      this();
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_requestFilesInDependency_result(user_requestFilesInDependency_result other) {
      if (other.isSetE()) {
        this.e = new DependencyDoesNotExistException(other.e);
      }
    }

    public user_requestFilesInDependency_result deepCopy() {
      return new user_requestFilesInDependency_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
    }

    public DependencyDoesNotExistException getE() {
      return this.e;
    }

    public user_requestFilesInDependency_result setE(DependencyDoesNotExistException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((DependencyDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_requestFilesInDependency_result)
        return this.equals((user_requestFilesInDependency_result)that);
      return false;
    }

    public boolean equals(user_requestFilesInDependency_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_requestFilesInDependency_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_requestFilesInDependency_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_requestFilesInDependency_resultStandardSchemeFactory implements SchemeFactory {
      public user_requestFilesInDependency_resultStandardScheme getScheme() {
        return new user_requestFilesInDependency_resultStandardScheme();
      }
    }

    private static class user_requestFilesInDependency_resultStandardScheme extends StandardScheme<user_requestFilesInDependency_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_requestFilesInDependency_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new DependencyDoesNotExistException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_requestFilesInDependency_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_requestFilesInDependency_resultTupleSchemeFactory implements SchemeFactory {
      public user_requestFilesInDependency_resultTupleScheme getScheme() {
        return new user_requestFilesInDependency_resultTupleScheme();
      }
    }

    private static class user_requestFilesInDependency_resultTupleScheme extends TupleScheme<user_requestFilesInDependency_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_requestFilesInDependency_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetE()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_requestFilesInDependency_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.e = new DependencyDoesNotExistException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_createFile_args implements org.apache.thrift.TBase<user_createFile_args, user_createFile_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_createFile_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_createFile_args");

    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField UFS_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("ufsPath", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField BLOCK_SIZE_BYTE_FIELD_DESC = new org.apache.thrift.protocol.TField("blockSizeByte", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField RECURSIVE_FIELD_DESC = new org.apache.thrift.protocol.TField("recursive", org.apache.thrift.protocol.TType.BOOL, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_createFile_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_createFile_argsTupleSchemeFactory());
    }

    public String path; // required
    public String ufsPath; // required
    public long blockSizeByte; // required
    public boolean recursive; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      PATH((short)1, "path"),
      UFS_PATH((short)2, "ufsPath"),
      BLOCK_SIZE_BYTE((short)3, "blockSizeByte"),
      RECURSIVE((short)4, "recursive");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // PATH
            return PATH;
          case 2: // UFS_PATH
            return UFS_PATH;
          case 3: // BLOCK_SIZE_BYTE
            return BLOCK_SIZE_BYTE;
          case 4: // RECURSIVE
            return RECURSIVE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BLOCKSIZEBYTE_ISSET_ID = 0;
    private static final int __RECURSIVE_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.UFS_PATH, new org.apache.thrift.meta_data.FieldMetaData("ufsPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.BLOCK_SIZE_BYTE, new org.apache.thrift.meta_data.FieldMetaData("blockSizeByte", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.RECURSIVE, new org.apache.thrift.meta_data.FieldMetaData("recursive", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_createFile_args.class, metaDataMap);
    }

    public user_createFile_args() {
    }

    public user_createFile_args(
      String path,
      String ufsPath,
      long blockSizeByte,
      boolean recursive)
    {
      this();
      this.path = path;
      this.ufsPath = ufsPath;
      this.blockSizeByte = blockSizeByte;
      setBlockSizeByteIsSet(true);
      this.recursive = recursive;
      setRecursiveIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_createFile_args(user_createFile_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetPath()) {
        this.path = other.path;
      }
      if (other.isSetUfsPath()) {
        this.ufsPath = other.ufsPath;
      }
      this.blockSizeByte = other.blockSizeByte;
      this.recursive = other.recursive;
    }

    public user_createFile_args deepCopy() {
      return new user_createFile_args(this);
    }

    @Override
    public void clear() {
      this.path = null;
      this.ufsPath = null;
      setBlockSizeByteIsSet(false);
      this.blockSizeByte = 0;
      setRecursiveIsSet(false);
      this.recursive = false;
    }

    public String getPath() {
      return this.path;
    }

    public user_createFile_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public String getUfsPath() {
      return this.ufsPath;
    }

    public user_createFile_args setUfsPath(String ufsPath) {
      this.ufsPath = ufsPath;
      return this;
    }

    public void unsetUfsPath() {
      this.ufsPath = null;
    }

    /** Returns true if field ufsPath is set (has been assigned a value) and false otherwise */
    public boolean isSetUfsPath() {
      return this.ufsPath != null;
    }

    public void setUfsPathIsSet(boolean value) {
      if (!value) {
        this.ufsPath = null;
      }
    }

    public long getBlockSizeByte() {
      return this.blockSizeByte;
    }

    public user_createFile_args setBlockSizeByte(long blockSizeByte) {
      this.blockSizeByte = blockSizeByte;
      setBlockSizeByteIsSet(true);
      return this;
    }

    public void unsetBlockSizeByte() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKSIZEBYTE_ISSET_ID);
    }

    /** Returns true if field blockSizeByte is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockSizeByte() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKSIZEBYTE_ISSET_ID);
    }

    public void setBlockSizeByteIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKSIZEBYTE_ISSET_ID, value);
    }

    public boolean isRecursive() {
      return this.recursive;
    }

    public user_createFile_args setRecursive(boolean recursive) {
      this.recursive = recursive;
      setRecursiveIsSet(true);
      return this;
    }

    public void unsetRecursive() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __RECURSIVE_ISSET_ID);
    }

    /** Returns true if field recursive is set (has been assigned a value) and false otherwise */
    public boolean isSetRecursive() {
      return EncodingUtils.testBit(__isset_bitfield, __RECURSIVE_ISSET_ID);
    }

    public void setRecursiveIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __RECURSIVE_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case UFS_PATH:
        if (value == null) {
          unsetUfsPath();
        } else {
          setUfsPath((String)value);
        }
        break;

      case BLOCK_SIZE_BYTE:
        if (value == null) {
          unsetBlockSizeByte();
        } else {
          setBlockSizeByte((Long)value);
        }
        break;

      case RECURSIVE:
        if (value == null) {
          unsetRecursive();
        } else {
          setRecursive((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case PATH:
        return getPath();

      case UFS_PATH:
        return getUfsPath();

      case BLOCK_SIZE_BYTE:
        return Long.valueOf(getBlockSizeByte());

      case RECURSIVE:
        return Boolean.valueOf(isRecursive());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case PATH:
        return isSetPath();
      case UFS_PATH:
        return isSetUfsPath();
      case BLOCK_SIZE_BYTE:
        return isSetBlockSizeByte();
      case RECURSIVE:
        return isSetRecursive();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_createFile_args)
        return this.equals((user_createFile_args)that);
      return false;
    }

    public boolean equals(user_createFile_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_ufsPath = true && this.isSetUfsPath();
      boolean that_present_ufsPath = true && that.isSetUfsPath();
      if (this_present_ufsPath || that_present_ufsPath) {
        if (!(this_present_ufsPath && that_present_ufsPath))
          return false;
        if (!this.ufsPath.equals(that.ufsPath))
          return false;
      }

      boolean this_present_blockSizeByte = true;
      boolean that_present_blockSizeByte = true;
      if (this_present_blockSizeByte || that_present_blockSizeByte) {
        if (!(this_present_blockSizeByte && that_present_blockSizeByte))
          return false;
        if (this.blockSizeByte != that.blockSizeByte)
          return false;
      }

      boolean this_present_recursive = true;
      boolean that_present_recursive = true;
      if (this_present_recursive || that_present_recursive) {
        if (!(this_present_recursive && that_present_recursive))
          return false;
        if (this.recursive != that.recursive)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_createFile_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetPath()).compareTo(other.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, other.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUfsPath()).compareTo(other.isSetUfsPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUfsPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ufsPath, other.ufsPath);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBlockSizeByte()).compareTo(other.isSetBlockSizeByte());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockSizeByte()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockSizeByte, other.blockSizeByte);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRecursive()).compareTo(other.isSetRecursive());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRecursive()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.recursive, other.recursive);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_createFile_args(");
      boolean first = true;

      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ufsPath:");
      if (this.ufsPath == null) {
        sb.append("null");
      } else {
        sb.append(this.ufsPath);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("blockSizeByte:");
      sb.append(this.blockSizeByte);
      first = false;
      if (!first) sb.append(", ");
      sb.append("recursive:");
      sb.append(this.recursive);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_createFile_argsStandardSchemeFactory implements SchemeFactory {
      public user_createFile_argsStandardScheme getScheme() {
        return new user_createFile_argsStandardScheme();
      }
    }

    private static class user_createFile_argsStandardScheme extends StandardScheme<user_createFile_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_createFile_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // UFS_PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.ufsPath = iprot.readString();
                struct.setUfsPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // BLOCK_SIZE_BYTE
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockSizeByte = iprot.readI64();
                struct.setBlockSizeByteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // RECURSIVE
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.recursive = iprot.readBool();
                struct.setRecursiveIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_createFile_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        if (struct.ufsPath != null) {
          oprot.writeFieldBegin(UFS_PATH_FIELD_DESC);
          oprot.writeString(struct.ufsPath);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(BLOCK_SIZE_BYTE_FIELD_DESC);
        oprot.writeI64(struct.blockSizeByte);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(RECURSIVE_FIELD_DESC);
        oprot.writeBool(struct.recursive);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_createFile_argsTupleSchemeFactory implements SchemeFactory {
      public user_createFile_argsTupleScheme getScheme() {
        return new user_createFile_argsTupleScheme();
      }
    }

    private static class user_createFile_argsTupleScheme extends TupleScheme<user_createFile_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_createFile_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetPath()) {
          optionals.set(0);
        }
        if (struct.isSetUfsPath()) {
          optionals.set(1);
        }
        if (struct.isSetBlockSizeByte()) {
          optionals.set(2);
        }
        if (struct.isSetRecursive()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetUfsPath()) {
          oprot.writeString(struct.ufsPath);
        }
        if (struct.isSetBlockSizeByte()) {
          oprot.writeI64(struct.blockSizeByte);
        }
        if (struct.isSetRecursive()) {
          oprot.writeBool(struct.recursive);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_createFile_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ufsPath = iprot.readString();
          struct.setUfsPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.blockSizeByte = iprot.readI64();
          struct.setBlockSizeByteIsSet(true);
        }
        if (incoming.get(3)) {
          struct.recursive = iprot.readBool();
          struct.setRecursiveIsSet(true);
        }
      }
    }

  }

  public static class user_createFile_result implements org.apache.thrift.TBase<user_createFile_result, user_createFile_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_createFile_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_createFile_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField E_R_FIELD_DESC = new org.apache.thrift.protocol.TField("eR", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_I_FIELD_DESC = new org.apache.thrift.protocol.TField("eI", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField E_S_FIELD_DESC = new org.apache.thrift.protocol.TField("eS", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField E_T_FIELD_DESC = new org.apache.thrift.protocol.TField("eT", org.apache.thrift.protocol.TType.STRUCT, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_createFile_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_createFile_resultTupleSchemeFactory());
    }

    public int success; // required
    public FileAlreadyExistException eR; // required
    public InvalidPathException eI; // required
    public BlockInfoException eB; // required
    public SuspectedFileSizeException eS; // required
    public TachyonException eT; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_R((short)1, "eR"),
      E_I((short)2, "eI"),
      E_B((short)3, "eB"),
      E_S((short)4, "eS"),
      E_T((short)5, "eT");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_R
            return E_R;
          case 2: // E_I
            return E_I;
          case 3: // E_B
            return E_B;
          case 4: // E_S
            return E_S;
          case 5: // E_T
            return E_T;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.E_R, new org.apache.thrift.meta_data.FieldMetaData("eR", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_I, new org.apache.thrift.meta_data.FieldMetaData("eI", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_S, new org.apache.thrift.meta_data.FieldMetaData("eS", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_T, new org.apache.thrift.meta_data.FieldMetaData("eT", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_createFile_result.class, metaDataMap);
    }

    public user_createFile_result() {
    }

    public user_createFile_result(
      int success,
      FileAlreadyExistException eR,
      InvalidPathException eI,
      BlockInfoException eB,
      SuspectedFileSizeException eS,
      TachyonException eT)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.eR = eR;
      this.eI = eI;
      this.eB = eB;
      this.eS = eS;
      this.eT = eT;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_createFile_result(user_createFile_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetER()) {
        this.eR = new FileAlreadyExistException(other.eR);
      }
      if (other.isSetEI()) {
        this.eI = new InvalidPathException(other.eI);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
      if (other.isSetES()) {
        this.eS = new SuspectedFileSizeException(other.eS);
      }
      if (other.isSetET()) {
        this.eT = new TachyonException(other.eT);
      }
    }

    public user_createFile_result deepCopy() {
      return new user_createFile_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.eR = null;
      this.eI = null;
      this.eB = null;
      this.eS = null;
      this.eT = null;
    }

    public int getSuccess() {
      return this.success;
    }

    public user_createFile_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public FileAlreadyExistException getER() {
      return this.eR;
    }

    public user_createFile_result setER(FileAlreadyExistException eR) {
      this.eR = eR;
      return this;
    }

    public void unsetER() {
      this.eR = null;
    }

    /** Returns true if field eR is set (has been assigned a value) and false otherwise */
    public boolean isSetER() {
      return this.eR != null;
    }

    public void setERIsSet(boolean value) {
      if (!value) {
        this.eR = null;
      }
    }

    public InvalidPathException getEI() {
      return this.eI;
    }

    public user_createFile_result setEI(InvalidPathException eI) {
      this.eI = eI;
      return this;
    }

    public void unsetEI() {
      this.eI = null;
    }

    /** Returns true if field eI is set (has been assigned a value) and false otherwise */
    public boolean isSetEI() {
      return this.eI != null;
    }

    public void setEIIsSet(boolean value) {
      if (!value) {
        this.eI = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public user_createFile_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public SuspectedFileSizeException getES() {
      return this.eS;
    }

    public user_createFile_result setES(SuspectedFileSizeException eS) {
      this.eS = eS;
      return this;
    }

    public void unsetES() {
      this.eS = null;
    }

    /** Returns true if field eS is set (has been assigned a value) and false otherwise */
    public boolean isSetES() {
      return this.eS != null;
    }

    public void setESIsSet(boolean value) {
      if (!value) {
        this.eS = null;
      }
    }

    public TachyonException getET() {
      return this.eT;
    }

    public user_createFile_result setET(TachyonException eT) {
      this.eT = eT;
      return this;
    }

    public void unsetET() {
      this.eT = null;
    }

    /** Returns true if field eT is set (has been assigned a value) and false otherwise */
    public boolean isSetET() {
      return this.eT != null;
    }

    public void setETIsSet(boolean value) {
      if (!value) {
        this.eT = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Integer)value);
        }
        break;

      case E_R:
        if (value == null) {
          unsetER();
        } else {
          setER((FileAlreadyExistException)value);
        }
        break;

      case E_I:
        if (value == null) {
          unsetEI();
        } else {
          setEI((InvalidPathException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      case E_S:
        if (value == null) {
          unsetES();
        } else {
          setES((SuspectedFileSizeException)value);
        }
        break;

      case E_T:
        if (value == null) {
          unsetET();
        } else {
          setET((TachyonException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Integer.valueOf(getSuccess());

      case E_R:
        return getER();

      case E_I:
        return getEI();

      case E_B:
        return getEB();

      case E_S:
        return getES();

      case E_T:
        return getET();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_R:
        return isSetER();
      case E_I:
        return isSetEI();
      case E_B:
        return isSetEB();
      case E_S:
        return isSetES();
      case E_T:
        return isSetET();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_createFile_result)
        return this.equals((user_createFile_result)that);
      return false;
    }

    public boolean equals(user_createFile_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_eR = true && this.isSetER();
      boolean that_present_eR = true && that.isSetER();
      if (this_present_eR || that_present_eR) {
        if (!(this_present_eR && that_present_eR))
          return false;
        if (!this.eR.equals(that.eR))
          return false;
      }

      boolean this_present_eI = true && this.isSetEI();
      boolean that_present_eI = true && that.isSetEI();
      if (this_present_eI || that_present_eI) {
        if (!(this_present_eI && that_present_eI))
          return false;
        if (!this.eI.equals(that.eI))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      boolean this_present_eS = true && this.isSetES();
      boolean that_present_eS = true && that.isSetES();
      if (this_present_eS || that_present_eS) {
        if (!(this_present_eS && that_present_eS))
          return false;
        if (!this.eS.equals(that.eS))
          return false;
      }

      boolean this_present_eT = true && this.isSetET();
      boolean that_present_eT = true && that.isSetET();
      if (this_present_eT || that_present_eT) {
        if (!(this_present_eT && that_present_eT))
          return false;
        if (!this.eT.equals(that.eT))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_createFile_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetER()).compareTo(other.isSetER());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetER()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eR, other.eR);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEI()).compareTo(other.isSetEI());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEI()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eI, other.eI);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetES()).compareTo(other.isSetES());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetES()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eS, other.eS);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetET()).compareTo(other.isSetET());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetET()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eT, other.eT);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_createFile_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("eR:");
      if (this.eR == null) {
        sb.append("null");
      } else {
        sb.append(this.eR);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eI:");
      if (this.eI == null) {
        sb.append("null");
      } else {
        sb.append(this.eI);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eS:");
      if (this.eS == null) {
        sb.append("null");
      } else {
        sb.append(this.eS);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eT:");
      if (this.eT == null) {
        sb.append("null");
      } else {
        sb.append(this.eT);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_createFile_resultStandardSchemeFactory implements SchemeFactory {
      public user_createFile_resultStandardScheme getScheme() {
        return new user_createFile_resultStandardScheme();
      }
    }

    private static class user_createFile_resultStandardScheme extends StandardScheme<user_createFile_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_createFile_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.success = iprot.readI32();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_R
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eR = new FileAlreadyExistException();
                struct.eR.read(iprot);
                struct.setERIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_I
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eI = new InvalidPathException();
                struct.eI.read(iprot);
                struct.setEIIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // E_S
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eS = new SuspectedFileSizeException();
                struct.eS.read(iprot);
                struct.setESIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // E_T
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eT = new TachyonException();
                struct.eT.read(iprot);
                struct.setETIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_createFile_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI32(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eR != null) {
          oprot.writeFieldBegin(E_R_FIELD_DESC);
          struct.eR.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eI != null) {
          oprot.writeFieldBegin(E_I_FIELD_DESC);
          struct.eI.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eS != null) {
          oprot.writeFieldBegin(E_S_FIELD_DESC);
          struct.eS.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eT != null) {
          oprot.writeFieldBegin(E_T_FIELD_DESC);
          struct.eT.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_createFile_resultTupleSchemeFactory implements SchemeFactory {
      public user_createFile_resultTupleScheme getScheme() {
        return new user_createFile_resultTupleScheme();
      }
    }

    private static class user_createFile_resultTupleScheme extends TupleScheme<user_createFile_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_createFile_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetER()) {
          optionals.set(1);
        }
        if (struct.isSetEI()) {
          optionals.set(2);
        }
        if (struct.isSetEB()) {
          optionals.set(3);
        }
        if (struct.isSetES()) {
          optionals.set(4);
        }
        if (struct.isSetET()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetSuccess()) {
          oprot.writeI32(struct.success);
        }
        if (struct.isSetER()) {
          struct.eR.write(oprot);
        }
        if (struct.isSetEI()) {
          struct.eI.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
        if (struct.isSetES()) {
          struct.eS.write(oprot);
        }
        if (struct.isSetET()) {
          struct.eT.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_createFile_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.success = iprot.readI32();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eR = new FileAlreadyExistException();
          struct.eR.read(iprot);
          struct.setERIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eI = new InvalidPathException();
          struct.eI.read(iprot);
          struct.setEIIsSet(true);
        }
        if (incoming.get(3)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
        if (incoming.get(4)) {
          struct.eS = new SuspectedFileSizeException();
          struct.eS.read(iprot);
          struct.setESIsSet(true);
        }
        if (incoming.get(5)) {
          struct.eT = new TachyonException();
          struct.eT.read(iprot);
          struct.setETIsSet(true);
        }
      }
    }

  }

  public static class user_createNewBlock_args implements org.apache.thrift.TBase<user_createNewBlock_args, user_createNewBlock_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_createNewBlock_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_createNewBlock_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_createNewBlock_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_createNewBlock_argsTupleSchemeFactory());
    }

    public int fileId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_createNewBlock_args.class, metaDataMap);
    }

    public user_createNewBlock_args() {
    }

    public user_createNewBlock_args(
      int fileId)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_createNewBlock_args(user_createNewBlock_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
    }

    public user_createNewBlock_args deepCopy() {
      return new user_createNewBlock_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_createNewBlock_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_createNewBlock_args)
        return this.equals((user_createNewBlock_args)that);
      return false;
    }

    public boolean equals(user_createNewBlock_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_createNewBlock_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_createNewBlock_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_createNewBlock_argsStandardSchemeFactory implements SchemeFactory {
      public user_createNewBlock_argsStandardScheme getScheme() {
        return new user_createNewBlock_argsStandardScheme();
      }
    }

    private static class user_createNewBlock_argsStandardScheme extends StandardScheme<user_createNewBlock_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_createNewBlock_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_createNewBlock_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_createNewBlock_argsTupleSchemeFactory implements SchemeFactory {
      public user_createNewBlock_argsTupleScheme getScheme() {
        return new user_createNewBlock_argsTupleScheme();
      }
    }

    private static class user_createNewBlock_argsTupleScheme extends TupleScheme<user_createNewBlock_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_createNewBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_createNewBlock_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
      }
    }

  }

  public static class user_createNewBlock_result implements org.apache.thrift.TBase<user_createNewBlock_result, user_createNewBlock_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_createNewBlock_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_createNewBlock_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_createNewBlock_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_createNewBlock_resultTupleSchemeFactory());
    }

    public long success; // required
    public FileDoesNotExistException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_createNewBlock_result.class, metaDataMap);
    }

    public user_createNewBlock_result() {
    }

    public user_createNewBlock_result(
      long success,
      FileDoesNotExistException e)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_createNewBlock_result(user_createNewBlock_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetE()) {
        this.e = new FileDoesNotExistException(other.e);
      }
    }

    public user_createNewBlock_result deepCopy() {
      return new user_createNewBlock_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.e = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public user_createNewBlock_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public FileDoesNotExistException getE() {
      return this.e;
    }

    public user_createNewBlock_result setE(FileDoesNotExistException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Long.valueOf(getSuccess());

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_createNewBlock_result)
        return this.equals((user_createNewBlock_result)that);
      return false;
    }

    public boolean equals(user_createNewBlock_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_createNewBlock_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_createNewBlock_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_createNewBlock_resultStandardSchemeFactory implements SchemeFactory {
      public user_createNewBlock_resultStandardScheme getScheme() {
        return new user_createNewBlock_resultStandardScheme();
      }
    }

    private static class user_createNewBlock_resultStandardScheme extends StandardScheme<user_createNewBlock_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_createNewBlock_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new FileDoesNotExistException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_createNewBlock_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_createNewBlock_resultTupleSchemeFactory implements SchemeFactory {
      public user_createNewBlock_resultTupleScheme getScheme() {
        return new user_createNewBlock_resultTupleScheme();
      }
    }

    private static class user_createNewBlock_resultTupleScheme extends TupleScheme<user_createNewBlock_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_createNewBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_createNewBlock_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new FileDoesNotExistException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_completeFile_args implements org.apache.thrift.TBase<user_completeFile_args, user_completeFile_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_completeFile_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_completeFile_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_completeFile_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_completeFile_argsTupleSchemeFactory());
    }

    public int fileId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_completeFile_args.class, metaDataMap);
    }

    public user_completeFile_args() {
    }

    public user_completeFile_args(
      int fileId)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_completeFile_args(user_completeFile_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
    }

    public user_completeFile_args deepCopy() {
      return new user_completeFile_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_completeFile_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_completeFile_args)
        return this.equals((user_completeFile_args)that);
      return false;
    }

    public boolean equals(user_completeFile_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_completeFile_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_completeFile_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_completeFile_argsStandardSchemeFactory implements SchemeFactory {
      public user_completeFile_argsStandardScheme getScheme() {
        return new user_completeFile_argsStandardScheme();
      }
    }

    private static class user_completeFile_argsStandardScheme extends StandardScheme<user_completeFile_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_completeFile_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_completeFile_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_completeFile_argsTupleSchemeFactory implements SchemeFactory {
      public user_completeFile_argsTupleScheme getScheme() {
        return new user_completeFile_argsTupleScheme();
      }
    }

    private static class user_completeFile_argsTupleScheme extends TupleScheme<user_completeFile_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_completeFile_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_completeFile_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
      }
    }

  }

  public static class user_completeFile_result implements org.apache.thrift.TBase<user_completeFile_result, user_completeFile_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_completeFile_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_completeFile_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_completeFile_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_completeFile_resultTupleSchemeFactory());
    }

    public FileDoesNotExistException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_completeFile_result.class, metaDataMap);
    }

    public user_completeFile_result() {
    }

    public user_completeFile_result(
      FileDoesNotExistException e)
    {
      this();
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_completeFile_result(user_completeFile_result other) {
      if (other.isSetE()) {
        this.e = new FileDoesNotExistException(other.e);
      }
    }

    public user_completeFile_result deepCopy() {
      return new user_completeFile_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
    }

    public FileDoesNotExistException getE() {
      return this.e;
    }

    public user_completeFile_result setE(FileDoesNotExistException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_completeFile_result)
        return this.equals((user_completeFile_result)that);
      return false;
    }

    public boolean equals(user_completeFile_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_completeFile_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_completeFile_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_completeFile_resultStandardSchemeFactory implements SchemeFactory {
      public user_completeFile_resultStandardScheme getScheme() {
        return new user_completeFile_resultStandardScheme();
      }
    }

    private static class user_completeFile_resultStandardScheme extends StandardScheme<user_completeFile_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_completeFile_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new FileDoesNotExistException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_completeFile_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_completeFile_resultTupleSchemeFactory implements SchemeFactory {
      public user_completeFile_resultTupleScheme getScheme() {
        return new user_completeFile_resultTupleScheme();
      }
    }

    private static class user_completeFile_resultTupleScheme extends TupleScheme<user_completeFile_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_completeFile_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetE()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_completeFile_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.e = new FileDoesNotExistException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_getUserId_args implements org.apache.thrift.TBase<user_getUserId_args, user_getUserId_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_getUserId_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getUserId_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getUserId_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getUserId_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getUserId_args.class, metaDataMap);
    }

    public user_getUserId_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getUserId_args(user_getUserId_args other) {
    }

    public user_getUserId_args deepCopy() {
      return new user_getUserId_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getUserId_args)
        return this.equals((user_getUserId_args)that);
      return false;
    }

    public boolean equals(user_getUserId_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getUserId_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getUserId_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getUserId_argsStandardSchemeFactory implements SchemeFactory {
      public user_getUserId_argsStandardScheme getScheme() {
        return new user_getUserId_argsStandardScheme();
      }
    }

    private static class user_getUserId_argsStandardScheme extends StandardScheme<user_getUserId_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getUserId_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getUserId_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getUserId_argsTupleSchemeFactory implements SchemeFactory {
      public user_getUserId_argsTupleScheme getScheme() {
        return new user_getUserId_argsTupleScheme();
      }
    }

    private static class user_getUserId_argsTupleScheme extends TupleScheme<user_getUserId_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getUserId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getUserId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class user_getUserId_result implements org.apache.thrift.TBase<user_getUserId_result, user_getUserId_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_getUserId_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getUserId_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getUserId_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getUserId_resultTupleSchemeFactory());
    }

    public long success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getUserId_result.class, metaDataMap);
    }

    public user_getUserId_result() {
    }

    public user_getUserId_result(
      long success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getUserId_result(user_getUserId_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public user_getUserId_result deepCopy() {
      return new user_getUserId_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
    }

    public long getSuccess() {
      return this.success;
    }

    public user_getUserId_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Long.valueOf(getSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getUserId_result)
        return this.equals((user_getUserId_result)that);
      return false;
    }

    public boolean equals(user_getUserId_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getUserId_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getUserId_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getUserId_resultStandardSchemeFactory implements SchemeFactory {
      public user_getUserId_resultStandardScheme getScheme() {
        return new user_getUserId_resultStandardScheme();
      }
    }

    private static class user_getUserId_resultStandardScheme extends StandardScheme<user_getUserId_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getUserId_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getUserId_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getUserId_resultTupleSchemeFactory implements SchemeFactory {
      public user_getUserId_resultTupleScheme getScheme() {
        return new user_getUserId_resultTupleScheme();
      }
    }

    private static class user_getUserId_resultTupleScheme extends TupleScheme<user_getUserId_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getUserId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getUserId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class user_getBlockId_args implements org.apache.thrift.TBase<user_getBlockId_args, user_getBlockId_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_getBlockId_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getBlockId_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField INDEX_FIELD_DESC = new org.apache.thrift.protocol.TField("index", org.apache.thrift.protocol.TType.I32, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getBlockId_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getBlockId_argsTupleSchemeFactory());
    }

    public int fileId; // required
    public int index; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId"),
      INDEX((short)2, "index");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          case 2: // INDEX
            return INDEX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private static final int __INDEX_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.INDEX, new org.apache.thrift.meta_data.FieldMetaData("index", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getBlockId_args.class, metaDataMap);
    }

    public user_getBlockId_args() {
    }

    public user_getBlockId_args(
      int fileId,
      int index)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.index = index;
      setIndexIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getBlockId_args(user_getBlockId_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
      this.index = other.index;
    }

    public user_getBlockId_args deepCopy() {
      return new user_getBlockId_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
      setIndexIsSet(false);
      this.index = 0;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_getBlockId_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public int getIndex() {
      return this.index;
    }

    public user_getBlockId_args setIndex(int index) {
      this.index = index;
      setIndexIsSet(true);
      return this;
    }

    public void unsetIndex() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __INDEX_ISSET_ID);
    }

    /** Returns true if field index is set (has been assigned a value) and false otherwise */
    public boolean isSetIndex() {
      return EncodingUtils.testBit(__isset_bitfield, __INDEX_ISSET_ID);
    }

    public void setIndexIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __INDEX_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case INDEX:
        if (value == null) {
          unsetIndex();
        } else {
          setIndex((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      case INDEX:
        return Integer.valueOf(getIndex());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      case INDEX:
        return isSetIndex();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getBlockId_args)
        return this.equals((user_getBlockId_args)that);
      return false;
    }

    public boolean equals(user_getBlockId_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      boolean this_present_index = true;
      boolean that_present_index = true;
      if (this_present_index || that_present_index) {
        if (!(this_present_index && that_present_index))
          return false;
        if (this.index != that.index)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getBlockId_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIndex()).compareTo(other.isSetIndex());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIndex()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.index, other.index);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getBlockId_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("index:");
      sb.append(this.index);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getBlockId_argsStandardSchemeFactory implements SchemeFactory {
      public user_getBlockId_argsStandardScheme getScheme() {
        return new user_getBlockId_argsStandardScheme();
      }
    }

    private static class user_getBlockId_argsStandardScheme extends StandardScheme<user_getBlockId_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getBlockId_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // INDEX
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.index = iprot.readI32();
                struct.setIndexIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getBlockId_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(INDEX_FIELD_DESC);
        oprot.writeI32(struct.index);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getBlockId_argsTupleSchemeFactory implements SchemeFactory {
      public user_getBlockId_argsTupleScheme getScheme() {
        return new user_getBlockId_argsTupleScheme();
      }
    }

    private static class user_getBlockId_argsTupleScheme extends TupleScheme<user_getBlockId_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getBlockId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        if (struct.isSetIndex()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
        if (struct.isSetIndex()) {
          oprot.writeI32(struct.index);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getBlockId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.index = iprot.readI32();
          struct.setIndexIsSet(true);
        }
      }
    }

  }

  public static class user_getBlockId_result implements org.apache.thrift.TBase<user_getBlockId_result, user_getBlockId_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_getBlockId_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getBlockId_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getBlockId_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getBlockId_resultTupleSchemeFactory());
    }

    public long success; // required
    public FileDoesNotExistException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getBlockId_result.class, metaDataMap);
    }

    public user_getBlockId_result() {
    }

    public user_getBlockId_result(
      long success,
      FileDoesNotExistException e)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getBlockId_result(user_getBlockId_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetE()) {
        this.e = new FileDoesNotExistException(other.e);
      }
    }

    public user_getBlockId_result deepCopy() {
      return new user_getBlockId_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.e = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public user_getBlockId_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public FileDoesNotExistException getE() {
      return this.e;
    }

    public user_getBlockId_result setE(FileDoesNotExistException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((FileDoesNotExistException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Long.valueOf(getSuccess());

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getBlockId_result)
        return this.equals((user_getBlockId_result)that);
      return false;
    }

    public boolean equals(user_getBlockId_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getBlockId_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getBlockId_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getBlockId_resultStandardSchemeFactory implements SchemeFactory {
      public user_getBlockId_resultStandardScheme getScheme() {
        return new user_getBlockId_resultStandardScheme();
      }
    }

    private static class user_getBlockId_resultStandardScheme extends StandardScheme<user_getBlockId_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getBlockId_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new FileDoesNotExistException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getBlockId_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getBlockId_resultTupleSchemeFactory implements SchemeFactory {
      public user_getBlockId_resultTupleScheme getScheme() {
        return new user_getBlockId_resultTupleScheme();
      }
    }

    private static class user_getBlockId_resultTupleScheme extends TupleScheme<user_getBlockId_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getBlockId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getBlockId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new FileDoesNotExistException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_getWorker_args implements org.apache.thrift.TBase<user_getWorker_args, user_getWorker_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_getWorker_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getWorker_args");

    private static final org.apache.thrift.protocol.TField RANDOM_FIELD_DESC = new org.apache.thrift.protocol.TField("random", org.apache.thrift.protocol.TType.BOOL, (short)1);
    private static final org.apache.thrift.protocol.TField HOST_FIELD_DESC = new org.apache.thrift.protocol.TField("host", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getWorker_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getWorker_argsTupleSchemeFactory());
    }

    public boolean random; // required
    public String host; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      RANDOM((short)1, "random"),
      HOST((short)2, "host");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // RANDOM
            return RANDOM;
          case 2: // HOST
            return HOST;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __RANDOM_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.RANDOM, new org.apache.thrift.meta_data.FieldMetaData("random", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.HOST, new org.apache.thrift.meta_data.FieldMetaData("host", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getWorker_args.class, metaDataMap);
    }

    public user_getWorker_args() {
    }

    public user_getWorker_args(
      boolean random,
      String host)
    {
      this();
      this.random = random;
      setRandomIsSet(true);
      this.host = host;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getWorker_args(user_getWorker_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.random = other.random;
      if (other.isSetHost()) {
        this.host = other.host;
      }
    }

    public user_getWorker_args deepCopy() {
      return new user_getWorker_args(this);
    }

    @Override
    public void clear() {
      setRandomIsSet(false);
      this.random = false;
      this.host = null;
    }

    public boolean isRandom() {
      return this.random;
    }

    public user_getWorker_args setRandom(boolean random) {
      this.random = random;
      setRandomIsSet(true);
      return this;
    }

    public void unsetRandom() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __RANDOM_ISSET_ID);
    }

    /** Returns true if field random is set (has been assigned a value) and false otherwise */
    public boolean isSetRandom() {
      return EncodingUtils.testBit(__isset_bitfield, __RANDOM_ISSET_ID);
    }

    public void setRandomIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __RANDOM_ISSET_ID, value);
    }

    public String getHost() {
      return this.host;
    }

    public user_getWorker_args setHost(String host) {
      this.host = host;
      return this;
    }

    public void unsetHost() {
      this.host = null;
    }

    /** Returns true if field host is set (has been assigned a value) and false otherwise */
    public boolean isSetHost() {
      return this.host != null;
    }

    public void setHostIsSet(boolean value) {
      if (!value) {
        this.host = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case RANDOM:
        if (value == null) {
          unsetRandom();
        } else {
          setRandom((Boolean)value);
        }
        break;

      case HOST:
        if (value == null) {
          unsetHost();
        } else {
          setHost((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case RANDOM:
        return Boolean.valueOf(isRandom());

      case HOST:
        return getHost();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case RANDOM:
        return isSetRandom();
      case HOST:
        return isSetHost();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getWorker_args)
        return this.equals((user_getWorker_args)that);
      return false;
    }

    public boolean equals(user_getWorker_args that) {
      if (that == null)
        return false;

      boolean this_present_random = true;
      boolean that_present_random = true;
      if (this_present_random || that_present_random) {
        if (!(this_present_random && that_present_random))
          return false;
        if (this.random != that.random)
          return false;
      }

      boolean this_present_host = true && this.isSetHost();
      boolean that_present_host = true && that.isSetHost();
      if (this_present_host || that_present_host) {
        if (!(this_present_host && that_present_host))
          return false;
        if (!this.host.equals(that.host))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getWorker_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetRandom()).compareTo(other.isSetRandom());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRandom()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.random, other.random);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetHost()).compareTo(other.isSetHost());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetHost()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getWorker_args(");
      boolean first = true;

      sb.append("random:");
      sb.append(this.random);
      first = false;
      if (!first) sb.append(", ");
      sb.append("host:");
      if (this.host == null) {
        sb.append("null");
      } else {
        sb.append(this.host);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getWorker_argsStandardSchemeFactory implements SchemeFactory {
      public user_getWorker_argsStandardScheme getScheme() {
        return new user_getWorker_argsStandardScheme();
      }
    }

    private static class user_getWorker_argsStandardScheme extends StandardScheme<user_getWorker_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getWorker_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // RANDOM
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.random = iprot.readBool();
                struct.setRandomIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // HOST
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.host = iprot.readString();
                struct.setHostIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getWorker_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(RANDOM_FIELD_DESC);
        oprot.writeBool(struct.random);
        oprot.writeFieldEnd();
        if (struct.host != null) {
          oprot.writeFieldBegin(HOST_FIELD_DESC);
          oprot.writeString(struct.host);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getWorker_argsTupleSchemeFactory implements SchemeFactory {
      public user_getWorker_argsTupleScheme getScheme() {
        return new user_getWorker_argsTupleScheme();
      }
    }

    private static class user_getWorker_argsTupleScheme extends TupleScheme<user_getWorker_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getWorker_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetRandom()) {
          optionals.set(0);
        }
        if (struct.isSetHost()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetRandom()) {
          oprot.writeBool(struct.random);
        }
        if (struct.isSetHost()) {
          oprot.writeString(struct.host);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getWorker_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.random = iprot.readBool();
          struct.setRandomIsSet(true);
        }
        if (incoming.get(1)) {
          struct.host = iprot.readString();
          struct.setHostIsSet(true);
        }
      }
    }

  }

  public static class user_getWorker_result implements org.apache.thrift.TBase<user_getWorker_result, user_getWorker_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_getWorker_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getWorker_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getWorker_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getWorker_resultTupleSchemeFactory());
    }

    public NetAddress success; // required
    public NoWorkerException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NetAddress.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getWorker_result.class, metaDataMap);
    }

    public user_getWorker_result() {
    }

    public user_getWorker_result(
      NetAddress success,
      NoWorkerException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getWorker_result(user_getWorker_result other) {
      if (other.isSetSuccess()) {
        this.success = new NetAddress(other.success);
      }
      if (other.isSetE()) {
        this.e = new NoWorkerException(other.e);
      }
    }

    public user_getWorker_result deepCopy() {
      return new user_getWorker_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public NetAddress getSuccess() {
      return this.success;
    }

    public user_getWorker_result setSuccess(NetAddress success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public NoWorkerException getE() {
      return this.e;
    }

    public user_getWorker_result setE(NoWorkerException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((NetAddress)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((NoWorkerException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getWorker_result)
        return this.equals((user_getWorker_result)that);
      return false;
    }

    public boolean equals(user_getWorker_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getWorker_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getWorker_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getWorker_resultStandardSchemeFactory implements SchemeFactory {
      public user_getWorker_resultStandardScheme getScheme() {
        return new user_getWorker_resultStandardScheme();
      }
    }

    private static class user_getWorker_resultStandardScheme extends StandardScheme<user_getWorker_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getWorker_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new NetAddress();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new NoWorkerException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getWorker_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getWorker_resultTupleSchemeFactory implements SchemeFactory {
      public user_getWorker_resultTupleScheme getScheme() {
        return new user_getWorker_resultTupleScheme();
      }
    }

    private static class user_getWorker_resultTupleScheme extends TupleScheme<user_getWorker_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getWorker_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getWorker_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new NetAddress();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new NoWorkerException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class getFileStatus_args implements org.apache.thrift.TBase<getFileStatus_args, getFileStatus_args._Fields>, java.io.Serializable, Cloneable, Comparable<getFileStatus_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getFileStatus_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getFileStatus_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getFileStatus_argsTupleSchemeFactory());
    }

    public int fileId; // required
    public String path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId"),
      PATH((short)2, "path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          case 2: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getFileStatus_args.class, metaDataMap);
    }

    public getFileStatus_args() {
    }

    public getFileStatus_args(
      int fileId,
      String path)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.path = path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getFileStatus_args(getFileStatus_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
      if (other.isSetPath()) {
        this.path = other.path;
      }
    }

    public getFileStatus_args deepCopy() {
      return new getFileStatus_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
      this.path = null;
    }

    public int getFileId() {
      return this.fileId;
    }

    public getFileStatus_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public String getPath() {
      return this.path;
    }

    public getFileStatus_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFileStatus_args)
        return this.equals((getFileStatus_args)that);
      return false;
    }

    public boolean equals(getFileStatus_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(getFileStatus_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(other.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, other.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getFileStatus_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getFileStatus_argsStandardSchemeFactory implements SchemeFactory {
      public getFileStatus_argsStandardScheme getScheme() {
        return new getFileStatus_argsStandardScheme();
      }
    }

    private static class getFileStatus_argsStandardScheme extends StandardScheme<getFileStatus_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getFileStatus_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getFileStatus_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getFileStatus_argsTupleSchemeFactory implements SchemeFactory {
      public getFileStatus_argsTupleScheme getScheme() {
        return new getFileStatus_argsTupleScheme();
      }
    }

    private static class getFileStatus_argsTupleScheme extends TupleScheme<getFileStatus_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getFileStatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getFileStatus_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class getFileStatus_result implements org.apache.thrift.TBase<getFileStatus_result, getFileStatus_result._Fields>, java.io.Serializable, Cloneable, Comparable<getFileStatus_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getFileStatus_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_I_FIELD_DESC = new org.apache.thrift.protocol.TField("eI", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getFileStatus_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getFileStatus_resultTupleSchemeFactory());
    }

    public ClientFileInfo success; // required
    public InvalidPathException eI; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_I((short)1, "eI");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_I
            return E_I;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ClientFileInfo.class)));
      tmpMap.put(_Fields.E_I, new org.apache.thrift.meta_data.FieldMetaData("eI", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getFileStatus_result.class, metaDataMap);
    }

    public getFileStatus_result() {
    }

    public getFileStatus_result(
      ClientFileInfo success,
      InvalidPathException eI)
    {
      this();
      this.success = success;
      this.eI = eI;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getFileStatus_result(getFileStatus_result other) {
      if (other.isSetSuccess()) {
        this.success = new ClientFileInfo(other.success);
      }
      if (other.isSetEI()) {
        this.eI = new InvalidPathException(other.eI);
      }
    }

    public getFileStatus_result deepCopy() {
      return new getFileStatus_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.eI = null;
    }

    public ClientFileInfo getSuccess() {
      return this.success;
    }

    public getFileStatus_result setSuccess(ClientFileInfo success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidPathException getEI() {
      return this.eI;
    }

    public getFileStatus_result setEI(InvalidPathException eI) {
      this.eI = eI;
      return this;
    }

    public void unsetEI() {
      this.eI = null;
    }

    /** Returns true if field eI is set (has been assigned a value) and false otherwise */
    public boolean isSetEI() {
      return this.eI != null;
    }

    public void setEIIsSet(boolean value) {
      if (!value) {
        this.eI = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ClientFileInfo)value);
        }
        break;

      case E_I:
        if (value == null) {
          unsetEI();
        } else {
          setEI((InvalidPathException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E_I:
        return getEI();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_I:
        return isSetEI();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFileStatus_result)
        return this.equals((getFileStatus_result)that);
      return false;
    }

    public boolean equals(getFileStatus_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_eI = true && this.isSetEI();
      boolean that_present_eI = true && that.isSetEI();
      if (this_present_eI || that_present_eI) {
        if (!(this_present_eI && that_present_eI))
          return false;
        if (!this.eI.equals(that.eI))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(getFileStatus_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEI()).compareTo(other.isSetEI());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEI()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eI, other.eI);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getFileStatus_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eI:");
      if (this.eI == null) {
        sb.append("null");
      } else {
        sb.append(this.eI);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getFileStatus_resultStandardSchemeFactory implements SchemeFactory {
      public getFileStatus_resultStandardScheme getScheme() {
        return new getFileStatus_resultStandardScheme();
      }
    }

    private static class getFileStatus_resultStandardScheme extends StandardScheme<getFileStatus_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getFileStatus_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ClientFileInfo();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_I
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eI = new InvalidPathException();
                struct.eI.read(iprot);
                struct.setEIIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getFileStatus_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eI != null) {
          oprot.writeFieldBegin(E_I_FIELD_DESC);
          struct.eI.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getFileStatus_resultTupleSchemeFactory implements SchemeFactory {
      public getFileStatus_resultTupleScheme getScheme() {
        return new getFileStatus_resultTupleScheme();
      }
    }

    private static class getFileStatus_resultTupleScheme extends TupleScheme<getFileStatus_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getFileStatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEI()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetEI()) {
          struct.eI.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getFileStatus_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new ClientFileInfo();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eI = new InvalidPathException();
          struct.eI.read(iprot);
          struct.setEIIsSet(true);
        }
      }
    }

  }

  public static class user_getClientBlockInfo_args implements org.apache.thrift.TBase<user_getClientBlockInfo_args, user_getClientBlockInfo_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_getClientBlockInfo_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getClientBlockInfo_args");

    private static final org.apache.thrift.protocol.TField BLOCK_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("blockId", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getClientBlockInfo_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getClientBlockInfo_argsTupleSchemeFactory());
    }

    public long blockId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      BLOCK_ID((short)1, "blockId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // BLOCK_ID
            return BLOCK_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BLOCKID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.BLOCK_ID, new org.apache.thrift.meta_data.FieldMetaData("blockId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getClientBlockInfo_args.class, metaDataMap);
    }

    public user_getClientBlockInfo_args() {
    }

    public user_getClientBlockInfo_args(
      long blockId)
    {
      this();
      this.blockId = blockId;
      setBlockIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getClientBlockInfo_args(user_getClientBlockInfo_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.blockId = other.blockId;
    }

    public user_getClientBlockInfo_args deepCopy() {
      return new user_getClientBlockInfo_args(this);
    }

    @Override
    public void clear() {
      setBlockIdIsSet(false);
      this.blockId = 0;
    }

    public long getBlockId() {
      return this.blockId;
    }

    public user_getClientBlockInfo_args setBlockId(long blockId) {
      this.blockId = blockId;
      setBlockIdIsSet(true);
      return this;
    }

    public void unsetBlockId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    /** Returns true if field blockId is set (has been assigned a value) and false otherwise */
    public boolean isSetBlockId() {
      return EncodingUtils.testBit(__isset_bitfield, __BLOCKID_ISSET_ID);
    }

    public void setBlockIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case BLOCK_ID:
        if (value == null) {
          unsetBlockId();
        } else {
          setBlockId((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case BLOCK_ID:
        return Long.valueOf(getBlockId());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case BLOCK_ID:
        return isSetBlockId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getClientBlockInfo_args)
        return this.equals((user_getClientBlockInfo_args)that);
      return false;
    }

    public boolean equals(user_getClientBlockInfo_args that) {
      if (that == null)
        return false;

      boolean this_present_blockId = true;
      boolean that_present_blockId = true;
      if (this_present_blockId || that_present_blockId) {
        if (!(this_present_blockId && that_present_blockId))
          return false;
        if (this.blockId != that.blockId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getClientBlockInfo_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetBlockId()).compareTo(other.isSetBlockId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBlockId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockId, other.blockId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getClientBlockInfo_args(");
      boolean first = true;

      sb.append("blockId:");
      sb.append(this.blockId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getClientBlockInfo_argsStandardSchemeFactory implements SchemeFactory {
      public user_getClientBlockInfo_argsStandardScheme getScheme() {
        return new user_getClientBlockInfo_argsStandardScheme();
      }
    }

    private static class user_getClientBlockInfo_argsStandardScheme extends StandardScheme<user_getClientBlockInfo_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getClientBlockInfo_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // BLOCK_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.blockId = iprot.readI64();
                struct.setBlockIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getClientBlockInfo_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(BLOCK_ID_FIELD_DESC);
        oprot.writeI64(struct.blockId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getClientBlockInfo_argsTupleSchemeFactory implements SchemeFactory {
      public user_getClientBlockInfo_argsTupleScheme getScheme() {
        return new user_getClientBlockInfo_argsTupleScheme();
      }
    }

    private static class user_getClientBlockInfo_argsTupleScheme extends TupleScheme<user_getClientBlockInfo_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getClientBlockInfo_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetBlockId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetBlockId()) {
          oprot.writeI64(struct.blockId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getClientBlockInfo_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.blockId = iprot.readI64();
          struct.setBlockIdIsSet(true);
        }
      }
    }

  }

  public static class user_getClientBlockInfo_result implements org.apache.thrift.TBase<user_getClientBlockInfo_result, user_getClientBlockInfo_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_getClientBlockInfo_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getClientBlockInfo_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_F_FIELD_DESC = new org.apache.thrift.protocol.TField("eF", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_B_FIELD_DESC = new org.apache.thrift.protocol.TField("eB", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getClientBlockInfo_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getClientBlockInfo_resultTupleSchemeFactory());
    }

    public ClientBlockInfo success; // required
    public FileDoesNotExistException eF; // required
    public BlockInfoException eB; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_F((short)1, "eF"),
      E_B((short)2, "eB");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_F
            return E_F;
          case 2: // E_B
            return E_B;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ClientBlockInfo.class)));
      tmpMap.put(_Fields.E_F, new org.apache.thrift.meta_data.FieldMetaData("eF", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_B, new org.apache.thrift.meta_data.FieldMetaData("eB", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getClientBlockInfo_result.class, metaDataMap);
    }

    public user_getClientBlockInfo_result() {
    }

    public user_getClientBlockInfo_result(
      ClientBlockInfo success,
      FileDoesNotExistException eF,
      BlockInfoException eB)
    {
      this();
      this.success = success;
      this.eF = eF;
      this.eB = eB;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getClientBlockInfo_result(user_getClientBlockInfo_result other) {
      if (other.isSetSuccess()) {
        this.success = new ClientBlockInfo(other.success);
      }
      if (other.isSetEF()) {
        this.eF = new FileDoesNotExistException(other.eF);
      }
      if (other.isSetEB()) {
        this.eB = new BlockInfoException(other.eB);
      }
    }

    public user_getClientBlockInfo_result deepCopy() {
      return new user_getClientBlockInfo_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.eF = null;
      this.eB = null;
    }

    public ClientBlockInfo getSuccess() {
      return this.success;
    }

    public user_getClientBlockInfo_result setSuccess(ClientBlockInfo success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public FileDoesNotExistException getEF() {
      return this.eF;
    }

    public user_getClientBlockInfo_result setEF(FileDoesNotExistException eF) {
      this.eF = eF;
      return this;
    }

    public void unsetEF() {
      this.eF = null;
    }

    /** Returns true if field eF is set (has been assigned a value) and false otherwise */
    public boolean isSetEF() {
      return this.eF != null;
    }

    public void setEFIsSet(boolean value) {
      if (!value) {
        this.eF = null;
      }
    }

    public BlockInfoException getEB() {
      return this.eB;
    }

    public user_getClientBlockInfo_result setEB(BlockInfoException eB) {
      this.eB = eB;
      return this;
    }

    public void unsetEB() {
      this.eB = null;
    }

    /** Returns true if field eB is set (has been assigned a value) and false otherwise */
    public boolean isSetEB() {
      return this.eB != null;
    }

    public void setEBIsSet(boolean value) {
      if (!value) {
        this.eB = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ClientBlockInfo)value);
        }
        break;

      case E_F:
        if (value == null) {
          unsetEF();
        } else {
          setEF((FileDoesNotExistException)value);
        }
        break;

      case E_B:
        if (value == null) {
          unsetEB();
        } else {
          setEB((BlockInfoException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E_F:
        return getEF();

      case E_B:
        return getEB();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_F:
        return isSetEF();
      case E_B:
        return isSetEB();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getClientBlockInfo_result)
        return this.equals((user_getClientBlockInfo_result)that);
      return false;
    }

    public boolean equals(user_getClientBlockInfo_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_eF = true && this.isSetEF();
      boolean that_present_eF = true && that.isSetEF();
      if (this_present_eF || that_present_eF) {
        if (!(this_present_eF && that_present_eF))
          return false;
        if (!this.eF.equals(that.eF))
          return false;
      }

      boolean this_present_eB = true && this.isSetEB();
      boolean that_present_eB = true && that.isSetEB();
      if (this_present_eB || that_present_eB) {
        if (!(this_present_eB && that_present_eB))
          return false;
        if (!this.eB.equals(that.eB))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getClientBlockInfo_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEF()).compareTo(other.isSetEF());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEF()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eF, other.eF);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEB()).compareTo(other.isSetEB());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEB()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eB, other.eB);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getClientBlockInfo_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eF:");
      if (this.eF == null) {
        sb.append("null");
      } else {
        sb.append(this.eF);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eB:");
      if (this.eB == null) {
        sb.append("null");
      } else {
        sb.append(this.eB);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getClientBlockInfo_resultStandardSchemeFactory implements SchemeFactory {
      public user_getClientBlockInfo_resultStandardScheme getScheme() {
        return new user_getClientBlockInfo_resultStandardScheme();
      }
    }

    private static class user_getClientBlockInfo_resultStandardScheme extends StandardScheme<user_getClientBlockInfo_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getClientBlockInfo_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new ClientBlockInfo();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_F
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eF = new FileDoesNotExistException();
                struct.eF.read(iprot);
                struct.setEFIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_B
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eB = new BlockInfoException();
                struct.eB.read(iprot);
                struct.setEBIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getClientBlockInfo_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eF != null) {
          oprot.writeFieldBegin(E_F_FIELD_DESC);
          struct.eF.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eB != null) {
          oprot.writeFieldBegin(E_B_FIELD_DESC);
          struct.eB.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getClientBlockInfo_resultTupleSchemeFactory implements SchemeFactory {
      public user_getClientBlockInfo_resultTupleScheme getScheme() {
        return new user_getClientBlockInfo_resultTupleScheme();
      }
    }

    private static class user_getClientBlockInfo_resultTupleScheme extends TupleScheme<user_getClientBlockInfo_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getClientBlockInfo_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEF()) {
          optionals.set(1);
        }
        if (struct.isSetEB()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetEF()) {
          struct.eF.write(oprot);
        }
        if (struct.isSetEB()) {
          struct.eB.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getClientBlockInfo_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = new ClientBlockInfo();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eF = new FileDoesNotExistException();
          struct.eF.read(iprot);
          struct.setEFIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eB = new BlockInfoException();
          struct.eB.read(iprot);
          struct.setEBIsSet(true);
        }
      }
    }

  }

  public static class user_getFileBlocks_args implements org.apache.thrift.TBase<user_getFileBlocks_args, user_getFileBlocks_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_getFileBlocks_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getFileBlocks_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getFileBlocks_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getFileBlocks_argsTupleSchemeFactory());
    }

    public int fileId; // required
    public String path; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId"),
      PATH((short)2, "path");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          case 2: // PATH
            return PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getFileBlocks_args.class, metaDataMap);
    }

    public user_getFileBlocks_args() {
    }

    public user_getFileBlocks_args(
      int fileId,
      String path)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.path = path;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getFileBlocks_args(user_getFileBlocks_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
      if (other.isSetPath()) {
        this.path = other.path;
      }
    }

    public user_getFileBlocks_args deepCopy() {
      return new user_getFileBlocks_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
      this.path = null;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_getFileBlocks_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public String getPath() {
      return this.path;
    }

    public user_getFileBlocks_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      case PATH:
        return getPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      case PATH:
        return isSetPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getFileBlocks_args)
        return this.equals((user_getFileBlocks_args)that);
      return false;
    }

    public boolean equals(user_getFileBlocks_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getFileBlocks_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(other.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, other.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getFileBlocks_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getFileBlocks_argsStandardSchemeFactory implements SchemeFactory {
      public user_getFileBlocks_argsStandardScheme getScheme() {
        return new user_getFileBlocks_argsStandardScheme();
      }
    }

    private static class user_getFileBlocks_argsStandardScheme extends StandardScheme<user_getFileBlocks_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getFileBlocks_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getFileBlocks_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getFileBlocks_argsTupleSchemeFactory implements SchemeFactory {
      public user_getFileBlocks_argsTupleScheme getScheme() {
        return new user_getFileBlocks_argsTupleScheme();
      }
    }

    private static class user_getFileBlocks_argsTupleScheme extends TupleScheme<user_getFileBlocks_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getFileBlocks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getFileBlocks_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
      }
    }

  }

  public static class user_getFileBlocks_result implements org.apache.thrift.TBase<user_getFileBlocks_result, user_getFileBlocks_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_getFileBlocks_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_getFileBlocks_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField E_F_FIELD_DESC = new org.apache.thrift.protocol.TField("eF", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_I_FIELD_DESC = new org.apache.thrift.protocol.TField("eI", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_getFileBlocks_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_getFileBlocks_resultTupleSchemeFactory());
    }

    public List<ClientBlockInfo> success; // required
    public FileDoesNotExistException eF; // required
    public InvalidPathException eI; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_F((short)1, "eF"),
      E_I((short)2, "eI");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_F
            return E_F;
          case 2: // E_I
            return E_I;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ClientBlockInfo.class))));
      tmpMap.put(_Fields.E_F, new org.apache.thrift.meta_data.FieldMetaData("eF", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_I, new org.apache.thrift.meta_data.FieldMetaData("eI", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_getFileBlocks_result.class, metaDataMap);
    }

    public user_getFileBlocks_result() {
    }

    public user_getFileBlocks_result(
      List<ClientBlockInfo> success,
      FileDoesNotExistException eF,
      InvalidPathException eI)
    {
      this();
      this.success = success;
      this.eF = eF;
      this.eI = eI;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_getFileBlocks_result(user_getFileBlocks_result other) {
      if (other.isSetSuccess()) {
        List<ClientBlockInfo> __this__success = new ArrayList<ClientBlockInfo>(other.success.size());
        for (ClientBlockInfo other_element : other.success) {
          __this__success.add(new ClientBlockInfo(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetEF()) {
        this.eF = new FileDoesNotExistException(other.eF);
      }
      if (other.isSetEI()) {
        this.eI = new InvalidPathException(other.eI);
      }
    }

    public user_getFileBlocks_result deepCopy() {
      return new user_getFileBlocks_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.eF = null;
      this.eI = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ClientBlockInfo> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ClientBlockInfo elem) {
      if (this.success == null) {
        this.success = new ArrayList<ClientBlockInfo>();
      }
      this.success.add(elem);
    }

    public List<ClientBlockInfo> getSuccess() {
      return this.success;
    }

    public user_getFileBlocks_result setSuccess(List<ClientBlockInfo> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public FileDoesNotExistException getEF() {
      return this.eF;
    }

    public user_getFileBlocks_result setEF(FileDoesNotExistException eF) {
      this.eF = eF;
      return this;
    }

    public void unsetEF() {
      this.eF = null;
    }

    /** Returns true if field eF is set (has been assigned a value) and false otherwise */
    public boolean isSetEF() {
      return this.eF != null;
    }

    public void setEFIsSet(boolean value) {
      if (!value) {
        this.eF = null;
      }
    }

    public InvalidPathException getEI() {
      return this.eI;
    }

    public user_getFileBlocks_result setEI(InvalidPathException eI) {
      this.eI = eI;
      return this;
    }

    public void unsetEI() {
      this.eI = null;
    }

    /** Returns true if field eI is set (has been assigned a value) and false otherwise */
    public boolean isSetEI() {
      return this.eI != null;
    }

    public void setEIIsSet(boolean value) {
      if (!value) {
        this.eI = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ClientBlockInfo>)value);
        }
        break;

      case E_F:
        if (value == null) {
          unsetEF();
        } else {
          setEF((FileDoesNotExistException)value);
        }
        break;

      case E_I:
        if (value == null) {
          unsetEI();
        } else {
          setEI((InvalidPathException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E_F:
        return getEF();

      case E_I:
        return getEI();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_F:
        return isSetEF();
      case E_I:
        return isSetEI();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_getFileBlocks_result)
        return this.equals((user_getFileBlocks_result)that);
      return false;
    }

    public boolean equals(user_getFileBlocks_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_eF = true && this.isSetEF();
      boolean that_present_eF = true && that.isSetEF();
      if (this_present_eF || that_present_eF) {
        if (!(this_present_eF && that_present_eF))
          return false;
        if (!this.eF.equals(that.eF))
          return false;
      }

      boolean this_present_eI = true && this.isSetEI();
      boolean that_present_eI = true && that.isSetEI();
      if (this_present_eI || that_present_eI) {
        if (!(this_present_eI && that_present_eI))
          return false;
        if (!this.eI.equals(that.eI))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_getFileBlocks_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEF()).compareTo(other.isSetEF());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEF()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eF, other.eF);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEI()).compareTo(other.isSetEI());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEI()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eI, other.eI);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_getFileBlocks_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eF:");
      if (this.eF == null) {
        sb.append("null");
      } else {
        sb.append(this.eF);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eI:");
      if (this.eI == null) {
        sb.append("null");
      } else {
        sb.append(this.eI);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_getFileBlocks_resultStandardSchemeFactory implements SchemeFactory {
      public user_getFileBlocks_resultStandardScheme getScheme() {
        return new user_getFileBlocks_resultStandardScheme();
      }
    }

    private static class user_getFileBlocks_resultStandardScheme extends StandardScheme<user_getFileBlocks_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_getFileBlocks_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list148 = iprot.readListBegin();
                  struct.success = new ArrayList<ClientBlockInfo>(_list148.size);
                  for (int _i149 = 0; _i149 < _list148.size; ++_i149)
                  {
                    ClientBlockInfo _elem150;
                    _elem150 = new ClientBlockInfo();
                    _elem150.read(iprot);
                    struct.success.add(_elem150);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_F
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eF = new FileDoesNotExistException();
                struct.eF.read(iprot);
                struct.setEFIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_I
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eI = new InvalidPathException();
                struct.eI.read(iprot);
                struct.setEIIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_getFileBlocks_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (ClientBlockInfo _iter151 : struct.success)
            {
              _iter151.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.eF != null) {
          oprot.writeFieldBegin(E_F_FIELD_DESC);
          struct.eF.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eI != null) {
          oprot.writeFieldBegin(E_I_FIELD_DESC);
          struct.eI.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_getFileBlocks_resultTupleSchemeFactory implements SchemeFactory {
      public user_getFileBlocks_resultTupleScheme getScheme() {
        return new user_getFileBlocks_resultTupleScheme();
      }
    }

    private static class user_getFileBlocks_resultTupleScheme extends TupleScheme<user_getFileBlocks_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_getFileBlocks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEF()) {
          optionals.set(1);
        }
        if (struct.isSetEI()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (ClientBlockInfo _iter152 : struct.success)
            {
              _iter152.write(oprot);
            }
          }
        }
        if (struct.isSetEF()) {
          struct.eF.write(oprot);
        }
        if (struct.isSetEI()) {
          struct.eI.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_getFileBlocks_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list153 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<ClientBlockInfo>(_list153.size);
            for (int _i154 = 0; _i154 < _list153.size; ++_i154)
            {
              ClientBlockInfo _elem155;
              _elem155 = new ClientBlockInfo();
              _elem155.read(iprot);
              struct.success.add(_elem155);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eF = new FileDoesNotExistException();
          struct.eF.read(iprot);
          struct.setEFIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eI = new InvalidPathException();
          struct.eI.read(iprot);
          struct.setEIIsSet(true);
        }
      }
    }

  }

  public static class user_delete_args implements org.apache.thrift.TBase<user_delete_args, user_delete_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_delete_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_delete_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField RECURSIVE_FIELD_DESC = new org.apache.thrift.protocol.TField("recursive", org.apache.thrift.protocol.TType.BOOL, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_delete_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_delete_argsTupleSchemeFactory());
    }

    public int fileId; // required
    public String path; // required
    public boolean recursive; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId"),
      PATH((short)2, "path"),
      RECURSIVE((short)3, "recursive");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          case 2: // PATH
            return PATH;
          case 3: // RECURSIVE
            return RECURSIVE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private static final int __RECURSIVE_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.RECURSIVE, new org.apache.thrift.meta_data.FieldMetaData("recursive", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_delete_args.class, metaDataMap);
    }

    public user_delete_args() {
    }

    public user_delete_args(
      int fileId,
      String path,
      boolean recursive)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.path = path;
      this.recursive = recursive;
      setRecursiveIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_delete_args(user_delete_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
      if (other.isSetPath()) {
        this.path = other.path;
      }
      this.recursive = other.recursive;
    }

    public user_delete_args deepCopy() {
      return new user_delete_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
      this.path = null;
      setRecursiveIsSet(false);
      this.recursive = false;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_delete_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public String getPath() {
      return this.path;
    }

    public user_delete_args setPath(String path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    public boolean isRecursive() {
      return this.recursive;
    }

    public user_delete_args setRecursive(boolean recursive) {
      this.recursive = recursive;
      setRecursiveIsSet(true);
      return this;
    }

    public void unsetRecursive() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __RECURSIVE_ISSET_ID);
    }

    /** Returns true if field recursive is set (has been assigned a value) and false otherwise */
    public boolean isSetRecursive() {
      return EncodingUtils.testBit(__isset_bitfield, __RECURSIVE_ISSET_ID);
    }

    public void setRecursiveIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __RECURSIVE_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((String)value);
        }
        break;

      case RECURSIVE:
        if (value == null) {
          unsetRecursive();
        } else {
          setRecursive((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      case PATH:
        return getPath();

      case RECURSIVE:
        return Boolean.valueOf(isRecursive());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      case PATH:
        return isSetPath();
      case RECURSIVE:
        return isSetRecursive();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_delete_args)
        return this.equals((user_delete_args)that);
      return false;
    }

    public boolean equals(user_delete_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_recursive = true;
      boolean that_present_recursive = true;
      if (this_present_recursive || that_present_recursive) {
        if (!(this_present_recursive && that_present_recursive))
          return false;
        if (this.recursive != that.recursive)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_delete_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(other.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, other.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRecursive()).compareTo(other.isSetRecursive());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRecursive()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.recursive, other.recursive);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_delete_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("recursive:");
      sb.append(this.recursive);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_delete_argsStandardSchemeFactory implements SchemeFactory {
      public user_delete_argsStandardScheme getScheme() {
        return new user_delete_argsStandardScheme();
      }
    }

    private static class user_delete_argsStandardScheme extends StandardScheme<user_delete_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_delete_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // RECURSIVE
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.recursive = iprot.readBool();
                struct.setRecursiveIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_delete_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        if (struct.path != null) {
          oprot.writeFieldBegin(PATH_FIELD_DESC);
          oprot.writeString(struct.path);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(RECURSIVE_FIELD_DESC);
        oprot.writeBool(struct.recursive);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_delete_argsTupleSchemeFactory implements SchemeFactory {
      public user_delete_argsTupleScheme getScheme() {
        return new user_delete_argsTupleScheme();
      }
    }

    private static class user_delete_argsTupleScheme extends TupleScheme<user_delete_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_delete_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        if (struct.isSetPath()) {
          optionals.set(1);
        }
        if (struct.isSetRecursive()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
        if (struct.isSetPath()) {
          oprot.writeString(struct.path);
        }
        if (struct.isSetRecursive()) {
          oprot.writeBool(struct.recursive);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_delete_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.path = iprot.readString();
          struct.setPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.recursive = iprot.readBool();
          struct.setRecursiveIsSet(true);
        }
      }
    }

  }

  public static class user_delete_result implements org.apache.thrift.TBase<user_delete_result, user_delete_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_delete_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_delete_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_delete_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_delete_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public TachyonException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_delete_result.class, metaDataMap);
    }

    public user_delete_result() {
    }

    public user_delete_result(
      boolean success,
      TachyonException e)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_delete_result(user_delete_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetE()) {
        this.e = new TachyonException(other.e);
      }
    }

    public user_delete_result deepCopy() {
      return new user_delete_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.e = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public user_delete_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public TachyonException getE() {
      return this.e;
    }

    public user_delete_result setE(TachyonException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TachyonException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_delete_result)
        return this.equals((user_delete_result)that);
      return false;
    }

    public boolean equals(user_delete_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_delete_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(other.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, other.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_delete_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_delete_resultStandardSchemeFactory implements SchemeFactory {
      public user_delete_resultStandardScheme getScheme() {
        return new user_delete_resultStandardScheme();
      }
    }

    private static class user_delete_resultStandardScheme extends StandardScheme<user_delete_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_delete_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TachyonException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_delete_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_delete_resultTupleSchemeFactory implements SchemeFactory {
      public user_delete_resultTupleScheme getScheme() {
        return new user_delete_resultTupleScheme();
      }
    }

    private static class user_delete_resultTupleScheme extends TupleScheme<user_delete_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_delete_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_delete_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TachyonException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class user_rename_args implements org.apache.thrift.TBase<user_rename_args, user_rename_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_rename_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_rename_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField SRC_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("srcPath", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField DST_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("dstPath", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_rename_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_rename_argsTupleSchemeFactory());
    }

    public int fileId; // required
    public String srcPath; // required
    public String dstPath; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId"),
      SRC_PATH((short)2, "srcPath"),
      DST_PATH((short)3, "dstPath");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          case 2: // SRC_PATH
            return SRC_PATH;
          case 3: // DST_PATH
            return DST_PATH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.SRC_PATH, new org.apache.thrift.meta_data.FieldMetaData("srcPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.DST_PATH, new org.apache.thrift.meta_data.FieldMetaData("dstPath", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_rename_args.class, metaDataMap);
    }

    public user_rename_args() {
    }

    public user_rename_args(
      int fileId,
      String srcPath,
      String dstPath)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.srcPath = srcPath;
      this.dstPath = dstPath;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_rename_args(user_rename_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
      if (other.isSetSrcPath()) {
        this.srcPath = other.srcPath;
      }
      if (other.isSetDstPath()) {
        this.dstPath = other.dstPath;
      }
    }

    public user_rename_args deepCopy() {
      return new user_rename_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
      this.srcPath = null;
      this.dstPath = null;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_rename_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public String getSrcPath() {
      return this.srcPath;
    }

    public user_rename_args setSrcPath(String srcPath) {
      this.srcPath = srcPath;
      return this;
    }

    public void unsetSrcPath() {
      this.srcPath = null;
    }

    /** Returns true if field srcPath is set (has been assigned a value) and false otherwise */
    public boolean isSetSrcPath() {
      return this.srcPath != null;
    }

    public void setSrcPathIsSet(boolean value) {
      if (!value) {
        this.srcPath = null;
      }
    }

    public String getDstPath() {
      return this.dstPath;
    }

    public user_rename_args setDstPath(String dstPath) {
      this.dstPath = dstPath;
      return this;
    }

    public void unsetDstPath() {
      this.dstPath = null;
    }

    /** Returns true if field dstPath is set (has been assigned a value) and false otherwise */
    public boolean isSetDstPath() {
      return this.dstPath != null;
    }

    public void setDstPathIsSet(boolean value) {
      if (!value) {
        this.dstPath = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case SRC_PATH:
        if (value == null) {
          unsetSrcPath();
        } else {
          setSrcPath((String)value);
        }
        break;

      case DST_PATH:
        if (value == null) {
          unsetDstPath();
        } else {
          setDstPath((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      case SRC_PATH:
        return getSrcPath();

      case DST_PATH:
        return getDstPath();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      case SRC_PATH:
        return isSetSrcPath();
      case DST_PATH:
        return isSetDstPath();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_rename_args)
        return this.equals((user_rename_args)that);
      return false;
    }

    public boolean equals(user_rename_args that) {
      if (that == null)
        return false;

      boolean this_present_fileId = true;
      boolean that_present_fileId = true;
      if (this_present_fileId || that_present_fileId) {
        if (!(this_present_fileId && that_present_fileId))
          return false;
        if (this.fileId != that.fileId)
          return false;
      }

      boolean this_present_srcPath = true && this.isSetSrcPath();
      boolean that_present_srcPath = true && that.isSetSrcPath();
      if (this_present_srcPath || that_present_srcPath) {
        if (!(this_present_srcPath && that_present_srcPath))
          return false;
        if (!this.srcPath.equals(that.srcPath))
          return false;
      }

      boolean this_present_dstPath = true && this.isSetDstPath();
      boolean that_present_dstPath = true && that.isSetDstPath();
      if (this_present_dstPath || that_present_dstPath) {
        if (!(this_present_dstPath && that_present_dstPath))
          return false;
        if (!this.dstPath.equals(that.dstPath))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_rename_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetFileId()).compareTo(other.isSetFileId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFileId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fileId, other.fileId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSrcPath()).compareTo(other.isSetSrcPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSrcPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.srcPath, other.srcPath);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDstPath()).compareTo(other.isSetDstPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDstPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dstPath, other.dstPath);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_rename_args(");
      boolean first = true;

      sb.append("fileId:");
      sb.append(this.fileId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("srcPath:");
      if (this.srcPath == null) {
        sb.append("null");
      } else {
        sb.append(this.srcPath);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("dstPath:");
      if (this.dstPath == null) {
        sb.append("null");
      } else {
        sb.append(this.dstPath);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_rename_argsStandardSchemeFactory implements SchemeFactory {
      public user_rename_argsStandardScheme getScheme() {
        return new user_rename_argsStandardScheme();
      }
    }

    private static class user_rename_argsStandardScheme extends StandardScheme<user_rename_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_rename_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // FILE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.fileId = iprot.readI32();
                struct.setFileIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SRC_PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.srcPath = iprot.readString();
                struct.setSrcPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // DST_PATH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.dstPath = iprot.readString();
                struct.setDstPathIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_rename_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(FILE_ID_FIELD_DESC);
        oprot.writeI32(struct.fileId);
        oprot.writeFieldEnd();
        if (struct.srcPath != null) {
          oprot.writeFieldBegin(SRC_PATH_FIELD_DESC);
          oprot.writeString(struct.srcPath);
          oprot.writeFieldEnd();
        }
        if (struct.dstPath != null) {
          oprot.writeFieldBegin(DST_PATH_FIELD_DESC);
          oprot.writeString(struct.dstPath);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_rename_argsTupleSchemeFactory implements SchemeFactory {
      public user_rename_argsTupleScheme getScheme() {
        return new user_rename_argsTupleScheme();
      }
    }

    private static class user_rename_argsTupleScheme extends TupleScheme<user_rename_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_rename_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetFileId()) {
          optionals.set(0);
        }
        if (struct.isSetSrcPath()) {
          optionals.set(1);
        }
        if (struct.isSetDstPath()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetFileId()) {
          oprot.writeI32(struct.fileId);
        }
        if (struct.isSetSrcPath()) {
          oprot.writeString(struct.srcPath);
        }
        if (struct.isSetDstPath()) {
          oprot.writeString(struct.dstPath);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_rename_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.fileId = iprot.readI32();
          struct.setFileIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.srcPath = iprot.readString();
          struct.setSrcPathIsSet(true);
        }
        if (incoming.get(2)) {
          struct.dstPath = iprot.readString();
          struct.setDstPathIsSet(true);
        }
      }
    }

  }

  public static class user_rename_result implements org.apache.thrift.TBase<user_rename_result, user_rename_result._Fields>, java.io.Serializable, Cloneable, Comparable<user_rename_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_rename_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField E_A_FIELD_DESC = new org.apache.thrift.protocol.TField("eA", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField E_F_FIELD_DESC = new org.apache.thrift.protocol.TField("eF", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField E_I_FIELD_DESC = new org.apache.thrift.protocol.TField("eI", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_rename_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_rename_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public FileAlreadyExistException eA; // required
    public FileDoesNotExistException eF; // required
    public InvalidPathException eI; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E_A((short)1, "eA"),
      E_F((short)2, "eF"),
      E_I((short)3, "eI");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E_A
            return E_A;
          case 2: // E_F
            return E_F;
          case 3: // E_I
            return E_I;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.E_A, new org.apache.thrift.meta_data.FieldMetaData("eA", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_F, new org.apache.thrift.meta_data.FieldMetaData("eF", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.E_I, new org.apache.thrift.meta_data.FieldMetaData("eI", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_rename_result.class, metaDataMap);
    }

    public user_rename_result() {
    }

    public user_rename_result(
      boolean success,
      FileAlreadyExistException eA,
      FileDoesNotExistException eF,
      InvalidPathException eI)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.eA = eA;
      this.eF = eF;
      this.eI = eI;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_rename_result(user_rename_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetEA()) {
        this.eA = new FileAlreadyExistException(other.eA);
      }
      if (other.isSetEF()) {
        this.eF = new FileDoesNotExistException(other.eF);
      }
      if (other.isSetEI()) {
        this.eI = new InvalidPathException(other.eI);
      }
    }

    public user_rename_result deepCopy() {
      return new user_rename_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.eA = null;
      this.eF = null;
      this.eI = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public user_rename_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public FileAlreadyExistException getEA() {
      return this.eA;
    }

    public user_rename_result setEA(FileAlreadyExistException eA) {
      this.eA = eA;
      return this;
    }

    public void unsetEA() {
      this.eA = null;
    }

    /** Returns true if field eA is set (has been assigned a value) and false otherwise */
    public boolean isSetEA() {
      return this.eA != null;
    }

    public void setEAIsSet(boolean value) {
      if (!value) {
        this.eA = null;
      }
    }

    public FileDoesNotExistException getEF() {
      return this.eF;
    }

    public user_rename_result setEF(FileDoesNotExistException eF) {
      this.eF = eF;
      return this;
    }

    public void unsetEF() {
      this.eF = null;
    }

    /** Returns true if field eF is set (has been assigned a value) and false otherwise */
    public boolean isSetEF() {
      return this.eF != null;
    }

    public void setEFIsSet(boolean value) {
      if (!value) {
        this.eF = null;
      }
    }

    public InvalidPathException getEI() {
      return this.eI;
    }

    public user_rename_result setEI(InvalidPathException eI) {
      this.eI = eI;
      return this;
    }

    public void unsetEI() {
      this.eI = null;
    }

    /** Returns true if field eI is set (has been assigned a value) and false otherwise */
    public boolean isSetEI() {
      return this.eI != null;
    }

    public void setEIIsSet(boolean value) {
      if (!value) {
        this.eI = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case E_A:
        if (value == null) {
          unsetEA();
        } else {
          setEA((FileAlreadyExistException)value);
        }
        break;

      case E_F:
        if (value == null) {
          unsetEF();
        } else {
          setEF((FileDoesNotExistException)value);
        }
        break;

      case E_I:
        if (value == null) {
          unsetEI();
        } else {
          setEI((InvalidPathException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case E_A:
        return getEA();

      case E_F:
        return getEF();

      case E_I:
        return getEI();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E_A:
        return isSetEA();
      case E_F:
        return isSetEF();
      case E_I:
        return isSetEI();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_rename_result)
        return this.equals((user_rename_result)that);
      return false;
    }

    public boolean equals(user_rename_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_eA = true && this.isSetEA();
      boolean that_present_eA = true && that.isSetEA();
      if (this_present_eA || that_present_eA) {
        if (!(this_present_eA && that_present_eA))
          return false;
        if (!this.eA.equals(that.eA))
          return false;
      }

      boolean this_present_eF = true && this.isSetEF();
      boolean that_present_eF = true && that.isSetEF();
      if (this_present_eF || that_present_eF) {
        if (!(this_present_eF && that_present_eF))
          return false;
        if (!this.eF.equals(that.eF))
          return false;
      }

      boolean this_present_eI = true && this.isSetEI();
      boolean that_present_eI = true && that.isSetEI();
      if (this_present_eI || that_present_eI) {
        if (!(this_present_eI && that_present_eI))
          return false;
        if (!this.eI.equals(that.eI))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    @Override
    public int compareTo(user_rename_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEA()).compareTo(other.isSetEA());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEA()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eA, other.eA);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEF()).compareTo(other.isSetEF());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEF()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eF, other.eF);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEI()).compareTo(other.isSetEI());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEI()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.eI, other.eI);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("user_rename_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("eA:");
      if (this.eA == null) {
        sb.append("null");
      } else {
        sb.append(this.eA);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eF:");
      if (this.eF == null) {
        sb.append("null");
      } else {
        sb.append(this.eF);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("eI:");
      if (this.eI == null) {
        sb.append("null");
      } else {
        sb.append(this.eI);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class user_rename_resultStandardSchemeFactory implements SchemeFactory {
      public user_rename_resultStandardScheme getScheme() {
        return new user_rename_resultStandardScheme();
      }
    }

    private static class user_rename_resultStandardScheme extends StandardScheme<user_rename_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, user_rename_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E_A
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eA = new FileAlreadyExistException();
                struct.eA.read(iprot);
                struct.setEAIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // E_F
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eF = new FileDoesNotExistException();
                struct.eF.read(iprot);
                struct.setEFIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // E_I
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.eI = new InvalidPathException();
                struct.eI.read(iprot);
                struct.setEIIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, user_rename_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.eA != null) {
          oprot.writeFieldBegin(E_A_FIELD_DESC);
          struct.eA.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eF != null) {
          oprot.writeFieldBegin(E_F_FIELD_DESC);
          struct.eF.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.eI != null) {
          oprot.writeFieldBegin(E_I_FIELD_DESC);
          struct.eI.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class user_rename_resultTupleSchemeFactory implements SchemeFactory {
      public user_rename_resultTupleScheme getScheme() {
        return new user_rename_resultTupleScheme();
      }
    }

    private static class user_rename_resultTupleScheme extends TupleScheme<user_rename_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, user_rename_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetEA()) {
          optionals.set(1);
        }
        if (struct.isSetEF()) {
          optionals.set(2);
        }
        if (struct.isSetEI()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetEA()) {
          struct.eA.write(oprot);
        }
        if (struct.isSetEF()) {
          struct.eF.write(oprot);
        }
        if (struct.isSetEI()) {
          struct.eI.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, user_rename_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.eA = new FileAlreadyExistException();
          struct.eA.read(iprot);
          struct.setEAIsSet(true);
        }
        if (incoming.get(2)) {
          struct.eF = new FileDoesNotExistException();
          struct.eF.read(iprot);
          struct.setEFIsSet(true);
        }
        if (incoming.get(3)) {
          struct.eI = new InvalidPathException();
          struct.eI.read(iprot);
          struct.setEIIsSet(true);
        }
      }
    }

  }

  public static class user_setPinned_args implements org.apache.thrift.TBase<user_setPinned_args, user_setPinned_args._Fields>, java.io.Serializable, Cloneable, Comparable<user_setPinned_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("user_setPinned_args");

    private static final org.apache.thrift.protocol.TField FILE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("fileId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField PINNED_FIELD_DESC = new org.apache.thrift.protocol.TField("pinned", org.apache.thrift.protocol.TType.BOOL, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new user_setPinned_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new user_setPinned_argsTupleSchemeFactory());
    }

    public int fileId; // required
    public boolean pinned; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      FILE_ID((short)1, "fileId"),
      PINNED((short)2, "pinned");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // FILE_ID
            return FILE_ID;
          case 2: // PINNED
            return PINNED;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FILEID_ISSET_ID = 0;
    private static final int __PINNED_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.FILE_ID, new org.apache.thrift.meta_data.FieldMetaData("fileId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.PINNED, new org.apache.thrift.meta_data.FieldMetaData("pinned", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(user_setPinned_args.class, metaDataMap);
    }

    public user_setPinned_args() {
    }

    public user_setPinned_args(
      int fileId,
      boolean pinned)
    {
      this();
      this.fileId = fileId;
      setFileIdIsSet(true);
      this.pinned = pinned;
      setPinnedIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public user_setPinned_args(user_setPinned_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.fileId = other.fileId;
      this.pinned = other.pinned;
    }

    public user_setPinned_args deepCopy() {
      return new user_setPinned_args(this);
    }

    @Override
    public void clear() {
      setFileIdIsSet(false);
      this.fileId = 0;
      setPinnedIsSet(false);
      this.pinned = false;
    }

    public int getFileId() {
      return this.fileId;
    }

    public user_setPinned_args setFileId(int fileId) {
      this.fileId = fileId;
      setFileIdIsSet(true);
      return this;
    }

    public void unsetFileId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    /** Returns true if field fileId is set (has been assigned a value) and false otherwise */
    public boolean isSetFileId() {
      return EncodingUtils.testBit(__isset_bitfield, __FILEID_ISSET_ID);
    }

    public void setFileIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __FILEID_ISSET_ID, value);
    }

    public boolean isPinned() {
      return this.pinned;
    }

    public user_setPinned_args setPinned(boolean pinned) {
      this.pinned = pinned;
      setPinnedIsSet(true);
      return this;
    }

    public void unsetPinned() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PINNED_ISSET_ID);
    }

    /** Returns true if field pinned is set (has been assigned a value) and false otherwise */
    public boolean isSetPinned() {
      return EncodingUtils.testBit(__isset_bitfield, __PINNED_ISSET_ID);
    }

    public void setPinnedIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PINNED_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case FILE_ID:
        if (value == null) {
          unsetFileId();
        } else {
          setFileId((Integer)value);
        }
        break;

      case PINNED:
        if (value == null) {
          unsetPinned();
        } else {
          setPinned((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case FILE_ID:
        return Integer.valueOf(getFileId());

      case PINNED:
        return Boolean.valueOf(isPinned());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case FILE_ID:
        return isSetFileId();
      case PINNED:
        return isSetPinned();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof user_setPinned_args)
        return this.equals((user_setPinned_args)that);
      return false;
    }

    public boolean equals(user_setPinned_args that) {
      if (that == null)
        re