/*
 * Decompiled with CFR 0.152.
 */
package tachyon.underfs;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystem;
import tachyon.underfs.UnderFileSystemFactory;

public final class UnderFileSystemRegistry {
    private static final List<UnderFileSystemFactory> FACTORIES = new CopyOnWriteArrayList<UnderFileSystemFactory>();
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static boolean sInit = false;

    public static List<UnderFileSystemFactory> available() {
        return Collections.unmodifiableList(FACTORIES);
    }

    public static UnderFileSystem create(String path, TachyonConf tachyonConf, Object ufsConf) {
        List<UnderFileSystemFactory> factories = UnderFileSystemRegistry.findAll(path, tachyonConf);
        if (factories.isEmpty()) {
            throw new IllegalArgumentException("No Under File System Factory found for: " + path);
        }
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (UnderFileSystemFactory factory : factories) {
            try {
                return factory.create(path, tachyonConf, ufsConf);
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        StringBuilder errorStr = new StringBuilder();
        errorStr.append("All eligible Under File Systems were unable to create an instance for the given path: ").append(path).append('\n');
        for (Throwable e : errors) {
            errorStr.append(e).append('\n');
        }
        throw new IllegalArgumentException(errorStr.toString());
    }

    public static UnderFileSystemFactory find(String path, TachyonConf tachyonConf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        for (UnderFileSystemFactory factory : FACTORIES) {
            if (!factory.supportsPath(path, tachyonConf)) continue;
            LOG.debug("Selected Under File System Factory implementation {} for path {}", factory.getClass(), (Object)path);
            return factory;
        }
        LOG.warn("No Under File System Factory implementation supports the path {}", (Object)path);
        return null;
    }

    public static List<UnderFileSystemFactory> findAll(String path, TachyonConf tachyonConf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        ArrayList<UnderFileSystemFactory> eligibleFactories = new ArrayList<UnderFileSystemFactory>();
        for (UnderFileSystemFactory factory : FACTORIES) {
            if (!factory.supportsPath(path, tachyonConf)) continue;
            LOG.debug("Under File System Factory implementation {} is eligible for path {}", factory.getClass(), (Object)path);
            eligibleFactories.add(factory);
        }
        if (eligibleFactories.isEmpty()) {
            LOG.warn("No Under File System Factory implementation supports the path {}", (Object)path);
        }
        return eligibleFactories;
    }

    private static synchronized void init() {
        if (sInit) {
            return;
        }
        ServiceLoader<UnderFileSystemFactory> discoveredFactories = ServiceLoader.load(UnderFileSystemFactory.class);
        for (UnderFileSystemFactory factory : discoveredFactories) {
            LOG.debug("Discovered Under File System Factory implementation {} - {}", factory.getClass(), (Object)factory.toString());
            FACTORIES.add(factory);
        }
        sInit = true;
    }

    public static void register(UnderFileSystemFactory factory) {
        if (factory == null) {
            return;
        }
        LOG.debug("Registered Under File System Factory implementation {} - {}", factory.getClass(), (Object)factory.toString());
        FACTORIES.add(0, factory);
    }

    public static synchronized void reset() {
        if (sInit) {
            sInit = false;
            FACTORIES.clear();
        }
        UnderFileSystemRegistry.init();
    }

    public static void unregister(UnderFileSystemFactory factory) {
        if (factory == null) {
            return;
        }
        LOG.debug("Unregistered Under File System Factory implementation {} - {}", factory.getClass(), (Object)factory.toString());
        FACTORIES.remove(factory);
    }

    static {
        UnderFileSystemRegistry.init();
    }
}

