/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.authentication;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import tachyon.conf.TachyonConf;
import tachyon.security.authentication.AuthType;
import tachyon.security.authentication.AuthenticationProvider;
import tachyon.security.authentication.PlainSaslServer;
import tachyon.security.authentication.PlainSaslServerProvider;

public final class PlainSaslUtils {
    public static boolean isPlainSaslProviderAdded() {
        return Security.getProvider("SaslPlain") != null;
    }

    public static TTransportFactory getPlainServerTransportFactory(AuthType authType, TachyonConf conf) throws SaslException {
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        AuthenticationProvider provider = AuthenticationProvider.Factory.getAuthenticationProvider(authType, conf);
        saslFactory.addServerDefinition("PLAIN", null, null, new HashMap(), (CallbackHandler)new PlainSaslServer.PlainServerCallbackHandler(provider));
        return saslFactory;
    }

    public static TTransport getPlainClientTransport(String username, String password, TTransport wrappedTransport) throws SaslException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap(), (CallbackHandler)new PlainClientCallbackHandler(username, password), wrappedTransport);
    }

    static {
        Security.addProvider(new PlainSaslServerProvider());
    }

    public static class PlainClientCallbackHandler
    implements CallbackHandler {
        private final String mUserName;
        private final String mPassword;

        public PlainClientCallbackHandler(String userName, String password) {
            this.mUserName = userName;
            this.mPassword = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.mUserName);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callback;
                    passCallback.setPassword(this.mPassword == null ? null : this.mPassword.toCharArray());
                    continue;
                }
                Class<?> callbackClass = callback == null ? null : callback.getClass();
                throw new UnsupportedCallbackException(callback, callbackClass + " is unsupported.");
            }
        }
    }
}

