/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.authentication;

import javax.security.sasl.AuthenticationException;
import tachyon.security.authentication.AuthenticationProvider;
import tachyon.util.CommonUtils;

public class CustomAuthenticationProviderImpl
implements AuthenticationProvider {
    private final AuthenticationProvider mCustomProvider;

    public CustomAuthenticationProviderImpl(String providerName) {
        Class<?> customProviderClass;
        try {
            customProviderClass = Class.forName(providerName);
        }
        catch (ClassNotFoundException cfe) {
            throw new RuntimeException(providerName + " not found");
        }
        try {
            this.mCustomProvider = (AuthenticationProvider)CommonUtils.createNewClassInstance(customProviderClass, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(customProviderClass.getName() + " instantiate failed :" + e.getMessage());
        }
    }

    public AuthenticationProvider getCustomProvider() {
        return this.mCustomProvider;
    }

    @Override
    public void authenticate(String user, String password) throws AuthenticationException {
        this.mCustomProvider.authenticate(user, password);
    }
}

