/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.zk;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.zk.ClientDecorator;

public class Zk {
    private static Logger log = LoggerFactory.getLogger(Zk.class);
    private static final String CHARSET = "utf-8";
    public static CuratorFramework zkclient = null;

    public static void init(String address, ClientDecorator clientDecorator) throws Exception {
        if (StrUtil.isBlank(address)) {
            log.error("zk address is null");
            throw new RuntimeException("zk address is null");
        }
        RetryForever rp = new RetryForever(500);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(address).connectionTimeoutMs(15000).sessionTimeoutMs(60000).retryPolicy((RetryPolicy)rp);
        zkclient = builder.build();
        if (clientDecorator != null) {
            clientDecorator.decorate(zkclient);
        }
    }

    public static void start() {
        zkclient.start();
    }

    public static void createOrUpdate(String path, String content, CreateMode createMode) throws Exception {
        if (content != null) {
            Zk.createOrUpdate(path, content.getBytes(CHARSET), createMode);
            return;
        }
        Zk.createOrUpdate(path, (byte[])null, createMode);
    }

    public static void createOrUpdate(String path, byte[] content, CreateMode createMode) throws Exception {
        if (!createMode.isSequential() && Zk.exists(path)) {
            log.info("\u8282\u70b9\u5df2\u7ecf\u5b58\u5728:{}", (Object)path);
            if (content != null) {
                Zk.setData(path, content);
            }
            return;
        }
        try {
            ((ACLBackgroundPathAndBytesable)zkclient.create().creatingParentsIfNeeded().withMode(createMode)).forPath(path, content);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    public static void createContainers(String path) throws Exception {
        zkclient.createContainers(path);
    }

    public static void delete(String path) throws Exception {
        ((ChildrenDeletable)zkclient.delete().guaranteed()).deletingChildrenIfNeeded().forPath(path);
        log.info("{} deleted", (Object)path);
    }

    public static boolean exists(String path) throws Exception {
        Stat stat = (Stat)zkclient.checkExists().forPath(path);
        return stat != null;
    }

    public static byte[] getBytes(String path) throws Exception {
        return (byte[])zkclient.getData().forPath(path);
    }

    public static String getString(String path, String charset) throws Exception {
        byte[] bs = Zk.getBytes(path);
        if (bs != null && bs.length > 0) {
            return new String(bs, charset);
        }
        return null;
    }

    public static String getString(String path) throws Exception {
        return Zk.getString(path, CHARSET);
    }

    public static List<String> getChildren(String path) throws Exception {
        List paths = (List)zkclient.getChildren().forPath(path);
        return paths;
    }

    public static void upload(String path, String localpath, CreateMode createMode) throws Exception {
        byte[] bs = Files.readAllBytes(new File(localpath).toPath());
        Zk.setData(path, bs);
    }

    public static void setData(String path, byte[] bs) throws Exception {
        if (bs != null) {
            if (Zk.exists(path)) {
                zkclient.setData().forPath(path, bs);
            } else {
                try {
                    ((ACLBackgroundPathAndBytesable)zkclient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, bs);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
            }
        }
    }

    public static void setData(String path, String content) throws Exception {
        if (!StrUtil.isBlank(content)) {
            Zk.setData(path, content.getBytes(CHARSET));
        }
    }

    public static void addPathChildrenCacheListener(String path, PathChildrenCacheListener pathChildrenCacheListener) throws Exception {
        PathChildrenCache cache = new PathChildrenCache(zkclient, path, true);
        cache.start();
        cache.getListenable().addListener((Object)pathChildrenCacheListener);
    }
}

