/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import java.util.Map;
import org.tio.utils.qr.scheme.Schema;
import org.tio.utils.qr.scheme.SchemeUtil;

public class VCard
extends Schema {
    private static final String BEGIN_VCARD = "BEGIN:VCARD";
    private static final String NAME = "N";
    private static final String COMPANY = "ORG";
    private static final String TITLE = "TITLE";
    private static final String PHONE = "TEL";
    private static final String WEB = "URL";
    private static final String EMAIL = "EMAIL";
    private static final String ADDRESS = "ADR";
    private static final String NOTE = "NOTE";
    private String name;
    private String company;
    private String title;
    private String phoneNumber;
    private String email;
    private String address;
    private String website;
    private String note;

    public VCard() {
    }

    public VCard(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VCard setName(String name) {
        this.name = name;
        return this;
    }

    public String getCompany() {
        return this.company;
    }

    public VCard setCompany(String company) {
        this.company = company;
        return this;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public VCard setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public VCard setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public VCard setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public VCard setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getWebsite() {
        return this.website;
    }

    public VCard setWebsite(String website) {
        this.website = website;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.startsWith(BEGIN_VCARD)) {
            throw new IllegalArgumentException("this is not a valid VCARD code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code);
        if (parameters.containsKey(NAME)) {
            this.setName(parameters.get(NAME));
        }
        if (parameters.containsKey(TITLE)) {
            this.setTitle(parameters.get(TITLE));
        }
        if (parameters.containsKey(COMPANY)) {
            this.setCompany(parameters.get(COMPANY));
        }
        if (parameters.containsKey(ADDRESS)) {
            this.setAddress(parameters.get(ADDRESS));
        }
        if (parameters.containsKey(EMAIL)) {
            this.setEmail(parameters.get(EMAIL));
        }
        if (parameters.containsKey(WEB)) {
            this.setWebsite(parameters.get(WEB));
        }
        if (parameters.containsKey(PHONE)) {
            this.setPhoneNumber(parameters.get(PHONE));
        }
        if (parameters.containsKey(NOTE)) {
            this.setNote(parameters.get(NOTE));
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_VCARD).append("\n");
        sb.append("VERSION:3.0").append("\n");
        if (this.name != null) {
            sb.append(NAME).append(":").append(this.name);
        }
        if (this.company != null) {
            sb.append("\n").append(COMPANY).append(":").append(this.company);
        }
        if (this.title != null) {
            sb.append("\n").append(TITLE).append(":").append(this.title);
        }
        if (this.phoneNumber != null) {
            sb.append("\n").append(PHONE).append(":").append(this.phoneNumber);
        }
        if (this.website != null) {
            sb.append("\n").append(WEB).append(":").append(this.website);
        }
        if (this.email != null) {
            sb.append("\n").append(EMAIL).append(":").append(this.email);
        }
        if (this.address != null) {
            sb.append("\n").append(ADDRESS).append(":").append(this.address);
        }
        if (this.note != null) {
            sb.append("\n").append(NOTE).append(":").append(this.note);
        }
        sb.append("\n").append("END:VCARD");
        return sb.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static VCard parse(String code) {
        VCard vCard = new VCard();
        vCard.parseSchema(code);
        return vCard;
    }
}

