/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.token;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.BetweenFormater;

public class TokenPathAccessStat
implements Serializable {
    private static final long serialVersionUID = 3463584577647075747L;
    private Long durationType;
    private long duration;
    private String token;
    private String ip;
    private String uid;
    private String path;
    private long firstAccessTime = SystemTimer.currTime;
    private long lastAccessTime = SystemTimer.currTime;
    public final AtomicInteger count = new AtomicInteger();
    public final AtomicLong timeCost = new AtomicLong();

    public TokenPathAccessStat(Long durationType, String token, String path, String ip, String uid) {
        this.durationType = durationType;
        this.token = token;
        this.path = path;
        this.ip = ip;
        this.uid = uid;
    }

    public String getFormatedDuration() {
        this.duration = SystemTimer.currTime - this.firstAccessTime;
        BetweenFormater betweenFormater = new BetweenFormater(this.duration, BetweenFormater.Level.MILLSECOND);
        return betweenFormater.format();
    }

    public double getPerSecond() {
        int count = this.count.get();
        long duration = this.getDuration();
        double perSecond = (double)count / (double)duration * 1000.0;
        return perSecond;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getFirstAccessTime() {
        return this.firstAccessTime;
    }

    public void setFirstAccessTime(long firstAccessTime) {
        this.firstAccessTime = firstAccessTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getDuration() {
        this.duration = SystemTimer.currTime - this.firstAccessTime;
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

