/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.synchronoss.cloud.nio.multipart.util.ParameterParser;

public class MultipartUtils {
    public static final byte DASH = 45;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte[] HEADER_DELIMITER = new byte[]{13, 10, 13, 10};
    public static final String MULTIPART = "multipart/";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-transfer-encoding";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String CONTENT_TYPE = "Content-type";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";

    private MultipartUtils() {
    }

    public static boolean isMultipart(String contentTypeHeaderValue) {
        return contentTypeHeaderValue != null && contentTypeHeaderValue.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public static boolean hasMultipartContentType(Map<String, List<String>> headers) {
        return MultipartUtils.isMultipart(MultipartUtils.getHeader(CONTENT_TYPE, headers));
    }

    public static long getContentLength(Map<String, List<String>> headers) {
        long contentLength = -1L;
        String contentLengthHeaderValue = MultipartUtils.getHeader(CONTENT_LENGTH, headers);
        if (contentLengthHeaderValue != null && contentLengthHeaderValue.length() > 0) {
            try {
                contentLength = Long.parseLong(contentLengthHeaderValue);
            }
            catch (Exception e) {
                contentLength = -1L;
            }
        }
        return contentLength;
    }

    public static String getCharEncoding(Map<String, List<String>> headers) {
        String contentType = MultipartUtils.getHeader(CONTENT_TYPE, headers);
        if (contentType != null) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentType, ';');
            return params.get("charset");
        }
        return null;
    }

    public static List<String> getHeaders(String headerName, Map<String, List<String>> headers) {
        return headers.get(headerName.toLowerCase());
    }

    public static String getHeader(String headerName, Map<String, List<String>> headers) {
        List<String> headerValues = MultipartUtils.getHeaders(headerName, headers);
        if (headerValues == null || headerValues.size() == 0) {
            return null;
        }
        return headerValues.get(0);
    }

    public static boolean isFormField(Map<String, List<String>> headers) {
        String fileName = MultipartUtils.getFileName(headers);
        String fieldName = MultipartUtils.getFieldName(headers);
        return fieldName != null && fileName == null;
    }

    public static String getFileName(Map<String, List<String>> headers) {
        String contentDispositionLc;
        String contentDisposition = MultipartUtils.getHeader(CONTENT_DISPOSITION, headers);
        String fileName = null;
        if (contentDisposition != null && ((contentDispositionLc = contentDisposition.toLowerCase(Locale.ENGLISH)).startsWith(FORM_DATA) || contentDispositionLc.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    public static String getFieldName(Map<String, List<String>> headers) {
        String contentDisposition = MultipartUtils.getHeader(CONTENT_DISPOSITION, headers);
        String fieldName = null;
        if (contentDisposition != null && contentDisposition.toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    public static boolean isContentTransferEncodingBase64Encoded(Map<String, List<String>> partHeaders) {
        String contentEncoding = MultipartUtils.getHeader(CONTENT_TRANSFER_ENCODING, partHeaders);
        return contentEncoding != null && "base64".equalsIgnoreCase(contentEncoding);
    }

    public static byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }
}

