/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.purl.sword.client.SWORDComboBox;
import org.purl.sword.client.SWORDFormPanel;

public class ServiceDialog {
    private SWORDComboBox username;
    private JPasswordField password;
    private SWORDComboBox location;
    private SWORDComboBox onBehalfOf;
    private JFrame parentFrame = null;
    private JPanel controls = null;
    private static Object[] options = new Object[]{"Get Service Document", "Cancel"};

    public ServiceDialog(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.controls = this.createControls();
    }

    public int show() {
        int result = JOptionPane.showOptionDialog(this.parentFrame, this.controls, "Get Service Document", 2, -1, null, options, options[1]);
        if (result == 0) {
            this.username.updateList();
            this.location.updateList();
            this.onBehalfOf.updateList();
        }
        return result;
    }

    protected JPanel createControls() {
        this.username = new SWORDComboBox();
        this.username.setEditable(true);
        this.password = new JPasswordField();
        this.location = new SWORDComboBox();
        this.location.setEditable(true);
        this.onBehalfOf = new SWORDComboBox();
        this.onBehalfOf.setEditable(true);
        JLabel userLabel = new JLabel("Username:", 11);
        JLabel passwordLabel = new JLabel("Password:", 11);
        JLabel locationLabel = new JLabel("Location:", 11);
        JLabel onBehalfOfLabel = new JLabel("On Behalf Of:", 11);
        SWORDFormPanel panel = new SWORDFormPanel();
        panel.addFirstRow(userLabel, this.username);
        panel.addRow(passwordLabel, this.password);
        panel.addRow(locationLabel, this.location);
        panel.addRow(onBehalfOfLabel, this.onBehalfOf);
        return panel;
    }

    public String getUsername() {
        return this.username.getText();
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public String getLocation() {
        return this.location.getText();
    }

    public String getOnBehalfOf() {
        String text = this.onBehalfOf.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public void addUserIds(String[] users) {
        this.username.insertItems(users);
    }

    public void addServiceUrls(String[] services) {
        this.location.insertItems(services);
    }

    public void addOnBehalfOf(String[] users) {
        this.onBehalfOf.insertItems(users);
    }
}

