/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import org.jboss.logging.Logger;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.internal.TransformMessages;

@Scannable(value=false)
public class JAXBUnmarshalTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private static Logger _logger = Logger.getLogger(JAXBUnmarshalTransformer.class);
    private JAXBContext _jaxbContext;
    private boolean _isXOPPackage;

    public JAXBUnmarshalTransformer(QName from, QName to, String contextPath, boolean isXOPPackage) throws SwitchYardException {
        super(from, to);
        this._isXOPPackage = isXOPPackage;
        try {
            this._jaxbContext = contextPath != null ? JAXBContext.newInstance((String)contextPath) : JAXBContext.newInstance((Class[])new Class[]{QNameUtil.toJavaMessageType((QName)to)});
        }
        catch (JAXBException e) {
            throw TransformMessages.MESSAGES.failedToCreateJAXBContext(to.toString(), e);
        }
    }

    public Message transform(Message message) {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = this._jaxbContext.createUnmarshaller();
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new JAXBAttachmentUnmarshaller(message, this._isXOPPackage));
        }
        catch (JAXBException e) {
            throw TransformMessages.MESSAGES.failedToCreateMarshaller(this.getTo().toString(), e);
        }
        try {
            Object unmarshalledObject;
            Source source;
            byte[] bytes = null;
            if (InputStream.class.isAssignableFrom(message.getContent().getClass()) || Reader.class.isAssignableFrom(message.getContent().getClass())) {
                bytes = (byte[])message.getContent(byte[].class);
                message.setContent((Object)bytes);
            }
            if ((source = (Source)message.getContent(Source.class)) instanceof StAXSource || source instanceof SAXSource) {
                if (bytes != null) {
                    message.setContent((Object)bytes);
                }
                source = (Source)message.getContent(DOMSource.class);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unmarshalling from " + source.getClass() + ", systemId=" + source.getSystemId()));
            }
            if ((unmarshalledObject = unmarshaller.unmarshal(source)) instanceof JAXBElement) {
                message.setContent(((JAXBElement)unmarshalledObject).getValue());
            } else {
                message.setContent(unmarshalledObject);
            }
        }
        catch (JAXBException e) {
            throw TransformMessages.MESSAGES.failedToUnmarshallForType(this.getTo().toString(), e);
        }
        return message;
    }

    class JAXBAttachmentUnmarshaller
    extends AttachmentUnmarshaller {
        private Message _message;
        private boolean _xop;

        JAXBAttachmentUnmarshaller(Message message, boolean xop) {
            this._message = message;
            this._xop = xop;
        }

        public DataHandler getAttachmentAsDataHandler(String cid) {
            if (this._message.getAttachment(cid) == null) {
                return null;
            }
            return new DataHandler(this._message.getAttachment(cid));
        }

        public byte[] getAttachmentAsByteArray(String cid) {
            if (this._message.getAttachment(cid) == null) {
                return null;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                int read;
                InputStream is = this._message.getAttachment(cid).getInputStream();
                byte[] buff = new byte[128];
                while ((read = is.read(buff)) != -1) {
                    os.write(buff, 0, read);
                }
                os.flush();
                os.close();
                is.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return os.toByteArray();
        }

        public boolean isXOPPackage() {
            return this._xop;
        }
    }
}

