/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.camel.internal;

import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.switchyard.Context;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.camel.ContextPropertyUtil;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.internal.TransformMessages;

@Scannable(value=false)
public class CamelTransformer
extends BaseTransformer<Message, Message> {
    private Endpoint _endpoint;

    protected CamelTransformer(QName from, QName to, Endpoint endpoint) {
        super(from, to);
        this._endpoint = endpoint;
    }

    public Message transform(Message message) {
        try {
            Exchange exchange = this._endpoint.createExchange();
            UnitOfWork uow = exchange.getContext().getUnitOfWorkFactory().createUnitOfWork(exchange);
            DefaultRouteContext rc = new DefaultRouteContext(exchange.getContext());
            uow.pushRouteContext((RouteContext)rc);
            exchange.setUnitOfWork(uow);
            uow.start();
            exchange.getIn().setBody(message.getContent());
            this.copyProperties(message.getContext(), exchange);
            Producer producer = this._endpoint.createProducer();
            producer.process(exchange);
            if (exchange.isFailed()) {
                if (exchange.getException() != null) {
                    throw TransformMessages.MESSAGES.failedToTransformViaCamelEndpoint(this._endpoint.getEndpointUri(), exchange.getException());
                }
                throw TransformMessages.MESSAGES.failedToTransformViaCamelEndpoint(this._endpoint.getEndpointUri(), (String)exchange.getIn().getBody(String.class));
            }
            if (QNameUtil.isJavaMessageType((QName)this.getTo())) {
                message.setContent(exchange.getIn().getBody(QNameUtil.toJavaMessageType((QName)this.getTo())));
            } else {
                message.setContent(exchange.getIn().getBody());
            }
            return message;
        }
        catch (Exception e) {
            throw TransformMessages.MESSAGES.failedToTransformViaCamelEndpoint(this._endpoint.getEndpointUri(), e);
        }
    }

    private void copyProperties(Context context, Exchange exchange) {
        for (Property property : context.getProperties()) {
            if (property.hasLabel(BehaviorLabel.TRANSIENT.label()) || ContextPropertyUtil.isReservedProperty((String)property.getName(), (Scope)property.getScope())) continue;
            if (Scope.EXCHANGE.equals((Object)property.getScope())) {
                exchange.setProperty(property.getName(), property.getValue());
                continue;
            }
            exchange.getIn().setHeader(property.getName(), property.getValue());
        }
    }
}

