/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.smooks.internal;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.milyn.Smooks;
import org.milyn.container.plugin.SourceFactory;
import org.milyn.javabean.binding.model.Bean;
import org.milyn.javabean.binding.model.ModelSet;
import org.milyn.javabean.binding.xml.XMLBinding;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.TransformMessages;

@Scannable(value=false)
public class XMLBindingTransformer
extends BaseTransformer {
    private static Logger _log = Logger.getLogger(XMLBindingTransformer.class);
    private XMLBinding _xmlBinding;
    private Bean _bean;
    private BindingDirection _direction;

    protected XMLBindingTransformer(QName from, QName to, Smooks smooks, ModelSet beanModel, BindingDirection direction) {
        super(from, to);
        this._xmlBinding = new XMLBinding(smooks);
        this._xmlBinding.setOmitXMLDeclaration(true);
        this._xmlBinding.intiailize();
        this._bean = (Bean)beanModel.getModels().values().iterator().next();
        this._direction = direction;
    }

    public Object transform(Object from) {
        if (from == null) {
            _log.debug((Object)"Null from payload passed to XMLBindingTransformer.  Returning null.");
            return null;
        }
        if (this._direction == BindingDirection.XML2JAVA) {
            Source source = SourceFactory.getInstance().createSource(from);
            try {
                return this._xmlBinding.fromXML(source, this._bean.getBeanClass());
            }
            catch (IOException e) {
                throw TransformMessages.MESSAGES.exceptionTransformingFromXML(this._bean.getBeanClass().getName(), e);
            }
        }
        if (!this._bean.getBeanClass().isInstance(from)) {
            throw TransformMessages.MESSAGES.cannotTransformToXML(from.getClass().getName(), this._bean.getBeanClass().getName());
        }
        return this._xmlBinding.toXML(from);
    }

    public static enum BindingDirection {
        XML2JAVA,
        JAVA2XML;

    }
}

