/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.smooks.internal;

import javax.xml.namespace.QName;
import org.milyn.Smooks;
import org.milyn.container.ApplicationContext;
import org.milyn.javabean.binding.model.ModelSet;
import org.switchyard.transform.TransformMessages;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.SmooksTransformModel;
import org.switchyard.transform.config.model.SmooksTransformType;
import org.switchyard.transform.internal.TransformerFactory;
import org.switchyard.transform.smooks.internal.SmooksTransformer;
import org.switchyard.transform.smooks.internal.XMLBindingTransformer;

public class SmooksTransformFactory
implements TransformerFactory<SmooksTransformModel> {
    @Override
    public Transformer newTransformer(SmooksTransformModel model) {
        Object transformer;
        Smooks smooks;
        String transformType = model.getTransformType();
        String config = model.getConfig();
        QName from = model.getFrom();
        QName to = model.getTo();
        if (transformType == null || transformType.trim().length() == 0) {
            throw TransformMessages.MESSAGES.invalidSmooksConfigurationModelNullType();
        }
        if (config == null || config.trim().length() == 0) {
            throw TransformMessages.MESSAGES.invalidSmooksConfigurationModelNullConfig();
        }
        if (from == null) {
            throw TransformMessages.MESSAGES.invalidSmooksConfigurationModelNullFrom();
        }
        if (to == null) {
            throw TransformMessages.MESSAGES.invalidSmooksConfigurationModelNullTo();
        }
        SmooksTransformType transformationType = SmooksTransformType.valueOf(transformType);
        try {
            smooks = new Smooks(config);
            smooks.createExecutionContext();
        }
        catch (Exception e) {
            throw TransformMessages.MESSAGES.failedToCreateSmooksInstance(config, e);
        }
        if (transformationType == SmooksTransformType.JAVA2XML) {
            transformer = SmooksTransformFactory.newXMLBindingTransformer(from, to, smooks, XMLBindingTransformer.BindingDirection.JAVA2XML);
        } else if (transformationType == SmooksTransformType.XML2JAVA) {
            transformer = SmooksTransformFactory.newXMLBindingTransformer(from, to, smooks, XMLBindingTransformer.BindingDirection.XML2JAVA);
        } else if (transformationType == SmooksTransformType.SMOOKS) {
            transformer = new SmooksTransformer(from, to, smooks, model);
        } else {
            throw TransformMessages.MESSAGES.unhandledSmooksTransformationType(transformationType.toString());
        }
        transformer.setFrom(model.getFrom());
        transformer.setTo(model.getTo());
        return transformer;
    }

    private static Transformer newXMLBindingTransformer(QName from, QName to, Smooks smooks, XMLBindingTransformer.BindingDirection direction) {
        ModelSet beanModel = ModelSet.get((ApplicationContext)smooks.getApplicationContext());
        if (beanModel != null && !beanModel.getModels().isEmpty()) {
            return new XMLBindingTransformer(from, to, smooks, beanModel, direction);
        }
        throw TransformMessages.MESSAGES.invalidBindingConfiguration(direction.toString());
    }
}

