/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.config.model;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.switchyard.common.cdi.CDIUtil;
import org.switchyard.common.type.classpath.AbstractTypeFilter;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scannable;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.transform.v1.V1TransformsModel;
import org.switchyard.transform.config.model.v1.V1JavaTransformModel;
import org.switchyard.transform.internal.TransformerTypes;
import org.switchyard.transform.internal.TransformerUtil;

public class TransformSwitchYardScanner
implements Scanner<SwitchYardModel> {
    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1TransformsModel transformsModel = null;
        List<Class<?>> transformerClasses = this.scanForTransformers(input.getURLs());
        for (Class<?> transformer : transformerClasses) {
            List<TransformerTypes> supportedTransforms = TransformerUtil.listTransformations(transformer);
            for (TransformerTypes supportedTransform : supportedTransforms) {
                V1JavaTransformModel transformModel = new V1JavaTransformModel();
                String bean = CDIUtil.getNamedAnnotationValue(transformer);
                if (bean != null) {
                    transformModel.setBean(bean);
                } else {
                    transformModel.setClazz(transformer.getName());
                }
                transformModel.setFrom(supportedTransform.getFrom());
                transformModel.setTo(supportedTransform.getTo());
                if (transformsModel == null) {
                    transformsModel = new V1TransformsModel();
                    switchyardModel.setTransforms((TransformsModel)transformsModel);
                }
                transformsModel.addTransform((TransformModel)transformModel);
            }
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    private List<Class<?>> scanForTransformers(List<URL> urls) throws IOException {
        TransformerInstanceOfFilter filter = new TransformerInstanceOfFilter();
        ClasspathScanner scanner = new ClasspathScanner((Filter)filter);
        for (URL url : urls) {
            scanner.scan(url);
        }
        return filter.getMatchedTypes();
    }

    private class TransformerInstanceOfFilter
    extends AbstractTypeFilter {
        private TransformerInstanceOfFilter() {
        }

        public boolean matches(Class<?> clazz) {
            Scannable scannable = clazz.getAnnotation(Scannable.class);
            if (scannable != null && !scannable.value()) {
                return false;
            }
            return TransformerUtil.isTransformer(clazz);
        }
    }
}

