/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.json.internal;

import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

public class JSON2JavaTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private ObjectMapper _mapper;
    private Class _clazz;

    public JSON2JavaTransformer(QName from, QName to, ObjectMapper mapper, Class clazz) {
        super(from, to);
        this._mapper = mapper;
        this._clazz = clazz;
    }

    public Message transform(Message message) {
        try {
            Object result = this._mapper.readValue((Reader)message.getContent(Reader.class), this._clazz);
            if (this._clazz.isInstance(result)) {
                message.setContent(result);
                return message;
            }
            throw new SwitchYardException("Result of transformation has wrong instance type " + result.getClass());
        }
        catch (JsonParseException e) {
            throw new SwitchYardException("Unexpected JSON parse exception, check your transformer configuration", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new SwitchYardException("Unexpected JSON mapping exception, check your transformer configuration", (Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException("Unexpected I/O exception, check your transformer configuration", (Throwable)e);
        }
    }
}

