/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.map;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;

public class FromMapToJava<F, T>
extends BaseTransformer<Map, Object> {
    private static Logger _logger = Logger.getLogger(FromMapToJava.class);
    private GraphBuilder _graphBuilder;
    private static Map<Class, Class> primitives = new HashMap<Class, Class>();

    public FromMapToJava() {
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
    }

    public Transformer setTo(QName toType) {
        super.setTo(toType);
        if (!QNameUtil.isJavaMessageType((QName)toType)) {
            throw new SwitchYardException("Invalid 'to' type '" + toType + "'.  Must be a Java Object type.");
        }
        Class javaType = QNameUtil.toJavaMessageType((QName)toType);
        if (javaType == null) {
            throw new SwitchYardException("Invalid 'to' type '" + toType + "'.  Class Not Found.");
        }
        this._graphBuilder = new ComplexTypeBuilder(javaType, null, null);
        return this;
    }

    public Object transform(Map from) {
        return this._graphBuilder.build(from);
    }

    private final class CollectionTypeBuilder
    extends GraphBuilder {
        private volatile GraphBuilder _collectionEntryBuilder;
        private Class<?> _collectionEntryType;

        private CollectionTypeBuilder(Class<?> collectionType, Class<?> collectionEntryType, GraphBuilder parentBuilder, Method parentSetterMethod) {
            super(collectionType, parentBuilder, parentSetterMethod);
            this._collectionEntryType = collectionEntryType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object build(Object value) {
            CollectionTypeBuilder collectionTypeBuilder = this;
            synchronized (collectionTypeBuilder) {
                Collection instance = (Collection)this.newInstance();
                if (value instanceof Collection) {
                    for (Object arrayEntry : (Collection)value) {
                        if (this._collectionEntryBuilder == null) {
                            this._collectionEntryBuilder = this.newBuilder(arrayEntry.getClass(), this._collectionEntryType, null);
                        }
                        instance.add(this._collectionEntryBuilder.build(arrayEntry));
                    }
                }
                return instance;
            }
        }
    }

    private final class ComplexTypeBuilder
    extends GraphBuilder {
        private Map<String, GraphBuilder> _childNodes;

        private ComplexTypeBuilder(Class javaType, GraphBuilder parentBuilder, Method parentSetterMethod) {
            super(javaType, parentBuilder, parentSetterMethod);
            this._childNodes = new ConcurrentHashMap<String, GraphBuilder>();
        }

        @Override
        Object build(Object value) {
            Object instance = this.newInstance();
            if (value instanceof Map && !((Map)value).isEmpty()) {
                Set properties = ((Map)value).entrySet();
                for (Map.Entry entry : properties) {
                    String propertyName = (String)entry.getKey();
                    Object propertyValue = entry.getValue();
                    GraphBuilder nodeBuilder = this._childNodes.get(propertyName);
                    if (nodeBuilder == null) {
                        nodeBuilder = this.newBuilder(propertyName, propertyValue.getClass());
                        this._childNodes.put(propertyName, nodeBuilder);
                    }
                    Object propertyVal = nodeBuilder.build(propertyValue);
                    try {
                        this.setPropertyValue(instance, propertyVal, nodeBuilder._parentSetterMethod);
                    }
                    catch (Exception e) {
                        throw new SwitchYardException("Error invoking setter method '" + nodeBuilder._parentSetterMethod.getName() + "' on type '" + this.getJavaType().getName() + "'.", (Throwable)e);
                    }
                }
            }
            return instance;
        }
    }

    private final class SimpleTypeBuilder
    extends GraphBuilder {
        private SimpleTypeBuilder(Class javaType, GraphBuilder parentBuilder, Method parentSetterMethod) {
            super(javaType, parentBuilder, parentSetterMethod);
        }

        @Override
        Object build(Object value) {
            return value;
        }
    }

    private abstract class GraphBuilder {
        private Class _javaType;
        private String _parentPropertyName;
        private GraphBuilder _parentNode;
        private Method _parentSetterMethod;
        private BeanInfo _beanInfo;

        private GraphBuilder(Class javaType, GraphBuilder parentBuilder, Method parentSetterMethod) {
            this._javaType = javaType;
            this._parentNode = parentBuilder;
            this._parentSetterMethod = parentSetterMethod;
            try {
                this._beanInfo = Introspector.getBeanInfo(this._javaType);
            }
            catch (IntrospectionException e) {
                throw new SwitchYardException("Failed to extract bean information from bean type '" + this._javaType.getName() + "'.", (Throwable)e);
            }
        }

        public Class getJavaType() {
            return this._javaType;
        }

        public String getParentPropertyName() {
            return this._parentPropertyName;
        }

        public void setParentPropertyName(String parentPropertyName) {
            this._parentPropertyName = parentPropertyName;
        }

        abstract Object build(Object var1);

        protected void setPropertyValue(Object instance, Object propertyVal, Method parentSetterMethod) throws IllegalAccessException, InvocationTargetException {
            Class paramType = parentSetterMethod.getParameterTypes()[0];
            if (paramType.isInstance(propertyVal)) {
                parentSetterMethod.invoke(instance, propertyVal);
                return;
            }
            if (paramType.isPrimitive()) {
                paramType = (Class)primitives.get(paramType);
            }
            try {
                Constructor stringConstructor = paramType.getConstructor(String.class);
                parentSetterMethod.invoke(instance, stringConstructor.newInstance(propertyVal.toString()));
                return;
            }
            catch (Exception e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Unable to set property '" + this._parentPropertyName + "' on bean instance of type '" + instance.getClass().getName() + "'."), (Throwable)e);
                }
                return;
            }
        }

        protected GraphBuilder newBuilder(String propertyName, Class mapType) {
            Method propertySetter = this.getSetter(propertyName);
            Class<?> propertyType = propertySetter.getParameterTypes()[0];
            GraphBuilder builder = this.newBuilder(mapType, propertyType, propertySetter);
            builder.setParentPropertyName(propertyName);
            return builder;
        }

        protected GraphBuilder newBuilder(Class mapType, Class javaType, Method parentSetter) {
            GraphBuilder nodeBuilder = null;
            if (Collection.class.isAssignableFrom(mapType)) {
                Type[] generics = parentSetter.getGenericParameterTypes();
                if (Collection.class.isAssignableFrom(javaType) && generics != null && generics.length == 1 && generics[0] != null) {
                    ParameterizedType genericType = (ParameterizedType)generics[0];
                    Type collectionEntryType = genericType.getActualTypeArguments()[0];
                    nodeBuilder = new CollectionTypeBuilder(javaType, (Class)collectionEntryType, this, parentSetter);
                }
            } else {
                nodeBuilder = Map.class.isAssignableFrom(mapType) ? new ComplexTypeBuilder(javaType, this, parentSetter) : new SimpleTypeBuilder(javaType, this, parentSetter);
            }
            return nodeBuilder;
        }

        private Method getSetter(String propertyName) {
            Method setterMethod = null;
            for (PropertyDescriptor propertyDesc : this._beanInfo.getPropertyDescriptors()) {
                if (!propertyDesc.getName().equals(propertyName)) continue;
                setterMethod = propertyDesc.getWriteMethod();
                break;
            }
            if (setterMethod == null) {
                throw new SwitchYardException("No setter method for property '" + propertyName + "' on class '" + this._javaType.getName() + "'.");
            }
            return setterMethod;
        }

        protected Object newInstance() {
            if (this._javaType == Collection.class) {
                return new ArrayList();
            }
            if (this._javaType == List.class) {
                return new ArrayList();
            }
            try {
                return this._javaType.newInstance();
            }
            catch (Exception e) {
                throw new SwitchYardException("Unable to create instance of type '" + this._javaType.getName() + "'.", (Throwable)e);
            }
        }
    }
}

