/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.exception.DuplicateTransformerException;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerFactory;
import org.switchyard.transform.TransformerFactoryClass;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.TransformerUtil;
import org.switchyard.transform.config.model.JavaTransformModel;

public class TransformerRegistryLoader {
    private static Logger _log = Logger.getLogger(TransformerRegistryLoader.class);
    public static final String TRANSFORMS_XML = "META-INF/switchyard/transforms.xml";
    private List<Transformer<?, ?>> _transformers = new LinkedList();
    private TransformerRegistry _transformerRegistry;
    private Map<Class<?>, TransformerFactory<?>> _transformerFactories = new HashMap();

    public TransformerRegistryLoader(TransformerRegistry transformerRegistry) {
        if (transformerRegistry == null) {
            throw new IllegalArgumentException("null 'transformerRegistry' argument.");
        }
        this._transformerRegistry = transformerRegistry;
    }

    public void registerTransformers(TransformsModel transforms) throws DuplicateTransformerException {
        if (transforms == null) {
            return;
        }
        try {
            for (TransformModel transformModel : transforms.getTransforms()) {
                Collection<Transformer<?, ?>> transformers = this.newTransformers(transformModel);
                for (Transformer<?, ?> transformer : transformers) {
                    if (this._transformerRegistry.hasTransformer(transformer.getFrom(), transformer.getTo())) {
                        Transformer registeredTransformer = this._transformerRegistry.getTransformer(transformer.getFrom(), transformer.getTo());
                        boolean test = false;
                        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                            if (!ste.getClassName().startsWith("org.switchyard.test.")) continue;
                            test = true;
                            break;
                        }
                        String msg = "Failed to register Transformer '" + this.toDescription(transformer) + "'.  A Transformer for these types is already registered: '" + this.toDescription(registeredTransformer) + "'.";
                        if (test) {
                            _log.trace((Object)msg);
                            continue;
                        }
                        throw new DuplicateTransformerException(msg);
                    }
                    _log.debug((Object)("Adding transformer => From: " + transformer.getFrom() + ", To:" + transformer.getTo()));
                    this._transformerRegistry.addTransformer(transformer);
                    this._transformers.add(transformer);
                }
            }
        }
        catch (DuplicateTransformerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.unregisterTransformers();
            throw e;
        }
    }

    public void unregisterTransformers() {
        for (Transformer<?, ?> transformer : this._transformers) {
            this._transformerRegistry.removeTransformer(transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOOTBTransforms() {
        try {
            List resources = Classes.getResources((String)TRANSFORMS_XML, this.getClass());
            for (URL resource : resources) {
                InputStream configStream = resource.openStream();
                try {
                    TransformsModel transformsModel = (TransformsModel)new ModelPuller().pull(configStream);
                    this.registerTransformers(transformsModel);
                }
                catch (DuplicateTransformerException e) {
                    _log.debug((Object)e.getMessage());
                }
                finally {
                    configStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SwitchYardException("Error reading out-of-the-box Transformer configurations from classpath (META-INF/switchyard/transforms.xml).", (Throwable)e);
        }
    }

    public Transformer<?, ?> newTransformer(TransformModel transformModel) {
        return this.newTransformers(transformModel).iterator().next();
    }

    public Collection<Transformer<?, ?>> newTransformers(TransformModel transformModel) {
        Collection<Object> transformers = null;
        if (transformModel instanceof JavaTransformModel) {
            String className = ((JavaTransformModel)transformModel).getClazz();
            Class transformClass = Classes.forName((String)className, TransformerUtil.class);
            if (transformClass == null) {
                throw new SwitchYardException("Unable to load transformer class " + className);
            }
            transformers = TransformerUtil.newTransformers(transformClass, transformModel.getFrom(), transformModel.getTo());
        } else {
            TransformerFactory<?> factory = this.getTransformerFactory(transformModel);
            transformers = new ArrayList();
            transformers.add(factory.newTransformer(transformModel));
        }
        if (transformers == null || transformers.isEmpty()) {
            throw new SwitchYardException("Unknown TransformModel type '" + transformModel.getClass().getName() + "'.");
        }
        return transformers;
    }

    private String toDescription(Transformer<?, ?> transformer) {
        return transformer.getClass().getName() + "(" + transformer.getFrom() + ", " + transformer.getTo() + ")";
    }

    private TransformerFactory<?> getTransformerFactory(TransformModel transformModel) {
        TransformerFactoryClass transformerFactoryClass = transformModel.getClass().getAnnotation(TransformerFactoryClass.class);
        if (transformerFactoryClass == null) {
            throw new SwitchYardException("TransformModel type '" + transformModel.getClass().getName() + "' is not annotated with an @TransformerFactoryClass annotation.");
        }
        Class<? extends TransformerFactory> factoryClass = transformerFactoryClass.value();
        if (!TransformerFactory.class.isAssignableFrom(factoryClass)) {
            throw new SwitchYardException("Invalid TransformerFactory implementation.  Must implement '" + TransformerFactory.class.getName() + "'.");
        }
        try {
            if (!this._transformerFactories.containsKey(factoryClass)) {
                TransformerFactory factory = factoryClass.newInstance();
                this._transformerFactories.put(factoryClass, factory);
            }
            return this._transformerFactories.get(factoryClass);
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to create an instance of TransformerFactory '" + factoryClass.getName() + "'.  Class must have a public default constructor and not be abstract.");
        }
    }
}

