/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerFactory;
import org.switchyard.transform.config.model.XsltTransformModel;
import org.switchyard.transform.xslt.XsltTransformer;

public final class XsltTransformFactory
implements TransformerFactory<XsltTransformModel> {
    private static final Logger LOGGER = Logger.getLogger(XsltTransformFactory.class);

    @Override
    public Transformer newTransformer(XsltTransformModel model) {
        String xsltFileUri = model.getXsltFile();
        boolean failOnWarning = model.failOnWarning();
        QName to = model.getTo();
        QName from = model.getFrom();
        if (xsltFileUri == null || xsltFileUri.equals("")) {
            throw new SwitchYardException("No xsl file has been defined. Check your transformer configuration.");
        }
        try {
            InputStream stylesheetStream = Classes.getResourceAsStream((String)xsltFileUri);
            if (stylesheetStream == null) {
                throw new SwitchYardException("Failed to load xsl file '" + xsltFileUri + "' from classpath.");
            }
            javax.xml.transform.TransformerFactory tFactory = javax.xml.transform.TransformerFactory.newInstance();
            tFactory.setErrorListener(new XsltTransformFactoryErrorListener(failOnWarning));
            Templates templates = tFactory.newTemplates(new StreamSource(stylesheetStream));
            return new XsltTransformer(from, to, templates, failOnWarning);
        }
        catch (TransformerConfigurationException e) {
            throw new SwitchYardException("An unexpected error ocurred while creating the xslt transformer", (Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException("Unable to locate the xslt file " + model.getXsltFile(), (Throwable)e);
        }
    }

    private class XsltTransformFactoryErrorListener
    implements ErrorListener {
        private boolean _failOnWarning;

        public XsltTransformFactoryErrorListener(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException ex) throws TransformerException {
            if (this._failOnWarning) {
                throw ex;
            }
            LOGGER.warn((Object)"Warning during xslt compilation", (Throwable)ex);
        }

        @Override
        public void error(TransformerException ex) throws TransformerException {
            throw ex;
        }

        @Override
        public void fatalError(TransformerException ex) throws TransformerException {
            throw ex;
        }
    }
}

