/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.switchyard.annotations.Transformer;
import org.xml.sax.InputSource;

public class StringTransforms {
    public static final StringTransforms TRANSFORMER = new StringTransforms();

    @Transformer
    public Reader toReader(String string) {
        return new StringReader(string);
    }

    @Transformer
    public InputStream toInputStream(String string) {
        return new ByteArrayInputStream(string.getBytes());
    }

    @Transformer
    public InputSource toInputSource(String string) {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(new ByteArrayInputStream(string.getBytes()));
        inputSource.setCharacterStream(new StringReader(string));
        return inputSource;
    }

    @Transformer
    public Integer toInteger(String string) {
        return Integer.parseInt(string);
    }

    @Transformer
    public Long toLong(String string) {
        return Long.parseLong(string);
    }

    @Transformer
    public Short toShort(String string) {
        return Short.parseShort(string);
    }

    @Transformer
    public char[] toChars(String string) {
        return string.toCharArray();
    }

    @Transformer
    public Character toCharacter(String string) {
        if (string.length() > 0) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    @Transformer
    public byte[] toBytes(String string) {
        return string.getBytes();
    }

    @Transformer
    public Double toDouble(String string) {
        return Double.parseDouble(string);
    }

    @Transformer
    public Float toFloat(String string) {
        return Float.valueOf(Float.parseFloat(string));
    }
}

