/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.switchyard.annotations.Transformer;
import org.switchyard.transform.ootb.io.InputStreamTransforms;
import org.switchyard.transform.ootb.io.ReaderTransforms;
import org.xml.sax.InputSource;

public class InputSourceTransforms {
    public static final InputSourceTransforms TRANSFORMER = new InputSourceTransforms();

    @Transformer
    public String toString(InputSource inSource) {
        Reader reader = inSource.getCharacterStream();
        if (reader != null) {
            return ReaderTransforms.TRANSFORMER.toString(reader);
        }
        InputStream stream = inSource.getByteStream();
        if (stream != null) {
            return InputStreamTransforms.TRANSFORMER.toString(stream);
        }
        return null;
    }

    @Transformer
    public Reader toReader(InputSource inSource) {
        Reader reader = inSource.getCharacterStream();
        if (reader != null) {
            return new StringReader(ReaderTransforms.TRANSFORMER.toString(reader));
        }
        return null;
    }

    @Transformer
    public InputStream toInputStream(InputSource inSource) {
        InputStream stream = inSource.getByteStream();
        if (stream != null) {
            return new ByteArrayInputStream(InputStreamTransforms.TRANSFORMER.toBytes(stream));
        }
        return null;
    }

    @Transformer
    public Integer toInteger(InputSource inSource) {
        return Integer.parseInt(this.toString(inSource));
    }

    @Transformer
    public Long toLong(InputSource inSource) {
        return Long.parseLong(this.toString(inSource));
    }

    @Transformer
    public Short toShort(InputSource inSource) {
        return Short.parseShort(this.toString(inSource));
    }

    @Transformer
    public char[] toChars(InputSource inSource) {
        return this.toString(inSource).toCharArray();
    }

    @Transformer
    public Character toCharacter(InputSource inSource) {
        return Character.valueOf(this.toString(inSource).charAt(0));
    }

    @Transformer
    public byte[] toBytes(InputSource inSource) {
        InputStream stream = inSource.getByteStream();
        if (stream != null) {
            return InputStreamTransforms.TRANSFORMER.toBytes(stream);
        }
        Reader reader = inSource.getCharacterStream();
        if (reader != null) {
            return ReaderTransforms.TRANSFORMER.toBytes(reader);
        }
        return null;
    }

    @Transformer
    public Double toDouble(InputSource inSource) {
        return Double.parseDouble(this.toString(inSource));
    }

    @Transformer
    public Float toFloat(InputSource inSource) {
        return Float.valueOf(Float.parseFloat(this.toString(inSource)));
    }
}

