/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.junit.Assert;

public final class ShrinkwrapUtil {
    public static final String SWITCHYARD_VERSION = "SWITCHYARD_VERSION";
    private static final String LOCAL_MAVEN_REPO = System.getProperty("maven.repo.local") != null ? System.getProperty("maven.repo.local") : System.getProperty("user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";

    private ShrinkwrapUtil() {
    }

    public static JavaArchive getSwitchYardJavaArchive(String groupId, String artifactId) {
        return ShrinkwrapUtil.getJavaArchive(groupId, artifactId, ShrinkwrapUtil.getSwitchYardVersion());
    }

    public static JavaArchive getJavaArchive(String groupId, String artifactId, String version) {
        return ShrinkwrapUtil.getArchive(groupId, artifactId, version, JavaArchive.class, "jar");
    }

    public static WebArchive getSwitchYardWebArchive(String groupId, String artifactId) {
        return ShrinkwrapUtil.getWebArchive(groupId, artifactId, ShrinkwrapUtil.getSwitchYardVersion());
    }

    public static WebArchive getWebArchive(String groupId, String artifactId, String version) {
        return ShrinkwrapUtil.getArchive(groupId, artifactId, version, WebArchive.class, "war");
    }

    public static <A extends Archive> A getArchive(String groupId, String artifactId, String version, Class<A> archiveType, String fileExtension) {
        Assert.assertNotNull((String)"'groupId' argument is null.", (Object)groupId);
        Assert.assertNotNull((String)"'artifactId' argument is null.", (Object)artifactId);
        Assert.assertNotNull((String)"'version' argument is null.", (Object)version);
        File artifactFile = new File(LOCAL_MAVEN_REPO, groupId.replace(".", "/") + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "." + fileExtension);
        if (!artifactFile.isFile()) {
            String artifact = groupId + ":" + artifactId + ":" + version;
            Assert.fail((String)("Failed to resolve artifact '" + artifact + "'.  The artifact must be declared as a dependency in your POM, thereby making it available in your local repository."));
        }
        Archive archive = (Archive)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifactFile.getName())).importFrom(ShrinkwrapUtil.convert(artifactFile)).as(archiveType);
        return (A)archive;
    }

    public static String getSwitchYardVersion() {
        String version = System.getenv(SWITCHYARD_VERSION);
        if (version == null) {
            Assert.fail((String)"Test Environment variable 'SWITCHYARD_VERSION' is not configured.  \n\t\t- If running the test in your IDE, set this Environment variable (in the test Run/Debug Configuration) to the current version of SwitchYard (maven artifact version).\n\t\t- If running the tests through Maven, make sure that the surefire plugin sets this Environment variable to the current version of SwitchYard (maven artifact version).");
        }
        if ((version = version.trim()).length() == 0) {
            Assert.fail((String)"Test Environment variable 'SWITCHYARD_VERSION' not configured.  If running the test in your IDE, set this Environment variable to the current version od SwitchYard.");
        }
        return version;
    }

    private static ZipFile convert(File file) throws ResolutionException {
        try {
            return new ZipFile(file);
        }
        catch (ZipException e) {
            throw new ResolutionException("Unable to treat dependency artifact \"" + file.getAbsolutePath() + "\" as a ZIP file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResolutionException("Unable to access artifact file at \"" + file.getAbsolutePath() + "\".", (Throwable)e);
        }
    }
}

