/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.junit.Assert;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class NamingMixIn
extends AbstractTestMixIn {
    private static final String INITIAL_CONTEXT_FACTORY_NAME = "org.jboss.as.naming.InitialContextFactory";
    private static final CompositeName EMPTY_NAME = new CompositeName();
    private static Integer referenceCounter = 0;
    private static InitialContext initialContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        Integer n = referenceCounter;
        synchronized (n) {
            if (referenceCounter != 0) {
                Integer n2 = referenceCounter;
                Integer n3 = referenceCounter = Integer.valueOf(referenceCounter + 1);
                return;
            }
            String factoryName = System.getProperty("java.naming.factory.initial");
            if (factoryName != null && !factoryName.equals(INITIAL_CONTEXT_FACTORY_NAME)) {
                return;
            }
            System.setProperty("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY_NAME);
            NamingContext.initializeNamingManager();
            NamespaceContextSelector.setDefault((NamespaceContextSelector)new NamespaceContextSelector(){

                public Context getContext(String identifier) {
                    try {
                        return (Context)new InitialContext().lookup(EMPTY_NAME);
                    }
                    catch (NamingException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            if (initialContext == null) {
                try {
                    initialContext = new InitialContext();
                    try {
                        Context.class.cast(initialContext.lookup("java:comp"));
                    }
                    catch (Exception e) {
                        initialContext.createSubcontext("java:comp");
                    }
                }
                catch (NamingException e) {
                    Assert.fail((String)("Failed to create context : " + e.getMessage()));
                }
            }
            Integer n4 = referenceCounter;
            Integer n5 = referenceCounter = Integer.valueOf(referenceCounter + 1);
        }
    }

    public InitialContext getInitialContext() {
        return initialContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninitialize() {
        Integer n = referenceCounter;
        synchronized (n) {
            Integer n2 = referenceCounter;
            Integer n3 = referenceCounter = Integer.valueOf(referenceCounter - 1);
            if (referenceCounter == 0) {
                NamingContext.setActiveNamingStore((NamingStore)new InMemoryNamingStore());
            }
        }
    }
}

