/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.registry.MapBindingRegistry;
import org.hornetq.jms.server.embedded.EmbeddedJMS;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class HornetQMixIn
extends AbstractTestMixIn {
    private static final String HORNETQ_CONF_FILE = "hornetq-configuration.xml";
    private static final String HORNETQ_JMS_CONF_FILE = "hornetq-jms.xml";
    private EmbeddedJMS _embeddedJMS;
    private ServerLocator _serverLocator;
    private ClientSessionFactory _clientSessionFactory;
    private ClientSession _clientSession;

    @Override
    public void initialize() {
        this._embeddedJMS = new EmbeddedJMS();
        this._embeddedJMS.setRegistry((BindingRegistry)new MapBindingRegistry());
        this._embeddedJMS.setConfigResourcePath(HORNETQ_CONF_FILE);
        this._embeddedJMS.setJmsConfigResourcePath(HORNETQ_JMS_CONF_FILE);
        try {
            this._embeddedJMS.start();
            this._serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])HornetQMixIn.getTransports(this.getConfiguration()));
            this._clientSessionFactory = this._serverLocator.createSessionFactory();
            this._clientSession = this._clientSessionFactory.createSession();
            this._clientSession.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConfiguration() {
        return this._embeddedJMS.getHornetQServer().getConfiguration();
    }

    private static TransportConfiguration[] getTransports(Configuration from) {
        Collection transports = from.getConnectorConfigurations().values();
        return transports.toArray(new TransportConfiguration[0]);
    }

    @Override
    public void uninitialize() {
        try {
            HornetQMixIn.closeSessionFactory(this._clientSessionFactory);
            HornetQMixIn.closeSession(this._clientSession);
            HornetQMixIn.closeServerLocator(this._serverLocator);
            this._embeddedJMS.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSession getClientSession() {
        if (this._clientSession != null) {
            return this._clientSession;
        }
        throw new IllegalStateException("The ClientSession has not been created. Please check the logs for errors.");
    }

    public ServerLocator getServerLocator() {
        return this._serverLocator;
    }

    public ClientMessage createMessage(String body) {
        ClientMessage message = this._clientSession.createMessage(true);
        message.getBodyBuffer().writeBytes(body.getBytes());
        return message;
    }

    public Object readObjectFromMessage(ClientMessage msg) throws Exception {
        byte[] bytes = new byte[msg.getBodySize()];
        HornetQBuffer bodyBuffer = msg.getBodyBuffer();
        bodyBuffer.readBytes(bytes);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return in.readObject();
    }

    public static void closeServerLocator(ServerLocator serverLocator) {
        if (serverLocator != null) {
            serverLocator.close();
        }
    }

    public static void closeSessionFactory(ClientSessionFactory factory) {
        if (factory != null) {
            factory.close();
        }
    }

    public static void closeSession(ClientSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (HornetQException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeClientConsumer(ClientConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (HornetQException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static void closeClientProducer(ClientProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (HornetQException ignore) {
                ignore.printStackTrace();
            }
        }
    }
}

