/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.config.model;

import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.rules.ExecuteRules;
import org.switchyard.component.rules.Rules;
import org.switchyard.component.rules.common.RulesActionType;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentServiceInterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class RulesSwitchYardScanner
implements Scanner<SwitchYardModel> {
    private static final IsAnnotationPresentFilter RESOURCE_FILTER = new IsAnnotationPresentFilter(Rules.class);
    private static final IsAnnotationPresentFilter EXECUTE_RULES_FILTER = new IsAnnotationPresentFilter(ExecuteRules.class);
    private static final String INTERFACE_ERR_MSG = " is a class. @Rules only allowed on interfaces.";

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        switchyardModel.setComposite((CompositeModel)compositeModel);
        ClasspathScanner rulesScanner = new ClasspathScanner((Filter)RESOURCE_FILTER);
        for (URL url : input.getURLs()) {
            rulesScanner.scan(url);
        }
        List rulesClasses = RESOURCE_FILTER.getMatchedTypes();
        for (Class rulesClass : rulesClasses) {
            Rules rules = rulesClass.getAnnotation(Rules.class);
            Class rulesInterface = rules.value();
            if (Rules.UndefinedRulesInterface.class.equals(rulesInterface)) {
                rulesInterface = rulesClass;
            }
            if (!rulesInterface.isInterface()) {
                throw new IOException(rulesInterface.getName() + INTERFACE_ERR_MSG);
            }
            String rulesName = rulesInterface.getSimpleName();
            V1ComponentModel componentModel = new V1ComponentModel();
            componentModel.setName(rulesName);
            V1RulesComponentImplementationModel rciModel = new V1RulesComponentImplementationModel();
            rciModel.setStateful(rules.stateful());
            JavaService javaService = JavaService.fromClass((Class)rulesInterface);
            for (Method method : rulesClass.getDeclaredMethods()) {
                ServiceOperation srvOper;
                RulesActionType rat = null;
                if (EXECUTE_RULES_FILTER.matches(method)) {
                    rat = RulesActionType.EXECUTE_RULES;
                }
                if (rat == null || (srvOper = javaService.getOperation(method.getName())) == null) continue;
                RulesActionModel ram = new V1RulesActionModel().setName(srvOper.getName()).setType(rat);
                rciModel.addRulesAction(ram);
            }
            for (GenericDeclaration genericDeclaration : rules.resources()) {
                if (Rules.UndefinedResource.class.equals((Object)genericDeclaration)) continue;
                Resource resource = (Resource)Construction.construct((Class)genericDeclaration);
                String location = resource.getLocation();
                ResourceType type = resource.getType();
                rciModel.addResource(new V1ResourceModel().setLocation(location).setType(type));
            }
            componentModel.setImplementation((ComponentImplementationModel)rciModel);
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel();
            V1JavaComponentServiceInterfaceModel csiModel = new V1JavaComponentServiceInterfaceModel();
            csiModel.setInterface(rulesInterface.getName());
            serviceModel.setInterface((ComponentServiceInterfaceModel)csiModel);
            serviceModel.setName(rulesName);
            componentModel.addService((ComponentServiceModel)serviceModel);
            compositeModel.addComponent((ComponentModel)componentModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }
}

