/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.transform.internal.TransformerRegistryLoader;
import org.switchyard.validate.internal.ValidatorRegistryLoader;

public abstract class AbstractDeployment {
    public static final String SWITCHYARD_XML = "/META-INF/switchyard.xml";
    public static final String CLASSLOADER_PROPERTY = "org.switchyard.deployment.DeploymentClassLoader";
    private AbstractDeployment _parentDeployment;
    private ServiceDomain _serviceDomain;
    private TransformerRegistryLoader _transformerRegistryLoader;
    private ValidatorRegistryLoader _validatorRegistryLoader;
    private SwitchYardModel _switchyardConfig;
    private QName _name;
    private boolean _failOnMissingActivator = true;

    protected AbstractDeployment(SwitchYardModel configModel) {
        this._switchyardConfig = configModel;
    }

    public void setParentDeployment(AbstractDeployment parentDeployment) {
        this._parentDeployment = parentDeployment;
    }

    public boolean failOnMissingActivator() {
        return this._failOnMissingActivator;
    }

    public void setFailOnMissingActivator(boolean failOnMissingActivator) {
        this._failOnMissingActivator = failOnMissingActivator;
    }

    public final void init(ServiceDomain appServiceDomain, List<Activator> activators) {
        if (appServiceDomain == null) {
            throw new IllegalArgumentException("null 'appServiceDomain' argument.");
        }
        if (this.getConfig() != null) {
            this._name = this.getConfig().getQName();
            if (this._name == null && this.getConfig().getComposite() != null) {
                this._name = this.getConfig().getComposite().getQName();
            }
        }
        this._serviceDomain = appServiceDomain;
        this._serviceDomain.setProperty(CLASSLOADER_PROPERTY, (Object)Classes.getTCCL());
        this._transformerRegistryLoader = new TransformerRegistryLoader(appServiceDomain);
        this._transformerRegistryLoader.loadOOTBTransforms();
        this._validatorRegistryLoader = new ValidatorRegistryLoader(appServiceDomain.getValidatorRegistry());
        this._validatorRegistryLoader.loadOOTBValidates();
        this.doInit(activators);
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        if (this._parentDeployment == null) {
            return this._serviceDomain;
        }
        return this._parentDeployment.getDomain();
    }

    public TransformerRegistryLoader getTransformerRegistryLoader() {
        return this._transformerRegistryLoader;
    }

    public ValidatorRegistryLoader getValidatorRegistryLoader() {
        return this._validatorRegistryLoader;
    }

    protected abstract void doInit(List<Activator> var1);

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();

    public abstract Lifecycle getGatwayLifecycle(QName var1, String var2);

    public SwitchYardModel getConfig() {
        return this._switchyardConfig;
    }
}

