/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceSecurity;
import org.switchyard.bus.camel.CamelExchangeBus;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.domain.DomainModel;
import org.switchyard.config.model.domain.HandlerModel;
import org.switchyard.config.model.domain.SecuritiesModel;
import org.switchyard.config.model.domain.SecurityModel;
import org.switchyard.config.model.property.PropertiesModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DefaultServiceSecurity;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.EventManager;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class ServiceDomainManager {
    public static final QName ROOT_DOMAIN = new QName("org.switchyard.domains.root");
    private static Logger _log = Logger.getLogger(ServiceDomainManager.class);
    private ServiceRegistry _registry = new DefaultServiceRegistry();
    private EventManager _eventManager = new EventManager();

    public ServiceDomain createDomain() {
        return this.createDomain(ROOT_DOMAIN, null);
    }

    public ServiceDomain createDomain(QName domainName, SwitchYardModel switchyardConfig) {
        BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
        BaseValidatorRegistry validatorRegistry = new BaseValidatorRegistry();
        SwitchYardCamelContext camelContext = new SwitchYardCamelContext();
        CamelExchangeBus bus = new CamelExchangeBus(camelContext);
        Map<String, ServiceSecurity> serviceSecurities = this.getServiceSecurities(switchyardConfig);
        DomainImpl domain = new DomainImpl(domainName, this._registry, (ExchangeBus)bus, (TransformerRegistry)transformerRegistry, (ValidatorRegistry)validatorRegistry, this._eventManager, serviceSecurities);
        camelContext.setServiceDomain((ServiceDomain)domain);
        if (switchyardConfig != null) {
            domain.getHandlers().addAll(this.getDomainHandlers(switchyardConfig.getDomain()));
        }
        return domain;
    }

    public EventManager getEventManager() {
        return this._eventManager;
    }

    private List<ExchangeHandler> getDomainHandlers(DomainModel domain) {
        LinkedList<ExchangeHandler> handlers = new LinkedList<ExchangeHandler>();
        if (domain != null && domain.getHandlers() != null) {
            for (HandlerModel handlerConfig : domain.getHandlers().getHandlers()) {
                Class handlerClass = Classes.forName((String)handlerConfig.getClassName());
                if (handlerClass == null) {
                    throw new SwitchYardException("Handler class not found " + handlerConfig.getClassName());
                }
                if (!ExchangeHandler.class.isAssignableFrom(handlerClass)) {
                    throw new SwitchYardException("Handler " + handlerConfig.getName() + " is not an instance of " + ExchangeHandler.class.getName());
                }
                try {
                    _log.debug((Object)("Adding handler " + handlerConfig.getName() + " to domain."));
                    ExchangeHandler handler = (ExchangeHandler)handlerClass.newInstance();
                    handlers.addLast(handler);
                }
                catch (Exception ex) {
                    throw new SwitchYardException("Failed to initialize handler class " + handlerClass.getName(), (Throwable)ex);
                }
            }
        }
        return handlers;
    }

    private Map<String, ServiceSecurity> getServiceSecurities(SwitchYardModel switchyard) {
        SecuritiesModel securities;
        DomainModel domain;
        HashMap<String, ServiceSecurity> map = new HashMap<String, ServiceSecurity>();
        if (switchyard != null && (domain = switchyard.getDomain()) != null && (securities = domain.getSecurities()) != null) {
            for (SecurityModel security : securities.getSecurities()) {
                if (security == null) continue;
                PropertiesModel properties = security.getProperties();
                DefaultServiceSecurity value = new DefaultServiceSecurity().setName(security.getName()).setCallbackHandler(security.getCallbackHandler(this.getClass().getClassLoader())).setProperties(properties != null ? properties.toMap() : null).setRolesAllowed(security.getRolesAllowed()).setRunAs(security.getRunAs()).setSecurityDomain(security.getSecurityDomain());
                String key = value.getName();
                if (!map.containsKey(key)) {
                    map.put(key, (ServiceSecurity)value);
                    continue;
                }
                throw new IllegalStateException("Duplicate security configuration names calculated: " + key);
            }
        }
        return map;
    }
}

