/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.deploy.Component;

public abstract class BaseComponent
implements Component {
    private String _name;
    private Configuration _config = Configurations.emptyConfig();
    private List<String> _activationTypes = new LinkedList<String>();

    protected BaseComponent(String ... types) {
        if (types != null) {
            this._activationTypes.addAll(Arrays.asList(types));
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void init(Configuration config) {
        this._config = config;
    }

    @Override
    public Configuration getConfig() {
        return this._config;
    }

    @Override
    public List<String> getActivationTypes() {
        return Collections.unmodifiableList(this._activationTypes);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void addResourceDependency(Object value) {
    }
}

