/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.ServiceDomain;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.ServiceHandler;

public abstract class BaseActivator
implements Activator {
    private List<String> _activationTypes = new LinkedList<String>();
    private ServiceDomain _serviceDomain;

    protected BaseActivator(String ... types) {
        if (types != null) {
            this._activationTypes.addAll(Arrays.asList(types));
        }
    }

    @Override
    public ServiceHandler activateBinding(QName name, BindingModel config) {
        throw new UnsupportedOperationException("activateBinding() not supported by " + this.getClass());
    }

    @Override
    public ServiceHandler activateService(QName name, ComponentModel config) {
        throw new UnsupportedOperationException("deactivateService() not supported by " + this.getClass());
    }

    @Override
    public void deactivateBinding(QName name, ServiceHandler handler) {
        throw new UnsupportedOperationException("deactivateBinding() not supported by " + this.getClass());
    }

    @Override
    public void deactivateService(QName name, ServiceHandler handler) {
        throw new UnsupportedOperationException("deactivateService() not supported by " + this.getClass());
    }

    public void setServiceDomain(ServiceDomain serviceDomain) {
        this._serviceDomain = serviceDomain;
    }

    public ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    @Override
    public boolean canActivate(String type) {
        return this._activationTypes.contains(type);
    }

    @Override
    public Collection<String> getActivationTypes() {
        return Collections.unmodifiableList(this._activationTypes);
    }

    @Override
    public void destroy() {
    }
}

