/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.validate.ValidatesModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.internal.DeploymentListener;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.TransformerRegistryLoader;
import org.switchyard.transform.jaxb.internal.JAXBTransformerFactory;
import org.switchyard.validate.ValidatorRegistryLoader;

public abstract class AbstractDeployment {
    public static final String SWITCHYARD_XML = "/META-INF/switchyard.xml";
    private AbstractDeployment _parentDeployment;
    private ServiceDomain _serviceDomain;
    private TransformerRegistryLoader _transformerRegistryLoader;
    private ValidatorRegistryLoader _validatorRegistryLoader;
    private SwitchYardModel _switchyardConfig;
    private QName _name;
    private Set<DeploymentListener> _listeners = new LinkedHashSet<DeploymentListener>();
    private boolean _failOnMissingActivator = true;
    private List<Transformer<?, ?>> _autoRegisteredTransformers = new ArrayList();
    private static Logger _log = Logger.getLogger(AbstractDeployment.class);

    protected AbstractDeployment(SwitchYardModel configModel) {
        this._switchyardConfig = configModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeploymentListener(DeploymentListener listener) {
        Set<DeploymentListener> set = this._listeners;
        synchronized (set) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeploymentListener(DeploymentListener listener) {
        Set<DeploymentListener> set = this._listeners;
        synchronized (set) {
            this._listeners.remove(listener);
        }
    }

    public void setParentDeployment(AbstractDeployment parentDeployment) {
        this._parentDeployment = parentDeployment;
    }

    public boolean failOnMissingActivator() {
        return this._failOnMissingActivator;
    }

    public void setFailOnMissingActivator(boolean failOnMissingActivator) {
        this._failOnMissingActivator = failOnMissingActivator;
    }

    public final void init(ServiceDomain appServiceDomain, List<Activator> activators) {
        if (appServiceDomain == null) {
            throw new IllegalArgumentException("null 'appServiceDomain' argument.");
        }
        if (this.getConfig() != null) {
            this._name = this.getConfig().getQName();
            if (this._name == null && this.getConfig().getComposite() != null) {
                this._name = this.getConfig().getComposite().getQName();
            }
        }
        this.notifyListeners(new InitializingNotifier());
        try {
            this._serviceDomain = appServiceDomain;
            this._transformerRegistryLoader = new TransformerRegistryLoader(appServiceDomain.getTransformerRegistry());
            this._transformerRegistryLoader.loadOOTBTransforms();
            this._validatorRegistryLoader = new ValidatorRegistryLoader(appServiceDomain.getValidatorRegistry());
            this._validatorRegistryLoader.loadOOTBValidates();
            this.doInit(activators);
        }
        catch (RuntimeException e) {
            this.notifyListeners(new InitializationFailedNotifier(e));
            throw e;
        }
        this.notifyListeners(new InitializedNotifier());
    }

    public final void start() {
        this.notifyListeners(new StartingNotifier());
        try {
            this.doStart();
        }
        catch (RuntimeException e) {
            this.notifyListeners(new StartFailedNotifier(e));
            throw e;
        }
        this.notifyListeners(new StartedNotifier());
    }

    public final void stop() {
        this.notifyListeners(new StoppingNotifier());
        try {
            this.doStop();
        }
        catch (RuntimeException e) {
            this.notifyListeners(new StopFailedNotifier(e));
            throw e;
        }
        this.notifyListeners(new StoppedNotifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        this.notifyListeners(new DestroyingNotifier());
        try {
            this.doDestroy();
        }
        finally {
            this.notifyListeners(new DestroyedNotifier());
        }
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        if (this._parentDeployment == null) {
            return this._serviceDomain;
        }
        return this._parentDeployment.getDomain();
    }

    public TransformerRegistryLoader getTransformerRegistryLoader() {
        return this._transformerRegistryLoader;
    }

    public ValidatorRegistryLoader getValidatorRegistryLoader() {
        return this._validatorRegistryLoader;
    }

    protected abstract void doInit(List<Activator> var1);

    protected abstract void doStart();

    protected abstract void doStop();

    protected abstract void doDestroy();

    public SwitchYardModel getConfig() {
        return this._switchyardConfig;
    }

    protected void deployAutoRegisteredTransformers(ServiceInterface serviceInterface) throws SwitchYardException {
        TransformerRegistry transformerReg = this.getDomain().getTransformerRegistry();
        if (serviceInterface instanceof JavaService) {
            Class javaInterface = ((JavaService)serviceInterface).getJavaInterface();
            List jaxbTransformers = JAXBTransformerFactory.newTransformers((Class)javaInterface);
            for (Transformer jaxbTransformer : jaxbTransformers) {
                if (transformerReg.hasTransformer(jaxbTransformer.getFrom(), jaxbTransformer.getTo())) continue;
                transformerReg.addTransformer(jaxbTransformer);
                this._autoRegisteredTransformers.add(jaxbTransformer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployAutoRegisteredTransformers() {
        TransformerRegistry transformerReg = this.getDomain().getTransformerRegistry();
        try {
            for (Transformer<?, ?> dynamicallyAddedTransformer : this._autoRegisteredTransformers) {
                transformerReg.removeTransformer(dynamicallyAddedTransformer);
            }
        }
        finally {
            this._autoRegisteredTransformers.clear();
        }
    }

    protected final void fireServiceDeployed(CompositeServiceModel serviceModel) {
        this.notifyListeners(new ServiceDeployedNotifier(serviceModel));
    }

    protected final void fireServiceUndeployed(QName serviceName) {
        this.notifyListeners(new ServiceUndeployedNotifier(serviceName));
    }

    protected final void fireComponentDeployed(ComponentModel componentModel) {
        this.notifyListeners(new ComponentServiceDeployedNotifier(componentModel));
    }

    protected final void fireComponentUndeployed(QName serviceName) {
        this.notifyListeners(new ComponentServiceUndeployedNotifier(serviceName));
    }

    protected final void fireTransformersRegistered(TransformsModel transforms) {
        this.notifyListeners(new TransformersRegisteredNotifier(transforms));
    }

    protected final void fireValidatorsRegistered(ValidatesModel validates) {
        this.notifyListeners(new ValidatorsRegisteredNotifier(validates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(DeploymentEventNotifier notifier) {
        ArrayList<DeploymentListener> listeners;
        Set<DeploymentListener> set = this._listeners;
        synchronized (set) {
            listeners = new ArrayList<DeploymentListener>(this._listeners);
        }
        for (DeploymentListener listener : listeners) {
            try {
                notifier.notify(listener);
            }
            catch (Exception e) {
                _log.warn((Object)"DeploymentListener threw exception during notify.", (Throwable)e);
            }
        }
    }

    private class DestroyedNotifier
    implements DeploymentEventNotifier {
        private DestroyedNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.destroyed(AbstractDeployment.this);
        }
    }

    private class DestroyingNotifier
    implements DeploymentEventNotifier {
        private DestroyingNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.destroying(AbstractDeployment.this);
        }
    }

    private class StopFailedNotifier
    implements DeploymentEventNotifier {
        private Throwable _exception;

        protected StopFailedNotifier(Throwable exception) {
            this._exception = exception;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.stopFailed(AbstractDeployment.this, this._exception);
        }
    }

    private class StoppedNotifier
    implements DeploymentEventNotifier {
        private StoppedNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.stopped(AbstractDeployment.this);
        }
    }

    private class StoppingNotifier
    implements DeploymentEventNotifier {
        private StoppingNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.stopping(AbstractDeployment.this);
        }
    }

    private class StartFailedNotifier
    implements DeploymentEventNotifier {
        private Throwable _exception;

        protected StartFailedNotifier(Throwable exception) {
            this._exception = exception;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.startFailed(AbstractDeployment.this, this._exception);
        }
    }

    private class StartedNotifier
    implements DeploymentEventNotifier {
        private StartedNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.started(AbstractDeployment.this);
        }
    }

    private class StartingNotifier
    implements DeploymentEventNotifier {
        private StartingNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.starting(AbstractDeployment.this);
        }
    }

    private class InitializationFailedNotifier
    implements DeploymentEventNotifier {
        private Throwable _exception;

        protected InitializationFailedNotifier(Throwable exception) {
            this._exception = exception;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.initializationFailed(AbstractDeployment.this, this._exception);
        }
    }

    private class InitializedNotifier
    implements DeploymentEventNotifier {
        private InitializedNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.initialized(AbstractDeployment.this);
        }
    }

    private class InitializingNotifier
    implements DeploymentEventNotifier {
        private InitializingNotifier() {
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.initializing(AbstractDeployment.this);
        }
    }

    private class ValidatorsRegisteredNotifier
    implements DeploymentEventNotifier {
        private ValidatesModel _validates;

        protected ValidatorsRegisteredNotifier(ValidatesModel validates) {
            this._validates = validates;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.validatorsRegistered(AbstractDeployment.this, this._validates);
        }
    }

    private class TransformersRegisteredNotifier
    implements DeploymentEventNotifier {
        private TransformsModel _transforms;

        protected TransformersRegisteredNotifier(TransformsModel transforms) {
            this._transforms = transforms;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.transformersRegistered(AbstractDeployment.this, this._transforms);
        }
    }

    private class ComponentServiceUndeployedNotifier
    implements DeploymentEventNotifier {
        private QName _serviceName;

        protected ComponentServiceUndeployedNotifier(QName serviceName) {
            this._serviceName = serviceName;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.componentServiceUndeployed(AbstractDeployment.this, this._serviceName);
        }
    }

    private class ComponentServiceDeployedNotifier
    implements DeploymentEventNotifier {
        private ComponentModel _componentModel;

        protected ComponentServiceDeployedNotifier(ComponentModel componentModel) {
            this._componentModel = componentModel;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.componentServiceDeployed(AbstractDeployment.this, this._componentModel);
        }
    }

    private class ServiceUndeployedNotifier
    implements DeploymentEventNotifier {
        private QName _serviceName;

        protected ServiceUndeployedNotifier(QName serviceName) {
            this._serviceName = serviceName;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.serviceUndeployed(AbstractDeployment.this, this._serviceName);
        }
    }

    private class ServiceDeployedNotifier
    implements DeploymentEventNotifier {
        private CompositeServiceModel _serviceModel;

        protected ServiceDeployedNotifier(CompositeServiceModel serviceModel) {
            this._serviceModel = serviceModel;
        }

        @Override
        public void notify(DeploymentListener listener) {
            listener.serviceDeployed(AbstractDeployment.this, this._serviceModel);
        }
    }

    private static interface DeploymentEventNotifier {
        public void notify(DeploymentListener var1);
    }
}

