/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.domain.HandlerModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class ServiceDomainManager {
    public static final QName ROOT_DOMAIN = new QName("org.switchyard.domains.root");
    public static final String BUS_CLASS_NAME = "busProvider";
    public static final String REGISTRY_CLASS_NAME = "registryProvider";
    private ServiceRegistry _registry = new DefaultServiceRegistry();
    private ExchangeBus _bus = new LocalExchangeBus();

    public ServiceDomain createDomain() {
        return this.createDomain(ROOT_DOMAIN, null);
    }

    public ServiceDomain createDomain(QName domainName, SwitchYardModel switchyardConfig) {
        BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
        BaseValidatorRegistry validatorRegistry = new BaseValidatorRegistry();
        DomainImpl domain = new DomainImpl(domainName, this._registry, this._bus, (TransformerRegistry)transformerRegistry, (ValidatorRegistry)validatorRegistry);
        if (switchyardConfig != null) {
            this.addHandlersToDomain((ServiceDomain)domain, switchyardConfig);
        }
        return domain;
    }

    private void addHandlersToDomain(ServiceDomain domain, SwitchYardModel config) {
        if (config.getDomain() != null && config.getDomain().getHandlers() != null) {
            for (HandlerModel handlerConfig : config.getDomain().getHandlers().getHandlers()) {
                Class handlerClass = Classes.forName((String)handlerConfig.getClassName());
                if (handlerClass == null) {
                    throw new SwitchYardException("Handler class not found " + handlerConfig.getClassName());
                }
                if (!ExchangeHandler.class.isAssignableFrom(handlerClass)) {
                    throw new SwitchYardException("Handler " + handlerConfig.getName() + " is not an instance of " + ExchangeHandler.class.getName());
                }
                try {
                    ExchangeHandler handler = (ExchangeHandler)handlerClass.newInstance();
                    domain.getHandlerChain().addFirst(handlerConfig.getName(), handler);
                }
                catch (Exception ex) {
                    throw new SwitchYardException("Failed to initialize handler class " + handlerClass.getName(), (Throwable)ex);
                }
            }
        }
    }
}

