/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.DomainProxy;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;

public class ServiceDomainManager {
    public static final QName ROOT_DOMAIN = new QName("org.switchyard.domains.root");
    public static final String BUS_CLASS_NAME = "busProvider";
    public static final String REGISTRY_CLASS_NAME = "registryProvider";
    private List<ServiceDomain> _activeApplicationServiceDomains = Collections.synchronizedList(new ArrayList());

    public ServiceReference findService(QName serviceName, ServiceDomain excludeDomain) {
        if (excludeDomain instanceof DomainProxy) {
            excludeDomain = ((DomainProxy)excludeDomain).getDomain();
        }
        for (ServiceDomain domain : this._activeApplicationServiceDomains) {
            ServiceReference service;
            if (domain == excludeDomain || (service = domain.getService(serviceName)) == null) continue;
            return service;
        }
        return null;
    }

    public static ServiceDomain createDomain() {
        return ServiceDomainManager.createDomain(ROOT_DOMAIN, null, null);
    }

    public static ServiceDomain createDomain(QName domainName, SwitchYardModel switchyardConfig) {
        String registryClassName = null;
        String busClassName = null;
        if (switchyardConfig != null && switchyardConfig.getDomain() != null) {
            if (switchyardConfig.getDomain().getProperty(REGISTRY_CLASS_NAME) != null) {
                registryClassName = switchyardConfig.getDomain().getProperty(REGISTRY_CLASS_NAME);
            }
            if (switchyardConfig.getDomain().getProperty(BUS_CLASS_NAME) != null) {
                busClassName = switchyardConfig.getDomain().getProperty(BUS_CLASS_NAME);
            }
        }
        return ServiceDomainManager.createDomain(domainName, registryClassName, busClassName);
    }

    public static ServiceDomain createDomain(QName domainName, String registryClassName, String busClassName) {
        if (registryClassName == null) {
            registryClassName = DefaultServiceRegistry.class.getName();
        }
        if (busClassName == null) {
            busClassName = LocalExchangeBus.class.getName();
        }
        try {
            ServiceRegistry registry = ServiceDomainManager.getRegistry(registryClassName);
            ExchangeBus endpointProvider = ServiceDomainManager.getEndpointProvider(busClassName);
            BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
            return new DomainImpl(domainName, registry, endpointProvider, (TransformerRegistry)transformerRegistry);
        }
        catch (NullPointerException npe) {
            throw new SwitchYardException((Throwable)npe);
        }
    }

    public ServiceDomain addApplicationServiceDomain(QName applicationName) {
        return this.addApplicationServiceDomain(applicationName, null);
    }

    public ServiceDomain addApplicationServiceDomain(QName applicationName, SwitchYardModel switchyardConfig) {
        ServiceDomain serviceDomain = ServiceDomainManager.createDomain(applicationName, switchyardConfig);
        this._activeApplicationServiceDomains.add(serviceDomain);
        return new DomainProxy(serviceDomain, this);
    }

    public void removeApplicationServiceDomain(ServiceDomain applicationDomain) {
        if (applicationDomain instanceof DomainProxy) {
            this._activeApplicationServiceDomains.remove(((DomainProxy)applicationDomain).getDomain());
        } else {
            this._activeApplicationServiceDomains.remove(applicationDomain);
        }
    }

    private static ServiceRegistry getRegistry(String registryClass) {
        ServiceLoader<ServiceRegistry> registryServices = ServiceLoader.load(ServiceRegistry.class);
        for (ServiceRegistry serviceRegistry : registryServices) {
            if (!registryClass.equals(serviceRegistry.getClass().getName())) continue;
            return serviceRegistry;
        }
        return null;
    }

    private static ExchangeBus getEndpointProvider(String providerClass) {
        ServiceLoader<ExchangeBus> providerServices = ServiceLoader.load(ExchangeBus.class);
        for (ExchangeBus provider : providerServices) {
            if (!providerClass.equals(provider.getClass().getName())) continue;
            return provider;
        }
        return null;
    }
}

