/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

final class SwitchYardSubsystemProviders {
    static final String RESOURCE_NAME = SwitchYardSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_GET_VERSION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemGetVersion(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_LIST_APPLICATIONS = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemListApplications(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_LIST_COMPONENTS = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemListComponents(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_LIST_SERVICES = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemListServices(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_READ_APPLICATION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemReadApplication(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_READ_COMPONENT = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemReadComponent(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_READ_SERVICE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemReadService(locale);
        }
    };

    private SwitchYardSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static final class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("switchyard"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set("urn:jboss:domain:switchyard:1.0");
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle.getString("switchyard.add"));
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getSubsystemGetVersion(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("get-version");
            op.get("description").set(bundle.getString("switchyard.get-version"));
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.get-version.reply"));
            return op;
        }

        static ModelNode getSubsystemListApplications(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("list-applications");
            op.get("description").set(bundle.getString("switchyard.list-applications"));
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.list-applications.reply"));
            op.get(new String[]{"reply-properties", "value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "name", "description"}).set(bundle.getString("switchyard.list-services.reply.name"));
            return op;
        }

        static ModelNode getSubsystemListComponents(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("list-components");
            op.get("description").set(bundle.getString("switchyard.list-components"));
            op.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "type", "description"}).set(bundle.getString("switchyard.list-components.param.type"));
            op.get(new String[]{"request-properties", "type", "nillable"}).set(true);
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.list-components.reply"));
            op.get(new String[]{"reply-properties", "value-type"}).set(ModelType.STRING);
            return op;
        }

        static ModelNode getSubsystemListServices(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("list-services");
            op.get("description").set(bundle.getString("switchyard.list-services"));
            op.get(new String[]{"request-properties", "application-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "application-name", "description"}).set(bundle.getString("switchyard.list-services.param.application-name"));
            op.get(new String[]{"request-properties", "application-name", "nillable"}).set(true);
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.list-services.reply"));
            op.get(new String[]{"reply-properties", "value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "name", "description"}).set(bundle.getString("switchyard.list-services.reply.name"));
            op.get(new String[]{"reply-properties", "value-type", "application", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "application", "description"}).set(bundle.getString("switchyard.list-services.reply.application"));
            return op;
        }

        static ModelNode getSubsystemReadApplication(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("read-application");
            op.get("description").set(bundle.getString("switchyard.read-application"));
            op.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("switchyard.read-application.param.name"));
            op.get(new String[]{"request-properties", "name", "nillable"}).set(true);
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.read-application.reply"));
            op.get(new String[]{"reply-properties", "value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "name", "description"}).set(bundle.getString("switchyard.read-application.reply.name"));
            op.get(new String[]{"reply-properties", "value-type", "services", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "value-type", "services", "description"}).set(bundle.getString("switchyard.read-application.reply.services"));
            Descriptions.populateServiceValueTypeNode(op.get(new String[]{"reply-properties", "value-type", "services"}), locale);
            op.get(new String[]{"reply-properties", "value-type", "componentServices", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "value-type", "componentServices", "description"}).set(bundle.getString("switchyard.read-application.reply.componentServices"));
            Descriptions.populateComponentServiceValueTypeNode(op.get(new String[]{"reply-properties", "value-type", "componentServices"}), locale);
            op.get(new String[]{"reply-properties", "value-type", "transformers", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "value-type", "transformers", "description"}).set(bundle.getString("switchyard.read-application.reply.transformers"));
            Descriptions.populateTransformerValueTypeNode(op.get(new String[]{"reply-properties", "value-type", "transformers"}), locale);
            return op;
        }

        static ModelNode getSubsystemReadComponent(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("read-component");
            op.get("description").set(bundle.getString("switchyard.read-component"));
            op.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("switchyard.read-component.param.name"));
            op.get(new String[]{"request-properties", "name", "nillable"}).set(true);
            op.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "type", "description"}).set(bundle.getString("switchyard.read-component.param.type"));
            op.get(new String[]{"request-properties", "type", "nillable"}).set(true);
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.read-component.reply"));
            op.get(new String[]{"reply-properties", "value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "name", "description"}).set(bundle.getString("switchyard.read-component.reply.name"));
            op.get(new String[]{"reply-properties", "value-type", "type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "type", "description"}).set(bundle.getString("switchyard.read-component.reply.type"));
            op.get(new String[]{"reply-properties", "value-type", "configSchema", "type"}).set(ModelType.STRING);
            op.get(new String[]{"reply-properties", "value-type", "configSchema", "description"}).set(bundle.getString("switchyard.read-component.reply.config-schema"));
            return op;
        }

        static ModelNode getSubsystemReadService(Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("read-service");
            op.get("description").set(bundle.getString("switchyard.read-service"));
            op.get(new String[]{"request-properties", "service-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "service-name", "description"}).set(bundle.getString("switchyard.read-service.param.service-name"));
            op.get(new String[]{"request-properties", "service-name", "nillable"}).set(true);
            op.get(new String[]{"request-properties", "application-name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "application-name", "description"}).set(bundle.getString("switchyard.read-service.param.application-name"));
            op.get(new String[]{"request-properties", "application-name", "nillable"}).set(true);
            op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
            op.get(new String[]{"reply-properties", "description"}).set(bundle.getString("switchyard.read-service.reply"));
            Descriptions.populateServiceValueTypeNode(op.get("reply-properties"), locale);
            return op;
        }

        static void populateServiceValueTypeNode(ModelNode op, Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            op.get(new String[]{"value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "name", "description"}).set(bundle.getString("switchyard.read-service.reply.name"));
            op.get(new String[]{"value-type", "application", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "application", "description"}).set(bundle.getString("switchyard.read-service.reply.application"));
            op.get(new String[]{"value-type", "interface", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "interface", "description"}).set(bundle.getString("switchyard.read-service.reply.interface"));
            op.get(new String[]{"value-type", "promotedService", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "promotedService", "description"}).set(bundle.getString("switchyard.read-service.reply.promotedService"));
            op.get(new String[]{"value-type", "gateways", "type"}).set(ModelType.LIST);
            op.get(new String[]{"value-type", "gateways", "description"}).set(bundle.getString("switchyard.read-service.reply.gateways"));
            op.get(new String[]{"value-type", "gateways", "value-type", "type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "gateways", "value-type", "type", "description"}).set(bundle.getString("switchyard.read-service.reply.gateways.gateway"));
            op.get(new String[]{"value-type", "gateways", "value-type", "configuration", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "gateways", "value-type", "configuration", "description"}).set(bundle.getString("switchyard.read-service.reply.gateways.configuration"));
        }

        static void populateComponentServiceValueTypeNode(ModelNode op, Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            op.get(new String[]{"value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "name", "description"}).set(bundle.getString("switchyard.read-service.reply.name"));
            op.get(new String[]{"value-type", "application", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "application", "description"}).set(bundle.getString("switchyard.read-service.reply.application"));
            op.get(new String[]{"value-type", "interface", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "interface", "description"}).set(bundle.getString("switchyard.read-service.reply.interface"));
            op.get(new String[]{"value-type", "implementation", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "implementation", "description"}).set(bundle.getString("switchyard.read-service.reply.implementation"));
            op.get(new String[]{"value-type", "implementationConfiguration", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "implementationConfiguration", "description"}).set(bundle.getString("switchyard.read-service.reply.implementationConfiguration"));
            op.get(new String[]{"value-type", "references", "type"}).set(ModelType.LIST);
            op.get(new String[]{"value-type", "references", "description"}).set(bundle.getString("switchyard.read-service.reply.references"));
            op.get(new String[]{"value-type", "references", "value-type", "name", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "references", "value-type", "name", "description"}).set(bundle.getString("switchyard.read-service.reply.references.name"));
            op.get(new String[]{"value-type", "references", "value-type", "interface", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "references", "value-type", "interface", "description"}).set(bundle.getString("switchyard.read-service.reply.references.interface"));
        }

        static void populateTransformerValueTypeNode(ModelNode op, Locale locale) {
            ResourceBundle bundle = SwitchYardSubsystemProviders.getResourceBundle(locale);
            op.get(new String[]{"value-type", "from", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "from", "description"}).set(bundle.getString("switchyard.read-application.reply.transformer.from"));
            op.get(new String[]{"value-type", "to", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "to", "description"}).set(bundle.getString("switchyard.read-application.reply.transformer.to"));
            op.get(new String[]{"value-type", "type", "type"}).set(ModelType.STRING);
            op.get(new String[]{"value-type", "type", "description"}).set(bundle.getString("switchyard.read-application.reply.transformer.type"));
        }
    }
}

