/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.switchyard.as7.extension.deployment.SwitchYardConfigDeploymentProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardConfigProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardDependencyProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardDeploymentProcessor;

public final class SwitchYardSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    static final SwitchYardSubsystemAdd INSTANCE = new SwitchYardSubsystemAdd();

    private SwitchYardSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        if (context instanceof BootOperationContext) {
            BootOperationContext bootContext = (BootOperationContext)context;
            LOG.info((Object)"Activating SwitchYard Extension");
            ArrayList<ModuleIdentifier> modules = new ArrayList<ModuleIdentifier>();
            if (operation.has("modules")) {
                ModelNode opmodules = operation.get("modules");
                ModelNode subModel = context.getSubModel();
                subModel.get("modules").set(opmodules);
                Set keys = opmodules.keys();
                if (keys != null) {
                    for (String current : keys) {
                        modules.add(ModuleIdentifier.fromString((String)current));
                    }
                }
            }
            int priority = 16384;
            bootContext.addDeploymentProcessor(Phase.PARSE, priority++, (DeploymentUnitProcessor)new SwitchYardConfigDeploymentProcessor());
            bootContext.addDeploymentProcessor(Phase.DEPENDENCIES, priority++, (DeploymentUnitProcessor)new SwitchYardDependencyProcessor(modules));
            bootContext.addDeploymentProcessor(Phase.POST_MODULE, priority++, (DeploymentUnitProcessor)new SwitchYardConfigProcessor());
            bootContext.addDeploymentProcessor(Phase.INSTALL, priority++, (DeploymentUnitProcessor)new SwitchYardDeploymentProcessor());
        }
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOperation);
    }
}

