/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.switchyard.config.model.ModelResource;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deployment.SwitchYardDeployment;
import org.switchyard.deployment.SwitchYardMetaData;

public class SwitchYardDeployer
extends AbstractSimpleVFSRealDeployer<SwitchYardMetaData> {
    private static final String BEAN_PREFIX = "switchyard";

    public SwitchYardDeployer() {
        super(SwitchYardMetaData.class);
        this.setOutput(BeanMetaData.class);
        this.setStage(DeploymentStages.REAL);
    }

    public void deploy(VFSDeploymentUnit unit, SwitchYardMetaData metaData) throws DeploymentException {
        try {
            this.parseSwitchYardConfig(metaData);
        }
        catch (IOException ioe) {
            throw new DeploymentException((Throwable)ioe);
        }
        BeanMetaData beanMetaData = this.createBeanMetaData((DeploymentUnit)unit, metaData);
        unit.addAttachment(BeanMetaData.class, (Object)beanMetaData);
    }

    private void parseSwitchYardConfig(SwitchYardMetaData metaData) throws IOException {
        InputStream is = metaData.getSwitchYardFile().openStream();
        SwitchYardModel switchyardModel = (SwitchYardModel)new ModelResource().pull(is);
        metaData.setSwitchYardModel(switchyardModel);
    }

    private BeanMetaData createBeanMetaData(DeploymentUnit deploymentUnit, SwitchYardMetaData metadata) {
        BeanMetaDataBuilder bmdBuilder = BeanMetaDataBuilder.createBuilder((String)("switchyard." + deploymentUnit.getName()), (String)SwitchYardDeployment.class.getName());
        bmdBuilder.addConstructorParameter(String.class.getName(), metadata.getArchiveName());
        bmdBuilder.addConstructorParameter(VFSDeploymentUnit.class.getName(), (Object)deploymentUnit);
        bmdBuilder.addConstructorParameter(SwitchYardModel.class.getName(), (Object)metadata.getSwitchYardModel());
        bmdBuilder.addDependency((Object)deploymentUnit.getName());
        bmdBuilder.addDependency((Object)(deploymentUnit.getName() + "_WeldBootstrapBean"));
        return bmdBuilder.getBeanMetaData();
    }
}

