/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.hornetq;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServers;
import org.hornetq.core.server.JournalType;
import org.switchyard.HandlerChain;
import org.switchyard.Service;
import org.switchyard.bus.hornetq.HornetQDispatcher;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.transform.TransformerRegistry;

public class HornetQBus
implements ExchangeBus {
    public static final String WORK_DIR = "org.switchyard.bus.hornetq.WorkDir";
    public static final String CONFIG_PATH = "org.switchyard.bus.hornetq.ConfigPath";
    public static final String SERVER_ID = "org.switchyard.bus.hornetq.ServerId";
    private Map<String, Object> _busConfig = new HashMap<String, Object>();
    private HornetQServer _server;
    private ClientSessionFactory _clientFactory;
    private HashMap<QName, HornetQDispatcher> _dispatchers = new HashMap();

    public HornetQBus(Map<String, Object> busConfig) {
        this._busConfig = busConfig;
        this._server = HornetQServers.newHornetQServer((Configuration)this.getHornetQConfig(busConfig));
    }

    public synchronized void start() {
        try {
            this._server.start();
            HashMap<String, Object> sessionConfig = new HashMap<String, Object>();
            if (this._busConfig.containsKey(SERVER_ID)) {
                sessionConfig.put("server-id", this._busConfig.get(SERVER_ID));
            }
            this._clientFactory = HornetQClient.createClientSessionFactory((TransportConfiguration)this.getInVMTransportConfig(InVMConnectorFactory.class.getName()));
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to start HornetQProvider", (Throwable)ex);
        }
    }

    public synchronized void stop() {
        try {
            for (HornetQDispatcher ep : this._dispatchers.values()) {
                ep.stop();
            }
            this._server.stop();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to stop HornetQProvider", (Throwable)ex);
        }
    }

    public Dispatcher getDispatcher(Service service) {
        return this._dispatchers.get(service.getName());
    }

    public synchronized Dispatcher createDispatcher(Service service, HandlerChain handlerChain, TransformerRegistry transformerRegistry) {
        HornetQDispatcher endpoint = new HornetQDispatcher(service, this._clientFactory, handlerChain, transformerRegistry);
        this._dispatchers.put(service.getName(), endpoint);
        endpoint.start();
        return endpoint;
    }

    HornetQServer getHornetQServer() {
        return this._server;
    }

    ClientSessionFactory getClientFactory() {
        return this._clientFactory;
    }

    Configuration getHornetQConfig(Map<String, Object> providerConfig) {
        FileConfiguration config = null;
        File workDir = new File((String)providerConfig.get(WORK_DIR));
        String configPath = (String)providerConfig.get(CONFIG_PATH);
        if (configPath != null) {
            config = new FileConfiguration();
            config.setConfigurationUrl(configPath);
            try {
                config.start();
            }
            catch (Exception ex) {
                throw new SwitchYardException("Failed to parse HornetQ configuration.", (Throwable)ex);
            }
        } else {
            config = new ConfigurationImpl();
            config.setSecurityEnabled(false);
            config.setJournalType(JournalType.NIO);
            config.getAcceptorConfigurations().add(this.getInVMTransportConfig(InVMAcceptorFactory.class.getName()));
            if (workDir != null) {
                config.setJournalDirectory(workDir.getAbsolutePath());
                config.setBindingsDirectory(workDir.getAbsolutePath());
                config.setLargeMessagesDirectory(workDir.getAbsolutePath());
            }
        }
        return config;
    }

    private TransportConfiguration getInVMTransportConfig(String transportClass) {
        HashMap<String, Object> sessionConfig = new HashMap<String, Object>();
        if (this._busConfig.containsKey(SERVER_ID)) {
            sessionConfig.put("server-id", this._busConfig.get(SERVER_ID));
        }
        return new TransportConfiguration(transportClass, sessionConfig);
    }
}

