/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.hornetq;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.MessageHandler;

class DispatchQueue {
    private ClientSession _session;
    private String _name;
    private ClientConsumer _consumer;
    private ClientProducer _producer;
    private MessageHandler _handler;

    DispatchQueue(ClientSession session, String name, MessageHandler handler) {
        this._session = session;
        this._name = name;
        this._handler = handler;
    }

    void init() throws HornetQException {
        this._session.start();
        this._session.createQueue(this._name, this._name);
        this._producer = this._session.createProducer(this._name);
        if (this._handler != null) {
            this._consumer = this._session.createConsumer(this._name);
            this._consumer.setMessageHandler(this._handler);
        }
    }

    void destroy() throws HornetQException {
        this._consumer.close();
        this._producer.close();
        this._session.deleteQueue(this._name);
        this._session.close();
    }

    String getName() {
        return this._name;
    }

    ClientSession getSession() {
        return this._session;
    }

    ClientConsumer getConsumer() {
        return this._consumer;
    }

    ClientProducer getProducer() {
        return this._producer;
    }
}

