/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.soap.addressing;

import java.util.Map;
import javax.inject.Named;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.quickstarts.soap.addressing.ItemNotAvailable;
import org.switchyard.quickstarts.soap.addressing.Order;
import org.switchyard.quickstarts.soap.addressing.OrderResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Named(value="warehouseProcessor")
public class WarehouseProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        Order order = (Order)exchange.getIn().getBody(Order.class);
        SOAPHeaderElement replyTo = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}ReplyTo");
        SOAPHeaderElement faultTo = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}FaultTo");
        SOAPHeaderElement relatesTo = (SOAPHeaderElement)exchange.getIn().getHeaders().get("{http://www.w3.org/2005/08/addressing}RelatesTo");
        Map headers = exchange.getIn().getHeaders();
        Object address = null;
        if (order.getItem().equals("Guardian Angel")) {
            throw new ItemNotAvailable("Sorry, all " + order.getItem() + "s are sold out!");
        }
        String toStr = "<wsa:To xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">" + ((Node)replyTo.getChildElements().next()).getFirstChild().getNodeValue() + "</wsa:To>";
        Element to = XMLHelper.getDocumentFromString((String)toStr).getDocumentElement();
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}relatesto", relatesTo);
        exchange.getOut().getHeaders().put("{http://www.w3.org/2005/08/addressing}to", to);
        OrderResponse response = new OrderResponse();
        response.setReturn("Order " + order.getItem() + " with quantity " + order.getQuantity() + " accepted.");
        exchange.getOut().setBody((Object)response);
    }
}

