/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import javax.xml.namespace.QName;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;

@Command(scope="switchyard", name="throttling", description="Update throttling settings on a service.")
public class UpdateThrottlingCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="operation", description="Specifies the operation type [enable | disable].", required=true)
    private OperationType _operation;
    @Argument(index=1, name="application", description="Specifies the name of the application containing the binding.", required=true)
    private String _application;
    @Argument(index=2, name="service", description="Specifies the name of the service containing the binding.", required=true)
    private String _service;
    @Option(name="--maxRequests", description="The maximum number of requests per period.")
    private Integer _maxRequests;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Application application = switchYard.getApplication(QName.valueOf(this._application));
        if (application == null) {
            System.err.println("Could not locate application: " + this._application);
            return null;
        }
        QName serviceName = QName.valueOf(this._service);
        Service service = application.getService(serviceName);
        if (service == null) {
            System.err.println("Could not locate service: " + this._service);
            return null;
        }
        service.getThrottling().update(Boolean.valueOf(this._operation == OperationType.enable), this._maxRequests);
        return null;
    }

    public static enum OperationType {
        enable,
        disable;

    }
}

