/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca.deploy;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SCAEndpoint;
import org.switchyard.component.sca.SCAInvoker;
import org.switchyard.component.sca.SCALogger;
import org.switchyard.component.sca.SCAMessages;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.SCABindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.infinispan.InfinispanRegistry;

public class SCAActivator
extends BaseActivator {
    private static final String CACHE_CONTAINER_ROOT = "java:jboss/infinispan/container/";
    private static final String CACHE_NAME_PROPERTY = "cache-name";
    static final String[] TYPES = new String[]{"sca"};
    private RemoteRegistry _registry;
    private RemoteEndpointPublisher _endpointPublisher;

    public SCAActivator(Configuration environment) {
        super(TYPES);
        String cacheName = "cluster";
        try {
            Configuration cacheConfig = environment.getFirstChild(CACHE_NAME_PROPERTY);
            if (cacheConfig != null) {
                cacheName = cacheConfig.getValue();
            }
            EmbeddedCacheManager cm = (EmbeddedCacheManager)new InitialContext().lookup(CACHE_CONTAINER_ROOT + cacheName);
            Cache cache = cm.getCache();
            this._registry = new InfinispanRegistry(cache);
        }
        catch (NamingException nEx) {
            SCALogger.ROOT_LOGGER.unableToResolveCacheContainer(cacheName);
        }
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        try {
            this._endpointPublisher.start();
        }
        catch (Exception ex) {
            SCALogger.ROOT_LOGGER.failedToStartRemoteEndpointListenerForSCAEndpoints(ex);
        }
        SCABindingModel scab = (SCABindingModel)config;
        if (scab.isServiceBinding()) {
            return new SCAEndpoint(scab, super.getServiceDomain(), this._endpointPublisher, this._registry);
        }
        if (scab.getTarget() == null && scab.getTargetNamespace() == null) {
            throw SCAMessages.MESSAGES.invalidSCABindingForReferenceTargetServiceOrNamespaceMustBeSpecified();
        }
        return new SCAInvoker(scab, this._registry);
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void setEndpointPublisher(RemoteEndpointPublisher endpointPublisher) {
        this._endpointPublisher = endpointPublisher;
    }

    public RemoteEndpointPublisher getEndpointPublisher() {
        return this._endpointPublisher;
    }
}

