/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.config.model.composite.SCABindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.cluster.ClusteredInvoker;
import org.switchyard.remote.cluster.LoadBalanceStrategy;
import org.switchyard.remote.cluster.RandomStrategy;
import org.switchyard.remote.cluster.RoundRobinStrategy;

public class SCAInvoker
extends BaseServiceHandler {
    private final SCABindingModel _config;
    private final String _bindingName;
    private final String _referenceName;
    private ClusteredInvoker _invoker;

    public SCAInvoker(SCABindingModel config) {
        this._config = config;
        this._bindingName = config.getName();
        this._referenceName = config.getReference().getName();
    }

    public SCAInvoker(SCABindingModel config, RemoteRegistry registry) {
        this(config);
        if (config.isLoadBalanced()) {
            LoadBalanceStrategy loadBalancer = this.createLoadBalancer(config.getLoadBalance());
            this._invoker = new ClusteredInvoker(registry, loadBalancer);
        } else {
            this._invoker = new ClusteredInvoker(registry);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            throw new HandlerException(String.format("Reference binding \"%s/%s\" is not started.", this._referenceName, this._bindingName));
        }
        try {
            if (this._config.isClustered()) {
                this.invokeRemote(exchange);
            } else {
                this.invokeLocal(exchange);
            }
        }
        catch (SwitchYardException syEx) {
            throw new HandlerException(syEx.getMessage());
        }
    }

    private void invokeLocal(Exchange exchange) throws HandlerException {
        QName serviceName = this.getTargetServiceName(exchange);
        ServiceReference ref = exchange.getProvider().getDomain().getServiceReference(serviceName);
        if (ref == null) {
            throw new HandlerException("Service reference " + serviceName + " not found in domain " + exchange.getProvider().getDomain().getName());
        }
        SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
        Exchange ex = ref.createExchange(exchange.getContract().getProviderOperation().getName(), (ExchangeHandler)replyHandler);
        Message invokeMsg = exchange.getMessage().copy();
        exchange.getContext().mergeInto(invokeMsg.getContext());
        ex.send(invokeMsg);
        if (ExchangePattern.IN_OUT.equals((Object)ex.getPattern())) {
            replyHandler.waitForOut();
            if (ex.getMessage() != null) {
                Message replyMsg = ex.getMessage().copy();
                ex.getContext().mergeInto(replyMsg.getContext());
                if (ExchangeState.FAULT.equals((Object)ex.getState())) {
                    exchange.sendFault(replyMsg);
                } else {
                    exchange.send(replyMsg);
                }
            }
        } else if (ExchangeState.FAULT.equals((Object)ex.getState())) {
            throw this.createHandlerException(ex.getMessage());
        }
    }

    private void invokeRemote(Exchange exchange) throws HandlerException {
        QName serviceName = this.getTargetServiceName(exchange);
        RemoteMessage request = new RemoteMessage().setDomain(exchange.getProvider().getDomain().getName()).setService(serviceName).setContent(exchange.getMessage().getContent());
        exchange.getContext().mergeInto(request.getContext());
        try {
            RemoteMessage reply = this._invoker.invoke(request);
            if (reply == null) {
                return;
            }
            if (ExchangePattern.IN_OUT.equals((Object)exchange.getPattern())) {
                Message msg = exchange.createMessage();
                msg.setContent(reply.getContent());
                Context replyCtx = reply.getContext();
                if (replyCtx != null) {
                    replyCtx.mergeInto(exchange.getContext());
                }
                if (reply.isFault()) {
                    exchange.sendFault(msg);
                } else {
                    exchange.send(msg);
                }
            } else if (reply.isFault()) {
                throw this.createHandlerException(reply.getContent());
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            exchange.sendFault(exchange.createMessage().setContent((Object)ioEx));
        }
    }

    private QName getTargetServiceName(Exchange exchange) {
        QName service = exchange.getProvider().getName();
        String targetName = this._config.hasTarget() ? this._config.getTarget() : service.getLocalPart();
        String targetNS = this._config.hasTargetNamespace() ? this._config.getTargetNamespace() : service.getNamespaceURI();
        return new QName(targetNS, targetName);
    }

    private HandlerException createHandlerException(Message message) {
        return this.createHandlerException(message == null ? null : message.getContent());
    }

    private HandlerException createHandlerException(Object content) {
        HandlerException ex = content == null ? new HandlerException("Runtime fault occurred without exception details!") : (content instanceof HandlerException ? (HandlerException)content : (content instanceof Throwable ? new HandlerException((Throwable)content) : new HandlerException(content.toString())));
        return ex;
    }

    LoadBalanceStrategy createLoadBalancer(String strategy) {
        if (RoundRobinStrategy.class.getSimpleName().equals(strategy)) {
            return new RoundRobinStrategy();
        }
        if (RandomStrategy.class.getSimpleName().equals(strategy)) {
            return new RandomStrategy();
        }
        try {
            Class<?> strategyClass = Class.forName(strategy);
            if (!LoadBalanceStrategy.class.isAssignableFrom(strategyClass)) {
                throw new SwitchYardException("Load balance class does not implement LoadBalanceStrategy: " + strategy);
            }
            return (LoadBalanceStrategy)strategyClass.newInstance();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Unable to instantiate strategy class: " + strategy, (Throwable)ex);
        }
    }
}

