/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.common.util.ProviderRegistry;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.resteasy.RESTEasyConsumeException;
import org.switchyard.component.resteasy.RestEasyLogger;
import org.switchyard.component.resteasy.RestEasyMessages;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.composer.RESTEasyComposition;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.component.resteasy.resource.ResourcePublisherFactory;
import org.switchyard.component.resteasy.util.DefaultMethodInvokerFactory;
import org.switchyard.component.resteasy.util.MethodInvoker;
import org.switchyard.component.resteasy.util.MethodInvokerFactory;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final Class<?>[] CLASS_ARG_ARRAY = new Class[]{Class.class};
    private final RESTEasyBindingModel _config;
    private final String _bindingName;
    private final String _referenceName;
    private String _baseAddress = "http://localhost:8080";
    private Map<String, MethodInvoker> _methodMap = new HashMap<String, MethodInvoker>();
    private MessageComposer<RESTEasyBindingData> _messageComposer;

    public OutboundHandler(RESTEasyBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._bindingName = config.getName();
        this._referenceName = config.getReference().getName();
    }

    protected void doStart() throws RESTEasyConsumeException {
        if (this._methodMap.isEmpty()) {
            MethodInvokerFactory invokerFactory;
            String resourceIntfs = this._config.getInterfaces();
            String address = this._config.getAddress();
            if (address != null) {
                this._baseAddress = address;
            }
            String path = this._baseAddress;
            String contextPath = this._config.getContextPath();
            if (contextPath != null && !ResourcePublisherFactory.ignoreContext().booleanValue()) {
                path = path + "/" + contextPath;
            }
            if ((invokerFactory = (MethodInvokerFactory)ProviderRegistry.getProvider(MethodInvokerFactory.class)) == null) {
                invokerFactory = new DefaultMethodInvokerFactory();
            }
            StringTokenizer st = new StringTokenizer(resourceIntfs, ",");
            while (st.hasMoreTokens()) {
                String className = st.nextToken().trim();
                Class clazz = Classes.forName((String)className);
                Boolean multiParams = false;
                for (Method method : clazz.getMethods()) {
                    if (!"as".equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), CLASS_ARG_ARRAY)) {
                        this._methodMap.put(method.getName(), invokerFactory.createInvoker(path, clazz, method, this._config));
                    }
                    if (multiParams.booleanValue() || method.getParameterTypes().length <= 1) continue;
                    multiParams = true;
                }
                if (!multiParams.booleanValue()) continue;
                RestEasyLogger.ROOT_LOGGER.defaultRESTEasyMessageComposerDoesnTHandleMultipleInputParameters(clazz.getName());
            }
            this._messageComposer = RESTEasyComposition.getMessageComposer(this._config);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            throw RestEasyMessages.MESSAGES.referenceBindingNotStarted(this._referenceName, this._bindingName);
        }
        String opName = exchange.getContract().getProviderOperation().getName();
        RESTEasyBindingData restRequest = null;
        try {
            restRequest = (RESTEasyBindingData)this._messageComposer.decompose(exchange, (BindingData)new RESTEasyBindingData());
        }
        catch (Exception e) {
            String m = RestEasyMessages.MESSAGES.unexpectedExceptionComposingRESTRequest();
            LOGGER.error((Object)m, (Throwable)e);
            throw new HandlerException(m, (Throwable)e);
        }
        Object response = null;
        MethodInvoker methodInvoker = this._methodMap.get(opName);
        if (methodInvoker == null) {
            String m = RestEasyMessages.MESSAGES.unableToMapAmongResources(opName, this._methodMap.keySet().toString());
            throw new HandlerException(m);
        }
        try {
            RESTEasyBindingData restResponse = methodInvoker.invoke(restRequest.getParameters(), restRequest.getHeaders());
            restResponse.setOperationName(opName);
            Message out = this._messageComposer.compose((BindingData)restResponse, exchange);
            if (restResponse.getStatusCode() < 400) {
                exchange.send(out);
            } else {
                exchange.sendFault(out);
            }
        }
        catch (Exception e) {
            String m = RestEasyMessages.MESSAGES.unexpectedExceptionComposingRESTResponse();
            LOGGER.error((Object)m, (Throwable)e);
            throw new HandlerException(m, (Throwable)e);
        }
    }
}

