/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.switchyard.Exchange;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rest.RsMethod;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.java.JavaService;

public final class RsMethodUtil {
    public static final String HTTP_GET_METHOD = "GET";
    public static final String HTTP_POST_METHOD = "POST";
    public static final String HTTP_PUT_METHOD = "PUT";
    public static final String HTTP_DELETE_METHOD = "DELETE";
    public static final String HTTP_HEAD_METHOD = "HEAD";
    public static final String HTTP_OPTIONS_METHOD = "OPTIONS";

    private RsMethodUtil() {
    }

    public static Map<String, RsMethod> parseResources(String resourceClasses) {
        HashMap<String, RsMethod> resourcePaths = new HashMap<String, RsMethod>();
        StringTokenizer st = new StringTokenizer(resourceClasses, ",");
        while (st.hasMoreTokens()) {
            String className = st.nextToken().trim();
            Class clazz = Classes.forName((String)className);
            if (clazz == null) {
                throw new RuntimeException("Unable to load class " + className);
            }
            String classLevelPath = "";
            Path path = clazz.getAnnotation(Path.class);
            if (path != null) {
                classLevelPath = path.value();
            }
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                Class<?>[] params = m.getParameterTypes();
                if (params.length > 1) {
                    throw new RuntimeException("Service operations on a REST interface must have none or exactly one parameter. " + m.getName());
                }
                RsMethod method = new RsMethod(clazz);
                JavaService.OperationTypeQNames operationTypeNames = new JavaService.OperationTypeQNames(m);
                Object op = null;
                op = m.getReturnType().equals(Void.TYPE) ? new InOnlyOperation(m.getName(), operationTypeNames.in()) : new InOutOperation(m.getName(), operationTypeNames.in(), operationTypeNames.out(), operationTypeNames.fault());
                String methodPath = classLevelPath;
                String paramName = null;
                path = m.getAnnotation(Path.class);
                Boolean foundPathParam = false;
                Boolean foundQueryParam = false;
                Boolean foundMatrixParam = false;
                if (path != null) {
                    Annotation[][] paramAnnotations = m.getParameterAnnotations();
                    if (paramAnnotations.length > 0 && paramAnnotations[0].length > 0) {
                        for (Annotation anno : paramAnnotations[0]) {
                            if (anno instanceof PathParam) {
                                paramName = ((PathParam)anno).value();
                                foundPathParam = true;
                                break;
                            }
                            if (anno instanceof QueryParam) {
                                paramName = ((QueryParam)anno).value();
                                foundQueryParam = true;
                                break;
                            }
                            if (!(anno instanceof MatrixParam)) continue;
                            paramName = ((MatrixParam)anno).value();
                            foundMatrixParam = true;
                            break;
                        }
                    }
                    methodPath = foundPathParam != false ? methodPath + path.value().substring(0, path.value().indexOf("{")) : methodPath + path.value();
                }
                Class<?> paramType = null;
                if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
                    paramType = m.getParameterTypes()[0];
                }
                method.setPath(methodPath);
                method.setParamName(paramName);
                method.setRequestType(paramType);
                method.setResponseType(m.getReturnType());
                method.setPathParam(foundPathParam);
                method.setQueryParam(foundQueryParam);
                method.setMatrixParam(foundMatrixParam);
                if (m.getAnnotation(DELETE.class) != null) {
                    method.setMethod(HTTP_DELETE_METHOD);
                } else if (m.getAnnotation(GET.class) != null) {
                    method.setMethod(HTTP_GET_METHOD);
                } else if (m.getAnnotation(HEAD.class) != null) {
                    method.setMethod(HTTP_HEAD_METHOD);
                } else if (m.getAnnotation(OPTIONS.class) != null) {
                    method.setMethod(HTTP_OPTIONS_METHOD);
                } else if (m.getAnnotation(POST.class) != null) {
                    method.setMethod(HTTP_POST_METHOD);
                } else if (m.getAnnotation(PUT.class) != null) {
                    method.setMethod(HTTP_PUT_METHOD);
                } else {
                    throw new RuntimeException("Encountered unknown REST method type.");
                }
                String[] produces = null;
                if (m.getAnnotation(Produces.class) != null) {
                    produces = m.getAnnotation(Produces.class).value();
                } else if (clazz.getAnnotation(Produces.class) != null) {
                    produces = clazz.getAnnotation(Produces.class).value();
                }
                method.setProduces(RsMethodUtil.parseMediaTypes(produces));
                String[] consumes = null;
                if (m.getAnnotation(Consumes.class) != null) {
                    consumes = m.getAnnotation(Consumes.class).value();
                } else if (clazz.getAnnotation(Consumes.class) != null) {
                    consumes = clazz.getAnnotation(Consumes.class).value();
                }
                method.setConsumes(RsMethodUtil.parseMediaTypes(consumes));
                resourcePaths.put(op.toString(), method);
            }
        }
        return resourcePaths;
    }

    private static List<MediaType> parseMediaTypes(String[] types) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        if (types != null) {
            for (String type : types) {
                mediaTypes.add(MediaType.valueOf((String)type));
            }
        } else {
            mediaTypes.add(MediaType.TEXT_PLAIN_TYPE);
        }
        return mediaTypes;
    }

    public static String getPath(RsMethod restMethod, Exchange exchange) {
        String path = restMethod.getPath();
        if (restMethod.hasPathParam().booleanValue()) {
            path = restMethod.getPath() + "/" + exchange.getMessage().getContent();
        } else if (restMethod.hasQueryParam().booleanValue()) {
            path = restMethod.getPath() + "?" + restMethod.getParamName() + "=" + exchange.getMessage().getContent();
        } else if (restMethod.hasMatrixParam().booleanValue()) {
            path = restMethod.getPath() + ";" + restMethod.getParamName() + "=" + exchange.getMessage().getContent();
        }
        return path;
    }
}

