/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.kie.internal.task.api.UserGroupCallback;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.io.pull.Puller;

public class BPMUserGroupCallback
implements UserGroupCallback {
    private Map<String, List<String>> _groupStore = new HashMap<String, List<String>>();
    private Set<String> _allGroups = new HashSet<String>();

    public BPMUserGroupCallback() {
        this.init(System.getProperty("jbpm.user.group.mapping", System.getProperty("jboss.server.config.dir", "target/classes") + "/roles.properties"));
    }

    public BPMUserGroupCallback(String location) {
        this.init(location);
    }

    public BPMUserGroupCallback(Properties userGroups) {
        this.init(userGroups);
    }

    private void init(String location) {
        if (location.startsWith("classpath:")) {
            location = location.replaceFirst("classpath:", "");
        } else if (location.startsWith("file:")) {
            location = location.replaceFirst("file:", "");
        }
        Properties userGroups = (Properties)new PropertiesPuller().pullPath(location, Puller.PathType.values());
        this.init(userGroups);
    }

    private void init(Properties userGroups) {
        if (userGroups == null) {
            userGroups = new Properties();
        }
        List<String> groups = null;
        for (String string : userGroups.keySet()) {
            groups = Arrays.asList(userGroups.getProperty(string, "").split(","));
            this._groupStore.put(string, groups);
            this._allGroups.addAll(groups);
        }
        if (!this._groupStore.containsKey("Administrator")) {
            this._groupStore.put("Administrator", Collections.emptyList());
        }
    }

    public boolean existsUser(String userId) {
        return this._groupStore.containsKey(userId);
    }

    public boolean existsGroup(String groupId) {
        return this._allGroups.contains(groupId);
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        List<String> groups = this._groupStore.get(userId);
        return groups;
    }
}

