/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.jbpm.services.task.wih.LocalHTWorkItemHandler;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.kie.internal.task.api.EventService;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.type.reflect.MethodAccess;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.WorkItemHandlerModel;
import org.switchyard.component.bpm.config.model.WorkItemHandlersModel;
import org.switchyard.component.bpm.runtime.BPMRuntimeManager;
import org.switchyard.component.bpm.service.StandardSwitchYardServiceTaskHandler;
import org.switchyard.component.bpm.service.SwitchYardServiceTaskHandler;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.config.model.composite.ComponentModel;

public final class WorkItemHandlers {
    private static final String HUMAN_TASK = "Human Task";
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{ProcessRuntime.class}, {KieRuntime.class}, {KnowledgeRuntime.class}, new Class[0]};
    private static final Map<String, Class<? extends WorkItemHandler>> DEFAULT_HANDLERS = new HashMap<String, Class<? extends WorkItemHandler>>();

    public static void registerWorkItemHandlers(BPMComponentImplementationModel model, ClassLoader loader, ProcessRuntime processRuntime, BPMRuntimeManager runtimeManager, ServiceDomain serviceDomain) {
        ComponentModel componentModel = model.getComponent();
        QName componentName = componentModel.getQName();
        String componentTNS = componentModel.getTargetNamespace();
        HashSet<String> registeredNames = new HashSet<String>();
        WorkItemHandlersModel workItemHandlersModel = model.getWorkItemHandlers();
        if (workItemHandlersModel != null) {
            for (WorkItemHandlerModel workItemHandlerModel : workItemHandlersModel.getWorkItemHandlers()) {
                Class<?> workItemHandlerClass = workItemHandlerModel.getClazz(loader);
                if (workItemHandlerClass == null) {
                    throw new SwitchYardException("Could not load workItemHandler class: " + workItemHandlerModel.getModelConfiguration().getAttribute("class"));
                }
                WorkItemHandler workItemHandler = WorkItemHandlers.newWorkItemHandler(workItemHandlerClass, processRuntime, runtimeManager);
                String name = workItemHandlerModel.getName();
                if (workItemHandler instanceof SwitchYardServiceTaskHandler) {
                    SwitchYardServiceTaskHandler ssth = (SwitchYardServiceTaskHandler)workItemHandler;
                    if (name != null) {
                        ssth.setName(name);
                    } else {
                        name = ssth.getName();
                    }
                    ssth.setComponentName(componentName);
                    ssth.setInvoker(new SwitchYardServiceInvoker(serviceDomain, componentTNS));
                    ssth.setProcessRuntime(processRuntime);
                }
                if (name == null && workItemHandler instanceof AbstractHTWorkItemHandler) {
                    name = HUMAN_TASK;
                }
                if (name == null) {
                    throw new SwitchYardException("Could not use null name to register workItemHandler: " + workItemHandler.getClass().getName());
                }
                processRuntime.getWorkItemManager().registerWorkItemHandler(name, workItemHandler);
                registeredNames.add(name);
            }
        }
        for (Map.Entry entry : DEFAULT_HANDLERS.entrySet()) {
            String name = (String)entry.getKey();
            if (registeredNames.contains(name)) continue;
            WorkItemHandler defaultHandler = WorkItemHandlers.newWorkItemHandler((Class)entry.getValue(), processRuntime, runtimeManager);
            if (defaultHandler instanceof SwitchYardServiceTaskHandler) {
                SwitchYardServiceTaskHandler ssth = (SwitchYardServiceTaskHandler)defaultHandler;
                ssth.setName(name);
                ssth.setComponentName(componentName);
                ssth.setInvoker(new SwitchYardServiceInvoker(serviceDomain, componentTNS));
                ssth.setProcessRuntime(processRuntime);
            }
            processRuntime.getWorkItemManager().registerWorkItemHandler(name, defaultHandler);
            registeredNames.add(name);
        }
        if (!registeredNames.contains(HUMAN_TASK) && runtimeManager != null) {
            RuntimeEngine runtimeEngine = runtimeManager.getRuntimeEngine();
            ExternalTaskEventListener externalTaskEventListener = new ExternalTaskEventListener();
            externalTaskEventListener.setRuntimeManager((RuntimeManager)runtimeManager);
            LocalHTWorkItemHandler htwih = new LocalHTWorkItemHandler();
            htwih.setRuntimeManager((RuntimeManager)runtimeManager);
            if (runtimeEngine.getTaskService() instanceof EventService) {
                ((EventService)runtimeEngine.getTaskService()).registerTaskLifecycleEventListener((Object)externalTaskEventListener);
            }
            if (processRuntime instanceof Disposable) {
                ((Disposable)processRuntime).addDisposeListener(new DisposeListener(){

                    public void onDispose(RuntimeEngine re) {
                        if (re.getTaskService() instanceof EventService) {
                            ((EventService)re.getTaskService()).clearTaskLifecycleEventListeners();
                            ((EventService)re.getTaskService()).clearTasknotificationEventListeners();
                        }
                    }
                });
            }
            processRuntime.getWorkItemManager().registerWorkItemHandler(HUMAN_TASK, (WorkItemHandler)htwih);
            registeredNames.add(HUMAN_TASK);
        }
    }

    public static WorkItemHandler newWorkItemHandler(Class<? extends WorkItemHandler> workItemHandlerClass, ProcessRuntime processRuntime, BPMRuntimeManager runtimeManager) {
        MethodAccess access;
        WorkItemHandler workItemHandler = null;
        Constructor<? extends WorkItemHandler> constructor = WorkItemHandlers.getConstructor(workItemHandlerClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                workItemHandler = (WorkItemHandler)Construction.construct(workItemHandlerClass);
            } else if (parameterTypes.length == 1) {
                workItemHandler = (WorkItemHandler)Construction.construct(workItemHandlerClass, (Class[])parameterTypes, (Object[])new Object[]{processRuntime});
            }
        }
        catch (Throwable t) {
            throw new SwitchYardException("Could not instantiate workItemHandler class: " + workItemHandlerClass.getName());
        }
        if (workItemHandler != null && runtimeManager != null && (access = new MethodAccess(workItemHandler.getClass(), "getRuntimeManager", "setRuntimeManager")).isWriteable()) {
            access.write((Object)workItemHandler, (Object)runtimeManager);
        }
        return workItemHandler;
    }

    private static Constructor<? extends WorkItemHandler> getConstructor(Class<? extends WorkItemHandler> workItemHandlerClass) {
        Constructor<? extends WorkItemHandler> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = workItemHandlerClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    private WorkItemHandlers() {
    }

    static {
        DEFAULT_HANDLERS.put("SwitchYard Service Task", SwitchYardServiceTaskHandler.class);
        DEFAULT_HANDLERS.put("Service Task", StandardSwitchYardServiceTaskHandler.class);
    }
}

